/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.vlc;

import emulator.media.vlc.VLCPlayerImpl;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.VideoControl;

class VideoControlImpl
implements VideoControl {
    private final VLCPlayerImpl player;

    VideoControlImpl(VLCPlayerImpl player) {
        this.player = player;
    }

    @Override
    public int getDisplayHeight() {
        return this.player.width;
    }

    @Override
    public int getDisplayWidth() {
        return this.player.height;
    }

    @Override
    public int getDisplayX() {
        return this.player.displayX;
    }

    @Override
    public int getDisplayY() {
        return this.player.displayY;
    }

    @Override
    public void setDisplayFullScreen(boolean b2) {
        this.player.fullscreen = b2;
    }

    @Override
    public void setDisplayLocation(int x, int y) {
        this.player.displayX = x;
        this.player.displayY = y;
    }

    @Override
    public void setDisplaySize(int w, int h2) {
        if (this.player.width == w && this.player.height == h2) {
            return;
        }
        this.player.width = w;
        this.player.height = h2;
        this.player.notifyListeners("sizeChanged", this);
    }

    @Override
    public void setVisible(boolean b2) {
        this.player.visible = b2;
    }

    @Override
    public int getSourceHeight() {
        if (this.player.released || this.player.mediaPlayer == null) {
            throw new IllegalStateException();
        }
        try {
            if (this.player.mediaPlayer.video().videoDimension() == null) {
                this.player.mediaPlayer.media().parsing().parse();
                Thread.sleep(100L);
            }
            this.player.sourceHeight = this.player.mediaPlayer.video().videoDimension().height;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.player.sourceHeight == 0) {
            this.player.sourceHeight = this.player.bufferHeight;
        }
        return this.player.sourceHeight;
    }

    @Override
    public int getSourceWidth() {
        if (this.player.released || this.player.mediaPlayer == null) {
            throw new IllegalStateException();
        }
        try {
            if (this.player.mediaPlayer.video().videoDimension() == null) {
                this.player.mediaPlayer.media().parsing().parse();
                Thread.sleep(100L);
            }
            this.player.sourceWidth = this.player.mediaPlayer.video().videoDimension().width;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.player.sourceWidth == 0) {
            this.player.sourceWidth = this.player.bufferWidth;
        }
        return this.player.sourceWidth;
    }

    @Override
    public byte[] getSnapshot(String p0) throws MediaException {
        if (this.player.released || this.player.mediaPlayer == null) {
            throw new IllegalStateException();
        }
        if (this.player.img != null) {
            return VLCPlayerImpl.imgToBytes(this.player.img);
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.player.mediaPlayer.snapshots().get(), "JPEG", os);
            byte[] bytes = os.toByteArray();
            os.close();
            return bytes;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new MediaException(e2);
        }
    }

    @Override
    public Object initDisplayMode(int p0, Object p1) {
        if (p0 == 0) {
            this.player.isItem = true;
            return this.player.getItem();
        }
        this.player.canvas = p1;
        return null;
    }
}

