/*
 * Decompiled with CFR 0.152.
 */
package emulator.media.vlc;

import emulator.media.vlc.VLCPlayerImpl;
import javax.microedition.media.control.VolumeControl;

class VolumeControlImpl
implements VolumeControl {
    private final VLCPlayerImpl player;

    VolumeControlImpl(VLCPlayerImpl player) {
        this.player = player;
    }

    @Override
    public int getLevel() {
        if (this.player.released || this.player.mediaPlayer == null) {
            throw new IllegalStateException();
        }
        if (this.isMuted()) {
            return 0;
        }
        this.player.volume = this.player.mediaPlayer.audio().volume();
        return this.player.volume;
    }

    @Override
    public boolean isMuted() {
        if (this.player.released || this.player.mediaPlayer == null) {
            throw new IllegalStateException();
        }
        return this.player.mediaPlayer.audio().isMute();
    }

    @Override
    public int setLevel(int p0) {
        if (this.player.released || this.player.mediaPlayer == null) {
            throw new IllegalStateException();
        }
        if (this.isMuted()) {
            return 0;
        }
        this.player.mediaPlayer.audio().setVolume(p0);
        this.player.volume = this.player.mediaPlayer.audio().volume();
        this.player.notifyListeners("volumeChanged", this.player.volume);
        return this.player.volume;
    }

    @Override
    public void setMute(boolean p0) {
        if (this.player.released || this.player.mediaPlayer == null) {
            throw new IllegalStateException();
        }
        this.player.mediaPlayer.audio().setMute(p0);
    }
}

