/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui;

import emulator.Emulator;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;

public class TargetedCommand {
    public final Command command;
    public final Displayable screen;
    public final Item item;
    public final int selectionIndex;
    public final boolean wasSelected;
    public final String text;

    public TargetedCommand(Command command, Displayable screen) {
        this.command = command;
        this.screen = screen;
        this.item = null;
        this.selectionIndex = -1;
        this.wasSelected = false;
        this.text = command.getLongLabel();
    }

    public TargetedCommand(Command command, Item item) {
        this.command = command;
        this.screen = null;
        this.item = item;
        this.selectionIndex = -1;
        this.wasSelected = false;
        this.text = command.getLongLabel();
    }

    public TargetedCommand(ChoiceGroup group, int index, boolean selected) {
        this.command = null;
        this.screen = null;
        this.item = group;
        this.selectionIndex = index;
        this.wasSelected = selected;
        this.text = group.getString(index);
    }

    public boolean isChoice() {
        return this.item instanceof ChoiceGroup && this.command == null;
    }

    public void invoke() {
        if (this.command == null && this.item != null) {
            ((ChoiceGroup)this.item).setSelectedIndex(this.selectionIndex, true);
            return;
        }
        if (this.command != null && this.screen != null) {
            Emulator.getEventQueue().commandAction(this.command, this.screen);
            return;
        }
        if (this.command != null && this.item != null) {
            Emulator.getEventQueue().commandAction(this.command, this.item);
            return;
        }
        throw new IllegalStateException();
    }
}

