/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.bridge;

import emulator.graphics2D.IFont;
import emulator.graphics2D.IImage;
import emulator.graphics2D.awt.FontAWT;
import emulator.graphics2D.awt.ImageAWT;
import emulator.graphics3D.IGraphics3D;
import emulator.ui.IEmulatorFrontend;
import emulator.ui.ILogStream;
import emulator.ui.IMessage;
import emulator.ui.IPlugin;
import emulator.ui.IProperty;
import emulator.ui.IScreen;
import emulator.ui.TargetedCommand;
import emulator.ui.bridge.BridgeLog;
import emulator.ui.bridge.BridgeOutput;
import emulator.ui.bridge.PermissionWaitData;
import emulator.ui.swt.Property;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class BridgeFrontend
implements IEmulatorFrontend {
    public final MappedByteBuffer frameBuffer;
    private final FileChannel bufferChannel;
    public final BufferedReader inputpipe;
    public final FileOutputStream statepipe;
    public final FileOutputStream readypipe;
    public final FileInputStream readpipe;
    final Object stateWriteLock = new Object();
    private final BridgeOutput screen;
    private final Property iproperty = new Property();
    private final BridgeLog log = new BridgeLog();
    private Properties midletProps;
    Thread worker;
    final HashMap<Integer, TargetedCommand> commandsCache = new HashMap();
    final Vector<PermissionWaitData> permissions = new Vector();
    private static int commandsCounter = 1;

    public BridgeFrontend(String path, int w, int h2) {
        if (!(new File(path + "inputpipe").exists() && new File(path + "statepipe").exists() && new File(path + "readypipe").exists() && new File(path + "readpipe").exists())) {
            System.out.println("Pipes are missing!");
            System.exit(21);
        }
        MappedByteBuffer _buffer = null;
        FileChannel _bufferChannel = null;
        BufferedReader _inputpipe = null;
        FileOutputStream _statepipe = null;
        FileOutputStream _readypipe = null;
        FileInputStream _readpipe = null;
        try {
            _bufferChannel = new RandomAccessFile(path + "screen", "rw").getChannel();
            _buffer = _bufferChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 4L * (long)w * (long)h2);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            System.exit(24);
        }
        try {
            _inputpipe = new BufferedReader(new FileReader(path + "inputpipe"));
            _statepipe = new FileOutputStream(path + "statepipe");
            _readypipe = new FileOutputStream(path + "readypipe");
            _readpipe = new FileInputStream(path + "readpipe");
        }
        catch (IOException e3) {
            e3.printStackTrace();
            System.exit(22);
        }
        this.frameBuffer = _buffer;
        this.bufferChannel = _bufferChannel;
        this.inputpipe = _inputpipe;
        this.statepipe = _statepipe;
        this.readypipe = _readypipe;
        this.readpipe = _readpipe;
        this.screen = new BridgeOutput(this, w, h2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToState(char type, byte[] blob) {
        System.out.println("Sending packet " + type + " to state pipe");
        Object object = this.stateWriteLock;
        synchronized (object) {
            byte[] len = ByteBuffer.allocate(4).putInt(blob.length).array();
            try {
                this.statepipe.write(type);
                this.statepipe.write(len);
                this.statepipe.write(blob);
            }
            catch (IOException e2) {
                System.out.println("Broken state pipe");
                System.exit(25);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCommandsChoice(Vector<TargetedCommand> list2) {
        Object object = this.stateWriteLock;
        synchronized (object) {
            try {
                this.commandsCache.clear();
                if (list2 == null || list2.isEmpty()) {
                    this.sendToState('O', new byte[0]);
                    return;
                }
                ByteBuffer bb = ByteBuffer.allocate(4);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                bb.putInt(list2.size());
                baos.write(bb.array());
                bb.clear();
                for (TargetedCommand command : list2) {
                    if (command == null) continue;
                    int id = commandsCounter;
                    this.commandsCache.put(commandsCounter, command);
                    bb.putInt(id);
                    baos.write(bb.array());
                    if (command.isChoice()) {
                        baos.write(command.wasSelected ? 2 : 1);
                    } else {
                        baos.write(0);
                    }
                    baos.write(command.text.getBytes(StandardCharsets.UTF_8));
                    baos.write(0);
                    bb.clear();
                    ++commandsCounter;
                }
                this.sendToState('M', baos.toByteArray());
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    public IMessage getMessage() {
        return null;
    }

    @Override
    public ILogStream getLogStream() {
        return this.log;
    }

    @Override
    public IProperty getProperty() {
        return this.iproperty;
    }

    @Override
    public IScreen getScreen() {
        return this.screen;
    }

    @Override
    public int getScreenDepth() {
        return 24;
    }

    @Override
    public void pushPlugin(IPlugin p0) {
    }

    @Override
    public void disposeSubWindows() {
    }

    @Override
    public IFont newFont(int face, int size, int style) {
        return new FontAWT(this.iproperty.getDefaultFontName(), size, style, false);
    }

    @Override
    public IFont newCustomFont(int face, int size, int style, boolean height) {
        return new FontAWT(this.iproperty.getDefaultFontName(), size, style, height);
    }

    @Override
    public IFont newFont(String name, int size, int style) {
        return new FontAWT(name, size, style, false);
    }

    @Override
    public IFont loadFont(InputStream fontData, int size) {
        return null;
    }

    @Override
    public IImage newImage(int p0, int p1, boolean transparent) {
        return new ImageAWT(p0, p1, transparent, -1);
    }

    @Override
    public IImage newImage(int p0, int p1, boolean p2, int p3) {
        return new ImageAWT(p0, p1, p2, p3);
    }

    @Override
    public IImage newImage(byte[] p0) throws IOException {
        return new ImageAWT(p0);
    }

    @Override
    public IGraphics3D getGraphics3D() {
        throw new Error("This method seems unused?");
    }

    @Override
    public void syncValues() {
    }

    @Override
    public String getAppProperty(String p0) {
        String property;
        if (this.midletProps != null && (property = this.midletProps.getProperty(p0)) != null) {
            return property.trim();
        }
        return null;
    }

    @Override
    public Properties getAppProperties() {
        return this.midletProps;
    }

    @Override
    public void setAppProperties(Properties p) {
        this.midletProps = p;
    }

    @Override
    public void updateLanguage() {
    }

    @Override
    public void dispose() {
        try {
            this.bufferChannel.close();
            this.readypipe.close();
            this.statepipe.close();
            this.readpipe.close();
            this.inputpipe.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

