/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.bridge;

import emulator.Emulator;
import emulator.Settings;
import emulator.ui.TargetedCommand;
import emulator.ui.bridge.BridgeFrontend;
import emulator.ui.bridge.PermissionWaitData;
import java.io.IOException;

class BridgeInput
implements Runnable {
    private final BridgeFrontend bridge;

    BridgeInput(BridgeFrontend bridge) {
        this.bridge = bridge;
    }

    @Override
    public void run() {
        while (true) {
            String line = null;
            try {
                line = this.bridge.inputpipe.readLine();
            }
            catch (IOException e2) {
                System.exit(29);
            }
            if (line == null) {
                this.bridge.worker.interrupt();
                return;
            }
            try {
                String[] data = line.split(" ");
                this.handleEvent(data);
                continue;
            }
            catch (RuntimeException e3) {
                e3.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void handleEvent(String[] data) {
        block9 : switch (data[0]) {
            case "K": {
                int code = Integer.parseInt(data[2]);
                switch (data[1]) {
                    case "D": {
                        Emulator.getEventQueue().keyPress(code);
                        break block9;
                    }
                    case "R": {
                        Emulator.getEventQueue().keyRepeat(code);
                        break block9;
                    }
                    case "U": {
                        Emulator.getEventQueue().keyRelease(code);
                        break block9;
                    }
                }
                throw new IllegalArgumentException();
            }
            case "T": {
                int n = Integer.parseInt(data[1]);
                int x = Integer.parseInt(data[3]);
                int y = Integer.parseInt(data[4]);
                switch (data[2]) {
                    case "D": {
                        Emulator.getEventQueue().mouseDown(x, y, n);
                        break block9;
                    }
                    case "M": {
                        Emulator.getEventQueue().mouseDrag(x, y, n);
                        break block9;
                    }
                    case "U": {
                        Emulator.getEventQueue().mouseUp(x, y, n);
                        break block9;
                    }
                }
                throw new IllegalArgumentException();
            }
            case "C": {
                int x = Integer.parseInt(data[1]);
                TargetedCommand c2 = this.bridge.commandsCache.get(x);
                if (c2 == null) {
                    throw new IllegalArgumentException();
                }
                c2.invoke();
                break;
            }
            case "P": {
                int x = Integer.parseInt(data[1]);
                boolean a2 = BridgeInput.parseBool(data[2]);
                for (PermissionWaitData pwd : this.bridge.permissions) {
                    if (pwd.requestId != x) continue;
                    this.bridge.permissions.remove(pwd);
                    pwd.resolve(a2);
                    break block9;
                }
                throw new IllegalArgumentException();
            }
            case "I": {
                throw new RuntimeException("Not implemented");
            }
            case "E": {
                throw new RuntimeException("Not implemented");
            }
            case "X": {
                Settings.xrayView = BridgeInput.parseBool(data[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event type: " + data[0]);
            }
        }
    }

    private static boolean parseBool(String s) {
        if (s.equals("0")) {
            return false;
        }
        if (s.equals("1")) {
            return true;
        }
        throw new IllegalArgumentException();
    }
}

