/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.bridge;

import emulator.Emulator;
import emulator.custom.CustomMethod;
import emulator.ui.ILogStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class BridgeLog
implements ILogStream,
Runnable {
    PrintStream filePrintStream;
    LogStream logStream;
    final StringBuffer printQueue = new StringBuffer();

    public BridgeLog() {
        try {
            File file = new File(Emulator.getUserPath() + "/log.txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            this.logStream = new LogStream(this);
            this.filePrintStream = new PrintStream(new FileOutputStream(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Thread((Runnable)this, "KEmulator-Log").start();
    }

    @Override
    public final void print(String s) {
        this.logStream.orig.print(s);
        this.queuePrint(s);
    }

    @Override
    public final void println(String s) {
        this.logStream.orig.println(s);
        this.queuePrint(s + "\n");
    }

    @Override
    public final void println() {
        this.logStream.orig.println();
        this.queuePrint("\n");
    }

    @Override
    public final void stdout(String s) {
        this.logStream.orig.println(s);
        this.queuePrint(s + "\n");
    }

    @Override
    public void println(Throwable e2) {
        this.println(CustomMethod.getStackTrace(e2));
    }

    @Override
    public final void printStackTrace(String s) {
        this.println("==StackTrace==" + s + "==StackTrace==");
    }

    public void wrapPrint(String s) {
        this.queuePrint(s);
    }

    public void wrapPrintln(String s) {
        this.queuePrint(s + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queuePrint(String s) {
        StringBuffer stringBuffer = this.printQueue;
        synchronized (stringBuffer) {
            this.printQueue.append(s);
            this.printQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                CharSequence s;
                if (this.printQueue.length() > 0) {
                    StringBuffer stringBuffer = this.printQueue;
                    synchronized (stringBuffer) {
                        s = this.printQueue.toString();
                        this.printQueue.setLength(0);
                    }
                    try {
                        this.filePrintStream.print((String)s);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                s = this.printQueue;
                synchronized (s) {
                    this.printQueue.wait();
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
    }

    private final class LogStream
    extends PrintStream {
        PrintStream orig;
        private final BridgeLog log;

        LogStream(BridgeLog log) {
            super(System.out, true);
            this.log = log;
            this.orig = System.out;
            System.setOut(this);
            System.setErr(this);
        }

        @Override
        public final void print(String s) {
            this.log.wrapPrint(">>" + s);
            this.orig.print(s);
        }

        @Override
        public final void println(String s) {
            this.log.wrapPrintln(">>" + s);
            this.orig.println(s);
        }

        @Override
        public final void print(Object o) {
            this.log.wrapPrint(">>" + o);
            this.orig.print(o);
        }

        @Override
        public final void println(Object o) {
            this.log.wrapPrintln(">>" + o);
            this.orig.println(o);
        }

        @Override
        public final void println() {
            this.log.wrapPrintln(">>");
            this.orig.println();
        }
    }
}

