/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.bridge;

import emulator.Emulator;
import emulator.custom.ResourceManager;
import emulator.graphics2D.IImage;
import emulator.graphics2D.awt.ImageAWT;
import emulator.ui.CommandsMenuPosition;
import emulator.ui.ICaret;
import emulator.ui.IScreen;
import emulator.ui.TargetedCommand;
import emulator.ui.bridge.BridgeFrontend;
import emulator.ui.bridge.BridgeInput;
import emulator.ui.bridge.DummyCaret;
import emulator.ui.bridge.PermissionWaitData;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;

final class BridgeOutput
implements IScreen {
    private final BridgeFrontend bridge;
    private final ImageAWT screenImageAwt;
    private final ImageAWT backBufferImageAwt;
    private final ImageAWT xrayScreenImageAwt;
    private boolean firstFrame = true;
    private final Object lock = new Object();
    private String leftSoftLabel;
    private String rightSoftLabel;

    BridgeOutput(BridgeFrontend bridge, int w, int h2) {
        this.bridge = bridge;
        this.screenImageAwt = new ImageAWT(w, h2, false, -1);
        this.backBufferImageAwt = new ImageAWT(w, h2, false, -1);
        this.xrayScreenImageAwt = new ImageAWT(w, h2, true, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImage getScreenImg() {
        Object object = this.lock;
        synchronized (object) {
            return this.screenImageAwt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImage getBackBufferImage() {
        Object object = this.lock;
        synchronized (object) {
            return this.backBufferImageAwt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImage getXRayScreenImage() {
        Object object = this.lock;
        synchronized (object) {
            return this.xrayScreenImageAwt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaint() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.firstFrame) {
                try {
                    int read = this.bridge.readpipe.read();
                    if (read == -1) {
                        System.exit(27);
                    }
                    if (read != 10) {
                        System.out.println("Not line feed read from read event pipe!");
                    }
                }
                catch (IOException e2) {
                    System.exit(27);
                }
            }
            this.firstFrame = false;
            try {
                this.sendBuffer();
            }
            catch (Throwable e3) {
                e3.printStackTrace();
                System.exit(28);
            }
            try {
                this.bridge.readypipe.write(10);
            }
            catch (IOException e4) {
                System.exit(26);
            }
        }
    }

    private void sendBuffer() {
        int[] data = this.screenImageAwt.getData();
        this.bridge.frameBuffer.position(0);
        for (int pixel : data) {
            this.bridge.frameBuffer.putInt(pixel);
        }
    }

    @Override
    public int getWidth() {
        return this.getScreenImg().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getScreenImg().getHeight();
    }

    @Override
    public void setLeftSoftLabel(String label) {
        this.leftSoftLabel = label;
        this.sendLabels();
    }

    @Override
    public void setRightSoftLabel(String label) {
        this.rightSoftLabel = label;
        this.sendLabels();
    }

    private void sendLabels() {
        byte[] l = this.leftSoftLabel == null ? new byte[]{} : this.leftSoftLabel.getBytes(StandardCharsets.UTF_8);
        byte[] r = this.rightSoftLabel == null ? new byte[]{} : this.rightSoftLabel.getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb = ByteBuffer.allocate(l.length + 1 + r.length);
        bb.put(l);
        bb.put((byte)0);
        bb.put(r);
        this.bridge.sendToState('C', bb.array());
    }

    @Override
    public void showCommandsList(Vector<TargetedCommand> cmds, CommandsMenuPosition target, int tx, int ty) {
        this.bridge.requestCommandsChoice(cmds);
    }

    @Override
    public void forceCloseCommandsList() {
        this.bridge.requestCommandsChoice(null);
    }

    @Override
    public void startVibra(long p0) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(p0);
        this.bridge.sendToState('V', bb.array());
    }

    @Override
    public void stopVibra() {
        this.bridge.sendToState('V', new byte[8]);
    }

    @Override
    public ICaret getCaret() {
        return new DummyCaret();
    }

    @Override
    public void setSize(int w, int h2) {
    }

    @Override
    public void setWindowIcon(InputStream inputStream) {
        try {
            ImageAWT img = new ImageAWT(ResourceManager.getBytes(inputStream));
            int[] rgba = img.getData();
            ByteBuffer bb = ByteBuffer.allocate(4 + rgba.length * 4);
            bb.putShort((short)img.getWidth());
            bb.putShort((short)img.getHeight());
            for (int i2 = 0; i2 < rgba.length; ++i2) {
                bb.putInt(rgba[i2]);
            }
            this.bridge.sendToState('I', bb.array());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void showMessage(String message) {
        this.bridge.sendToState('L', message.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void showMessage(String title, String detail) {
        this.showMessage(title + "\n\n" + detail);
    }

    @Override
    public void showMessageThreadSafe(String title, String detail) {
        this.showMessage(title, detail);
    }

    @Override
    public int showMidletChoice(Vector<String> midletKeys) {
        return 0;
    }

    @Override
    public int showUpdateDialog(int type) {
        return 0;
    }

    @Override
    public boolean showSecurityDialog(String message) {
        try {
            return new PermissionWaitData().request(this.bridge, message);
        }
        catch (InterruptedException e2) {
            return false;
        }
    }

    @Override
    public String showIMEIDialog() {
        return "";
    }

    @Override
    public void setCurrent(Displayable d) {
        if (d instanceof TextBox) {
            throw new IllegalArgumentException("Not implemented");
        }
        if (d instanceof List) {
            throw new IllegalArgumentException("Not implemented");
        }
        this.bridge.sendToState('D', new byte[]{66});
        this.updateTitle();
    }

    @Override
    public void updateTitle() {
        String title = Emulator.getCurrentDisplay().getCurrent().getTitle();
        if (title == null) {
            this.bridge.sendToState('T', new byte[0]);
        } else {
            this.bridge.sendToState('T', title.getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    public void runWithMidlet() {
        this.bridge.worker = Thread.currentThread();
        try {
            while (true) {
                Thread.sleep(3600L);
            }
        }
        catch (InterruptedException e2) {
            return;
        }
    }

    @Override
    public void runEmpty() {
        System.exit(30);
    }

    @Override
    public void appStarted(boolean first) {
        if (first) {
            new Thread(new BridgeInput(this.bridge)).start();
        }
    }

    @Override
    public boolean isShown() {
        return true;
    }
}

