/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.effect;

import java.util.Random;

public final class WaterEffect {
    private int width = 0;
    private int height = 0;
    private final boolean useShading;
    public int currentBufferIndex = 0;
    public int damping = 5;
    private int[] buffer1 = null;
    private int[] buffer2 = null;
    private final Random random = new Random();

    public WaterEffect() {
        this.useShading = true;
    }

    public void initialize(int width, int height) {
        if (this.buffer1 != null) {
            this.buffer1 = null;
        }
        if (this.buffer2 != null) {
            this.buffer2 = null;
        }
        this.buffer1 = new int[width * height];
        this.buffer2 = new int[width * height];
        this.width = width;
        this.height = height;
        this.currentBufferIndex = 0;
    }

    public void processFrame(int[] sourceImage, int[] destImage) {
        if (!this.useShading) {
            this.renderRefraction(sourceImage, destImage);
        } else {
            this.renderRefractionWithShading(sourceImage, destImage);
        }
        this.updateSimulation(this.currentBufferIndex, this.damping);
        this.currentBufferIndex ^= 1;
    }

    private void updateSimulation(int bufferIndex, int dampingFactor) {
        int[] srcBuffer;
        int[] dstBuffer;
        int i2 = this.width + 1;
        if (bufferIndex == 0) {
            dstBuffer = this.buffer1;
            srcBuffer = this.buffer2;
        } else {
            dstBuffer = this.buffer2;
            srcBuffer = this.buffer1;
        }
        int endOffset = (this.height - 1) * this.width;
        while (i2 < endOffset) {
            int rowEndOffset = i2 + this.width - 2;
            while (i2 < rowEndOffset) {
                int newHeight = (srcBuffer[i2 + this.width] + srcBuffer[i2 - this.width] + srcBuffer[i2 + 1] + srcBuffer[i2 - 1] + srcBuffer[i2 - this.width - 1] + srcBuffer[i2 - this.width + 1] + srcBuffer[i2 + this.width - 1] + srcBuffer[i2 + this.width + 1] >> 2) - dstBuffer[i2];
                dstBuffer[i2] = newHeight - (newHeight >> dampingFactor);
                ++i2;
            }
            i2 += 2;
        }
    }

    public void addDrop(int x, int y, int radius, int strength, int bufferIndex) {
        int[] buffer = bufferIndex == 0 ? this.buffer1 : this.buffer2;
        int radiusSq = radius * radius;
        if (x < 0) {
            x = 1 + radius + this.random.nextInt() % (this.width - 2 * radius - 1);
        }
        if (y < 0) {
            y = 1 + radius + this.random.nextInt() % (this.height - 2 * radius - 1);
        }
        int yStart = -radius;
        int yEnd = radius;
        int xStart = -radius;
        int xEnd = radius;
        if (x - radius < 1) {
            xStart -= x - radius - 1;
        }
        if (y - radius < 1) {
            yStart -= y - radius - 1;
        }
        if (x + radius > this.width - 1) {
            xEnd -= x + radius - this.width + 1;
        }
        if (y + radius > this.height - 1) {
            yEnd -= y + radius - this.height + 1;
        }
        for (int iy = yStart; iy < yEnd; ++iy) {
            int iySq = iy * iy;
            for (int ix = xStart; ix < xEnd; ++ix) {
                int offset;
                if (ix * ix + iySq >= radiusSq) continue;
                int n = offset = this.width * (iy + y) + (ix + x);
                buffer[n] = buffer[n] + strength;
            }
        }
    }

    private void renderRefraction(int[] srcImage, int[] dstImage) {
        int[] heightMap = this.buffer1;
        int endOffset = (this.height - 1) * this.width;
        for (int i2 = this.width + 1; i2 < endOffset; i2 += 2) {
            int rowEndOffset = i2 + this.width - 2;
            while (i2 < rowEndOffset) {
                int diffY = heightMap[i2] - heightMap[i2 + this.width];
                int diffX = heightMap[i2] - heightMap[i2 + 1];
                int offset = i2 + this.width * (diffY >> 3) + (diffX >> 3);
                dstImage[i2] = srcImage[offset];
                diffY = heightMap[++i2] - heightMap[i2 + this.width];
                diffX = heightMap[i2] - heightMap[i2 + 1];
                offset = i2 + this.width * (diffY >> 3) + (diffX >> 3);
                dstImage[i2] = srcImage[offset];
                ++i2;
            }
        }
    }

    private void renderRefractionWithShading(int[] srcImage, int[] dstImage) {
        int maxOffset = this.width * this.height;
        int[] heightMap = this.buffer1;
        int endOffset = (this.height - 1) * this.width;
        for (int i2 = this.width + 1; i2 < endOffset; i2 += 2) {
            int rowEndOffset = i2 + this.width - 2;
            while (i2 < rowEndOffset) {
                int pixelColor;
                int diffY = heightMap[i2] - heightMap[i2 + this.width];
                int diffX = heightMap[i2] - heightMap[i2 + 1];
                int offset = i2 + this.width * (diffY >> 3) + (diffX >> 3);
                if (offset < maxOffset && offset > 0) {
                    dstImage[i2] = pixelColor = WaterEffect.applyShading(srcImage[offset], diffX);
                }
                if ((offset = ++i2 + this.width * ((diffY = heightMap[i2] - heightMap[i2 + this.width]) >> 3) + ((diffX = heightMap[i2] - heightMap[i2 + 1]) >> 3)) < maxOffset && offset > 0) {
                    dstImage[i2] = pixelColor = WaterEffect.applyShading(srcImage[offset], diffX);
                }
                ++i2;
            }
        }
    }

    private static int applyShading(int color, int shade) {
        int r = (color >> 16 & 0xFF) - shade;
        int g = (color >> 8 & 0xFF) - shade;
        int b2 = (color & 0xFF) - shade;
        r = r < 0 ? 0 : Math.min(r, 255);
        g = g < 0 ? 0 : Math.min(g, 255);
        b2 = b2 < 0 ? 0 : Math.min(b2, 255);
        return 0xFF000000 | r << 16 | g << 8 | b2;
    }
}

