/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.Emulator;
import emulator.UILocale;
import emulator.graphics2D.swt.ImageSWT;
import emulator.ui.effect.WaterEffect;
import emulator.ui.swt.Class158;
import emulator.ui.swt.Class163;
import emulator.ui.swt.EmulatorScreen;
import emulator.ui.swt.SWTFrontend;
import emulator.ui.swt.Water;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public final class About
implements MouseListener,
MouseMoveListener {
    private Shell aboutShell = null;
    private CLabel aboutText = null;
    private Link websiteLink = null;
    private Button okBtn = null;
    private Canvas waterCanvas = null;
    private WaterEffect waterEffect;
    private ImageSWT logoImage;
    private ImageSWT waterImage;
    private Timer animationTimer;
    GC canvasGC;
    int[] logoImageData;
    int[] waterImageData;

    private void createAboutShell(Shell shell) {
        GridData gridData = new GridData();
        new GridData().horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        GridData layoutData5 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData5.grabExcessHorizontalSpace = true;
        layoutData5.grabExcessVerticalSpace = false;
        layoutData5.verticalAlignment = 4;
        layoutData5.verticalSpan = 1;
        GridData gridData2 = new GridData();
        new GridData().horizontalIndent = 5;
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = false;
        gridData2.grabExcessVerticalSpace = false;
        gridData2.verticalAlignment = 4;
        GridLayout layout = new GridLayout();
        new GridLayout().numColumns = 2;
        layout.horizontalSpacing = 0;
        this.aboutShell = new Shell(shell, 67680);
        this.aboutShell.setText("About KEmulator");
        this.aboutShell.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/res/icon")));
        this.aboutShell.setLayout((Layout)layout);
        this.addIcon();
        this.aboutText = new CLabel((Composite)this.aboutShell, 0);
        this.aboutText.setLayoutData((Object)layoutData5);
        this.aboutText.setFont(EmulatorScreen.f);
        this.aboutText.setText(Emulator.getAboutString());
        this.websiteLink = new Link((Composite)this.aboutShell, 0);
        this.websiteLink.setText("<a>nnproject.cc/kem</a>");
        this.websiteLink.setLayoutData((Object)gridData2);
        this.websiteLink.addSelectionListener((SelectionListener)new Class158(this));
        GridData layoutData3 = new GridData();
        new GridData().horizontalAlignment = 3;
        layoutData3.grabExcessHorizontalSpace = false;
        layoutData3.verticalAlignment = 3;
        this.okBtn = new Button((Composite)this.aboutShell, 0x800008);
        this.okBtn.setText(UILocale.get("DIALOG_OK", "OK"));
        this.okBtn.setLayoutData((Object)layoutData3);
        layoutData3.widthHint = 100;
        this.okBtn.addSelectionListener((SelectionListener)new Class163(this));
        GridData layoutData2 = new GridData();
        layoutData2.horizontalSpan = 2;
        layoutData2.horizontalAlignment = 4;
        layoutData2.grabExcessHorizontalSpace = true;
        layoutData2.grabExcessVerticalSpace = true;
        layoutData2.verticalAlignment = 4;
        TabFolder tabFolder = new TabFolder((Composite)this.aboutShell, 128);
        GridData layoutData = new GridData();
        layoutData.horizontalIndent = 2;
        layoutData.horizontalSpan = 2;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        tabFolder.setLayoutData((Object)layoutData);
        Composite helpComposite = new Composite((Composite)tabFolder, 0);
        StyledText helpText = new StyledText(helpComposite, 2562);
        GridLayout gridLayout = new GridLayout();
        helpComposite.setLayout((Layout)gridLayout);
        GridData layoutData4 = new GridData();
        layoutData4.horizontalAlignment = 4;
        layoutData4.grabExcessHorizontalSpace = true;
        layoutData4.grabExcessVerticalSpace = true;
        layoutData4.horizontalSpan = 2;
        layoutData4.verticalAlignment = 4;
        helpText.setLayoutData((Object)layoutData4);
        helpText.setEditable(false);
        helpText.setIndent(5);
        helpText.setFont(EmulatorScreen.f);
        TabItem logTab = new TabItem(tabFolder, 0);
        logTab.setText("Changelog");
        logTab.setControl((Control)helpComposite);
        Composite apisComposite = new Composite((Composite)tabFolder, 0);
        StyledText apisText = new StyledText(apisComposite, 2562);
        GridLayout gridLayout2 = new GridLayout();
        apisComposite.setLayout((Layout)gridLayout2);
        GridData layoutData42 = new GridData();
        layoutData42.horizontalAlignment = 4;
        layoutData42.grabExcessHorizontalSpace = true;
        layoutData42.grabExcessVerticalSpace = true;
        layoutData42.horizontalSpan = 2;
        layoutData42.verticalAlignment = 4;
        apisText.setLayoutData((Object)layoutData42);
        apisText.setEditable(false);
        apisText.setIndent(5);
        apisText.setFont(EmulatorScreen.f);
        TabItem apisTab = new TabItem(tabFolder, 0);
        apisTab.setText("Supported APIs");
        apisTab.setControl((Control)apisComposite);
        Composite creditsComposite = new Composite((Composite)tabFolder, 0);
        StyledText creditsText = new StyledText(creditsComposite, 2562);
        GridLayout gridLayout3 = new GridLayout();
        creditsComposite.setLayout((Layout)gridLayout3);
        GridData layoutData43 = new GridData();
        layoutData43.horizontalAlignment = 4;
        layoutData43.grabExcessHorizontalSpace = true;
        layoutData43.grabExcessVerticalSpace = true;
        layoutData43.horizontalSpan = 2;
        layoutData43.verticalAlignment = 4;
        creditsText.setLayoutData((Object)layoutData43);
        creditsText.setEditable(false);
        creditsText.setIndent(5);
        creditsText.setFont(EmulatorScreen.f);
        TabItem creditsTab = new TabItem(tabFolder, 0);
        creditsTab.setText("Credits");
        creditsTab.setControl((Control)creditsComposite);
        this.aboutShell.pack();
        this.aboutShell.setSize(new Point(400, 600));
        this.setText(helpText, "/res/help");
        this.setText(apisText, "/res/apis");
        this.setText(creditsText, "/res/credits");
    }

    private void setText(StyledText styledText, String res) {
        styledText.setText("");
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(res)));
            while ((line = bufferedReader.readLine()) != null) {
                int charCount = styledText.getCharCount();
                if (line.startsWith("$")) {
                    styledText.append(line.substring(1) + "\n");
                    styledText.setStyleRange(new StyleRange(charCount, line.length(), Display.getCurrent().getSystemColor(9), null));
                    continue;
                }
                styledText.append(line + "\n");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void method454(Shell shell) {
        this.createAboutShell(shell);
        Display display = shell.getDisplay();
        this.aboutShell.setLocation(shell.getLocation().x + (shell.getSize().x - this.aboutShell.getSize().x >> 1), shell.getLocation().y + (shell.getSize().y - this.aboutShell.getSize().y >> 1));
        this.aboutShell.open();
        while (!this.aboutShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void addIcon() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.verticalSpan = 3;
        layoutData.heightHint = 146;
        layoutData.widthHint = 156;
        this.waterCanvas = new Canvas((Composite)this.aboutShell, 0x20040000);
        this.waterCanvas.setLayoutData((Object)layoutData);
        this.waterCanvas.addMouseListener((MouseListener)this);
        this.waterCanvas.addMouseMoveListener((MouseMoveListener)this);
        this.canvasGC = new GC((Drawable)this.waterCanvas);
        this.method455(Emulator.class.getResourceAsStream("/res/sign"));
    }

    private void method455(InputStream inputStream) {
        try {
            this.logoImage = new ImageSWT(inputStream);
            this.waterImage = new ImageSWT(this.logoImage.getWidth(), this.logoImage.getHeight(), false, 6393563);
            this.logoImageData = this.logoImage.getData();
            this.waterImageData = this.waterImage.getData();
            this.waterEffect = new WaterEffect();
            this.waterEffect.initialize(this.logoImage.getWidth(), this.logoImage.getHeight());
            this.waterEffect.addDrop(this.logoImage.getWidth() >> 1, this.logoImage.getHeight() >> 1, 10, 500, this.waterEffect.currentBufferIndex);
            this.animationTimer = new Timer();
            this.animationTimer.schedule((TimerTask)new WaterTask(this), 0L, 30L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public final void mouseDown(MouseEvent mouseEvent) {
        this.waterEffect.addDrop(mouseEvent.x, mouseEvent.y, 5, 500, this.waterEffect.currentBufferIndex);
    }

    public final void mouseUp(MouseEvent mouseEvent) {
    }

    public final void mouseMove(MouseEvent mouseEvent) {
        this.waterEffect.addDrop(mouseEvent.x, mouseEvent.y, 5, 50, this.waterEffect.currentBufferIndex);
    }

    static Shell method456(About class54) {
        return class54.aboutShell;
    }

    static WaterEffect method457(About class54) {
        return class54.waterEffect;
    }

    static Canvas method458(About class54) {
        return class54.waterCanvas;
    }

    static Timer method459(About class54) {
        return class54.animationTimer;
    }

    static WaterEffect method460(About class54, WaterEffect ana811) {
        class54.waterEffect = ana811;
        return class54.waterEffect;
    }

    static ImageSWT method461(About class54) {
        return class54.waterImage;
    }

    public void finalize() {
        this.aboutShell.getDisplay().asyncExec(() -> {
            try {
                if (!this.canvasGC.isDisposed()) {
                    this.canvasGC.dispose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    static final class WaterTask
    extends TimerTask {
        private final About waterTask;

        private WaterTask(About waterTask) {
            this.waterTask = waterTask;
        }

        @Override
        public final void run() {
            About.method457(this.waterTask).processFrame(this.waterTask.logoImageData, this.waterTask.waterImageData);
            SWTFrontend.getDisplay().syncExec((Runnable)new Water(this, this.waterTask.waterEffect));
        }

        WaterTask(About class54, Class158 class55) {
            this(class54);
        }

        static About method433(WaterTask waterTask) {
            return waterTask.waterTask;
        }
    }
}

