/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import com.nokia.mid.ui.TextEditor;
import emulator.Emulator;
import emulator.Settings;
import emulator.ui.ICaret;
import emulator.ui.swt.EmulatorScreen;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.TextField;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public final class CaretImpl
implements ICaret,
ModifyListener,
TraverseListener,
FocusListener,
KeyListener {
    private static Font font = Font.getDefaultFont();
    private Text swtText;
    private Canvas swtCanvas;
    private Display display;
    private Caret swtCaret;
    private float zoom;
    private int caretLocX;
    private int caretLocY;
    private int caretX;
    private int caretY;
    private Object currentItem;
    private int caretPosition;
    private int caretCol;
    private int caretRow;
    private org.eclipse.swt.graphics.Font swtFont;

    public CaretImpl(Canvas canvas) {
        this.swtCanvas = canvas;
        this.display = canvas.getDisplay();
        this.swtCaret = new Caret(this.swtCanvas, 0);
        this.swtCaret.setVisible(false);
        this.zoom = 1.0f;
    }

    @Override
    public int getCaretPosition() {
        if (this.swtText == null || this.currentItem == null) {
            return 0;
        }
        this.display.syncExec(() -> {
            try {
                this.caretPosition = this.swtText.getCaretPosition();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return this.caretPosition;
    }

    @Override
    public String getSelection() {
        if (this.swtText == null || this.currentItem == null) {
            return null;
        }
        return this.swtText.getSelectionText();
    }

    @Override
    public void setCaret(int index) {
        if (this.swtText == null || this.currentItem == null) {
            return;
        }
        this.display.syncExec(() -> {
            try {
                this.swtText.setSelection(index);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Override
    public void setSelection(int index, int length) {
        if (this.swtText == null || this.currentItem == null) {
            return;
        }
        this.display.syncExec(() -> {
            try {
                this.swtText.setSelection(index, length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public final void a(Transform paramTransform, int paramInt) {
    }

    public final synchronized void setCaretLocation(int x, int y) {
        this.caretLocX = x;
        this.caretLocY = y;
        int[] i2 = ((EmulatorScreen)Emulator.getEmulator().getScreen()).transformCaret(x, y, true);
        if (this.swtCaret != null) {
            this.swtCaret.setLocation(i2[0], i2[1]);
        }
        if (this.swtText != null) {
            this.swtText.setLocation(i2[0], i2[1]);
        }
    }

    public final void setWindowZoom(float aFloat840) {
        this.zoom = aFloat840;
        Object item = this.currentItem;
        if (item != null) {
            if (this.swtFont != null && !this.swtFont.isDisposed() && this.swtText != null) {
                this.swtText.setFont(null);
                this.swtFont.dispose();
            }
            if (item instanceof DateField) {
                this.swtCaret.setSize(Math.min(1, (int)aFloat840), (int)((float)font.getBaselinePosition() * aFloat840));
                this.setCaretLocation(this.caretLocX, this.caretLocY);
            } else {
                int h2;
                int w;
                if (item instanceof TextEditor) {
                    w = ((TextEditor)item).getWidth();
                    h2 = ((TextEditor)item).getHeight();
                } else {
                    w = ((TextField)item)._getTextAreaWidth();
                    h2 = ((TextField)item)._getTextAreaHeight();
                }
                this.swtFont = new org.eclipse.swt.graphics.Font((Device)this.swtCanvas.getDisplay(), Emulator.getEmulator().getProperty().getDefaultFontName(), Math.max(2, (int)((float)font.getHeight() * this.zoom * 0.7f) - 1), 0);
                if (this.swtText == null) {
                    return;
                }
                this.swtText.setFont(this.swtFont);
                int[] i2 = ((EmulatorScreen)Emulator.getEmulator().getScreen()).transformCaret(w, h2, false);
                this.swtText.setSize(Math.max(1, i2[0]), Math.max(1, i2[1]));
                this.setCaretLocation(this.caretLocX, this.caretLocY);
                this.swtText.setVisible(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void focusItem(Object item, int x, int y) {
        Object tmp;
        CaretImpl caretImpl = this;
        synchronized (caretImpl) {
            tmp = this.currentItem;
            this.currentItem = item;
        }
        if (tmp != item) {
            if (tmp instanceof TextEditor) {
                ((TextEditor)tmp).setFocus(false);
            } else if (tmp instanceof TextField) {
                ((TextField)tmp)._swtFocusLost();
            }
        }
        this.caretX = x;
        this.caretY = y;
        this.caretPosition = 0;
        this.caretCol = 0;
        this.caretRow = 0;
        font = item instanceof TextEditor ? ((TextEditor)item).getFont() : Font.getDefaultFont();
        Object lastItem = tmp;
        this.display.syncExec(() -> {
            if (lastItem != item && this.swtText != null) {
                if (!this.swtText.isDisposed()) {
                    this.swtText.dispose();
                }
                this.swtText = null;
            }
            if (item instanceof DateField) {
                this.swtCaret.setVisible(true);
            } else {
                this.swtCaret.setVisible(false);
                Text text = this.swtText;
                if (text == null) {
                    text = new Text((Composite)this.swtCanvas, item instanceof TextField || !((TextEditor)item).isMultiline() ? 2 : 66);
                    text.setText(item instanceof TextField ? ((TextField)item).getString() : ((TextEditor)item).getContent());
                    text.setData(item);
                    text.addModifyListener((ModifyListener)this);
                    text.addTraverseListener((TraverseListener)this);
                    text.addFocusListener((FocusListener)this);
                    text.addKeyListener((KeyListener)this);
                    this.swtText = text;
                }
                if (item instanceof TextEditor) {
                    int c2 = ((TextEditor)item).getForegroundColor();
                    if (c2 != 0) {
                        text.setForeground(new Color(null, c2 >> 16 & 0xFF, c2 >> 8 & 0xFF, c2 & 0xFF, 255));
                    }
                    if ((c2 = ((TextEditor)item).getBackgroundColor()) != 0) {
                        text.setBackground(new Color(null, c2 >> 16 & 0xFF, c2 >> 8 & 0xFF, c2 & 0xFF, 255));
                    }
                }
                text.setEditable(!(item instanceof TextField) || !((TextField)item)._isUneditable());
                text.setVisible(true);
                text.setFocus();
            }
            this.setCaretLocation(this.caretX, this.caretY);
            this.setWindowZoom(this.zoom);
            ((EmulatorScreen)Emulator.getEmulator().getScreen()).toggleMenuAccelerators(false);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defocusItem(Object item) {
        Object tmp;
        CaretImpl caretImpl = this;
        synchronized (caretImpl) {
            tmp = this.currentItem;
            if (tmp != item) {
                return;
            }
            this.currentItem = null;
        }
        if (tmp instanceof TextEditor) {
            ((TextEditor)tmp).setFocus(false);
        } else if (tmp instanceof TextField) {
            ((TextField)tmp)._swtFocusLost();
        }
        this.display.syncExec(() -> {
            if (this.swtText != null && !this.swtText.isDisposed()) {
                this.swtText.dispose();
                this.swtText = null;
            }
            this.swtCaret.setVisible(false);
            if (!Settings.canvasKeyboard) {
                ((EmulatorScreen)Emulator.getEmulator().getScreen()).toggleMenuAccelerators(true);
            }
        });
    }

    @Override
    public void updateText(Object item, String text) {
        if (item != this.currentItem || this.swtText == null) {
            return;
        }
        this.display.syncExec(() -> {
            try {
                this.swtText.setText(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Override
    public void displayableChanged() {
        if (this.currentItem == null) {
            return;
        }
        this.defocusItem(this.currentItem);
    }

    public final void mouseDown(int x, int y) {
    }

    public final boolean _keyPressed(KeyEvent event) {
        if (this.currentItem == null || !(this.currentItem instanceof DateField)) {
            return false;
        }
        char c2 = event.character;
        if (c2 == '\n' || c2 == '\r') {
            c2 = '\u0000';
        }
        if (c2 >= '0' && c2 <= '9' || c2 == '\u0000') {
            ((DateField)this.currentItem)._input(c2);
        }
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 0x100000A || keyEvent.keyCode == 0x100000B || keyEvent.keyCode == 0x100000C || keyEvent.keyCode == 0x1000014) {
            ((EmulatorScreen)Emulator.getEmulator().getScreen()).keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 0x100000A || keyEvent.keyCode == 0x100000B || keyEvent.keyCode == 0x100000C || keyEvent.keyCode == 0x1000014) {
            ((EmulatorScreen)Emulator.getEmulator().getScreen()).keyReleased(keyEvent);
        }
    }

    public void keyTraversed(TraverseEvent e2) {
        String text = this.swtText.getText();
        int length = text.length();
        int pos = this.swtText.getCaretPosition();
        int line = this.swtText.getCaretLineNumber();
        int key = e2.keyCode;
        Object item = e2.widget.getData();
        switch (e2.detail) {
            case 2: 
            case 8: 
            case 16: {
                this.defocusItem(this.currentItem);
                break;
            }
            case 32: 
            case 64: {
                if (item instanceof TextEditor) {
                    if (length != 0 && (key != 0x1000001 || line != 0) && (key != 0x1000002 || text.contains("\n"))) break;
                    if (key == 0x1000001) {
                        ((TextEditor)item)._inputAction(8);
                        break;
                    }
                    if (key != 0x1000002) break;
                    ((TextEditor)item)._inputAction(16);
                    break;
                }
                if (length == 0) {
                    this.defocusItem(item);
                    break;
                }
                boolean b2 = false;
                switch (key) {
                    case 0x1000001: {
                        b2 = line == 0;
                        break;
                    }
                    case 0x1000002: {
                        b2 = !text.contains("\n");
                        break;
                    }
                    case 0x1000003: {
                        b2 = pos == 0;
                        break;
                    }
                    case 0x1000004: {
                        boolean bl = b2 = pos == length;
                    }
                }
                if (!b2) break;
                this.defocusItem(item);
            }
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String text = ((Text)modifyEvent.widget).getText();
        Object item = modifyEvent.widget.getData();
        if (item instanceof TextEditor) {
            if (text.equals(((TextEditor)item).getContent())) {
                return;
            }
            ((TextEditor)item)._contentChanged(text);
        } else {
            if (text.equals(((TextField)item).getString())) {
                return;
            }
            ((TextField)item)._setString(text);
        }
    }

    public void focusGained(FocusEvent e2) {
        if (e2.widget != this.swtText) {
            this.swtCanvas.setFocus();
        }
    }

    public void focusLost(FocusEvent e2) {
    }
}

