/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.Controllers;
import emulator.Emulator;
import emulator.KeyMapping;
import emulator.KeyRecords;
import emulator.ReflectUtil;
import emulator.Settings;
import emulator.UILocale;
import emulator.Updater;
import emulator.Utils;
import emulator.custom.CustomMethod;
import emulator.custom.ResourceManager;
import emulator.debug.Profiler;
import emulator.debug.Profiler3D;
import emulator.graphics2D.IImage;
import emulator.graphics2D.awt.ImageAWT;
import emulator.graphics2D.swt.ImageSWT;
import emulator.ui.CommandsMenuPosition;
import emulator.ui.ICaret;
import emulator.ui.IScreen;
import emulator.ui.TargetedCommand;
import emulator.ui.swt.About;
import emulator.ui.swt.CaretImpl;
import emulator.ui.swt.Class29;
import emulator.ui.swt.Class43;
import emulator.ui.swt.Class45;
import emulator.ui.swt.Class50;
import emulator.ui.swt.Class53;
import emulator.ui.swt.CommandsMenuListener;
import emulator.ui.swt.InputDialog;
import emulator.ui.swt.Log;
import emulator.ui.swt.MemoryView;
import emulator.ui.swt.MessageConsole;
import emulator.ui.swt.Property;
import emulator.ui.swt.ResizeMethod;
import emulator.ui.swt.SWTFrontend;
import emulator.ui.swt.ScreenSizeDialog;
import emulator.ui.swt.Win32KeyboardPoller;
import emulator.ui.swt.devutils.idea.IdeaUtils;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Screen;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TouchEvent;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Touch;

public final class EmulatorScreen
implements IScreen,
Runnable,
PaintListener,
DisposeListener,
ControlListener,
KeyListener,
MouseListener,
MouseMoveListener,
SelectionListener,
MouseWheelListener,
MouseTrackListener,
TouchListener,
Listener {
    private static Display display;
    private static int threadCount;
    private final int startWidth;
    private final int startHeight;
    private Shell shell;
    private org.eclipse.swt.widgets.Canvas canvas;
    private CLabel leftSoftLabel;
    private CLabel rightSoftLabel;
    private CLabel statusLabel;
    private Menu menu;
    private Menu menuMidlet;
    private Menu menuTool;
    private Menu menuView;
    private Menu menu2dEngine;
    private Menu menuM3GEngine;
    public static int locX;
    public static int locY;
    public static int sizeW;
    public static int sizeH;
    public static boolean maximized;
    public static boolean fullscreen;
    private Transform paintTransform;
    private int rotation;
    private int rotatedWidth;
    private int rotatedHeight;
    private float realZoom;
    private int windowDecorationHeight;
    private Image screenImg;
    private ImageSWT screenCopySwt;
    private ImageSWT screenImageSwt;
    private ImageSWT backBufferImageSwt;
    private ImageSWT xrayScreenImageSwt;
    private ImageAWT screenCopyAwt;
    private ImageAWT screenImageAwt;
    private ImageAWT backBufferImageAwt;
    private ImageAWT xrayScreenImageAwt;
    private static long aLong982;
    MenuItem awt2dMenuItem;
    MenuItem swt2dMenuItem;
    MenuItem swerve3dMenuItem;
    MenuItem lwj3dMenuItem;
    MenuItem loadJarMenuItem;
    MenuItem loadAutoPlayMenuItem;
    MenuItem openJadMenuItem;
    MenuItem suspendMenuItem;
    MenuItem resumeMenuItem;
    MenuItem pausestepMenuItem;
    MenuItem playResumeMenuItem;
    MenuItem restartMenuItem;
    MenuItem exitMenuItem;
    MenuItem zoomInMenuItem;
    MenuItem zoomOutMenuItem;
    MenuItem interposeNearestMenuItem;
    MenuItem interposeLowMenuItem;
    MenuItem interposeHighMenuItem;
    MenuItem speedUpMenuItem;
    MenuItem slowDownMenuItem;
    MenuItem resetSpeedMenuItem;
    MenuItem recordKeysMenuItem;
    MenuItem enableAutoplayMenuItem;
    MenuItem captureToFileMenuItem;
    MenuItem captureToClipboardMenuItem;
    MenuItem showTrackInfoMenuItem;
    MenuItem helpMenuItem;
    MenuItem updateMenuItem;
    MenuItem optionsMenuItem;
    MenuItem xrayViewMenuItem;
    MenuItem infosMenuItem;
    MenuItem alwaysOnTopMenuItem;
    MenuItem rotateScreenMenuItem;
    MenuItem forcePaintMenuItem;
    MenuItem keypadMenuItem;
    MenuItem logMenuItem;
    MenuItem watchesMenuItem;
    MenuItem profilerMenuItem;
    MenuItem methodsMenuItem;
    MenuItem memoryViewMenuItem;
    MenuItem mediaViewMenuItem;
    MenuItem smsConsoleMenuItem;
    MenuItem sensorMenuItem;
    MenuItem devUtilsMenuItem;
    MenuItem networkKillswitchMenuItem;
    private MenuItem canvasKeyboardMenuItem;
    private MenuItem changeResMenuItem;
    private Menu menuResize;
    private MenuItem centerOnScreenMenuItem;
    private MenuItem syncSizeMenuItem;
    private MenuItem fillScreenMenuItem;
    private MenuItem integerScalingMenuItem;
    private MenuItem m3gViewMenuItem;
    private MenuItem resetSizeMenuItem;
    private MenuItem fullscreenMenuItem;
    private static int captureFileCounter;
    private static String aString993;
    private int pauseState;
    private String[] pauseStateStrings;
    private boolean infosEnabled;
    private String aString1008;
    private CaretImpl caret;
    private boolean[] keysState;
    private int mouseXPress;
    private int mouseXRelease;
    private int mouseYPress;
    private int mouseYRelease;
    private boolean mouseDownInfos;
    private Vibrate vibraThread;
    private long vibra;
    private long vibraStart;
    private MenuItem rotate90MenuItem;
    private final Vector<Integer> pressedKeys = new Vector();
    static Font f;
    private int screenX;
    private int screenY;
    private int screenWidth;
    private int screenHeight;
    private boolean pointerState;
    private boolean win;
    private MenuItem glM3DMenuItem;
    private MenuItem softM3DMenuItem;
    private Menu menuM3DEngine;
    private boolean wasResized;
    private boolean windowResizedByUser = true;
    private boolean windowAutosized = true;
    private StackLayout stackLayout;
    private Composite swtContent;
    private Displayable lastDisplayable;
    protected int dialogSelection;
    private boolean midletSupportsMultitouch;
    private boolean touchEnabled;
    private final Vector<Long> touchIds = new Vector();
    private int lastPointerX;
    private int lastPointerY;
    private boolean paintPending;
    private Menu commandsMenu;
    private String leftSoftLabelText;
    private String rightSoftLabelText;
    private Win32KeyboardPoller poller;

    public EmulatorScreen(int n, int n2) {
        this.pauseStateStrings = new String[]{UILocale.get("MAIN_INFO_BAR_UNLOADED", "UNLOADED"), UILocale.get("MAIN_INFO_BAR_RUNNING", "RUNNING"), UILocale.get("MAIN_INFO_BAR_PAUSED", "PAUSED")};
        display = SWTFrontend.getDisplay();
        this.initShell();
        try {
            this.initScreenBuffer(n, n2);
        }
        catch (Throwable e2) {
            Emulator.getEmulator().getLogStream().println("Failed to initialize screen buffer with size " + n + "x" + n2 + ", falling back to 240x320.");
            e2.printStackTrace();
            n = 240;
            n2 = 320;
            this.initScreenBuffer(240, 320);
        }
        this.startWidth = n;
        this.startHeight = n2;
        this.updatePauseState();
    }

    public Shell getShell() {
        return this.shell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initScreenBuffer(int w, int h2) {
        EmulatorScreen emulatorScreen = this;
        synchronized (emulatorScreen) {
            if (w < 1) {
                w = 1;
            }
            if (h2 < 1) {
                h2 = 1;
            }
            int bgcolor = 0xFFFFFF;
            if (Settings.g2d == 0) {
                this.screenCopySwt = new ImageSWT(w, h2, false, 0xFFFFFF);
                this.screenImageSwt = new ImageSWT(w, h2, false, 0xFFFFFF);
                this.backBufferImageSwt = new ImageSWT(w, h2, false, 0xFFFFFF);
                this.xrayScreenImageSwt = new ImageSWT(w, h2, true, 0xFFFFFF);
                return;
            }
            if (Settings.g2d == 1) {
                this.screenCopyAwt = new ImageAWT(w, h2, false, 0xFFFFFF);
                this.screenImageAwt = new ImageAWT(w, h2, false, 0xFFFFFF);
                this.backBufferImageAwt = new ImageAWT(w, h2, false, 0xFFFFFF);
                this.xrayScreenImageAwt = new ImageAWT(w, h2, true, -16777216);
            }
        }
    }

    @Override
    public void setWindowIcon(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            this.shell.setImage(new Image(null, inputStream));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void showMessage(String message) {
        try {
            EmulatorScreen.setWindowOnTop(ReflectUtil.getHandle(this.shell), true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MessageBox messageBox = new MessageBox(this.shell);
        messageBox.setText(UILocale.get("MESSAGE_BOX_TITLE", "KEmulator Alert"));
        messageBox.setMessage(message);
        messageBox.open();
    }

    @Override
    public void showMessage(String title, String detail) {
        try {
            EmulatorScreen.setWindowOnTop(ReflectUtil.getHandle(this.shell), true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Shell shell = new Shell(this.shell, 2144);
        shell.setSize(450, 300);
        shell.setText(UILocale.get("MESSAGE_BOX_TITLE", "KEmulator Alert"));
        shell.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout(256));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label = new Label(composite, 0);
        label.setText(title);
        Composite composite_1 = new Composite((Composite)shell, 0);
        composite_1.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite_1.setLayout((Layout)new FillLayout(256));
        Text text = new Text(composite_1, 2826);
        text.setText(detail);
        Rectangle clientArea = this.shell.getMonitor().getClientArea();
        Point size = shell.getSize();
        shell.setLocation(clientArea.x + (clientArea.width - size.x) / 2, clientArea.y + (clientArea.height - size.y) / 2);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    @Override
    public void showMessageThreadSafe(String title, String detail) {
        display.syncExec(() -> this.showMessage(title, detail));
    }

    private void getWindowPos() {
        maximized = this.shell.getMaximized();
        if (!maximized && !fullscreen) {
            locX = this.shell.getLocation().x;
            locY = this.shell.getLocation().y;
            sizeW = this.shell.getSize().x;
            sizeH = this.shell.getSize().y;
        }
    }

    @Override
    public void runWithMidlet() {
        this.start(true);
    }

    @Override
    public void runEmpty() {
        this.start(false);
    }

    void start(boolean midletLoaded) {
        this.pauseState = midletLoaded ? 1 : 0;
        this.updatePauseState();
        try {
            if (sizeW > 0 && sizeH > 0) {
                this.shell.setSize(sizeW, sizeH);
            }
            this.windowResizedByUser = false;
            this.windowDecorationHeight = this.shell.getSize().y - this.shell.getClientArea().height;
            this.updateCanvasRect(true, sizeW <= 0 || sizeH <= 0, false);
            this.windowResizedByUser = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.showMessage(UILocale.get("LOAD_GDIPLUS_ERROR", "Can't load \" gdiplus.dll \" !!! Plz download & copy to %system32% path."));
            System.exit(1);
            return;
        }
        Rectangle clientArea = display.getPrimaryMonitor().getClientArea();
        if (locX == Integer.MIN_VALUE) {
            locX = clientArea.x + (clientArea.width - this.shell.getSize().x) >> 1;
        }
        if (locY == Integer.MIN_VALUE) {
            locY = clientArea.y + (clientArea.height - this.shell.getSize().y) >> 1;
        }
        this.shell.setLocation(locX, locY);
        display.asyncExec((Runnable)new WindowOpen(this, 1));
        display.asyncExec((Runnable)new WindowOpen(this, 2));
        if (midletLoaded) {
            String s = Emulator.getEmulator().getAppProperty("Nokia-UI-Enhancement");
            this.midletSupportsMultitouch = s != null && s.contains("EnableMultiPointTouchEvents");
        }
        this.shell.open();
        this.shell.addDisposeListener((DisposeListener)this);
        this.shell.addControlListener((ControlListener)this);
        if (maximized) {
            this.shell.setMaximized(true);
        }
        if (fullscreen) {
            Settings.resizeMode = ResizeMethod.Fit;
            this.shell.setMaximized(true);
        }
        this.win = Utils.win;
        if (this.win) {
            this.poller = new Win32KeyboardPoller(this);
            new Thread("KEmulator keyboard poll thread"){
                boolean b;

                @Override
                public void run() {
                    try {
                        if (this.b) {
                            if (EmulatorScreen.this.poller != null) {
                                EmulatorScreen.this.poller.pollKeyboard(EmulatorScreen.this.canvas);
                            }
                            Controllers.poll();
                            return;
                        }
                        this.b = true;
                        while (EmulatorScreen.this.shell != null && !EmulatorScreen.this.shell.isDisposed()) {
                            display.asyncExec((Runnable)this);
                            Thread.sleep(10L);
                        }
                    }
                    catch (Exception e2) {
                        System.err.println("Exception in keyboard poll thread");
                        e2.printStackTrace();
                    }
                }
            }.start();
        }
        try {
            while (this.shell != null && !this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Error e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
            CustomMethod.close();
            System.exit(1);
        }
        this.pauseState = 0;
    }

    @Override
    public void setSize(int x, int y) {
        if (this.pauseState == 1) {
            if (Settings.resizeMode == ResizeMethod.FollowWindowSize) {
                Settings.resizeMode = ResizeMethod.Fit;
                this.syncScalingModeSelection();
            }
            this.initScreenBuffer(x, y);
            this.updateCanvasRect(true, false, true);
            Emulator.getEventQueue().sizeChanged(x, y);
        }
    }

    private void rotate90degrees() {
        ++this.rotation;
        this.rotation %= 4;
        this.updateCanvasRect(true, false, true);
    }

    private void onWindowResized() {
        int newDecorH;
        boolean windowWasResizedByUser = this.windowResizedByUser;
        this.windowResizedByUser = true;
        if (windowWasResizedByUser) {
            this.windowAutosized = false;
        }
        boolean decorHChanged = (newDecorH = this.shell.getSize().y - this.shell.getClientArea().height) != this.windowDecorationHeight;
        this.windowDecorationHeight = newDecorH;
        if (windowWasResizedByUser || decorHChanged) {
            this.updateCanvasRect(decorHChanged && !windowWasResizedByUser, false, false);
        }
        this.updateStatus();
    }

    private void updateCanvasRect(boolean allowWindowResize, boolean forceWindowReset, boolean rotate) {
        if (this.shell.getFullScreen() || fullscreen) {
            allowWindowResize = false;
            forceWindowReset = false;
        }
        int nonRotatedW = this.getWidth();
        int nonRotatedH = this.getHeight();
        switch (this.rotation) {
            case 0: 
            case 2: {
                this.rotatedWidth = nonRotatedW;
                this.rotatedHeight = nonRotatedH;
                break;
            }
            case 1: 
            case 3: {
                this.rotatedWidth = nonRotatedH;
                this.rotatedHeight = nonRotatedW;
            }
        }
        int decorW = this.shell.getSize().x - this.shell.getClientArea().width;
        int statusH = fullscreen ? 0 : this.statusLabel.getSize().y;
        int cbw2 = this.canvas.getBorderWidth() * 2;
        int availableSpaceX = this.shell.getClientArea().width - cbw2;
        int availableSpaceY = this.shell.getClientArea().height - cbw2 - statusH;
        float suggestedFitZoom = Math.min((float)availableSpaceX / (float)this.rotatedWidth, (float)availableSpaceY / (float)this.rotatedHeight);
        ResizeMethod mode = Settings.resizeMode;
        if (forceWindowReset) {
            mode = ResizeMethod.Manual;
        }
        float finalZoom = suggestedFitZoom;
        switch (mode) {
            case FollowWindowSize: {
                this.rotatedWidth = (int)((float)availableSpaceX / Settings.canvasScale);
                this.rotatedHeight = (int)((float)availableSpaceY / Settings.canvasScale);
                this.realZoom = Settings.canvasScale;
                switch (this.rotation) {
                    case 0: 
                    case 2: {
                        nonRotatedW = this.rotatedWidth;
                        nonRotatedH = this.rotatedHeight;
                        break;
                    }
                    case 1: 
                    case 3: {
                        nonRotatedW = this.rotatedHeight;
                        nonRotatedH = this.rotatedWidth;
                    }
                }
                if (this.pauseState == 0 || this.getWidth() == nonRotatedW && this.getHeight() == nonRotatedH) break;
                this.initScreenBuffer(nonRotatedW, nonRotatedH);
                Emulator.getEventQueue().sizeChanged(nonRotatedW, nonRotatedH);
                break;
            }
            case FitInteger: {
                finalZoom = suggestedFitZoom >= 1.0f ? (float)Math.floor(suggestedFitZoom) : (float)(1.0 / Math.ceil(1.0 / (double)suggestedFitZoom));
            }
            case Fit: {
                if (!rotate) {
                    this.realZoom = finalZoom;
                    break;
                }
                finalZoom = this.realZoom;
            }
            case Manual: {
                boolean autoResize;
                if (mode == ResizeMethod.Manual) {
                    finalZoom = Settings.canvasScale;
                }
                boolean windowWasPerfect = this.windowAutosized || this.canvas.getClientArea().width == this.screenWidth && this.canvas.getClientArea().height == this.screenHeight;
                int cw = Math.max(120, (int)((float)this.rotatedWidth * finalZoom + (float)cbw2));
                int ch = (int)((float)this.rotatedHeight * finalZoom + (float)cbw2);
                this.realZoom = finalZoom;
                boolean overflow = !rotate && (cw > this.shell.getClientArea().width || ch > this.shell.getClientArea().height - statusH);
                boolean bl = autoResize = allowWindowResize && (windowWasPerfect || overflow) && !this.shell.getMaximized();
                if (autoResize || forceWindowReset) {
                    this.windowResizedByUser = false;
                    if (forceWindowReset) {
                        this.shell.setMaximized(false);
                    }
                    availableSpaceX = cw - cbw2;
                    availableSpaceY = ch - cbw2;
                    this.shell.setSize(cw + decorW, ch + statusH + this.windowDecorationHeight);
                    if (!rotate) {
                        this.windowAutosized = true;
                    }
                }
                if (!rotate) break;
                this.updateCanvasRect(true, false, false);
                return;
            }
            default: {
                throw new IllegalStateException("Unknown resize mode: " + (Object)((Object)Settings.resizeMode));
            }
        }
        this.screenWidth = (int)((float)nonRotatedW * this.realZoom);
        this.screenHeight = (int)((float)nonRotatedH * this.realZoom);
        switch (this.rotation) {
            case 0: 
            case 2: {
                this.screenX = (availableSpaceX - this.screenWidth) / 2;
                this.screenY = (availableSpaceY - this.screenHeight) / 2;
                break;
            }
            case 1: 
            case 3: {
                this.screenY = (availableSpaceX - this.screenHeight) / 2;
                this.screenX = (availableSpaceY - this.screenWidth) / 2;
            }
        }
        if (this.getScreenImg() != null) {
            this.wasResized = true;
            if (this.paintTransform == null) {
                this.paintTransform = new Transform(null);
            }
            this.paintTransform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            switch (this.rotation) {
                case 0: {
                    this.paintTransform.translate((float)this.screenX, (float)this.screenY);
                    break;
                }
                case 1: {
                    this.paintTransform.translate((float)this.screenY + (float)this.rotatedWidth * this.realZoom, (float)this.screenX);
                    this.paintTransform.rotate(90.0f);
                    break;
                }
                case 2: {
                    this.paintTransform.translate((float)this.screenX + (float)this.rotatedWidth * this.realZoom, (float)this.screenY + (float)this.rotatedHeight * this.realZoom);
                    this.paintTransform.rotate(180.0f);
                    break;
                }
                case 3: {
                    this.paintTransform.translate((float)this.screenY, (float)this.screenX + (float)this.rotatedHeight * this.realZoom);
                    this.paintTransform.rotate(270.0f);
                }
            }
        }
        this.canvas.redraw();
        this.updateStatus();
    }

    private void zoomIn() {
        if (Settings.resizeMode == ResizeMethod.Fit || Settings.resizeMode == ResizeMethod.FitInteger) {
            Settings.resizeMode = ResizeMethod.Manual;
            Settings.canvasScale = (float)(Math.floor(this.realZoom * 2.0f) / 2.0);
            this.syncScalingModeSelection();
        }
        Settings.canvasScale = Math.min(10.0f, Settings.canvasScale + 0.5f);
        this.updateCanvasRect(true, false, false);
    }

    private void zoomOut() {
        if (Settings.resizeMode == ResizeMethod.Fit || Settings.resizeMode == ResizeMethod.FitInteger) {
            Settings.resizeMode = ResizeMethod.Manual;
            Settings.canvasScale = (float)(Math.ceil(this.realZoom * 2.0f) / 2.0);
            this.syncScalingModeSelection();
        }
        Settings.canvasScale = Math.max(1.0f, Settings.canvasScale - 0.5f);
        this.updateCanvasRect(true, false, false);
    }

    private void pauseScreen() {
        if (this.screenImg != null && !this.screenImg.isDisposed()) {
            this.screenImg.dispose();
        }
        this.screenImg = new Image(null, this.getWidth(), this.getHeight());
        GC gc = new GC((Drawable)this.screenImg);
        if (Settings.g2d == 0) {
            this.screenImageSwt.copyToScreen(gc, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.getWidth(), this.getHeight());
        } else if (Settings.g2d == 1) {
            this.screenImageAwt.copyToScreen(gc, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.getWidth(), this.getHeight());
        }
        if (this.pauseState == 2) {
            gc.setAlpha(100);
            gc.setBackground(display.getSystemColor(15));
            gc.fillRectangle(0, 0, this.getWidth(), this.getHeight());
        }
        gc.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImage getScreenImg() {
        EmulatorScreen emulatorScreen = this;
        synchronized (emulatorScreen) {
            if (Settings.g2d == 0) {
                return this.screenImageSwt;
            }
            if (Settings.g2d == 1) {
                return this.screenImageAwt;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImage getBackBufferImage() {
        if (!Settings.asyncFlush) {
            return this.getScreenImg();
        }
        EmulatorScreen emulatorScreen = this;
        synchronized (emulatorScreen) {
            if (Settings.g2d == 0) {
                return this.backBufferImageSwt;
            }
            if (Settings.g2d == 1) {
                return this.backBufferImageAwt;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImage getXRayScreenImage() {
        EmulatorScreen emulatorScreen = this;
        synchronized (emulatorScreen) {
            if (Settings.g2d == 0) {
                return this.xrayScreenImageSwt;
            }
            if (Settings.g2d == 1) {
                return this.xrayScreenImageAwt;
            }
            return null;
        }
    }

    @Override
    public void repaint() {
        if (Emulator.getCurrentDisplay().getCurrent() == null || this.pauseState == 0) {
            return;
        }
        if (Settings.playingRecordedKeys) {
            String method698;
            KeyRecords h2 = Emulator.getRobot();
            while ((method698 = h2.method698(aLong982)) != null && method698.length() > 1) {
                char char1 = method698.charAt(0);
                String substring = method698.substring(1);
                if (char1 == '0') {
                    EmulatorScreen.method578(Integer.parseInt(substring));
                } else if (char1 == '1') {
                    EmulatorScreen.method580(Integer.parseInt(substring));
                }
                h2 = Emulator.getRobot();
            }
        } else if (Settings.enableKeyCache && !KeyMapping.keyCacheStack.empty()) {
            String s = (String)KeyMapping.keyCacheStack.pop();
            if (Settings.recordKeys && !Settings.playingRecordedKeys) {
                Emulator.getRobot().print(aLong982 + ":" + s);
            }
            char char2 = s.charAt(0);
            String substring2 = s.substring(1);
            if (char2 == '0') {
                EmulatorScreen.method578(Integer.parseInt(substring2));
            } else if (char2 == '1') {
                EmulatorScreen.method580(Integer.parseInt(substring2));
            }
        }
        if (Settings.asyncFlush) {
            if (this.paintPending) {
                return;
            }
            this.paintPending = true;
            display.asyncExec((Runnable)this);
            return;
        }
        display.syncExec((Runnable)this);
    }

    @Override
    public int getWidth() {
        return this.getScreenImg().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getScreenImg().getHeight();
    }

    @Override
    public void setLeftSoftLabel(String label) {
        if (this.leftSoftLabelText != null && this.leftSoftLabelText.equals(label)) {
            return;
        }
        this.leftSoftLabelText = label;
        display.syncExec(() -> this.leftSoftLabel.setText(label));
    }

    @Override
    public void setRightSoftLabel(String label) {
        if (this.rightSoftLabelText != null && this.rightSoftLabelText.equals(label)) {
            return;
        }
        this.rightSoftLabelText = label;
        display.syncExec(() -> this.rightSoftLabel.setText(label));
    }

    private void updateStatus() {
        String var8 = this.realZoom == 1.0f ? " " : "  ";
        StringBuffer var9 = new StringBuffer();
        var9.append((int)(this.realZoom * 100.0f));
        var9.append("%");
        var9.append(var8);
        if (this.pauseState != 1) {
            var9.append(this.pauseStateStrings[this.pauseState]);
            var9.append(var8);
        }
        if (this.pauseState == 1 && Settings.fpsCounter) {
            var9.append(Profiler.FPS);
            var9.append(" FPS");
            var9.append(var8);
        }
        if (Settings.speedModifier > 0) {
            var9.append("x");
        }
        var9.append(Settings.speedModifier);
        this.statusLabel.setText(var9.toString());
    }

    private void initShell() {
        GridLayout layout = new GridLayout();
        new GridLayout().numColumns = 3;
        layout.horizontalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = false;
        this.shell = new Shell(fullscreen ? 0 : 1264);
        this.shell.setText(Emulator.getTitle(null));
        this.shell.addListener(21, event -> CustomMethod.close());
        this.shell.setMinimumSize(120, 50);
        this.shell.setLayout((Layout)layout);
        try {
            if (f == null) {
                FontData fd = this.shell.getFont().getFontData()[0];
                fd.height = fd.height / (float)(-fd.data.lfHeight) * 12.0f;
                f = new Font((Device)this.shell.getDisplay(), fd);
            }
            this.shell.setFont(f);
        }
        catch (Error error) {
            // empty catch block
        }
        this.initCanvas();
        this.leftSoftLabel = new CLabel((Composite)this.shell, 0);
        this.leftSoftLabel.setText("\t");
        this.leftSoftLabel.addMouseListener((MouseListener)new Class43(this));
        this.statusLabel = new CLabel((Composite)this.shell, 0x1000000);
        this.statusLabel.setText("");
        this.rightSoftLabel = new CLabel((Composite)this.shell, 131072);
        this.rightSoftLabel.setText("\t");
        this.rightSoftLabel.addMouseListener((MouseListener)new Class50(this));
        this.initMenu();
        this.setFullscreen(fullscreen);
        this.shell.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/res/icon")));
        this.shell.addShellListener((ShellListener)new Class53(this));
    }

    private void setFullscreen(boolean fullscreen) {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        layoutData.verticalAlignment = 2;
        layoutData.exclude = fullscreen;
        GridData layoutData2 = new GridData();
        new GridData().horizontalAlignment = 3;
        layoutData2.verticalSpan = 1;
        layoutData2.grabExcessHorizontalSpace = false;
        layoutData2.verticalAlignment = 2;
        layoutData2.exclude = fullscreen;
        GridData layoutData3 = new GridData();
        new GridData().horizontalAlignment = 1;
        layoutData3.verticalSpan = 1;
        layoutData3.grabExcessHorizontalSpace = false;
        layoutData3.verticalAlignment = 2;
        layoutData3.exclude = fullscreen;
        this.leftSoftLabel.setLayoutData((Object)layoutData3);
        this.statusLabel.setLayoutData((Object)layoutData);
        this.rightSoftLabel.setLayoutData((Object)layoutData2);
        this.shell.setMenuBar(fullscreen ? null : this.menu);
    }

    private void changeFullscreen() {
        Shell tempShell = new Shell();
        this.canvas.setParent((Composite)tempShell);
        this.shell.removeDisposeListener((DisposeListener)this);
        this.shell.removeControlListener((ControlListener)this);
        this.shell.dispose();
        maximized = false;
        this.initShell();
        this.start(this.pauseState != 0);
        tempShell.dispose();
    }

    private void initMenu() {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu((Decorations)this.shell, 2);
        MenuItem menuItemMidlet = new MenuItem(this.menu, 64);
        menuItemMidlet.setText(UILocale.get("MENU_MIDLET", "Midlet"));
        MenuItem menuItemTool = new MenuItem(this.menu, 64);
        menuItemTool.setText(UILocale.get("MENU_TOOL", "Tool"));
        MenuItem menuItemView = new MenuItem(this.menu, 64);
        menuItemView.setText(UILocale.get("MENU_VIEW", "View"));
        this.menuView = new Menu(menuItemView);
        this.infosMenuItem = new MenuItem(this.menuView, 32);
        this.infosMenuItem.setText(UILocale.get("MENU_VIEW_INFO", "Infos") + "\tCtrl+I");
        this.infosMenuItem.addSelectionListener((SelectionListener)this);
        this.xrayViewMenuItem = new MenuItem(this.menuView, 32);
        this.xrayViewMenuItem.setText(UILocale.get("MENU_VIEW_XRAY", "X-Ray View") + "\tAlt+X");
        this.xrayViewMenuItem.addSelectionListener((SelectionListener)this);
        if (!Emulator.isX64()) {
            this.alwaysOnTopMenuItem = new MenuItem(this.menuView, 32);
            this.alwaysOnTopMenuItem.setText(UILocale.get("MENU_VIEW_TOP", "Always On Top") + "\tCtrl+O");
            this.alwaysOnTopMenuItem.addSelectionListener((SelectionListener)this);
            this.alwaysOnTopMenuItem.setSelection(Settings.alwaysOnTop);
        }
        this.rotateScreenMenuItem = new MenuItem(this.menuView, 8);
        this.rotateScreenMenuItem.setText(UILocale.get("MENU_VIEW_ROTATE", "Rotate Screen") + "\tCtrl+Y");
        this.rotateScreenMenuItem.addSelectionListener((SelectionListener)this);
        this.rotate90MenuItem = new MenuItem(this.menuView, 8);
        this.rotate90MenuItem.setText(UILocale.get("MENU_VIEW_ROTATE_90", "Rotate 90 Degrees") + "\tAlt+Y");
        this.rotate90MenuItem.addSelectionListener((SelectionListener)this);
        this.forcePaintMenuItem = new MenuItem(this.menuView, 8);
        this.forcePaintMenuItem.setText(UILocale.get("MENU_VIEW_FORCE_PAINT", "Force Paint") + "\tCtrl+F");
        this.forcePaintMenuItem.addSelectionListener((SelectionListener)this);
        try {
            EmulatorScreen.setWindowOnTop(ReflectUtil.getHandle(this.shell), Settings.alwaysOnTop);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        new MenuItem(this.menuView, 2);
        this.keypadMenuItem = new MenuItem(this.menuView, 8);
        this.keypadMenuItem.setText(UILocale.get("MENU_VIEW_KEYPAD", "Keypad"));
        this.keypadMenuItem.addSelectionListener((SelectionListener)this);
        this.watchesMenuItem = new MenuItem(this.menuView, 8);
        this.watchesMenuItem.setText(UILocale.get("MENU_VIEW_WATCHES", "Watches"));
        this.watchesMenuItem.addSelectionListener((SelectionListener)this);
        this.profilerMenuItem = new MenuItem(this.menuView, 8);
        this.profilerMenuItem.setText(UILocale.get("MENU_VIEW_PROFILER", "Profiler"));
        this.profilerMenuItem.addSelectionListener((SelectionListener)this);
        this.methodsMenuItem = new MenuItem(this.menuView, 8);
        this.methodsMenuItem.setText(UILocale.get("MENU_VIEW_METHODS", "Methods"));
        this.methodsMenuItem.addSelectionListener((SelectionListener)this);
        this.memoryViewMenuItem = new MenuItem(this.menuView, 8);
        this.memoryViewMenuItem.setText(UILocale.get("MENU_VIEW_MEMORY", "Memory View"));
        this.mediaViewMenuItem = new MenuItem(this.menuView, 8);
        this.mediaViewMenuItem.setText(UILocale.get("MENU_VIEW_MEDIA", "Media View"));
        this.m3gViewMenuItem = new MenuItem(this.menuView, 8);
        this.m3gViewMenuItem.setText(UILocale.get("MENU_VIEW_M3GVIEW", "M3G View"));
        this.m3gViewMenuItem.setEnabled(Settings.g3d == 1);
        this.m3gViewMenuItem.addSelectionListener((SelectionListener)this);
        this.memoryViewMenuItem.addSelectionListener((SelectionListener)this);
        this.mediaViewMenuItem.addSelectionListener((SelectionListener)this);
        this.smsConsoleMenuItem = new MenuItem(this.menuView, 8);
        this.smsConsoleMenuItem.setText(UILocale.get("MENU_VIEW_SMS", "SMS Console"));
        this.smsConsoleMenuItem.addSelectionListener((SelectionListener)this);
        this.sensorMenuItem = new MenuItem(this.menuView, 8);
        this.sensorMenuItem.setText(UILocale.get("MENU_VIEW_SENSOR", "Sensor Simulator"));
        this.sensorMenuItem.addSelectionListener((SelectionListener)this);
        this.devUtilsMenuItem = new MenuItem(this.menuView, 8);
        this.devUtilsMenuItem.setText("IntelliJ IDEA support");
        this.devUtilsMenuItem.addSelectionListener((SelectionListener)this);
        this.logMenuItem = new MenuItem(this.menuView, 8);
        this.logMenuItem.setText(UILocale.get("MENU_VIEW_LOG", "Log"));
        this.logMenuItem.addSelectionListener((SelectionListener)this);
        new MenuItem(this.menuView, 2);
        this.optionsMenuItem = new MenuItem(this.menuView, 8);
        this.optionsMenuItem.setText(UILocale.get("MENU_VIEW_OPTIONS", "Options..."));
        this.optionsMenuItem.addSelectionListener((SelectionListener)this);
        this.helpMenuItem = new MenuItem(this.menuView, 8);
        this.helpMenuItem.setText(UILocale.get("MENU_VIEW_HELP", "About"));
        this.helpMenuItem.addSelectionListener((SelectionListener)this);
        this.updateMenuItem = new MenuItem(this.menuView, 8);
        this.updateMenuItem.setText(UILocale.get("MENU_VIEW_CHECK_UPDATE", "Check for Updates"));
        this.updateMenuItem.addSelectionListener((SelectionListener)this);
        menuItemView.setMenu(this.menuView);
        this.menuTool = new Menu(menuItemTool);
        this.zoomInMenuItem = new MenuItem(this.menuTool, 8);
        this.zoomInMenuItem.setText(UILocale.get("MENU_TOOL_ZOOMIN", "Zoom In") + "\tPad+");
        this.zoomInMenuItem.addSelectionListener((SelectionListener)this);
        this.zoomOutMenuItem = new MenuItem(this.menuTool, 8);
        this.zoomOutMenuItem.setText(UILocale.get("MENU_TOOL_ZOOMOUT", "Zoom Out") + "\tPad-");
        this.zoomOutMenuItem.addSelectionListener((SelectionListener)this);
        SelectionAdapter interpolationListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                if (e2.widget == EmulatorScreen.this.interposeNearestMenuItem) {
                    Settings.interpolation = 0;
                    EmulatorScreen.this.interposeNearestMenuItem.setSelection(true);
                    EmulatorScreen.this.interposeLowMenuItem.setSelection(false);
                    EmulatorScreen.this.interposeHighMenuItem.setSelection(false);
                } else if (e2.widget == EmulatorScreen.this.interposeLowMenuItem) {
                    Settings.interpolation = 1;
                    EmulatorScreen.this.interposeNearestMenuItem.setSelection(false);
                    EmulatorScreen.this.interposeLowMenuItem.setSelection(true);
                    EmulatorScreen.this.interposeHighMenuItem.setSelection(false);
                } else if (e2.widget == EmulatorScreen.this.interposeHighMenuItem) {
                    Settings.interpolation = 2;
                    EmulatorScreen.this.interposeNearestMenuItem.setSelection(false);
                    EmulatorScreen.this.interposeLowMenuItem.setSelection(false);
                    EmulatorScreen.this.interposeHighMenuItem.setSelection(true);
                }
                EmulatorScreen.this.repaint();
            }
        };
        MenuItem interpolationMenuItem = new MenuItem(this.menuTool, 64);
        interpolationMenuItem.setText(UILocale.get("MENU_TOOL_INTERPOSE", "Interpolation"));
        Menu menuInterpolation = new Menu((Decorations)this.shell, 0x400004);
        this.interposeNearestMenuItem = new MenuItem(menuInterpolation, 16);
        this.interposeNearestMenuItem.setText(UILocale.get("MENU_TOOL_INTER_NEAREST", "NearestNeighbor"));
        this.interposeNearestMenuItem.setSelection(Settings.interpolation == 0);
        this.interposeNearestMenuItem.addSelectionListener((SelectionListener)interpolationListener);
        this.interposeLowMenuItem = new MenuItem(menuInterpolation, 16);
        this.interposeLowMenuItem.setText(UILocale.get("MENU_TOOL_INTER_LOW", "LowQuality"));
        this.interposeLowMenuItem.setSelection(Settings.interpolation == 1);
        this.interposeLowMenuItem.addSelectionListener((SelectionListener)interpolationListener);
        this.interposeHighMenuItem = new MenuItem(menuInterpolation, 16);
        this.interposeHighMenuItem.setText(UILocale.get("MENU_TOOL_INTER_HIGH", "HighQuality"));
        this.interposeHighMenuItem.setSelection(Settings.interpolation == 2);
        this.interposeHighMenuItem.addSelectionListener((SelectionListener)interpolationListener);
        interpolationMenuItem.setMenu(menuInterpolation);
        MenuItem resizeMenuItem = new MenuItem(this.menuTool, 64);
        resizeMenuItem.setText(UILocale.get("MENU_TOOL_RESIZE_MODE", "Display mode"));
        this.menuResize = new Menu((Decorations)this.shell, 0x400004);
        this.centerOnScreenMenuItem = new MenuItem(this.menuResize, 16);
        this.centerOnScreenMenuItem.setText(UILocale.get("MENU_TOOL_RESIZE_MODE_CENTER", "Center screen"));
        this.centerOnScreenMenuItem.addSelectionListener((SelectionListener)this);
        this.fillScreenMenuItem = new MenuItem(this.menuResize, 16);
        this.fillScreenMenuItem.setText(UILocale.get("MENU_TOOL_RESIZE_MODE_FILL", "Fit window"));
        this.fillScreenMenuItem.addSelectionListener((SelectionListener)this);
        this.integerScalingMenuItem = new MenuItem(this.menuResize, 16);
        this.integerScalingMenuItem.setText(UILocale.get("MENU_TOOL_RESIZE_MODE_FILL_INT", "Fit window (Integer scaling)"));
        this.integerScalingMenuItem.addSelectionListener((SelectionListener)this);
        this.syncSizeMenuItem = new MenuItem(this.menuResize, 16);
        this.syncSizeMenuItem.setText(UILocale.get("MENU_TOOL_RESIZE_MODE_SYNC", "Sync screen size"));
        this.syncSizeMenuItem.addSelectionListener((SelectionListener)this);
        new MenuItem(this.menuResize, 2);
        this.changeResMenuItem = new MenuItem(this.menuResize, 8);
        this.changeResMenuItem.setText(UILocale.get("MENU_TOOL_RESIZE_SET", "Change screen size"));
        this.changeResMenuItem.addSelectionListener((SelectionListener)this);
        this.resetSizeMenuItem = new MenuItem(this.menuResize, 8);
        this.resetSizeMenuItem.setText(UILocale.get("MENU_TOOL_RESIZE_RESET", "Reset window size"));
        this.resetSizeMenuItem.addSelectionListener((SelectionListener)this);
        this.fullscreenMenuItem = new MenuItem(this.menuResize, 32);
        this.fullscreenMenuItem.setText(UILocale.get("MENU_TOOL_TOGGLE_FULLSCREEN", "Toggle fullscreen") + "\tF11");
        this.fullscreenMenuItem.addSelectionListener((SelectionListener)this);
        this.fullscreenMenuItem.setSelection(fullscreen);
        resizeMenuItem.setMenu(this.menuResize);
        this.syncScalingModeSelection();
        new MenuItem(this.menuTool, 2);
        this.speedUpMenuItem = new MenuItem(this.menuTool, 8);
        this.speedUpMenuItem.setText(UILocale.get("MENU_TOOL_SPEEDUP", "Speed Up") + (!Settings.altLessSpeedShortcuts ? "\tAlt+>" : "\t>"));
        this.speedUpMenuItem.addSelectionListener((SelectionListener)this);
        this.slowDownMenuItem = new MenuItem(this.menuTool, 8);
        this.slowDownMenuItem.setText(UILocale.get("MENU_TOOL_SPEEDDOWN", "Slow Down") + (!Settings.altLessSpeedShortcuts ? "\tAlt+<" : "\t<"));
        this.slowDownMenuItem.addSelectionListener((SelectionListener)this);
        this.resetSpeedMenuItem = new MenuItem(this.menuTool, 8);
        this.resetSpeedMenuItem.setText(UILocale.get("MENU_TOOL_SPEEDRESET", "Reset Speed") + (!Settings.altLessSpeedShortcuts ? "\tAlt+?" : "\t?"));
        this.resetSpeedMenuItem.addSelectionListener((SelectionListener)this);
        new MenuItem(this.menuTool, 2);
        this.recordKeysMenuItem = new MenuItem(this.menuTool, 32);
        this.recordKeysMenuItem.setText(UILocale.get("MENU_TOOL_RECORD_KEY", "Record Keys"));
        this.recordKeysMenuItem.addSelectionListener((SelectionListener)this);
        this.recordKeysMenuItem.setSelection(Settings.recordKeys);
        this.recordKeysMenuItem.setEnabled(!Settings.playingRecordedKeys);
        this.enableAutoplayMenuItem = new MenuItem(this.menuTool, 32);
        this.enableAutoplayMenuItem.setText(UILocale.get("MENU_TOOL_AUTO_PLAY", "Enable Autoplay"));
        this.enableAutoplayMenuItem.addSelectionListener((SelectionListener)this);
        this.enableAutoplayMenuItem.setSelection(Settings.playingRecordedKeys);
        this.enableAutoplayMenuItem.setEnabled(Settings.playingRecordedKeys);
        new MenuItem(this.menuTool, 2);
        this.captureToFileMenuItem = new MenuItem(this.menuTool, 8);
        this.captureToFileMenuItem.setText(UILocale.get("MENU_TOOL_CAPTURE_FILE", "Capture to File") + "\tAlt+C");
        this.captureToFileMenuItem.addSelectionListener((SelectionListener)this);
        this.captureToClipboardMenuItem = new MenuItem(this.menuTool, 8);
        this.captureToClipboardMenuItem.setText(UILocale.get("MENU_TOOL_CAPTURE_CLIP", "Capture to ClipBoard") + "\tAlt+S");
        this.captureToClipboardMenuItem.setAccelerator(65619);
        this.captureToClipboardMenuItem.addSelectionListener((SelectionListener)this);
        new MenuItem(this.menuTool, 2);
        this.showTrackInfoMenuItem = new MenuItem(this.menuTool, 32);
        this.showTrackInfoMenuItem.setText(UILocale.get("MENU_TOOL_SHOW_TRACK_INFO", "Show Track Info") + "\tCtrl+F3");
        this.showTrackInfoMenuItem.setSelection(Settings.threadMethodTrack);
        this.showTrackInfoMenuItem.addSelectionListener((SelectionListener)this);
        this.showTrackInfoMenuItem.setAccelerator(17039372);
        this.canvasKeyboardMenuItem = new MenuItem(this.menuTool, 32);
        this.canvasKeyboardMenuItem.setText(UILocale.get("MENU_TOOL_QWERTY_MODE", "QWERTY Mode"));
        this.canvasKeyboardMenuItem.setSelection(Settings.canvasKeyboard);
        this.canvasKeyboardMenuItem.addSelectionListener((SelectionListener)this);
        this.networkKillswitchMenuItem = new MenuItem(this.menuTool, 32);
        this.networkKillswitchMenuItem.setText(UILocale.get("MENU_TOOL_DISABLE_NETWORK_ACCESS", "Disable network access"));
        this.networkKillswitchMenuItem.setSelection(Settings.networkNotAvailable);
        this.networkKillswitchMenuItem.addSelectionListener((SelectionListener)this);
        menuItemTool.setMenu(this.menuTool);
        this.menuMidlet = new Menu(menuItemMidlet);
        this.loadJarMenuItem = new MenuItem(this.menuMidlet, 8);
        this.loadJarMenuItem.setText(UILocale.get("MENU_MIDLET_LOAD_JAR", "Load jar..."));
        this.loadJarMenuItem.addSelectionListener((SelectionListener)this);
        this.loadAutoPlayMenuItem = new MenuItem(this.menuMidlet, 8);
        this.loadAutoPlayMenuItem.setText(UILocale.get("MENU_MIDLET_LOAD_AUTO_PLAY", "Load auto-play record"));
        this.loadAutoPlayMenuItem.addSelectionListener((SelectionListener)this);
        MenuItem menuItem5 = new MenuItem(this.menuMidlet, 64);
        menuItem5.setText(UILocale.get("MENU_MIDLET_RECENTLY", "Recent jarfiles"));
        Menu aMenu1018 = new Menu((Decorations)this.shell, 0x400004);
        for (int n = 1; n < 5 && !Settings.recentJars[n].equals(""); ++n) {
            String s;
            String f2 = s.substring(s.lastIndexOf((s = Settings.recentJars[n]).lastIndexOf(92) > 0 ? 92 : 47) + 1).trim();
            MenuItem menuItem6 = new MenuItem(aMenu1018, 8);
            menuItem6.setText("&" + n + " " + f2 + " " + (s.length() > 10 ? '[' + s.substring(0, 10) + "...]" : '[' + s + ']'));
            menuItem6.setAccelerator(SWT.MOD1 + 49 + n - 1);
            menuItem6.addSelectionListener((SelectionListener)new Class45(this, n));
        }
        menuItem5.setMenu(aMenu1018);
        new MenuItem(this.menuMidlet, 2);
        this.openJadMenuItem = new MenuItem(this.menuMidlet, 8);
        this.openJadMenuItem.setText(UILocale.get("MENU_MIDLET_JAD", "Open JAD with Notepad") + "\tCtrl+D");
        this.openJadMenuItem.addSelectionListener((SelectionListener)this);
        new MenuItem(this.menuMidlet, 2);
        MenuItem menuItem7 = new MenuItem(this.menuMidlet, 64);
        menuItem7.setText(UILocale.get("MENU_MIDLET_2D_ENGINE", "2D Engine"));
        this.menu2dEngine = new Menu((Decorations)this.shell, 0x400004);
        this.awt2dMenuItem = new MenuItem(this.menu2dEngine, 16);
        this.awt2dMenuItem.setText("AWT-Graphics");
        this.awt2dMenuItem.setSelection(Settings.g2d == 1);
        this.awt2dMenuItem.addSelectionListener((SelectionListener)this);
        this.swt2dMenuItem = new MenuItem(this.menu2dEngine, 16);
        this.swt2dMenuItem.setText("SWT-GDI+");
        this.swt2dMenuItem.setSelection(Settings.g2d == 0);
        this.swt2dMenuItem.addSelectionListener((SelectionListener)this);
        menuItem7.setMenu(this.menu2dEngine);
        MenuItem engineM3GGroup = new MenuItem(this.menuMidlet, 64);
        engineM3GGroup.setText(UILocale.get("MENU_MIDLET_M3G_ENGINE", "M3G Engine"));
        this.menuM3GEngine = new Menu((Decorations)this.shell, 0x400004);
        engineM3GGroup.setMenu(this.menuM3GEngine);
        this.lwj3dMenuItem = new MenuItem(this.menuM3GEngine, 16);
        this.lwj3dMenuItem.setText("LWJGL");
        this.lwj3dMenuItem.setSelection(Settings.g3d == 1);
        this.lwj3dMenuItem.addSelectionListener((SelectionListener)this);
        this.swerve3dMenuItem = new MenuItem(this.menuM3GEngine, 16);
        this.swerve3dMenuItem.setText("Swerve");
        this.swerve3dMenuItem.setSelection(Settings.g3d == 0);
        this.swerve3dMenuItem.setEnabled(!Emulator.isX64());
        this.swerve3dMenuItem.addSelectionListener((SelectionListener)this);
        MenuItem engineM3DGroup = new MenuItem(this.menuMidlet, 64);
        engineM3DGroup.setText(UILocale.get("MENU_MIDLET_M3D_ENGINE", "MascotCapsule Engine"));
        this.menuM3DEngine = new Menu((Decorations)this.shell, 0x400004);
        engineM3DGroup.setMenu(this.menuM3DEngine);
        this.glM3DMenuItem = new MenuItem(this.menuM3DEngine, 16);
        this.glM3DMenuItem.setText("LWJGL");
        this.glM3DMenuItem.setSelection(Settings.micro3d == 1);
        this.glM3DMenuItem.addSelectionListener((SelectionListener)this);
        this.softM3DMenuItem = new MenuItem(this.menuM3DEngine, 16);
        this.softM3DMenuItem.setText("Software");
        this.softM3DMenuItem.setSelection(Settings.micro3d == 0);
        this.softM3DMenuItem.setEnabled(!Emulator.isX64());
        this.softM3DMenuItem.addSelectionListener((SelectionListener)this);
        new MenuItem(this.menuMidlet, 2);
        this.suspendMenuItem = new MenuItem(this.menuMidlet, 8);
        this.suspendMenuItem.setText(UILocale.get("MENU_MIDLET_SUSPEND", "Suspend") + "\tCtrl+S");
        this.suspendMenuItem.addSelectionListener((SelectionListener)this);
        this.resumeMenuItem = new MenuItem(this.menuMidlet, 8);
        this.resumeMenuItem.setText(UILocale.get("MENU_MIDLET_RESUME", "Resume") + "\tCtrl+E");
        this.resumeMenuItem.addSelectionListener((SelectionListener)this);
        new MenuItem(this.menuMidlet, 2);
        this.pausestepMenuItem = new MenuItem(this.menuMidlet, 8);
        this.pausestepMenuItem.setText(UILocale.get("MENU_MIDLET_PAUSE_STEP", "Pause/Step") + "\tCtrl+T");
        this.pausestepMenuItem.addSelectionListener((SelectionListener)this);
        this.playResumeMenuItem = new MenuItem(this.menuMidlet, 8);
        this.playResumeMenuItem.setText(UILocale.get("MENU_MIDLET_PLAY_RESUME", "Play/Resume") + "\tCtrl+R");
        this.playResumeMenuItem.addSelectionListener((SelectionListener)this);
        new MenuItem(this.menuMidlet, 2);
        this.restartMenuItem = new MenuItem(this.menuMidlet, 8);
        this.restartMenuItem.setText(UILocale.get("MENU_MIDLET_RESTART", "Restart") + "\tAlt+R");
        this.restartMenuItem.setAccelerator(65618);
        this.restartMenuItem.addSelectionListener((SelectionListener)this);
        this.exitMenuItem = new MenuItem(this.menuMidlet, 8);
        this.exitMenuItem.setText(UILocale.get("MENU_MIDLET_EXIT", "Exit"));
        this.exitMenuItem.addSelectionListener((SelectionListener)this);
        menuItemMidlet.setMenu(this.menuMidlet);
        this.infosMenuItem.setAccelerator(262217);
        this.xrayViewMenuItem.setAccelerator(65624);
        if (this.alwaysOnTopMenuItem != null) {
            this.alwaysOnTopMenuItem.setAccelerator(262223);
        }
        this.rotateScreenMenuItem.setAccelerator(262233);
        this.rotate90MenuItem.setAccelerator(65625);
        this.forcePaintMenuItem.setAccelerator(262214);
        this.speedUpMenuItem.setAccelerator(!Settings.altLessSpeedShortcuts ? 65582 : 46);
        this.slowDownMenuItem.setAccelerator(!Settings.altLessSpeedShortcuts ? 65580 : 44);
        this.resetSpeedMenuItem.setAccelerator(!Settings.altLessSpeedShortcuts ? 65583 : 47);
        this.suspendMenuItem.setAccelerator(262227);
        this.resumeMenuItem.setAccelerator(262213);
        this.openJadMenuItem.setAccelerator(262212);
        this.pausestepMenuItem.setAccelerator(262228);
        this.playResumeMenuItem.setAccelerator(262226);
        this.toggleMenuAccelerators(!Settings.canvasKeyboard);
        this.shell.setMenuBar(this.menu);
    }

    void toggleMenuAccelerators(boolean b2) {
        this.captureToFileMenuItem.setAccelerator(b2 ? 65603 : 0);
    }

    public static void pause() {
        Settings.steps = 0;
    }

    static void pauseStep() {
        Settings.steps = 1;
    }

    public void resumeStep() {
        Settings.steps = -1;
        if (this.screenImg != null && !this.screenImg.isDisposed()) {
            this.screenImg.dispose();
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Menu parent;
        MenuItem menuItem;
        block135: {
            block136: {
                block137: {
                    String s;
                    String open3;
                    block138: {
                        block134: {
                            menuItem = (MenuItem)selectionEvent.widget;
                            parent = menuItem.getParent();
                            if (parent != this.menuTool) break block134;
                            if (menuItem == this.captureToFileMenuItem) {
                                if (this.pauseState != 0) {
                                    String string = Emulator.getUserPath() + "/capture/";
                                    File file = new File(string);
                                    if (!file.exists() || !file.isDirectory()) {
                                        file.mkdir();
                                    }
                                    if (Settings.g2d == 0) {
                                        this.screenCopySwt.saveToFile(string + aString993 + captureFileCounter + ".png");
                                    } else if (Settings.g2d == 1) {
                                        this.screenCopyAwt.saveToFile(string + aString993 + captureFileCounter + ".png");
                                    }
                                    ++captureFileCounter;
                                }
                            } else if (menuItem == this.captureToClipboardMenuItem) {
                                if (this.pauseState != 0) {
                                    if (Settings.g2d == 0) {
                                        this.screenCopySwt.copyToClipBoard();
                                        return;
                                    }
                                    if (Settings.g2d == 1) {
                                        this.screenCopyAwt.copyToClipBoard();
                                    }
                                }
                            } else {
                                if (menuItem == this.canvasKeyboardMenuItem) {
                                    Settings.canvasKeyboard = this.canvasKeyboardMenuItem.getSelection();
                                    this.toggleMenuAccelerators(!Settings.canvasKeyboard);
                                    return;
                                }
                                if (menuItem == this.networkKillswitchMenuItem) {
                                    Settings.networkNotAvailable = !Settings.networkNotAvailable;
                                    this.networkKillswitchMenuItem.setSelection(Settings.networkNotAvailable);
                                    return;
                                }
                                if (menuItem == this.showTrackInfoMenuItem) {
                                    Settings.threadMethodTrack = !Settings.threadMethodTrack;
                                    this.showTrackInfoMenuItem.setSelection(Settings.threadMethodTrack);
                                    return;
                                }
                                if (menuItem == this.zoomInMenuItem) {
                                    this.zoomIn();
                                    return;
                                }
                                if (menuItem == this.zoomOutMenuItem) {
                                    this.zoomOut();
                                    return;
                                }
                                if (menuItem == this.resetSpeedMenuItem) {
                                    Settings.speedModifier = 1;
                                    this.updateStatus();
                                } else if (menuItem == this.speedUpMenuItem) {
                                    if (Settings.speedModifier == -1) {
                                        Settings.speedModifier = 1;
                                        this.updateStatus();
                                        return;
                                    }
                                    if (Settings.speedModifier < 100) {
                                        ++Settings.speedModifier;
                                        this.updateStatus();
                                    }
                                } else if (menuItem == this.slowDownMenuItem) {
                                    if (Settings.speedModifier == 1) {
                                        Settings.speedModifier = -1;
                                        this.updateStatus();
                                        return;
                                    }
                                    if (Settings.speedModifier > -100) {
                                        --Settings.speedModifier;
                                        this.updateStatus();
                                    }
                                } else {
                                    if (menuItem == this.recordKeysMenuItem) {
                                        Settings.recordKeys = !Settings.recordKeys;
                                        return;
                                    }
                                    if (menuItem == this.enableAutoplayMenuItem) {
                                        Settings.playingRecordedKeys = !Settings.playingRecordedKeys;
                                    }
                                }
                            }
                            break block135;
                        }
                        if (parent != this.menuMidlet) break block135;
                        boolean equals = false;
                        if (menuItem == this.exitMenuItem) {
                            this.shell.close();
                            Thread.yield();
                            this.shell.dispose();
                            return;
                        }
                        if (menuItem == this.restartMenuItem) {
                            Emulator.loadGame(null, false);
                            return;
                        }
                        if (menuItem == this.loadJarMenuItem) {
                            EmulatorScreen.pauseStep();
                            FileDialog fileDialog2 = new FileDialog(this.shell, 4096);
                            fileDialog2.setText(UILocale.get("OPEN_JAR_FILE", "Open a jar file"));
                            fileDialog2.setFilterExtensions(new String[]{"*.jar;*.jad;*.jam", "*.*"});
                            String open2 = fileDialog2.open();
                            if (open2 != null) {
                                Settings.recordedKeysFile = null;
                                Emulator.loadGame(open2, equals);
                            }
                            this.resumeStep();
                            this.updatePauseState();
                            return;
                        }
                        if (menuItem != this.loadAutoPlayMenuItem) break block136;
                        EmulatorScreen.pauseStep();
                        FileDialog fileDialog3 = new FileDialog(this.shell, 4096);
                        fileDialog3.setText(UILocale.get("OPEN_REC_FILE", "Open a record file"));
                        fileDialog3.setFilterPath(Emulator.getUserPath());
                        fileDialog3.setFilterExtensions(new String[]{"*.rec", "*.*"});
                        open3 = fileDialog3.open();
                        if (open3 == null) break block137;
                        s = KeyRecords.method701(open3);
                        if (s != null && new File(s).exists()) break block138;
                        fileDialog3.setText(UILocale.get("LINK_JAR_FILE", "Specify a jar file"));
                        fileDialog3.setFileName("");
                        fileDialog3.setFilterExtensions(new String[]{"*.jar", "*.*"});
                        s = fileDialog3.open();
                        if (s == null) break block137;
                    }
                    Settings.recordedKeysFile = open3;
                    Emulator.loadGame(s, false);
                }
                this.resumeStep();
                this.updatePauseState();
                return;
            }
            if (menuItem == this.suspendMenuItem) {
                if (Emulator.getCurrentDisplay().getCurrent() != Emulator.getCanvas()) {
                    return;
                }
                this.pauseState = 2;
                Emulator.getEventQueue().queue(16);
                this.pauseScreen();
                this.canvas.redraw();
                this.updatePauseState();
                return;
            }
            if (menuItem == this.resumeMenuItem) {
                if (Emulator.getCurrentDisplay().getCurrent() != Emulator.getCanvas()) {
                    return;
                }
                this.pauseState = 1;
                Emulator.getEventQueue().queue(17);
                this.screenImg.dispose();
                if (Settings.steps == 0) {
                    this.pauseScreen();
                    this.canvas.redraw();
                } else {
                    try {
                        Emulator.getCanvas().repaint();
                    }
                    catch (Exception fileDialog3) {
                        // empty catch block
                    }
                }
                this.updatePauseState();
                return;
            }
            if (menuItem == this.pausestepMenuItem) {
                EmulatorScreen.pauseStep();
                this.updatePauseState();
                return;
            }
            if (menuItem == this.playResumeMenuItem) {
                this.resumeStep();
                this.updatePauseState();
                return;
            }
            if (menuItem == this.openJadMenuItem) {
                try {
                    String jadPath = Emulator.getJadPath();
                    if (jadPath != null) {
                        Emulator.openFileExternally(jadPath);
                    } else {
                        this.showMessage("The application doesn't have JAD with it.");
                    }
                }
                catch (Exception jadPath) {
                    // empty catch block
                }
                this.updatePauseState();
                return;
            }
        }
        if (parent == this.menu2dEngine) {
            if (menuItem == this.awt2dMenuItem) {
                if (this.pauseState != 0 && Settings.g2d != 1) {
                    Emulator.loadGame(null, 1, Settings.g3d, Settings.micro3d, false);
                    return;
                }
                Settings.g2d = 1;
                this.swt2dMenuItem.setSelection(false);
                this.awt2dMenuItem.setSelection(true);
            } else if (menuItem == this.swt2dMenuItem) {
                if (this.pauseState != 0 && Settings.g2d != 0) {
                    Emulator.loadGame(null, 0, Settings.g3d, Settings.micro3d, false);
                    return;
                }
                Settings.g2d = 0;
                this.awt2dMenuItem.setSelection(false);
                this.swt2dMenuItem.setSelection(true);
            }
            return;
        }
        if (parent == this.menuM3GEngine) {
            if (menuItem == this.swerve3dMenuItem) {
                if (this.pauseState != 0 && Settings.g3d != 0) {
                    Emulator.loadGame(null, Settings.g2d, 0, Settings.micro3d, false);
                    return;
                }
                Settings.g3d = 0;
                this.lwj3dMenuItem.setSelection(false);
                this.swerve3dMenuItem.setSelection(true);
            } else if (menuItem == this.lwj3dMenuItem) {
                if (this.pauseState != 0 && Settings.g3d != 1) {
                    Emulator.loadGame(null, Settings.g2d, 1, Settings.micro3d, false);
                    return;
                }
                Settings.g3d = 1;
                this.swerve3dMenuItem.setSelection(false);
                this.lwj3dMenuItem.setSelection(true);
            }
            return;
        }
        if (parent == this.menuM3DEngine) {
            if (menuItem == this.softM3DMenuItem) {
                if (this.pauseState != 0 && Settings.micro3d != 0) {
                    Emulator.loadGame(null, Settings.g2d, Settings.g3d, 0, false);
                    return;
                }
                Settings.micro3d = 0;
                this.glM3DMenuItem.setSelection(false);
                this.softM3DMenuItem.setSelection(true);
            } else if (menuItem == this.glM3DMenuItem) {
                if (this.pauseState != 0 && Settings.micro3d != 1) {
                    Emulator.loadGame(null, Settings.g2d, Settings.g3d, 1, false);
                    return;
                }
                Settings.micro3d = 1;
                this.softM3DMenuItem.setSelection(false);
                this.glM3DMenuItem.setSelection(true);
            }
            return;
        }
        if (parent == this.menuView) {
            if (menuItem == this.helpMenuItem) {
                new About().method454(this.shell);
                return;
            }
            if (menuItem == this.updateMenuItem) {
                if (Updater.state == 1) {
                    return;
                }
                new Thread(){

                    @Override
                    public void run() {
                        Updater.checkUpdate();
                        if (Updater.state == 2) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    EmulatorScreen.this.showUpdateDialog(1);
                                }
                            });
                            return;
                        }
                        if (Updater.state == 3) {
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    EmulatorScreen.this.showMessage(UILocale.get("UPDATE_ALREADY_LATEST_TEXT", "You already have the latest version of KEmulator."));
                                }
                            });
                        }
                    }
                }.start();
                return;
            }
            if (menuItem == this.optionsMenuItem) {
                ((Property)Emulator.getEmulator().getProperty()).open(this.shell);
                return;
            }
            if (menuItem == this.alwaysOnTopMenuItem) {
                Settings.alwaysOnTop = this.alwaysOnTopMenuItem.getSelection();
                try {
                    EmulatorScreen.setWindowOnTop(ReflectUtil.getHandle(this.shell), Settings.alwaysOnTop);
                }
                catch (Throwable equals) {
                    // empty catch block
                }
                return;
            }
            if (menuItem == this.logMenuItem) {
                if (((Log)Emulator.getEmulator().getLogStream()).isLogOpen()) {
                    ((Log)Emulator.getEmulator().getLogStream()).dispose();
                    return;
                }
                ((Log)Emulator.getEmulator().getLogStream()).createWindow(this.shell);
                return;
            }
            if (menuItem == this.keypadMenuItem) {
                if (((SWTFrontend)Emulator.getEmulator()).getKeyPad().method834()) {
                    ((SWTFrontend)Emulator.getEmulator()).getKeyPad().dipose();
                    return;
                }
                ((SWTFrontend)Emulator.getEmulator()).getKeyPad().method835(this.shell);
                return;
            }
            if (menuItem == this.infosMenuItem) {
                this.infosEnabled = this.infosMenuItem.getSelection();
                if (this.infosEnabled) {
                    this.canvas.setCursor(new Cursor((Device)display, 2));
                    ((SWTFrontend)Emulator.getEmulator()).getInfos().open(this.shell);
                    return;
                }
                this.canvas.setCursor(new Cursor((Device)display, 0));
                this.canvas.redraw();
                ((SWTFrontend)Emulator.getEmulator()).getInfos().dispose();
                return;
            }
            if (menuItem == this.rotateScreenMenuItem) {
                this.setSize(this.getHeight(), this.getWidth());
                return;
            }
            if (menuItem == this.rotate90MenuItem) {
                this.rotate90degrees();
                return;
            }
            if (menuItem == this.forcePaintMenuItem) {
                if (Settings.g2d == 0) {
                    if (Settings.xrayView) {
                        this.xrayScreenImageSwt.cloneImage(this.screenCopySwt);
                    } else {
                        this.backBufferImageSwt.cloneImage(this.screenCopySwt);
                    }
                } else if (Settings.g2d == 1) {
                    (Settings.xrayView ? this.xrayScreenImageAwt : this.backBufferImageAwt).cloneImage(this.screenCopyAwt);
                }
                this.canvas.redraw();
                return;
            }
            if (menuItem == this.sensorMenuItem) {
                File f2 = new File(Emulator.getAbsolutePath() + "/sensorsimulator.jar");
                if (f2.exists()) {
                    try {
                        if (Emulator.isX64()) {
                            String javahome = System.getProperty("java.home");
                            Runtime.getRuntime().exec(new String[]{javahome == null || javahome.length() < 1 ? "java" : javahome + "/bin/java", "-jar", f2.getAbsolutePath()});
                        } else {
                            String[] stringArray = new String[2];
                            String[] array = stringArray;
                            stringArray[0] = "cmd.exe";
                            array[1] = "/c \" java -jar " + f2.getAbsolutePath() + " \"";
                            Runtime.getRuntime().exec(array);
                        }
                    }
                    catch (Exception array) {
                        // empty catch block
                    }
                }
                return;
            }
            if (menuItem == this.devUtilsMenuItem) {
                IdeaUtils.open(this.shell);
                return;
            }
            if (menuItem == this.smsConsoleMenuItem) {
                if (((MessageConsole)Emulator.getEmulator().getMessage()).method479()) {
                    ((MessageConsole)Emulator.getEmulator().getMessage()).dispose();
                    return;
                }
                ((MessageConsole)Emulator.getEmulator().getMessage()).open(this.shell);
                return;
            }
            if (menuItem == this.m3gViewMenuItem) {
                try {
                    if (((SWTFrontend)Emulator.getEmulator()).getM3GView().method494()) {
                        ((SWTFrontend)Emulator.getEmulator()).getM3GView().close();
                        return;
                    }
                    ((SWTFrontend)Emulator.getEmulator()).getM3GView().method226();
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                }
                return;
            }
            if (menuItem == this.xrayViewMenuItem) {
                Settings.xrayView = this.xrayViewMenuItem.getSelection();
                return;
            }
            if (menuItem == this.watchesMenuItem) {
                if (((SWTFrontend)Emulator.getEmulator()).getClassWatcher().isVisible()) {
                    ((SWTFrontend)Emulator.getEmulator()).getClassWatcher().dispose();
                    return;
                }
                ((SWTFrontend)Emulator.getEmulator()).getClassWatcher().open(this.shell);
                return;
            }
            if (menuItem == this.profilerMenuItem) {
                if (((SWTFrontend)Emulator.getEmulator()).getProfiler().isVisible()) {
                    ((SWTFrontend)Emulator.getEmulator()).getProfiler().dispose();
                    return;
                }
                ((SWTFrontend)Emulator.getEmulator()).getProfiler().open(this.shell);
                return;
            }
            if (menuItem == this.methodsMenuItem) {
                if (((SWTFrontend)Emulator.getEmulator()).getMethods().method438()) {
                    ((SWTFrontend)Emulator.getEmulator()).getMethods().dispose();
                    return;
                }
                ((SWTFrontend)Emulator.getEmulator()).getMethods().method436();
                return;
            }
            if (menuItem == this.memoryViewMenuItem) {
                if (((SWTFrontend)Emulator.getEmulator()).getMemory().isShown()) {
                    ((SWTFrontend)Emulator.getEmulator()).getMemory().dispose();
                    return;
                }
                ((SWTFrontend)Emulator.getEmulator()).getMemory().open();
            }
            if (menuItem == this.mediaViewMenuItem) {
                if (((SWTFrontend)Emulator.getEmulator()).getMedia().isShown()) {
                    ((SWTFrontend)Emulator.getEmulator()).getMedia().dispose();
                    return;
                }
                ((SWTFrontend)Emulator.getEmulator()).getMedia().open();
            }
        } else if (parent == this.menuResize) {
            if (menuItem == this.centerOnScreenMenuItem) {
                Settings.resizeMode = ResizeMethod.Manual;
                this.syncScalingModeSelection();
                Settings.canvasScale = (float)(Math.floor(this.realZoom * 2.0f) / 2.0);
                this.updateCanvasRect(true, false, false);
            } else if (menuItem == this.syncSizeMenuItem) {
                Settings.resizeMode = ResizeMethod.FollowWindowSize;
                this.syncScalingModeSelection();
                this.updateCanvasRect(true, false, false);
            } else if (menuItem == this.fillScreenMenuItem) {
                Settings.resizeMode = ResizeMethod.Fit;
                this.syncScalingModeSelection();
                this.updateCanvasRect(true, false, false);
            } else if (menuItem == this.integerScalingMenuItem) {
                Settings.resizeMode = ResizeMethod.FitInteger;
                this.syncScalingModeSelection();
                this.updateCanvasRect(true, false, false);
            } else if (menuItem == this.resetSizeMenuItem) {
                if (this.getWidth() != this.startWidth || this.getHeight() != this.startHeight) {
                    this.initScreenBuffer(this.startWidth, this.startHeight);
                    Emulator.getEventQueue().sizeChanged(this.startWidth, this.startHeight);
                }
                Settings.canvasScale = 1.0f;
                this.updateCanvasRect(true, true, false);
            } else if (menuItem == this.changeResMenuItem) {
                ScreenSizeDialog d = new ScreenSizeDialog(this.shell, this.getWidth(), this.getHeight());
                int[] r = d.open();
                if (r != null) {
                    this.setSize(r[0], r[1]);
                }
            } else if (menuItem == this.fullscreenMenuItem) {
                fullscreen = this.fullscreenMenuItem.getSelection();
                this.changeFullscreen();
            }
        }
    }

    private void syncScalingModeSelection() {
        this.centerOnScreenMenuItem.setSelection(Settings.resizeMode == ResizeMethod.Manual);
        this.fillScreenMenuItem.setSelection(Settings.resizeMode == ResizeMethod.Fit);
        this.integerScalingMenuItem.setSelection(Settings.resizeMode == ResizeMethod.FitInteger);
        this.syncSizeMenuItem.setSelection(Settings.resizeMode == ResizeMethod.FollowWindowSize);
    }

    private static void setWindowOnTop(long handle, boolean b2) {
        try {
            Class<OS> cls = OS.class;
            try {
                Method setWindowPos = cls.getMethod("SetWindowPos", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                setWindowPos.invoke(null, (int)handle, b2 ? -1 : -2, 0, 0, 0, 0, 19);
            }
            catch (Exception e2) {
                Method setWindowPos = cls.getMethod("SetWindowPos", Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                setWindowPos.invoke(null, handle, b2 ? -1L : -2L, 0, 0, 0, 0, 19);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void updatePauseState() {
        this.suspendMenuItem.setEnabled(this.pauseState == 1);
        this.resumeMenuItem.setEnabled(this.pauseState == 2);
        this.restartMenuItem.setEnabled(this.pauseState != 0 && !Settings.uei);
        this.xrayViewMenuItem.setSelection(Settings.xrayView);
        this.forcePaintMenuItem.setEnabled(this.pauseState != 0);
        this.pausestepMenuItem.setEnabled(this.pauseState != 0);
        this.playResumeMenuItem.setEnabled(Settings.steps >= 0 && this.pauseState != 0);
        this.openJadMenuItem.setEnabled(this.pauseState != 0);
        this.watchesMenuItem.setEnabled(this.pauseState != 0);
        this.profilerMenuItem.setEnabled(this.pauseState != 0);
        this.memoryViewMenuItem.setEnabled(this.pauseState != 0);
        this.methodsMenuItem.setEnabled(this.pauseState != 0);
        this.m3gViewMenuItem.setEnabled(Settings.g3d == 1 && this.pauseState != 0);
        this.mediaViewMenuItem.setEnabled(this.pauseState != 0);
        this.updateStatus();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private void updateInfos(int n, int n2) {
        StringBuffer sb2;
        EmulatorScreen class93;
        int[] i2 = this.transformPointer(n, n2);
        int n3 = i2[0];
        int n4 = i2[1];
        if (n3 < 0 || n4 < 0 || n3 > this.getWidth() - 1 || n4 > this.getHeight() - 1) {
            return;
        }
        int rgb = this.getScreenImg().getRGB(n3, n4);
        int n5 = rgb >> 16 & 0xFF;
        int n6 = rgb >> 8 & 0xFF;
        int n7 = rgb & 0xFF;
        this.aString1008 = UILocale.get("INFO_FRAME_POS", "Pos") + "(" + n3 + "," + n4 + ")\n" + UILocale.get("INFO_FRAME_COLOR", "Color") + "(";
        if (Settings.infoColorHex) {
            StringBuffer sb = new StringBuffer();
            class93 = this;
            sb2 = sb.append(this.aString1008).append(n5).append(",").append(n6).append(",").append(n7);
        } else {
            StringBuffer sb3 = new StringBuffer();
            class93 = this;
            sb2 = sb3.append(this.aString1008).append("0x").append(Integer.toHexString(rgb).toUpperCase());
        }
        class93.aString1008 = sb2.toString();
        i2 = this.transformPointer(this.mouseXPress, this.mouseYPress);
        int[] i22 = this.transformPointer(this.mouseXRelease, this.mouseYRelease);
        this.aString1008 = this.aString1008 + ")\n" + UILocale.get("INFO_FRAME_RECT", "R") + "(" + i2[0] + "," + i2[1] + "," + (i22[0] - i2[0]) + "," + (i22[1] - i2[1]) + ")";
        ((SWTFrontend)Emulator.getEmulator()).getInfos().setText(this.aString1008);
    }

    private void initCanvas() {
        if (this.canvas != null) {
            this.canvas.setParent((Composite)this.shell);
            return;
        }
        GridData layoutData = new GridData();
        new GridData().horizontalSpan = 3;
        layoutData.verticalAlignment = 4;
        layoutData.verticalSpan = 1;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.canvas = new org.eclipse.swt.widgets.Canvas((Composite)this.shell, 0x20004000);
        this.canvas.setLayoutData((Object)layoutData);
        this.canvas.addKeyListener((KeyListener)this);
        this.canvas.addMouseListener((MouseListener)this);
        this.canvas.addMouseWheelListener((MouseWheelListener)this);
        this.canvas.addMouseMoveListener((MouseMoveListener)this);
        this.canvas.getShell().addMouseTrackListener((MouseTrackListener)this);
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addListener(38, (Listener)this);
        this.canvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                EmulatorScreen.this.caret.a(EmulatorScreen.this.paintTransform, EmulatorScreen.this.rotation);
                if (EmulatorScreen.this.swtContent != null && EmulatorScreen.this.lastDisplayable != null && EmulatorScreen.this.lastDisplayable instanceof Screen && ((Screen)EmulatorScreen.this.lastDisplayable)._isSWT()) {
                    ((Screen)EmulatorScreen.this.lastDisplayable)._swtUpdateSizes();
                }
            }
        });
        this.canvas.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                if (EmulatorScreen.this.lastDisplayable != null && EmulatorScreen.this.lastDisplayable instanceof Form) {
                    Form form;
                    Point p = EmulatorScreen.this.canvas.toControl(event.x, event.y);
                    int[] t = EmulatorScreen.this.transformPointer(p.x, p.y);
                    if (t[0] >= 0 && t[1] >= 0 && (form = (Form)EmulatorScreen.this.lastDisplayable)._tryShowMenuAt(t[0], t[1])) {
                        return;
                    }
                }
                event.doit = false;
            }
        });
        try {
            this.canvas.setTouchEnabled(true);
            this.touchEnabled = this.canvas.getTouchEnabled();
            this.canvas.addTouchListener((TouchListener)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stackLayout = new StackLayout();
        this.canvas.setLayout((Layout)this.stackLayout);
        this.keysState = new boolean[256];
        this.method589();
        this.caret = new CaretImpl(this.canvas);
        this.shell.layout();
        this.commandsMenu = new Menu((Control)this.canvas);
        this.canvas.setMenu(this.commandsMenu);
    }

    @Override
    public void showCommandsList(Vector<TargetedCommand> cmds, CommandsMenuPosition target, int tx, int ty) {
        display.syncExec(() -> {
            CommandsMenuListener listener = new CommandsMenuListener();
            for (MenuItem mi : this.commandsMenu.getItems()) {
                mi.dispose();
            }
            if (cmds.isEmpty()) {
                this.commandsMenu.setVisible(false);
                return;
            }
            for (TargetedCommand cmd : cmds) {
                if (cmd == null) {
                    new MenuItem(this.commandsMenu, 2);
                    continue;
                }
                MenuItem mi = new MenuItem(this.commandsMenu, cmd.isChoice() ? 16 : 8);
                mi.setText(cmd.text);
                mi.setData((Object)cmd);
                mi.addSelectionListener((SelectionListener)listener);
                if (!cmd.wasSelected) continue;
                mi.setSelection(true);
            }
            if (target == CommandsMenuPosition.CommandsButton) {
                this.commandsMenu.setLocation(this.getMenuLocation());
                this.commandsMenu.setVisible(true);
            } else if (target == CommandsMenuPosition.Custom) {
                int[] t = this.transformCaret(tx, ty, true);
                Point p = this.getCanvas().toDisplay(new Point(t[0], t[1]));
                this.commandsMenu.setLocation(p);
                this.commandsMenu.setVisible(true);
            }
        });
    }

    @Override
    public void forceCloseCommandsList() {
        display.syncExec(() -> this.commandsMenu.setVisible(false));
    }

    public void paintControl(PaintEvent paintEvent) {
        GC gc = paintEvent.gc;
        Rectangle size = this.canvas.getClientArea();
        if (this.pauseState == 0) {
            gc.setBackground(display.getSystemColor(22));
            gc.fillRectangle(0, 0, size.width, size.height);
            gc.setForeground(display.getSystemColor(21));
            gc.setFont(f);
            gc.drawText(Emulator.getInfoString(), size.width >> 3, size.height >> 3, true);
            return;
        }
        gc.setInterpolation(Settings.interpolation);
        int origWidth = this.getWidth();
        int origHeight = this.getHeight();
        if (this.swtContent == null) {
            try {
                if (this.screenX > 0 || this.screenY > 0) {
                    gc.setBackground(display.getSystemColor(2));
                    gc.fillRectangle(0, 0, size.width, size.height);
                }
                gc.setTransform(this.paintTransform);
                if (this.screenImg == null || this.screenImg.isDisposed()) {
                    IImage buf;
                    IImage iImage = buf = Settings.g2d == 1 ? this.screenCopyAwt : this.screenCopySwt;
                    if (this.screenX == 0 && this.screenY == 0 && origWidth == this.screenWidth && origHeight == this.screenHeight) {
                        buf.copyToScreen(gc);
                    } else {
                        buf.copyToScreen(gc, 0, 0, origWidth, origHeight, 0, 0, this.screenWidth, this.screenHeight);
                    }
                } else {
                    gc.drawImage(this.screenImg, 0, 0, origWidth, origHeight, 0, 0, this.screenWidth, this.screenHeight);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        gc.setAdvanced(false);
        this.drawMouseInputInfo(gc);
        if (this.wasResized) {
            this.caret.setWindowZoom((float)this.screenHeight / (float)origHeight);
            this.wasResized = false;
        }
    }

    private void drawMouseInputInfo(GC gc) {
        if (this.infosEnabled && (this.mouseXPress != this.mouseXRelease || this.mouseYPress != this.mouseYRelease)) {
            try {
                EmulatorScreen.OS_SetROP2(gc, 7);
                gc.setForeground(display.getSystemColor(1));
                gc.drawRectangle(this.mouseXPress, this.mouseYPress, this.mouseXRelease - this.mouseXPress, this.mouseYRelease - this.mouseYPress);
                EmulatorScreen.OS_SetROP2(gc, 13);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void OS_SetROP2(GC gc, int j) {
        try {
            long i2 = ReflectUtil.getHandle(gc);
            Class<OS> os = OS.class;
            Method m2 = null;
            try {
                m2 = os.getMethod("SetROP2", Integer.TYPE, Integer.TYPE);
                m2.invoke(null, (int)i2, j);
            }
            catch (Exception e2) {
                m2 = os.getMethod("SetROP2", Long.TYPE, Integer.TYPE);
                m2.invoke(null, i2, j);
            }
        }
        catch (Exception e3) {
            throw new Error(e3);
        }
    }

    public float getZoom() {
        return this.realZoom;
    }

    @Override
    public void run() {
        this.paintPending = false;
        if (this.pauseState != 1) {
            return;
        }
        if (Settings.pollKeyboardOnRepaint) {
            if (this.poller != null) {
                this.poller.pollKeyboard(this.canvas);
            }
            Controllers.poll();
        }
        if (this.swtContent == null) {
            if (Settings.g2d == 0) {
                this.screenImageSwt.cloneImage(this.screenCopySwt);
            } else if (Settings.g2d == 1) {
                this.screenImageAwt.cloneImage(this.screenCopyAwt);
            }
        } else {
            this.swtContent.redraw();
        }
        this.canvas.redraw();
        this.updateStatus();
        ++aLong982;
        Emulator.getEmulator().syncValues();
        Profiler.reset();
        Profiler3D.reset();
    }

    @Override
    public void setCurrent(final Displayable d) {
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (EmulatorScreen.this.lastDisplayable != null) {
                    if (EmulatorScreen.this.swtContent != null) {
                        EmulatorScreen.this.swtContent.setVisible(false);
                    }
                    if (EmulatorScreen.this.lastDisplayable instanceof Screen) {
                        ((Screen)EmulatorScreen.this.lastDisplayable)._swtHidden();
                    }
                    EmulatorScreen.this.lastDisplayable = null;
                }
                if (d == null) {
                    return;
                }
                EmulatorScreen.this.lastDisplayable = d;
                if (d instanceof Canvas) {
                    ((EmulatorScreen)EmulatorScreen.this).stackLayout.topControl = null;
                    EmulatorScreen.this.swtContent = null;
                } else if (d instanceof Screen) {
                    Composite c2 = (Composite)((Screen)d)._getSwtContent();
                    ((EmulatorScreen)EmulatorScreen.this).stackLayout.topControl = c2;
                    EmulatorScreen.this.swtContent = c2;
                    if (c2 != null) {
                        c2.setVisible(true);
                        c2.layout();
                    }
                }
                EmulatorScreen.this.updateTitleInternal();
                EmulatorScreen.this.canvas.layout();
                if (EmulatorScreen.this.lastDisplayable instanceof Screen) {
                    ((Screen)EmulatorScreen.this.lastDisplayable)._swtShown();
                }
            }
        });
    }

    @Override
    public void updateTitle() {
        display.syncExec(this::updateTitleInternal);
    }

    private void updateTitleInternal() {
        String title = null;
        title = this.lastDisplayable == null || (title = this.lastDisplayable.getTitle()) == null || (title = title.trim()).isEmpty() ? Emulator.getTitle(null) : Emulator.getTitle(title);
        this.shell.setText(title);
    }

    private static void method578(int n) {
        if (Emulator.getCurrentDisplay().getCurrent() == null) {
            return;
        }
        if (!Emulator.getCurrentDisplay().getCurrent().handleSoftKeyAction(n, true)) {
            if (Emulator.getCurrentDisplay().getCurrent() == Emulator.getCanvas()) {
                Emulator.getCanvas()._invokeKeyPressed(n);
                return;
            }
            Emulator.getScreen()._invokeKeyPressed(n);
        }
    }

    private static void method580(int n) {
        if (Emulator.getCurrentDisplay().getCurrent() == null) {
            return;
        }
        if (!Emulator.getCurrentDisplay().getCurrent().handleSoftKeyAction(n, false)) {
            if (Emulator.getCurrentDisplay().getCurrent() == Emulator.getCanvas()) {
                Emulator.getCanvas()._invokeKeyReleased(n);
                return;
            }
            Emulator.getScreen()._invokeKeyReleased(n);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 16777261) {
            this.zoomOut();
            return;
        }
        if (keyEvent.keyCode == 16777259) {
            this.zoomIn();
            return;
        }
        if (keyEvent.keyCode == 0x1000014) {
            fullscreen = !fullscreen;
            this.fullscreenMenuItem.setSelection(fullscreen);
            this.changeFullscreen();
            return;
        }
        int n = keyEvent.keyCode & 0xFEFFFFFF;
        this.caret._keyPressed(keyEvent);
        if (keyEvent.character >= '!' && keyEvent.character <= 'Z' && Settings.canvasKeyboard && (n < 48 || n > 57)) {
            n = keyEvent.character;
        }
        this.handleKeyPress(n);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!Settings.canvasKeyboard && this.poller != null) {
            return;
        }
        int n = keyEvent.keyCode & 0xFEFFFFFF;
        if (keyEvent.character >= '!' && keyEvent.character <= 'Z' && Settings.canvasKeyboard && (n < 48 || n > 57)) {
            n = keyEvent.character;
        }
        this.handleKeyRelease(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleKeyPress(int n) {
        if (this.pauseState == 0 || Settings.playingRecordedKeys || (n < 0 || n >= this.keysState.length) && !Settings.canvasKeyboard) {
            return;
        }
        String r = this.mapKey(n);
        if (r == null) {
            return;
        }
        n = Integer.parseInt(r);
        if (this.pressedKeys.contains(n)) {
            if (Emulator.getCurrentDisplay().getCurrent() instanceof Screen) {
                Emulator.getEventQueue().keyRepeat(n);
            } else if (Settings.enableKeyRepeat) {
                if (Settings.keyPressOnRepeat) {
                    Emulator.getEventQueue().keyPress(n);
                } else {
                    Emulator.getEventQueue().keyRepeat(n);
                }
            }
            return;
        }
        Vector<Integer> vector2 = this.pressedKeys;
        synchronized (vector2) {
            if (!this.pressedKeys.contains(n)) {
                this.pressedKeys.add(n);
            }
        }
        if (Settings.enableKeyCache) {
            KeyMapping.keyCacheStack.push('0' + r);
            return;
        }
        if (Settings.recordKeys && !Settings.playingRecordedKeys) {
            Emulator.getRobot().print(aLong982 + ":" + '0' + r);
        }
        Emulator.getEventQueue().keyPress(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleKeyRelease(int n) {
        if (this.pauseState == 0 || Settings.playingRecordedKeys || (n < 0 || n >= this.keysState.length) && !Settings.canvasKeyboard) {
            return;
        }
        String r = this.mapKey(n);
        if (r == null) {
            return;
        }
        n = Integer.parseInt(r);
        Vector<Integer> vector2 = this.pressedKeys;
        synchronized (vector2) {
            if (this.win && !this.pressedKeys.contains(n)) {
                return;
            }
            this.pressedKeys.removeElement(n);
        }
        if (Settings.enableKeyCache) {
            KeyMapping.keyCacheStack.push('1' + r);
            return;
        }
        if (Settings.recordKeys && !Settings.playingRecordedKeys) {
            Emulator.getRobot().print(aLong982 + ":" + '1' + r);
        }
        Emulator.getEventQueue().keyRelease(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onKeyUp(int n, Shell shell) {
        if (shell != this.shell) {
            ((SWTFrontend)Emulator.getEmulator()).getM3GView().keyReleased(n);
            return;
        }
        if (n <= 0 || this.pauseState == 0 || Settings.playingRecordedKeys) {
            return;
        }
        String r = this.mapKey(n);
        if (r == null) {
            return;
        }
        n = Integer.parseInt(r);
        Vector<Integer> vector2 = this.pressedKeys;
        synchronized (vector2) {
            if (!this.pressedKeys.contains(n)) {
                return;
            }
            this.pressedKeys.removeElement(n);
        }
        if (Settings.enableKeyCache) {
            KeyMapping.keyCacheStack.push('1' + r);
            return;
        }
        if (Settings.recordKeys && !Settings.playingRecordedKeys) {
            Emulator.getRobot().print(aLong982 + ":" + '1' + r);
        }
        Emulator.getEventQueue().keyRelease(Integer.parseInt(r));
    }

    private String mapKey(int n) {
        return KeyMapping.replaceKey(n);
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        if (Settings.playingRecordedKeys) {
            return;
        }
        if (this.pauseState == 0 || Emulator.getCurrentDisplay().getCurrent() == null) {
            return;
        }
        if (mouseEvent.button != 1 || Emulator.getCurrentDisplay().getCurrent() == Emulator.getCanvas()) {
            return;
        }
        try {
            Emulator.getScreen()._invokeKeyPressed(KeyMapping.getArrowKeyFromDevice(8));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    int[] transformPointer(int x, int y) {
        int h2;
        int w;
        if (this.rotation % 2 == 1) {
            w = this.getHeight();
            h2 = this.getWidth();
            x = (int)((float)(x - this.screenY) / ((float)this.screenHeight / (float)w));
            y = (int)((float)(y - this.screenX) / ((float)this.screenWidth / (float)h2));
        } else {
            w = this.getWidth();
            h2 = this.getHeight();
            x = (int)((float)(x - this.screenX) / ((float)this.screenWidth / (float)w));
            y = (int)((float)(y - this.screenY) / ((float)this.screenHeight / (float)h2));
        }
        switch (this.rotation) {
            case 0: {
                break;
            }
            case 1: {
                int tmp = x;
                x = y;
                y = w - tmp;
                break;
            }
            case 2: {
                x = w - x;
                y = h2 - y;
                break;
            }
            case 3: {
                int tmp = x;
                x = h2 - y;
                y = tmp;
            }
        }
        return new int[]{x, y};
    }

    public int[] transformCaret(int x, int y, boolean offset) {
        int h2;
        int w;
        if (this.rotation % 2 == 1) {
            w = this.getHeight();
            h2 = this.getWidth();
            x = (int)((float)x / ((float)w / (float)this.screenWidth)) + (offset ? this.screenX : 0);
            y = (int)((float)y / ((float)h2 / (float)this.screenHeight)) + (offset ? this.screenY : 0);
        } else {
            w = this.getWidth();
            h2 = this.getHeight();
            x = (int)((float)x / ((float)w / (float)this.screenWidth)) + (offset ? this.screenX : 0);
            y = (int)((float)y / ((float)h2 / (float)this.screenHeight)) + (offset ? this.screenY : 0);
        }
        switch (this.rotation) {
            case 0: {
                break;
            }
            case 1: {
                int tmp = x;
                x = y;
                y = w - tmp;
                break;
            }
            case 2: {
                x = w - x;
                y = h2 - y;
                break;
            }
            case 3: {
                int tmp = x;
                x = h2 - y;
                y = tmp;
            }
        }
        return new int[]{x, y};
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (this.infosEnabled && !this.mouseDownInfos) {
            this.mouseXPress = mouseEvent.x;
            this.mouseYPress = mouseEvent.y;
            this.mouseXRelease = mouseEvent.x;
            this.mouseYRelease = mouseEvent.y;
            this.mouseDownInfos = true;
        }
        if (this.pauseState == 0 || Settings.playingRecordedKeys || Emulator.getCurrentDisplay().getCurrent() == null) {
            return;
        }
        int[] i2 = this.transformPointer(mouseEvent.x, mouseEvent.y);
        if (i2[0] < 0 || i2[1] < 0 || i2[0] >= this.getWidth() || i2[1] >= this.getHeight()) {
            return;
        }
        this.pointerState = true;
        Emulator.getEventQueue().mouseDown(i2[0], i2[1], 0);
        this.lastPointerX = i2[0];
        this.lastPointerY = i2[1];
        this.caret.mouseDown(i2[0], i2[1]);
    }

    public void mouseUp(MouseEvent mouseEvent) {
        this.mouseDownInfos = false;
        if (this.pauseState == 0 || Settings.playingRecordedKeys || Emulator.getCurrentDisplay().getCurrent() == null) {
            return;
        }
        if (!this.pointerState) {
            return;
        }
        this.pointerState = false;
        int[] i2 = this.transformPointer(mouseEvent.x, mouseEvent.y);
        this.lastPointerX = i2[0];
        this.lastPointerY = i2[1];
        Emulator.getEventQueue().mouseUp(i2[0], i2[1], 0);
    }

    public void mouseMove(MouseEvent mouseEvent) {
        if (this.infosEnabled) {
            if (this.mouseDownInfos) {
                this.mouseXRelease = mouseEvent.x;
                this.mouseYRelease = mouseEvent.y;
                this.canvas.redraw();
            }
            this.updateInfos(mouseEvent.x, mouseEvent.y);
        }
        if (this.pauseState == 0 || Settings.playingRecordedKeys || Emulator.getCurrentDisplay().getCurrent() == null) {
            return;
        }
        if (this.pointerState && (mouseEvent.stateMask & 0x80000) != 0) {
            int[] i2 = this.transformPointer(mouseEvent.x, mouseEvent.y);
            if (i2[0] < 0 || i2[1] < 0 || i2[0] >= this.getWidth() || i2[1] >= this.getHeight() || this.lastPointerX == i2[0] && this.lastPointerY == i2[1]) {
                return;
            }
            this.lastPointerX = i2[0];
            this.lastPointerY = i2[1];
            Emulator.getEventQueue().mouseDrag(i2[0], i2[1], 0);
        }
    }

    public void touch(TouchEvent touchEvent) {
        if (!this.midletSupportsMultitouch) {
            return;
        }
        block5: for (Touch touch : touchEvent.touches) {
            Point p = this.canvas.toControl(touch.x, touch.y);
            int[] pos = this.transformPointer(p.x, p.y);
            if (touch.primary) continue;
            int id = this.touchIds.indexOf(touch.id);
            if (id == -1) {
                this.touchIds.add(touch.id);
                id = this.touchIds.size();
            } else {
                ++id;
            }
            switch (touch.state) {
                case 1: {
                    Emulator.getEventQueue().mouseDown(pos[0], pos[1], id);
                    continue block5;
                }
                case 4: {
                    Emulator.getEventQueue().mouseUp(pos[0], pos[1], id);
                    this.touchIds.remove(touch.id);
                    continue block5;
                }
                case 2: {
                    Emulator.getEventQueue().mouseDrag(pos[0], pos[1], id);
                }
            }
        }
    }

    public void mouseEnter(MouseEvent arg0) {
    }

    public void mouseExit(MouseEvent e2) {
    }

    public void mouseHover(MouseEvent arg0) {
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        Emulator.getEmulator().disposeSubWindows();
        Emulator.notifyDestroyed();
        if (this.pauseState != 0) {
            Emulator.getEventQueue().queue(11);
        }
    }

    public void controlMoved(ControlEvent controlEvent) {
        Shell method331;
        Shell method330;
        if (controlEvent.widget != this.shell) {
            return;
        }
        this.getWindowPos();
        if (((Log)Emulator.getEmulator().getLogStream()).isLogOpen()) {
            Shell logWindow = ((Log)Emulator.getEmulator().getLogStream()).getLogShell();
            if (((Log)Emulator.getEmulator().getLogStream()).isAttachedToParent() && !logWindow.isDisposed()) {
                logWindow.setLocation(this.shell.getLocation().x + this.shell.getSize().x, this.shell.getLocation().y);
            }
        }
        if (((MessageConsole)Emulator.getEmulator().getMessage()).method479()) {
            Shell method329 = ((MessageConsole)Emulator.getEmulator().getMessage()).method480();
            if (((MessageConsole)Emulator.getEmulator().getMessage()).method488() && !method329.isDisposed()) {
                method329.setLocation(this.shell.getLocation().x - method329.getSize().x, this.shell.getLocation().y);
            }
        }
        if (((SWTFrontend)Emulator.getEmulator()).getInfos().isShown() && !(method330 = ((SWTFrontend)Emulator.getEmulator()).getInfos().getShell()).isDisposed()) {
            method330.setLocation(this.shell.getLocation().x + this.shell.getSize().x, this.shell.getLocation().y);
        }
        if (((SWTFrontend)Emulator.getEmulator()).getKeyPad().method834() && !(method331 = ((SWTFrontend)Emulator.getEmulator()).getKeyPad().method833()).isDisposed()) {
            method331.setLocation(this.shell.getLocation().x + this.shell.getSize().x, this.shell.getLocation().y);
        }
    }

    public void controlResized(ControlEvent controlEvent) {
        this.onWindowResized();
        this.controlMoved(controlEvent);
    }

    private void mp(int i2) {
        if (Emulator.getCurrentDisplay().getCurrent() == Emulator.getCanvas()) {
            Emulator.getCanvas()._invokeKeyPressed(i2);
        } else {
            Emulator.getScreen()._invokeKeyPressed(i2);
        }
    }

    private void mr(int i2) {
        if (Emulator.getCurrentDisplay().getCurrent() == Emulator.getCanvas()) {
            Emulator.getCanvas()._invokeKeyReleased(i2);
        } else {
            Emulator.getScreen()._invokeKeyReleased(i2);
        }
    }

    private void mrp(int i2) {
        if (Emulator.getCurrentDisplay().getCurrent() == Emulator.getCanvas()) {
            Emulator.getCanvas()._invokeKeyRepeated(i2);
        }
    }

    @Override
    public void startVibra(long aLong1013) {
        if (!Settings.enableVibration) {
            return;
        }
        if (maximized) {
            return;
        }
        this.vibra = aLong1013;
        if (this.vibra == 0L) {
            this.stopVibra();
            return;
        }
        this.vibraStart = System.currentTimeMillis();
        if (this.vibraThread == null) {
            this.vibraThread = new Vibrate(this);
            new Thread((Runnable)this.vibraThread, "KEmulator vibrate-" + ++threadCount).start();
            return;
        }
        this.vibraThread.stop = false;
    }

    @Override
    public void stopVibra() {
        if (this.vibraThread != null) {
            this.vibraThread.stop = true;
        }
    }

    private void method589() {
        DropTarget dropTarget = new DropTarget((Control)this.canvas, 19);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new Class29(this));
    }

    @Override
    public ICaret getCaret() {
        return this.caret;
    }

    static Shell method561(EmulatorScreen class93) {
        return class93.shell;
    }

    public static Display method564() {
        return display;
    }

    static org.eclipse.swt.widgets.Canvas getCanvas(EmulatorScreen class93) {
        return class93.canvas;
    }

    static int method566(EmulatorScreen class93) {
        return class93.pauseState;
    }

    static boolean[] method556(EmulatorScreen class93) {
        return class93.keysState;
    }

    static long method559(EmulatorScreen class93, long aLong1017) {
        class93.vibraStart = aLong1017;
        return class93.vibraStart;
    }

    public Composite getCanvas() {
        return this.canvas;
    }

    public Point getMenuLocation() {
        return this.leftSoftLabel.toDisplay(0, this.leftSoftLabel.getSize().y);
    }

    public void updateLanguage() {
        this.initMenu();
        this.pauseStateStrings = new String[]{UILocale.get("MAIN_INFO_BAR_UNLOADED", "UNLOADED"), UILocale.get("MAIN_INFO_BAR_RUNNING", "RUNNING"), UILocale.get("MAIN_INFO_BAR_PAUSED", "PAUSED")};
        this.updateStatus();
        this.canvas.redraw();
    }

    @Override
    public void appStarted(boolean first) {
        if (first) {
            display.asyncExec((Runnable)new WindowOpen(this, 0));
        }
    }

    @Override
    public boolean isShown() {
        boolean[] r = new boolean[1];
        display.syncExec(() -> {
            r[0] = this.shell.isVisible() && !this.shell.getMinimized();
        });
        return r[0];
    }

    @Override
    public int showMidletChoice(Vector<String> midletKeys) {
        this.dialogSelection = -1;
        final Shell shell = new Shell(SWTFrontend.getDisplay(), 2144);
        shell.setSize(300, 400);
        shell.setText(UILocale.get("START_MIDLET_CHOICE_TITLE", "Choose MIDlet to run"));
        shell.setLayout((Layout)new GridLayout(1, false));
        final Table table = new Table((Composite)shell, 2052);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                EmulatorScreen.this.dialogSelection = table.getSelectionIndex();
            }

            public void widgetDefaultSelected(SelectionEvent e2) {
                EmulatorScreen.this.dialogSelection = table.getSelectionIndex();
                if (EmulatorScreen.this.dialogSelection == -1) {
                    return;
                }
                shell.close();
            }
        });
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite.setLayout((Layout)new RowLayout(256));
        for (String k2 : midletKeys) {
            String[] p = Emulator.getEmulator().getAppProperty(k2).split(",");
            TableItem t = new TableItem(table, 0);
            t.setText(0, p[0].trim());
            try {
                t.setImage(0, new Image((Device)SWTFrontend.getDisplay(), ResourceManager.getResourceAsStream(p[1].trim())));
            }
            catch (Exception exception) {}
        }
        Rectangle clientArea = this.shell.getMonitor().getClientArea();
        Point size = shell.getSize();
        shell.setLocation(clientArea.x + (clientArea.width - size.x) / 2, clientArea.y + (clientArea.height - size.y) / 2);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.dialogSelection;
    }

    @Override
    public int showUpdateDialog(int type) {
        this.dialogSelection = 0;
        try {
            EmulatorScreen.setWindowOnTop(ReflectUtil.getHandle(this.shell), true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MessageBox messageBox = new MessageBox(this.shell, 192);
        messageBox.setText(UILocale.get("UPDATE_TITLE", "KEmulator Update"));
        switch (type) {
            case 0: {
                messageBox.setMessage(UILocale.get("START_AUTO_UPDATE_TEXT", "Do you want to receive automatic updates?"));
                break;
            }
            case 1: {
                messageBox.setMessage(UILocale.get("UPDATE_AVAILABLE_TEXT", "A new version is available.\nDo you want to download it?"));
            }
        }
        int r = messageBox.open();
        int n = r == 64 ? 2 : (this.dialogSelection = r == 128 ? 1 : 0);
        if (type == 1 && this.dialogSelection == 2) {
            Updater.startUpdater(true);
        }
        try {
            EmulatorScreen.setWindowOnTop(ReflectUtil.getHandle(this.shell), Settings.alwaysOnTop);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.dialogSelection;
    }

    @Override
    public boolean showSecurityDialog(String message) {
        boolean[] ok = new boolean[1];
        this.shell.getDisplay().syncExec(() -> {
            MessageBox messageBox = new MessageBox(this.shell, 192);
            messageBox.setMessage(message);
            messageBox.setText(UILocale.get("SECURITY_ALERT_TITLE", "Security"));
            ok[0] = messageBox.open() == 64;
        });
        return ok[0];
    }

    @Override
    public String showIMEIDialog() {
        InputDialog[] imeiDialog = new InputDialog[1];
        this.shell.getDisplay().syncExec(() -> {
            imeiDialog[0] = new InputDialog(this.shell);
            imeiDialog[0].setMessage("Application asks for IMEI");
            imeiDialog[0].setInput("0000000000000000");
            imeiDialog[0].setText(UILocale.get("SECURITY_ALERT_TITLE", "Security"));
            imeiDialog[0].open();
        });
        return imeiDialog[0].getInput();
    }

    public boolean getTouchEnabled() {
        return this.touchEnabled;
    }

    public void mouseScrolled(MouseEvent arg0) {
        if (this.pauseState == 0 || Settings.playingRecordedKeys) {
            return;
        }
        try {
            int k2 = 0;
            if (arg0.count < 0) {
                k2 = Integer.parseInt(this.mapKey(2));
            } else if (arg0.count > 0) {
                k2 = Integer.parseInt(this.mapKey(1));
            }
            if (k2 != 0) {
                Emulator.getEventQueue().keyPress(k2);
                Emulator.getEventQueue().keyRelease(k2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleEvent(Event event) {
        if (event.type == 38) {
            if (this.pauseState == 0 || Settings.playingRecordedKeys) {
                return;
            }
            try {
                int k2 = 0;
                if (event.count < 0) {
                    k2 = Integer.parseInt(this.mapKey(3));
                } else if (event.count > 0) {
                    k2 = Integer.parseInt(this.mapKey(4));
                }
                if (k2 != 0) {
                    Emulator.getEventQueue().keyPress(k2);
                    Emulator.getEventQueue().keyRelease(k2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        locX = Integer.MIN_VALUE;
        locY = Integer.MIN_VALUE;
        sizeW = -1;
        sizeH = -1;
        captureFileCounter = 1;
        aString993 = new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss", Locale.ENGLISH).format(Calendar.getInstance().getTime()) + "_";
    }

    public final class WindowOpen
    implements Runnable {
        int target;
        private final EmulatorScreen screen;

        WindowOpen(EmulatorScreen screen, int target) {
            this.screen = screen;
            this.target = target;
        }

        @Override
        public void run() {
            switch (this.target) {
                case 0: {
                    MemoryView m2 = ((SWTFrontend)Emulator.getEmulator()).getMemory();
                    if (!Settings.showMemViewFrame || m2.isShown()) break;
                    this.screen.memoryViewMenuItem.setSelection(true);
                    m2.open();
                    return;
                }
                case 1: {
                    if (!Settings.showLogFrame) break;
                    this.screen.logMenuItem.setSelection(true);
                    ((Log)Emulator.getEmulator().getLogStream()).createWindow(EmulatorScreen.method561(this.screen));
                    return;
                }
                case 2: {
                    if (!Settings.showInfoFrame) break;
                    EmulatorScreen.this.infosEnabled = true;
                    this.screen.infosMenuItem.setSelection(true);
                    EmulatorScreen.getCanvas(this.screen).setCursor(new Cursor((Device)EmulatorScreen.method564(), 2));
                    ((SWTFrontend)Emulator.getEmulator()).getInfos().open(EmulatorScreen.method561(this.screen));
                }
            }
        }
    }

    private final class Vibrate
    implements Runnable {
        int anInt1193;
        boolean stop;
        Random aRandom1195;
        int anInt1197;
        int anInt1198;
        private final EmulatorScreen aClass93_1196;

        Vibrate(EmulatorScreen aClass93_1196) {
            this.aClass93_1196 = aClass93_1196;
            EmulatorScreen.method559(this.aClass93_1196, System.currentTimeMillis());
            this.stop = false;
            this.aRandom1195 = new Random();
        }

        @Override
        public void run() {
            try {
                while (!EmulatorScreen.this.shell.isDisposed()) {
                    if (this.stop) {
                        Thread.sleep(5L);
                        continue;
                    }
                    this.anInt1193 = 10;
                    EmulatorScreen emulatorScreen = this.aClass93_1196;
                    emulatorScreen.getClass();
                    ShellPosition shellPosition = emulatorScreen.new ShellPosition(this.aClass93_1196, 0, 0, true);
                    while (System.currentTimeMillis() - this.aClass93_1196.vibraStart < this.aClass93_1196.vibra && !this.stop) {
                        if (EmulatorScreen.method566(this.aClass93_1196) != 2) {
                            if (EmulatorScreen.this.shell.isDisposed()) {
                                return;
                            }
                            display.syncExec((Runnable)shellPosition);
                            this.anInt1197 = shellPosition.anInt1478;
                            this.anInt1198 = shellPosition.anInt1481;
                            if (this.anInt1193++ > 10) {
                                Display display = display;
                                EmulatorScreen emulatorScreen2 = this.aClass93_1196;
                                emulatorScreen2.getClass();
                                display.asyncExec((Runnable)emulatorScreen2.new ShellPosition(this.aClass93_1196, this.anInt1197 + this.aRandom1195.nextInt() % 5, this.anInt1198 + this.aRandom1195.nextInt() % 5, false));
                                this.anInt1193 = 0;
                            }
                            Display display = display;
                            EmulatorScreen emulatorScreen3 = this.aClass93_1196;
                            emulatorScreen3.getClass();
                            display.asyncExec((Runnable)emulatorScreen3.new ShellPosition(this.aClass93_1196, this.anInt1197, this.anInt1198, false));
                        }
                        Thread.sleep(1L);
                    }
                    this.stop = true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.aClass93_1196.vibraThread = null;
        }
    }

    final class ShellPosition
    implements Runnable {
        int anInt1478;
        int anInt1481;
        boolean aBoolean1479;
        private final EmulatorScreen aClass93_1480;

        ShellPosition(EmulatorScreen aClass93_1480, int anInt1478, int anInt1479, boolean aBoolean1479) {
            this.aClass93_1480 = aClass93_1480;
            this.anInt1478 = anInt1478;
            this.anInt1481 = anInt1479;
            this.aBoolean1479 = aBoolean1479;
        }

        @Override
        public void run() {
            if (this.aBoolean1479) {
                this.anInt1478 = EmulatorScreen.method561((EmulatorScreen)this.aClass93_1480).getLocation().x;
                this.anInt1481 = EmulatorScreen.method561((EmulatorScreen)this.aClass93_1480).getLocation().y;
                return;
            }
            EmulatorScreen.method561(this.aClass93_1480).setLocation(this.anInt1478, this.anInt1481);
        }
    }
}

