/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.Settings;
import emulator.UILocale;
import emulator.ui.swt.MemoryView;
import emulator.ui.swt.ResetUsageListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ImageViewControls
extends Composite
implements SelectionListener,
ModifyListener {
    private final Combo scale;
    private final Combo sortingMethod;
    private final Button drawDrawn;
    private final Button drawNonDrawn;
    private final Button darkenUnused;
    private final Button infos;
    private final Button reverseSort;
    private final Button drawReleased;
    private final Button draw2d;
    private final Button draw3d;
    private final Button clearReleasedBtn;
    private final Label totalPixelsLabel;
    private final MemoryView mv;

    public ImageViewControls(Composite parent, MemoryView mv) {
        super(parent, 0);
        this.mv = mv;
        RowLayout rl = new RowLayout();
        rl.wrap = true;
        rl.center = true;
        rl.type = 256;
        rl.spacing = 2;
        this.setLayout((Layout)rl);
        this.scale = new Combo((Composite)this, 8);
        this.initZoomCombo();
        new Label((Composite)this, 0).setText(UILocale.get("MEMORY_VIEW_SORT", "Sort:"));
        this.sortingMethod = new Combo((Composite)this, 8);
        this.initSortByCombo();
        this.reverseSort = new Button((Composite)this, 32);
        this.reverseSort.setText(UILocale.get("MEMORY_VIEW_ASCEND", "Ascending"));
        this.reverseSort.setSelection(true);
        this.reverseSort.addSelectionListener((SelectionListener)this);
        this.reverseSort.setLayoutData((Object)new RowData(90, -1));
        Group displays = new Group((Composite)this, 0);
        displays.setText("Display");
        RowLayout rl2 = new RowLayout();
        rl2.center = true;
        rl2.wrap = false;
        rl2.spacing = 5;
        displays.setLayout((Layout)rl2);
        this.infos = new Button((Composite)displays, 32);
        this.infos.setText("Infos");
        this.infos.setToolTipText("Show image type, size and usage counter");
        this.infos.setSelection(false);
        this.infos.addSelectionListener((SelectionListener)this);
        this.darkenUnused = new Button((Composite)displays, 32);
        this.darkenUnused.setText(UILocale.get("MEMORY_VIEW_UNUSED_REGION", "Used regions"));
        this.darkenUnused.setToolTipText("Shade image regions those were never drawn");
        this.darkenUnused.setSelection(false);
        this.darkenUnused.addSelectionListener((SelectionListener)this);
        Button clearUsageBtn = new Button((Composite)displays, 0x800000);
        clearUsageBtn.setText(UILocale.get("MEMORY_VIEW_RESET_IMAGE", "Reset usage"));
        clearUsageBtn.addSelectionListener((SelectionListener)new ResetUsageListener(mv));
        clearUsageBtn.setLayoutData((Object)new RowData(-1, 20));
        Group filters = new Group((Composite)this, 0);
        filters.setText("Filters");
        filters.setLayout((Layout)new GridLayout(5, false));
        this.drawDrawn = new Button((Composite)filters, 32);
        this.drawDrawn.setText(UILocale.get("MEMORY_VIEW_IMAGES_DRAWN", "Used"));
        this.drawDrawn.setToolTipText("Show images those were drawn at least once");
        this.drawDrawn.setSelection(true);
        this.drawDrawn.addSelectionListener((SelectionListener)this);
        this.drawNonDrawn = new Button((Composite)filters, 32);
        this.drawNonDrawn.setText(UILocale.get("MEMORY_VIEW_IMAGE_NEVER_DRAW", "Unused"));
        this.drawNonDrawn.setToolTipText("Show images those were not drawn yet");
        this.drawNonDrawn.setSelection(true);
        this.drawNonDrawn.addSelectionListener((SelectionListener)this);
        this.draw2d = new Button((Composite)filters, 32);
        this.draw2d.setText("LCDUI");
        this.draw2d.setToolTipText("Show alive LCDUI images");
        this.draw2d.setSelection(true);
        this.draw2d.addSelectionListener((SelectionListener)this);
        this.draw3d = new Button((Composite)filters, 32);
        this.draw3d.setText("3D");
        this.draw3d.setToolTipText("Show M3G and Micro3D textures");
        this.draw3d.setSelection(true);
        this.draw3d.addSelectionListener((SelectionListener)this);
        this.drawReleased = new Button((Composite)filters, 32);
        this.drawReleased.setText(UILocale.get("MEMORY_VIEW_RELEASED_IMAGES", "Released"));
        this.drawReleased.setToolTipText("Show released LCDUI images. For alive ones, try \"LCDUI\" toggle");
        this.drawReleased.setEnabled(Settings.recordReleasedImg);
        this.drawReleased.setSelection(false);
        this.drawReleased.addSelectionListener((SelectionListener)this);
        Group stats = new Group((Composite)this, 0);
        stats.setText("Statistics");
        stats.setLayout((Layout)new RowLayout());
        this.totalPixelsLabel = new Label((Composite)stats, 0);
        this.totalPixelsLabel.setText("? pixels");
        this.totalPixelsLabel.setLayoutData((Object)new RowData(200, 20));
        this.clearReleasedBtn = new Button((Composite)this, 0x800000);
        this.clearReleasedBtn.setText(UILocale.get("MEMORY_VIEW_CLEAR_RELEASED_IMAGES", "Clear Released Images"));
        this.clearReleasedBtn.setEnabled(Settings.recordReleasedImg);
        this.clearReleasedBtn.addSelectionListener((SelectionListener)this);
    }

    private void initZoomCombo() {
        this.scale.add("50%");
        this.scale.add("100%");
        this.scale.add("200%");
        this.scale.add("300%");
        this.scale.add("400%");
        this.scale.setText("100%");
        this.scale.setToolTipText("Images zoom");
        this.scale.addModifyListener((ModifyListener)this);
    }

    private void initSortByCombo() {
        this.sortingMethod.setEnabled(true);
        this.sortingMethod.add(UILocale.get("MEMORY_VIEW_SORT_REFERENCE", "Reference"));
        this.sortingMethod.add(UILocale.get("MEMORY_VIEW_SORT_SIZE", "Size"));
        this.sortingMethod.add(UILocale.get("MEMORY_VIEW_SORT_DRAW_COUNT", "Draw Count"));
        this.sortingMethod.setText(UILocale.get("MEMORY_VIEW_SORT_REFERENCE", "Reference"));
        this.sortingMethod.addModifyListener((ModifyListener)this);
    }

    public void updateStats(int pixels2d, int pixels3d, int count2d, int count3d) {
        String text = "Total (LCDUI+3D): " + (pixels2d + pixels3d) + "px";
        this.totalPixelsLabel.setText(text);
        String t2d = "LCDUI: " + count2d + " images, " + pixels2d + "px (" + pixels2d / 1024 + "Kipx) in total";
        String t3d = "M3G+Micro3D: " + count3d + " images, " + pixels3d + "px (" + pixels3d / 1024 + "Kipx) in total";
        String tip = "To estimate memory usage, multiply numbers by 4.";
        String tip2 = "Real memory usage will differ per device due to different formats.";
        this.totalPixelsLabel.setToolTipText(t2d + "\n" + t3d + "\n\n" + tip + "\n" + tip2);
    }

    public void widgetSelected(SelectionEvent e2) {
        if (e2.widget == this.drawDrawn) {
            this.mv.setImagesDrawn(this.drawDrawn.getSelection());
        } else if (e2.widget == this.drawNonDrawn) {
            this.mv.setImagesNotDrawn(this.drawNonDrawn.getSelection());
        } else if (e2.widget == this.reverseSort) {
            this.mv.setImagesAscend(this.reverseSort.getSelection());
        } else if (e2.widget == this.drawReleased) {
            this.mv.setShowReleasedImages(this.drawReleased.getSelection());
        } else if (e2.widget == this.darkenUnused) {
            this.mv.setDarkenUnused(this.darkenUnused.getSelection());
        } else if (e2.widget == this.clearReleasedBtn) {
            this.mv.memoryMgr.releasedImages.clear();
            this.mv.updateEverything();
        } else if (e2.widget == this.infos) {
            this.mv.setShowImagesInfo(this.infos.getSelection());
        } else if (e2.widget == this.draw2d) {
            this.mv.setShow2dImages(this.draw2d.getSelection());
        } else if (e2.widget == this.draw3d) {
            this.mv.setShow3dImages(this.draw3d.getSelection());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e2) {
    }

    public void modifyText(ModifyEvent e2) {
        if (e2.widget == this.sortingMethod) {
            this.mv.setImagesSorting(this.sortingMethod.getSelectionIndex());
        } else if (e2.widget == this.scale) {
            this.mv.setImagesScaling(this.scale.getSelectionIndex());
        }
    }
}

