/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.Settings;
import emulator.debug.MemoryViewImage;
import emulator.debug.MemoryViewImageType;
import emulator.graphics2D.CopyUtils;
import emulator.graphics2D.awt.ImageAWT;
import javax.microedition.m3g.Image2D;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ImageViewItem {
    public final javax.microedition.lcdui.Image drawable;
    public final Object source;
    public final MemoryViewImageType type;
    public final boolean released;
    public final String type2;
    public final boolean allowCache;
    public Image cache;
    public Rectangle drawnRect;
    private static final String[] m3gTypes = new String[]{"A", "L", "LA", "RGB", "RGBA"};

    public ImageViewItem(javax.microedition.lcdui.Image image, boolean released) {
        this.drawable = image;
        this.released = released;
        if (image instanceof MemoryViewImage) {
            this.source = ((MemoryViewImage)image).source;
            this.type = ((MemoryViewImage)image).type;
            if (this.source instanceof Image2D) {
                int t = ((Image2D)this.source).getFormat();
                this.type2 = m3gTypes[t - 96];
            } else {
                this.type2 = "";
            }
            this.allowCache = false;
            this.cache = null;
        } else {
            this.source = image;
            this.type = MemoryViewImageType.LCDUI;
            this.type2 = image.isMutable() ? "Mut." : "Immut.";
            this.allowCache = !image.isMutable() && Settings.g2d == 1;
        }
    }

    public boolean ensureCache() {
        if (this.allowCache) {
            if (this.cache == null) {
                this.cache = new Image(null, CopyUtils.toSwt(((ImageAWT)this.drawable.getImpl()).getBufferedImage()));
            }
            return true;
        }
        return false;
    }

    public String getCaption() {
        return this.type.toString();
    }
}

