/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.ui.swt.ImageViewItem;
import emulator.ui.swt.MemoryView;
import java.util.Comparator;
import java.util.IdentityHashMap;
import javax.microedition.lcdui.Image;

final class ImagesComparatorByOrder
implements Comparator<ImageViewItem> {
    private final MemoryView mv;
    private final IdentityHashMap<Image, Integer> positions;

    ImagesComparatorByOrder(MemoryView mv) {
        this.mv = mv;
        this.positions = new IdentityHashMap(MemoryView.allImages.size());
        for (int i2 = 0; i2 < MemoryView.allImages.size(); ++i2) {
            this.positions.put(MemoryView.allImages.get(i2), i2);
        }
    }

    @Override
    public int compare(ImageViewItem i1, ImageViewItem i2) {
        int index1 = this.positions.get(i1.drawable);
        int index2 = this.positions.get(i2.drawable);
        int n = index2 - index1;
        return this.mv.getSortByAscending() ? n : -n;
    }
}

