/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class InfosBox {
    private Shell shell;
    private CLabel label;
    private boolean visible;

    public void open(Shell parent) {
        this.createShell(parent);
        this.shell.setLocation(parent.getLocation().x + parent.getSize().x, parent.getLocation().y);
        this.shell.open();
        Display display = parent.getDisplay();
        this.visible = true;
        parent.forceActive();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.visible = false;
    }

    public void dispose() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public boolean isShown() {
        return this.visible;
    }

    public Shell getShell() {
        return this.shell;
    }

    private void createShell(Shell parent) {
        Display display = parent.getDisplay();
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.horizontalSpacing = 0;
        this.shell = new Shell(parent, 8);
        this.shell.setLayout((Layout)layout);
        this.shell.setSize(new Point(130, 50));
        this.shell.setBackground(display.getSystemColor(2));
        this.label = new CLabel((Composite)this.shell, 0);
        this.label.setText("Pos(0,0)\nColr(0)\nRect(0,0,0,0)");
        this.label.setLayoutData((Object)layoutData);
        this.label.setBackground(display.getSystemColor(13));
    }
}

