/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.UILocale;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputDialog
extends Dialog {
    private String message = "";
    private String input = "";

    public InputDialog(Shell parent) {
        this(parent, 67680);
    }

    public InputDialog(Shell parent, int style) {
        super(parent, style);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        this.createContents(shell);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.input;
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout(2, true));
        Label label = new Label((Composite)shell, 0);
        label.setText(this.message);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        final Text text = new Text((Composite)shell, 2048);
        text.setText(this.input);
        data = new GridData(768);
        data.horizontalSpan = 2;
        text.setLayoutData((Object)data);
        Button ok = new Button((Composite)shell, 8);
        ok.setText(UILocale.get("DIALOG_OK", "OK"));
        data = new GridData(768);
        ok.setLayoutData((Object)data);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputDialog.this.input = text.getText();
                shell.close();
            }
        });
        Button cancel = new Button((Composite)shell, 8);
        cancel.setText(UILocale.get("DIALOG_CANCEL", "Cancel"));
        data = new GridData(768);
        cancel.setLayoutData((Object)data);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputDialog.this.input = null;
                shell.close();
            }
        });
        shell.setDefaultButton(ok);
    }
}

