/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.Emulator;
import emulator.UILocale;
import emulator.custom.CustomMethod;
import emulator.ui.ILogStream;
import emulator.ui.swt.SWTFrontend;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class Log
implements ILogStream,
ControlListener,
DisposeListener,
Runnable {
    private Shell logShell = null;
    PrintStream filePrintStream;
    LogStream logStream;
    boolean logOpen;
    StyledText styledText = null;
    Shell parentShell;
    private boolean attachedToParent;
    final StringBuffer printQueue = new StringBuffer();

    public Log() {
        try {
            File file = new File(Emulator.getUserPath() + "/log.txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            this.logStream = new LogStream(this);
            this.filePrintStream = new PrintStream(new FileOutputStream(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Thread((Runnable)this, "KEmulator-Log").start();
    }

    @Override
    public final void print(String s) {
        this.logStream.orig.print(s);
        this.queuePrint(s);
    }

    @Override
    public final void println(String s) {
        this.logStream.orig.println(s);
        this.queuePrint(s + "\n");
    }

    @Override
    public final void println() {
        this.logStream.orig.println();
        this.queuePrint("\n");
    }

    @Override
    public final void stdout(String s) {
        this.logStream.orig.println(s);
        this.queuePrint(s + "\n");
    }

    @Override
    public void println(Throwable e2) {
        this.println(CustomMethod.getStackTrace(e2));
    }

    @Override
    public final void printStackTrace(String s) {
        this.println("==StackTrace==" + s + "==StackTrace==");
    }

    public void wrapPrint(String s) {
        this.queuePrint(s);
    }

    public void wrapPrintln(String s) {
        this.queuePrint(s + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queuePrint(String s) {
        StringBuffer stringBuffer = this.printQueue;
        synchronized (stringBuffer) {
            this.printQueue.append(s);
            this.printQueue.notify();
        }
    }

    private void loadLogFile() {
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(Emulator.getUserPath() + "/log.txt"));
            while ((line = bufferedReader.readLine()) != null) {
                this.styledText.append(line + "\n");
            }
            bufferedReader.close();
            this.styledText.setTopIndex(this.styledText.getLineCount());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean isLogOpen() {
        return this.logOpen;
    }

    public final Shell getLogShell() {
        return this.logShell;
    }

    public final void createWindow(Shell parent) {
        this.initWindows();
        this.loadLogFile();
        Display current = Display.getCurrent();
        this.parentShell = parent;
        this.logShell.setLocation(parent.getLocation().x + parent.getSize().x, parent.getLocation().y);
        this.logShell.setSize(parent.getSize());
        this.logOpen = true;
        this.attachedToParent = true;
        this.logShell.open();
        this.logShell.addControlListener((ControlListener)this);
        this.logShell.addDisposeListener((DisposeListener)this);
        parent.setFocus();
        while (!this.logShell.isDisposed()) {
            if (current.readAndDispatch()) continue;
            current.sleep();
        }
        this.logOpen = false;
    }

    public final void dispose() {
        if (this.logShell != null && !this.logShell.isDisposed()) {
            this.logShell.dispose();
        }
        this.logOpen = false;
    }

    private void initWindows() {
        FillLayout layout = new FillLayout();
        new FillLayout().spacing = 0;
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        this.logShell = new Shell();
        this.logShell.setText(UILocale.get("LOG_FRAME_TITLE", "Log"));
        this.logShell.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/res/icon")));
        this.logShell.setLayout((Layout)layout);
        this.logShell.setSize(new Point(310, 254));
        int style = 2816;
        this.styledText = new StyledText((Composite)this.logShell, style);
    }

    public final boolean isAttachedToParent() {
        return this.attachedToParent;
    }

    public final void controlMoved(ControlEvent controlEvent) {
        if (Math.abs(this.parentShell.getLocation().x + this.parentShell.getSize().x - this.logShell.getLocation().x) < 10 && Math.abs(this.parentShell.getLocation().y - this.logShell.getLocation().y) < 20) {
            this.logShell.setLocation(this.parentShell.getLocation().x + this.parentShell.getSize().x, this.parentShell.getLocation().y);
            this.attachedToParent = true;
        } else {
            this.attachedToParent = false;
        }
    }

    public final void controlResized(ControlEvent controlEvent) {
    }

    public final void widgetDisposed(DisposeEvent disposeEvent) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                if (this.printQueue.length() > 0) {
                    SWTFrontend.getDisplay().syncExec((Runnable)new Textout(this));
                    continue;
                }
                StringBuffer stringBuffer = this.printQueue;
                synchronized (stringBuffer) {
                    this.printQueue.wait();
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
    }

    private final class LogStream
    extends PrintStream {
        PrintStream orig;
        private final Log class11;

        LogStream(Log aClass11_1402) {
            super(System.out, true);
            this.class11 = aClass11_1402;
            this.orig = System.out;
            System.setOut(this);
            System.setErr(this);
        }

        @Override
        public final void print(String s) {
            this.class11.wrapPrint(">>" + s);
            this.orig.print(s);
        }

        @Override
        public final void println(String s) {
            this.class11.wrapPrintln(">>" + s);
            this.orig.println(s);
        }

        @Override
        public final void print(Object o) {
            this.class11.wrapPrint(">>" + o);
            this.orig.print(o);
        }

        @Override
        public final void println(Object o) {
            this.class11.wrapPrintln(">>" + o);
            this.orig.println(o);
        }

        @Override
        public final void println() {
            this.class11.wrapPrintln(">>");
            this.orig.println();
        }
    }

    private final class Textout
    implements Runnable {
        private final Log class11;

        private Textout(Log c11) {
            this.class11 = c11;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            String s;
            StringBuffer stringBuffer = Log.this.printQueue;
            synchronized (stringBuffer) {
                s = Log.this.printQueue.toString();
                Log.this.printQueue.setLength(0);
            }
            try {
                this.class11.filePrintStream.print(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.class11.logOpen || this.class11.styledText.isDisposed()) {
                return;
            }
            this.class11.styledText.append(s);
            this.class11.styledText.setTopIndex(this.class11.styledText.getLineCount());
        }
    }
}

