/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.Emulator;
import emulator.UILocale;
import emulator.Utils;
import emulator.debug.Memory;
import emulator.graphics3D.Quaternion;
import emulator.graphics3D.Transform3D;
import emulator.graphics3D.Vector4f;
import emulator.graphics3D.lwjgl.GLCanvasUtil;
import emulator.graphics3D.view.M3GView3D;
import emulator.ui.swt.Class56;
import emulator.ui.swt.Class57;
import emulator.ui.swt.Class58;
import emulator.ui.swt.EmulatorScreen;
import emulator.ui.swt.M3GViewCameraClipPlanesListener;
import emulator.ui.swt.M3GViewCameraFOVListener;
import emulator.ui.swt.M3GViewCameraPosListener;
import emulator.ui.swt.M3GViewCameraResetListener;
import emulator.ui.swt.M3GViewCloseListener;
import emulator.ui.swt.M3GViewDisplayAxisListener;
import emulator.ui.swt.M3GViewDisplayGridListener;
import emulator.ui.swt.M3GViewGroupClickListener;
import emulator.ui.swt.M3GViewLightSceneListener;
import emulator.ui.swt.M3GViewLightViewListener;
import emulator.ui.swt.M3GViewNodeRightClickListener;
import emulator.ui.swt.M3GViewUpdateWorldListener;
import emulator.ui.swt.M3GViewXrayListener;
import emulator.ui.swt.Win32KeyboardPoller;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class M3GViewUI
implements MouseMoveListener,
DisposeListener,
KeyListener,
MouseWheelListener {
    private Shell shell = null;
    private SashForm aSashForm890 = null;
    private Composite aComposite891 = null;
    private Menu menu = null;
    private Composite aComposite907 = null;
    private Tree aTree896 = null;
    Win32KeyboardPoller poller;
    Canvas canvas = null;
    private Memory memory;
    private M3GView3D m3gview;
    private Camera camera = new Camera();
    private Transform cameraTransform = new Transform();
    private Menu displayMenu = null;
    private Menu cameraMenu = null;
    private Menu lightMenu = null;
    private Menu projectionMenu = null;
    private boolean aBoolean905;
    boolean aBoolean909;
    private int anInt362 = 0;
    private int cameraMode;
    private int parallelProjEnabled;
    private float nearPlane;
    private float farPlane;
    private float fov;
    private float cameraX;
    private float cameraY;
    private float cameraZ;
    private Quaternion quaternion = new Quaternion();
    private Background aBackground900 = null;
    private Node aNode361 = null;
    private Rectangle aRectangle903;
    private MenuItem aMenuItem921;
    private MenuItem orbitCameraItem;
    private MenuItem aMenuItem927;
    private MenuItem aMenuItem928;
    private MenuItem aMenuItem929;
    private MenuItem persModeItem;
    private MenuItem aMenuItem931;
    private MenuItem aMenuItem932;
    private MenuItem aMenuItem933;
    private MenuItem aMenuItem934;
    private MenuItem aMenuItem935;
    private MenuItem sceneLightItem;
    private MenuItem viewLightItem;
    private MenuItem lightSettingsItem;
    private int anInt917;
    private int anInt922;
    private float rotationX;
    private float rotationY;
    protected float moveSpeed = 1.0f;
    private boolean moveForward;
    private boolean moveBackward;
    private boolean moveRight;
    private boolean moveLeft;
    private boolean shift;
    private boolean control;
    private int rotateX;
    private int rotateY;
    private long lastUpdate = 1L;
    private MenuItem renderInvisibleItem;
    private MenuItem axisItem;
    private static boolean showAxis;
    private MenuItem gridItem;
    private static boolean showGrid;
    private MenuItem xrayItem;

    public M3GViewUI() {
        this.memory = Memory.getInstance();
        this.m3gview = M3GView3D.getViewInstance();
    }

    private void setDefaultPreferences() {
        showAxis = false;
        this.axisItem.setSelection(showAxis);
        showGrid = false;
        this.gridItem.setSelection(showGrid);
        this.renderInvisibleItem.setSelection(this.m3gview.isRenderInvisibleNodes());
        this.sceneLightItem.setSelection(true);
        this.cameraMode = 0;
        this.parallelProjEnabled = 0;
        this.method524();
    }

    private void method524() {
        this.nearPlane = 1.0f;
        this.farPlane = 100000.0f;
        this.fov = 70.0f;
        this.setupCamera();
        this.cameraX = 0.0f;
        this.cameraY = 0.0f;
        this.cameraZ = 20.0f;
        this.quaternion.setAngleAxis(-10.0f, 1.0f, 0.0f, 0.0f);
        this.cameraTransform.setIdentity();
        this.cameraTransform.postRotateQuat(this.quaternion.x, this.quaternion.y, this.quaternion.z, this.quaternion.w);
        this.cameraTransform.postTranslate(this.cameraX, this.cameraY, this.cameraZ);
    }

    private void setupCamera() {
        Rectangle renderArea = this.canvas.getClientArea();
        if (renderArea.width == 0 || renderArea.height == 0) {
            return;
        }
        if (this.parallelProjEnabled == 0) {
            if (this.fov < 0.0f) {
                this.fov = 0.0f;
            }
            if (this.fov >= 180.0f) {
                this.fov = 179.99f;
            }
            this.camera.setPerspective(this.fov, (float)renderArea.width / (float)renderArea.height, this.nearPlane, this.farPlane);
        } else {
            this.camera.setParallel(this.fov, (float)renderArea.width / (float)renderArea.height, this.nearPlane, this.farPlane);
        }
    }

    public final void method226() {
        this.method543();
        Display display = Display.getCurrent();
        Rectangle clientArea = this.shell.getMonitor().getClientArea();
        Point size = this.shell.getSize();
        this.shell.setLocation(clientArea.x + (clientArea.width - size.x) / 2, clientArea.y + (clientArea.height - size.y) / 2);
        this.shell.open();
        this.shell.addDisposeListener((DisposeListener)this);
        this.setDefaultPreferences();
        this.addM3GObjects();
        new Thread(new Refresher(this)).start();
        new Thread(new Flusher(this)).start();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public final void close() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
        this.canvas = null;
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    public final boolean method494() {
        return this.shell != null && !this.shell.isDisposed();
    }

    private void addM3GObjects() {
        this.memory.updateEverything();
        this.aTree896.removeAll();
        for (int i2 = 0; i2 < this.memory.m3gObjects.size(); ++i2) {
            Node node = (Node)this.memory.m3gObjects.get(i2);
            String name = node.getClass().getName();
            TreeItem widget = new TreeItem(this.aTree896, 0);
            widget.setText(name.substring(name.lastIndexOf(".") + 1) + "_" + node.getUserID());
            if (!node.isRenderingEnabled()) {
                widget.setForeground(Display.getCurrent().getSystemColor(3));
            }
            widget.setData((Object)node);
            if (!(node instanceof Group)) continue;
            new TreeItem(widget, 0);
        }
    }

    private void method276() {
        block9: {
            Node var10001;
            block10: {
                M3GViewUI var10000;
                block8: {
                    this.aBackground900 = null;
                    this.aNode361 = null;
                    if (this.aTree896.getSelectionCount() <= 0) break block8;
                    this.aNode361 = (Node)this.aTree896.getSelection()[0].getData();
                    if (this.aNode361 instanceof Sprite3D || this.aNode361 instanceof Mesh || this.aNode361 instanceof Group) break block9;
                    var10000 = this;
                    var10001 = null;
                    break block10;
                }
                if (this.memory.m3gObjects.size() <= 0) break block9;
                var10000 = this;
                var10001 = (Node)this.memory.m3gObjects.get(0);
            }
            var10000.aNode361 = var10001;
        }
        if (this.aNode361 != null) {
            if (this.aNode361 instanceof World) {
                World var1 = (World)this.aNode361;
                this.aBackground900 = var1.getBackground();
                if (this.anInt362 == 0) {
                    this.m3gview.method374(var1);
                }
            } else {
                Light var2 = new Light();
                var2.setMode(128);
                M3GView3D.method388();
                M3GView3D.method381(var2, null);
            }
        }
        this.aRectangle903 = this.canvas.getClientArea();
    }

    private void update() {
        float deltaTime = (float)((double)(System.nanoTime() - this.lastUpdate) * 60.0 / 1.0E10);
        this.lastUpdate = System.nanoTime();
        float tmpSpeed = this.moveSpeed;
        if (this.shift) {
            tmpSpeed *= 5.0f;
        }
        if (this.control) {
            tmpSpeed /= 5.0f;
        }
        float forward = (float)((this.moveForward ? 1 : 0) - (this.moveBackward ? 1 : 0)) * tmpSpeed * deltaTime;
        float strafe = (float)((this.moveRight ? 1 : 0) - (this.moveLeft ? 1 : 0)) * tmpSpeed * deltaTime;
        if (forward != 0.0f && strafe != 0.0f) {
            forward = (float)((double)forward / Math.sqrt(2.0));
            strafe = (float)((double)strafe / Math.sqrt(2.0));
        }
        if (forward != 0.0f || strafe != 0.0f) {
            Transform t = new Transform();
            float[] m2 = new float[16];
            t.postTranslate(this.cameraX, this.cameraY, this.cameraZ);
            t.postRotateQuat(this.quaternion.x, this.quaternion.y, this.quaternion.z, this.quaternion.w);
            t.get(m2);
            if (forward != 0.0f) {
                this.cameraX += -m2[2] * forward;
                this.cameraY += -m2[6] * forward;
                this.cameraZ += -m2[10] * forward;
            }
            if (strafe != 0.0f) {
                this.cameraX += m2[0] * strafe;
                this.cameraY += m2[4] * strafe;
                this.cameraZ += m2[8] * strafe;
            }
        }
        try {
            this.m3gview.setCurrent(this.aRectangle903.width, this.aRectangle903.height);
            this.cameraTransform.setIdentity();
            this.cameraTransform.postTranslate(this.cameraX, this.cameraY, this.cameraZ);
            this.cameraTransform.postRotateQuat(this.quaternion.x, this.quaternion.y, this.quaternion.z, this.quaternion.w);
            M3GView3D.setCamera(this.camera, this.cameraTransform);
            this.m3gview.clearBackground(this.aBackground900);
            if (showGrid) {
                this.m3gview.drawGrid(1.0f);
            }
            if (this.aNode361 != null) {
                try {
                    this.m3gview.method368(this.aNode361, null);
                }
                catch (Exception t) {
                    // empty catch block
                }
            }
            if (showAxis) {
                this.m3gview.drawAxis();
            }
            this.m3gview.setViewport(this.aRectangle903.width, this.aRectangle903.height);
            this.m3gview.swapBuffers();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    public void setXray(boolean b2) {
        this.m3gview.setXray(b2);
    }

    private void method543() {
        GridLayout layout = new GridLayout();
        new GridLayout().numColumns = 1;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        this.shell = new Shell();
        this.shell.setText(UILocale.get("M3G_VIEW_TITLE", "M3G View"));
        this.shell.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/res/icon")));
        this.method545();
        this.shell.setLayout((Layout)layout);
        this.shell.setSize(new Point(600, 400));
        this.menu = new Menu((Decorations)this.shell, 2);
        MenuItem menuItem = new MenuItem(this.menu, 64);
        MenuItem menuItem2 = new MenuItem(this.menu, 64);
        menuItem2.setText(UILocale.get("M3G_VIEW_CAMERA", "Camera"));
        MenuItem menuItem3 = new MenuItem(this.menu, 64);
        menuItem3.setText(UILocale.get("M3G_VIEW_LIGHT", "Light"));
        this.lightMenu = new Menu(menuItem3);
        this.sceneLightItem = new MenuItem(this.lightMenu, 16);
        this.sceneLightItem.setText(UILocale.get("M3G_VIEW_LIGHT_SCENE", "Scene Graphics"));
        this.sceneLightItem.addSelectionListener((SelectionListener)new M3GViewLightSceneListener(this));
        this.viewLightItem = new MenuItem(this.lightMenu, 16);
        this.viewLightItem.setText(UILocale.get("M3G_VIEW_LIGHT_VIEW", "Viewer Light"));
        this.viewLightItem.addSelectionListener((SelectionListener)new M3GViewLightViewListener(this));
        menuItem3.setMenu(this.lightMenu);
        this.cameraMenu = new Menu(menuItem2);
        this.aMenuItem932 = new MenuItem(this.cameraMenu, 8);
        this.aMenuItem932.setText(UILocale.get("M3G_VIEW_CAMERA_CLIP_PLANES", "Clipping Planes") + "\tC");
        this.aMenuItem932.setAccelerator(67);
        this.aMenuItem932.addSelectionListener((SelectionListener)new M3GViewCameraClipPlanesListener(this));
        this.aMenuItem933 = new MenuItem(this.cameraMenu, 8);
        this.aMenuItem933.setText(UILocale.get("M3G_VIEW_CAMEAR_FIELD_OF_VIEW", "Field of View") + "\tF");
        this.aMenuItem933.setAccelerator(70);
        this.aMenuItem933.addSelectionListener((SelectionListener)new M3GViewCameraFOVListener(this));
        this.aMenuItem934 = new MenuItem(this.cameraMenu, 8);
        this.aMenuItem934.setText(UILocale.get("M3G_VIEW_CAMEAR_POSITION", "Camera Position") + "\tP");
        this.aMenuItem934.setAccelerator(80);
        this.aMenuItem934.addSelectionListener((SelectionListener)new M3GViewCameraPosListener(this));
        new MenuItem(this.cameraMenu, 2);
        this.aMenuItem935 = new MenuItem(this.cameraMenu, 8);
        this.aMenuItem935.setText(UILocale.get("M3G_VIEW_CAMEAR_RESET", "Reset Camera") + "\tR");
        this.aMenuItem935.setAccelerator(82);
        this.aMenuItem935.addSelectionListener((SelectionListener)new M3GViewCameraResetListener(this));
        menuItem2.setMenu(this.cameraMenu);
        this.displayMenu = new Menu(menuItem);
        this.axisItem = new MenuItem(this.displayMenu, 32);
        this.axisItem.setText(UILocale.get("M3G_VIEW_DISPLAY_COORDINATE", "Coordinate Axis"));
        this.axisItem.addSelectionListener((SelectionListener)new M3GViewDisplayAxisListener(this));
        this.gridItem = new MenuItem(this.displayMenu, 32);
        this.gridItem.setText(UILocale.get("M3G_VIEW_DISPLAY_SHOW_GRID", "Show Grid"));
        this.gridItem.addSelectionListener((SelectionListener)new M3GViewDisplayGridListener(this));
        this.xrayItem = new MenuItem(this.displayMenu, 32);
        this.xrayItem.setText(UILocale.get("M3G_VIEW_DISPLAY_SHOW_XRAY", "Show Xray") + "\tX");
        this.xrayItem.setAccelerator(88);
        this.xrayItem.addSelectionListener((SelectionListener)new M3GViewXrayListener(this));
        this.renderInvisibleItem = new MenuItem(this.displayMenu, 32);
        this.renderInvisibleItem.setText(UILocale.get("M3G_VIEW_DISPLAY_RENDER_INVISIBLE", "Render invisible nodes") + "\tV");
        this.renderInvisibleItem.setAccelerator(86);
        this.renderInvisibleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent selectionEvent) {
                M3GViewUI.this.m3gview.setRenderInvisibleNodes(((MenuItem)selectionEvent.widget).getSelection());
            }
        });
        new MenuItem(this.displayMenu, 2);
        this.aMenuItem921 = new MenuItem(this.displayMenu, 8);
        this.aMenuItem921.setText(UILocale.get("M3G_VIEW_DISPLAY_UPDATE_WORLD", "Update World") + "\tF5");
        this.aMenuItem921.setAccelerator(0x100000E);
        this.aMenuItem921.addSelectionListener((SelectionListener)new M3GViewUpdateWorldListener(this));
        menuItem.setMenu(this.displayMenu);
        menuItem.setText(UILocale.get("M3G_VIEW_DISPLAY", "Display"));
        this.shell.setMenuBar(this.menu);
        this.shell.addShellListener((ShellListener)new M3GViewCloseListener(this));
    }

    private void method545() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 4;
        this.aSashForm890 = new SashForm((Composite)this.shell, 0);
        this.aSashForm890.setLayoutData((Object)layoutData);
        this.method546();
        this.method547();
        this.aSashForm890.setWeights(new int[]{3, 7});
    }

    private void method546() {
        GridLayout layout = new GridLayout();
        new GridLayout().numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.verticalAlignment = 4;
        this.aComposite891 = new Composite((Composite)this.aSashForm890, 0);
        this.aComposite891.setLayout((Layout)layout);
        this.aTree896 = new Tree(this.aComposite891, 2048);
        this.aTree896.setHeaderVisible(false);
        this.aTree896.setLayoutData((Object)layoutData);
        this.aTree896.setLinesVisible(false);
        this.aTree896.addListener(17, (Listener)new M3GViewGroupClickListener(this));
        this.aTree896.addMouseListener((MouseListener)new M3GViewNodeRightClickListener(this));
    }

    private void method547() {
        GridLayout layout = new GridLayout();
        new GridLayout().marginWidth = 0;
        layout.marginHeight = 0;
        this.aComposite907 = new Composite((Composite)this.aSashForm890, 0);
        this.method548();
        this.aComposite907.setLayout((Layout)layout);
    }

    private void method548() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.verticalAlignment = 4;
        try {
            this.canvas = GLCanvasUtil.initGLCanvas(this.aComposite907, 264192, 1);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            if (this.canvas != null) {
                this.canvas.dispose();
            }
            this.canvas = new Canvas(this.aComposite907, 264192);
        }
        if (Utils.win) {
            this.poller = new Win32KeyboardPoller((EmulatorScreen)Emulator.getEmulator().getScreen());
        }
        this.canvas.setLayoutData((Object)layoutData);
        this.canvas.addMouseMoveListener((MouseMoveListener)this);
        this.canvas.addMouseListener((MouseListener)new Class56(this));
        this.canvas.addKeyListener((KeyListener)this);
        this.canvas.addControlListener((ControlListener)new Class57(this));
        this.canvas.addListener(12, (Listener)new Class58(this));
        this.canvas.addMouseWheelListener((MouseWheelListener)this);
    }

    public final void mouseMove(MouseEvent mouseEvent) {
        if (!this.aBoolean905) {
            return;
        }
        if ((mouseEvent.stateMask & 0x80000) != 0) {
            this.method492(this.anInt917 - mouseEvent.x, this.anInt922 - mouseEvent.y);
            this.anInt917 = mouseEvent.x;
            this.anInt922 = mouseEvent.y;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int key = keyEvent.keyCode;
        if (keyEvent.keyCode >= 0x1000001) {
            float x = 0.0f;
            float y = 0.0f;
            switch (key) {
                case 0x1000001: {
                    y = 1.0f;
                    break;
                }
                case 0x1000002: {
                    y = -1.0f;
                    break;
                }
                case 0x1000003: {
                    x = 1.0f;
                    break;
                }
                case 0x1000004: {
                    x = -1.0f;
                }
            }
            this.rotationX += x * 5.0f;
            this.rotationY += y * 5.0f;
            this.quaternion.setAngleAxis(0.0f, 0.0f, 0.0f, 0.0f);
            Quaternion var5 = new Quaternion();
            var5.setAngleAxis(this.rotationX, 0.0f, 1.0f, 0.0f);
            var5.mul(this.quaternion);
            this.quaternion.set(var5);
            var5 = new Quaternion();
            var5.setAngleAxis(this.rotationY, 1.0f, 0.0f, 0.0f);
            this.quaternion.mul(var5);
            return;
        }
        switch (key) {
            case 119: {
                this.moveForward = true;
                break;
            }
            case 97: {
                this.moveLeft = true;
                break;
            }
            case 115: {
                this.moveBackward = true;
                break;
            }
            case 100: {
                this.moveRight = true;
                break;
            }
            case 131072: {
                this.shift = true;
                break;
            }
            case 262144: {
                this.control = true;
                break;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyReleased(keyEvent.keyCode);
    }

    public void keyReleased(int key) {
        switch (key) {
            case 0x1000001: 
            case 0x1000002: {
                this.rotateY = 0;
                break;
            }
            case 0x1000003: 
            case 0x1000004: {
                this.rotateX = 0;
                break;
            }
            case 119: {
                this.moveForward = false;
                break;
            }
            case 97: {
                this.moveLeft = false;
                break;
            }
            case 115: {
                this.moveBackward = false;
                break;
            }
            case 100: {
                this.moveRight = false;
                break;
            }
            case 131072: {
                this.shift = false;
                break;
            }
            case 262144: {
                this.control = false;
                break;
            }
        }
    }

    private void method492(int x, int y) {
        Quaternion a2 = new Quaternion();
        switch (this.cameraMode) {
            case 0: {
                this.rotationX += (float)x / 2.0f;
                this.rotationY += (float)y / 2.0f;
                this.quaternion.setAngleAxis(0.0f, 0.0f, 0.0f, 0.0f);
                Quaternion var5 = new Quaternion();
                var5.setAngleAxis(this.rotationX, 0.0f, 1.0f, 0.0f);
                var5.mul(this.quaternion);
                this.quaternion.set(var5);
                var5 = new Quaternion();
                var5.setAngleAxis(this.rotationY, 1.0f, 0.0f, 0.0f);
                this.quaternion.mul(var5);
                break;
            }
            case 1: {
                this.cameraX += (float)x / 10.0f;
                this.cameraY -= (float)y / 10.0f;
            }
            case 2: {
                if (this.parallelProjEnabled != 0) break;
                this.cameraZ -= (float)x / 10.0f;
                return;
            }
            case 3: {
                this.fov -= (float)x / 10.0f;
                if (!(this.fov > 0.0f) || !(this.fov < 180.0f) && this.parallelProjEnabled == 0) {
                    this.fov += (float)x / 10.0f;
                }
                this.setupCamera();
            }
        }
    }

    private Vector4f method495(Quaternion q) {
        Vector4f a2 = new Vector4f(this.cameraX, this.cameraY, this.cameraZ, 1.0f);
        Vector4f b2 = new Vector4f();
        Transform transform = new Transform();
        transform.postRotateQuat(q.x, q.y, q.z, q.w);
        transform.postTranslate(this.cameraX, this.cameraY, this.cameraZ);
        ((Transform3D)transform.getImpl()).transform(a2);
        b2.cross(a2, Vector4f.Y_AXIS);
        return b2;
    }

    public final void widgetDisposed(DisposeEvent disposeEvent) {
        this.close();
    }

    static boolean method243(M3GViewUI class90, boolean aBoolean905) {
        class90.aBoolean905 = aBoolean905;
        return class90.aBoolean905;
    }

    static boolean method232(M3GViewUI class90) {
        return class90.aBoolean905;
    }

    static boolean method242(M3GViewUI class90) {
        return class90.aBoolean909;
    }

    static int setCameraMode(M3GViewUI m3gViewUi, int mode) {
        m3gViewUi.cameraMode = mode;
        return m3gViewUi.cameraMode;
    }

    static int method510(M3GViewUI class90, int anInt910) {
        class90.parallelProjEnabled = anInt910;
        return class90.parallelProjEnabled;
    }

    static MenuItem method505(M3GViewUI class90) {
        return class90.aMenuItem928;
    }

    static void method511(M3GViewUI class90) {
        class90.method276();
    }

    static void method252(M3GViewUI paramClass57) {
        paramClass57.setupCamera();
    }

    static Shell method499(M3GViewUI class90) {
        return class90.shell;
    }

    static float method503(M3GViewUI class90) {
        return class90.nearPlane;
    }

    static float method512(M3GViewUI class90) {
        return class90.farPlane;
    }

    static int method500(M3GViewUI class90) {
        return class90.parallelProjEnabled;
    }

    static float method506(M3GViewUI class90, float aFloat906) {
        class90.nearPlane = aFloat906;
        return class90.nearPlane;
    }

    static float method513(M3GViewUI class90, float aFloat911) {
        class90.farPlane = aFloat911;
        return class90.farPlane;
    }

    static float method517(M3GViewUI class90) {
        return class90.fov;
    }

    static float method518(M3GViewUI class90, float aFloat915) {
        class90.fov = aFloat915;
        return class90.fov;
    }

    static float method525(M3GViewUI class90) {
        return class90.cameraX;
    }

    static float method532(M3GViewUI class90) {
        return class90.cameraY;
    }

    static float method537(M3GViewUI class90) {
        return class90.cameraZ;
    }

    static float method526(M3GViewUI class90, float aFloat920) {
        class90.cameraX = aFloat920;
        return class90.cameraX;
    }

    static float method533(M3GViewUI class90, float aFloat924) {
        class90.cameraY = aFloat924;
        return class90.cameraY;
    }

    static float method538(M3GViewUI class90, float aFloat926) {
        class90.cameraZ = aFloat926;
        return class90.cameraZ;
    }

    static void method519(M3GViewUI class90) {
        class90.method524();
    }

    static boolean setAxisVisible(M3GViewUI class90, boolean aBoolean914) {
        showAxis = aBoolean914;
        return showAxis;
    }

    static MenuItem getAxisItem(M3GViewUI class90) {
        return class90.axisItem;
    }

    static boolean setGridVisible(M3GViewUI class90, boolean aBoolean919) {
        showGrid = aBoolean919;
        return showGrid;
    }

    static MenuItem getGridItem(M3GViewUI class90) {
        return class90.gridItem;
    }

    static MenuItem getXrayItem(M3GViewUI class90) {
        return class90.xrayItem;
    }

    static void method529(M3GViewUI class90) {
        class90.addM3GObjects();
    }

    static Tree method501(M3GViewUI class90) {
        return class90.aTree896;
    }

    static void nextCameraMode(M3GViewUI m3gViewUi) {
        m3gViewUi.cameraMode = (m3gViewUi.cameraMode + 1) % 4;
    }

    static int getCameraMode(M3GViewUI m3gViewUi) {
        return m3gViewUi.cameraMode;
    }

    static MenuItem method534(M3GViewUI class90) {
        return class90.aMenuItem929;
    }

    static MenuItem method539(M3GViewUI class90) {
        return class90.orbitCameraItem;
    }

    static MenuItem method541(M3GViewUI class90) {
        return class90.aMenuItem927;
    }

    static int method530(M3GViewUI class90, int anInt917) {
        class90.anInt917 = anInt917;
        return class90.anInt917;
    }

    static int method535(M3GViewUI class90, int anInt922) {
        class90.anInt922 = anInt922;
        return class90.anInt922;
    }

    static float fovAdd(M3GViewUI class90, float n) {
        return class90.fov += n;
    }

    static float fovSubtract(M3GViewUI class90, float n) {
        return class90.fov -= n;
    }

    public void mouseScrolled(MouseEvent mouseEvent) {
        if (mouseEvent.count == 0) {
            return;
        }
        this.moveSpeed = (float)((double)this.moveSpeed * Math.pow(1.15f, mouseEvent.count > 0 ? 1.0 : -1.0));
        this.moveSpeed = Math.max(0.01f, Math.min(1000.0f, this.moveSpeed));
    }

    static final class Refresher
    implements Runnable {
        final M3GViewUI ui;
        private Runnable r = new Runnable(){

            @Override
            public final void run() {
                try {
                    if (ui.poller != null && ui.canvas != null) {
                        ui.poller.pollKeyboard(ui.canvas);
                    }
                    if (M3GViewUI.method232(ui)) {
                        if (!M3GViewUI.method242(ui)) {
                            M3GViewUI.method511(ui);
                            ui.aBoolean909 = true;
                            return;
                        }
                    } else {
                        Rectangle clientArea = ui.canvas.getClientArea();
                        GC gc = new GC((Drawable)ui.canvas);
                        gc.setBackground(Display.getCurrent().getSystemColor(2));
                        gc.fillRectangle(clientArea);
                        gc.setForeground(Display.getCurrent().getSystemColor(3));
                        gc.drawString("M3GView init .....", clientArea.width >> 2, clientArea.height >> 2, true);
                        gc.dispose();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };

        private Refresher(M3GViewUI ui) {
            this.ui = ui;
        }

        @Override
        public final void run() {
            while (this.ui.canvas != null) {
                if (this.ui.canvas.isDisposed()) {
                    return;
                }
                this.ui.canvas.getDisplay().syncExec(this.r);
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private final class Flusher
    implements Runnable {
        private final M3GViewUI aClass90_1207;

        private Flusher(M3GViewUI aClass90_1207) {
            this.aClass90_1207 = aClass90_1207;
        }

        @Override
        public final void run() {
            M3GViewUI.method243(this.aClass90_1207, this.aClass90_1207.m3gview.init(this.aClass90_1207.canvas));
            while (this.aClass90_1207.canvas != null) {
                if (this.aClass90_1207.canvas.isDisposed()) {
                    return;
                }
                if (M3GViewUI.method232(this.aClass90_1207) && M3GViewUI.method242(this.aClass90_1207)) {
                    try {
                        this.aClass90_1207.update();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    this.aClass90_1207.aBoolean909 = false;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
        }

        Flusher(M3GViewUI class90, M3GViewLightSceneListener class91) {
            this(class90);
        }
    }
}

