/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import com.nokia.mid.sound.Sound;
import com.samsung.util.AudioClip;
import emulator.Emulator;
import emulator.Settings;
import emulator.UILocale;
import emulator.debug.MediaUtils;
import emulator.debug.Memory;
import emulator.debug.PlayerActionType;
import emulator.media.capture.CapturePlayerImpl;
import emulator.media.tone.MIDITonePlayer;
import emulator.media.vlc.VLCPlayerImpl;
import emulator.ui.swt.EmulatorScreen;
import emulator.ui.swt.SWTFrontend;
import java.util.Arrays;
import java.util.Vector;
import javax.microedition.media.MIDIImpl;
import javax.microedition.media.PlayerImpl;
import javax.microedition.media.ToneImpl;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MediaView
extends SelectionAdapter
implements DisposeListener,
SelectionListener,
Runnable {
    private Shell shell;
    private final Display display = SWTFrontend.getDisplay();
    private final Memory memoryMgr = Memory.getInstance();
    private Button resumeBtn;
    private Button pauseBtn;
    private Button stopBtn;
    private Button exportBtn;
    private Label volumeValueLabel;
    private Scale volumeScale;
    private Label timeLabel;
    private ProgressBar timeBar;
    private Table table;
    private boolean visible;

    public void open() {
        this.createShell();
        this.shell.open();
        this.shell.addDisposeListener((DisposeListener)this);
        this.updateAll();
        new Thread(this).start();
        this.visible = true;
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.visible = false;
    }

    private void createShell() {
        this.shell = new Shell(1264);
        this.shell.setText(UILocale.get("MEDIA_VIEW_TITLE", "Media view"));
        this.shell.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/res/icon")));
        this.shell.setLayout((Layout)new GridLayout(9, false));
        this.resumeBtn = new Button((Composite)this.shell, 0x800000);
        this.resumeBtn.setText(UILocale.get("MEMORY_VIEW_SOUND_START", "Resume"));
        this.resumeBtn.addSelectionListener((SelectionListener)this);
        this.pauseBtn = new Button((Composite)this.shell, 0x800000);
        this.pauseBtn.setText(UILocale.get("MEMORY_VIEW_SOUND_PAUSE", "Pause"));
        this.pauseBtn.addSelectionListener((SelectionListener)this);
        this.stopBtn = new Button((Composite)this.shell, 0x800000);
        this.stopBtn.setText(UILocale.get("MEMORY_VIEW_SOUND_STOP", "Stop"));
        this.stopBtn.addSelectionListener((SelectionListener)this);
        this.exportBtn = new Button((Composite)this.shell, 0x800000);
        this.exportBtn.setText(UILocale.get("MEMORY_VIEW_SOUND_EXPORT", "Export"));
        this.exportBtn.addSelectionListener((SelectionListener)this);
        Label volumeLabel = new Label((Composite)this.shell, 0);
        volumeLabel.setText(UILocale.get("MEMORY_VIEW_VOLUME_LABEL", "Volume"));
        this.volumeValueLabel = new Label((Composite)this.shell, 0);
        this.volumeValueLabel.setText("000%");
        this.volumeScale = new Scale((Composite)this.shell, 256);
        this.volumeScale.setMaximum(100);
        this.volumeScale.addSelectionListener((SelectionListener)this);
        this.timeLabel = new Label((Composite)this.shell, 0);
        this.timeLabel.setText("0000:00/0000:00");
        GridData gd1 = new GridData();
        gd1.grabExcessHorizontalSpace = true;
        gd1.verticalAlignment = 2;
        gd1.horizontalAlignment = 4;
        this.timeBar = new ProgressBar((Composite)this.shell, 65536);
        this.timeBar.setLayoutData((Object)gd1);
        GridData gd2 = new GridData();
        gd2.grabExcessHorizontalSpace = true;
        gd2.grabExcessVerticalSpace = true;
        gd2.verticalAlignment = 4;
        gd2.horizontalAlignment = 4;
        gd2.horizontalSpan = 9;
        this.table = new Table((Composite)this.shell, 67584);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addSelectionListener((SelectionListener)this);
        this.table.setLayoutData((Object)gd2);
        this.addTableColumn("Instance", 200);
        this.addTableColumn("Content type", 100);
        this.addTableColumn("State", 89);
        this.addTableColumn("Duration", 80);
        this.addTableColumn("Loops", 50);
        this.addTableColumn("Data size", 80);
        this.addTableColumn("Implementation", 100);
        Rectangle clientArea = ((EmulatorScreen)Emulator.getEmulator().getScreen()).getShell().getMonitor().getClientArea();
        this.shell.setSize((int)((double)clientArea.width * 0.4), (int)((double)clientArea.height * 0.6));
        this.shell.setLocation(clientArea.x + (int)((double)clientArea.height * 0.025), clientArea.y + (int)((double)clientArea.height * 0.025));
    }

    private void updateAll() {
        if (this.shell.isDisposed()) {
            return;
        }
        this.memoryMgr.updateEverything();
        Vector players = new Vector(this.memoryMgr.players);
        Vector<TableItem> lines = new Vector<TableItem>(Arrays.asList(this.table.getItems()));
        while (!lines.isEmpty()) {
            TableItem line = lines.lastElement();
            if (players.contains(line.getData())) {
                this.updateTableLine(line);
                players.remove(line.getData());
                lines.remove(lines.size() - 1);
                continue;
            }
            this.table.remove(lines.size() - 1);
            lines.remove(lines.size() - 1);
        }
        for (Object player : players) {
            TableItem line = new TableItem(this.table, 0);
            line.setData(player);
            this.updateTableLine(line);
        }
        this.updateControls();
    }

    private void updateTableLine(TableItem item) {
        Object value = item.getData();
        int msLen = MediaUtils.getPlayerDurationMs(value);
        String lengthText = msLen < 0 ? "Unknown" : MediaView.formatTime(msLen) + String.format(".%1$03d", msLen % 1000);
        int loopCount = MediaUtils.getPlayerLoopCount(value);
        item.setText(0, value.toString());
        item.setText(1, MediaUtils.getPlayerType(value));
        item.setText(2, MediaUtils.playerStateStr(value));
        item.setText(3, lengthText);
        item.setText(4, loopCount < 0 ? "\u221e" : String.valueOf(loopCount));
        item.setText(5, String.valueOf(MediaUtils.getPlayerDataLength(value)));
        item.setText(6, MediaView.getImplementation(value));
    }

    private void updateControls() {
        Object player = this.getSelectedPlayer();
        if (player == null) {
            this.resumeBtn.setEnabled(false);
            this.pauseBtn.setEnabled(false);
            this.stopBtn.setEnabled(false);
            this.exportBtn.setEnabled(false);
            this.volumeValueLabel.setText("???%");
            this.volumeScale.setSelection(0);
            this.volumeScale.setEnabled(false);
            this.timeLabel.setText("??:??/??:??");
            this.timeBar.setSelection(0);
            return;
        }
        this.resumeBtn.setEnabled(true);
        this.pauseBtn.setEnabled(true);
        this.stopBtn.setEnabled(true);
        this.exportBtn.setEnabled(Settings.enableMediaDump);
        this.volumeValueLabel.setText(MediaUtils.getPlayerVolume(player) + "%");
        this.volumeScale.setEnabled(true);
        this.volumeScale.setSelection(MediaUtils.getPlayerVolume(player));
        try {
            int total = MediaUtils.getPlayerDurationMs(player);
            int now = MediaUtils.getPlayerCurrentMs(player);
            this.timeLabel.setText(MediaView.formatTime(now) + "/" + MediaView.formatTime(total));
            if (total > 0 && now >= 0) {
                this.timeBar.setSelection(now * 100 / total);
            } else {
                this.timeBar.setSelection(0);
            }
        }
        catch (Exception e2) {
            this.timeLabel.setText("Error");
        }
    }

    private static String formatTime(int ms) {
        if (ms < 0) {
            return "??:??";
        }
        return String.format("%1$02d:%2$02d", ms / 60000, ms / 1000 % 60);
    }

    private static String getImplementation(Object player) {
        if (player instanceof AudioClip) {
            AudioClip ac = (AudioClip)player;
            if (ac.type == 1) {
                return "ma3smwemu";
            }
            return MediaView.getImplementation(ac.m_player);
        }
        if (player instanceof VLCPlayerImpl) {
            return "VLC";
        }
        if (player instanceof Sound) {
            return MediaView.getImplementation(((Sound)player).m_player);
        }
        if (player instanceof ToneImpl || player instanceof MIDITonePlayer || player instanceof MIDIImpl) {
            return "JVM MIDI";
        }
        if (player instanceof CapturePlayerImpl) {
            return "Capture";
        }
        if (player instanceof PlayerImpl) {
            return ((PlayerImpl)player).getReadableImplementationType();
        }
        return "Unknown";
    }

    private Object getSelectedPlayer() {
        TableItem[] sel = this.table.getSelection();
        if (sel != null && sel.length >= 1) {
            return sel[0].getData();
        }
        return null;
    }

    public final void widgetSelected(SelectionEvent e2) {
        if (e2.widget == this.table) {
            this.updateControls();
            return;
        }
        if (e2.widget == this.resumeBtn) {
            MediaUtils.modifyPlayer(this.getSelectedPlayer(), PlayerActionType.resume);
            this.updateControls();
            return;
        }
        if (e2.widget == this.pauseBtn) {
            MediaUtils.modifyPlayer(this.getSelectedPlayer(), PlayerActionType.pause);
            this.updateControls();
            return;
        }
        if (e2.widget == this.stopBtn) {
            MediaUtils.modifyPlayer(this.getSelectedPlayer(), PlayerActionType.stop);
            this.updateControls();
            return;
        }
        if (e2.widget == this.exportBtn) {
            MediaUtils.modifyPlayer(this.getSelectedPlayer(), PlayerActionType.export);
            this.updateControls();
            return;
        }
        if (e2.widget == this.volumeScale) {
            MediaUtils.setPlayerVolume(this.getSelectedPlayer(), this.volumeScale.getSelection());
            this.updateControls();
            return;
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.dispose();
    }

    public final boolean isShown() {
        return this.visible;
    }

    public final void dispose() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.visible = false;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(1000L);
            do {
                this.display.syncExec(this::updateAll);
                Thread.sleep(1000L);
            } while (this.visible && !this.shell.isDisposed());
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void addTableColumn(String name, int width) {
        TableColumn tc = new TableColumn(this.table, 0);
        tc.setText(name);
        tc.setWidth(width);
    }
}

