/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.Emulator;
import emulator.Settings;
import emulator.UILocale;
import emulator.debug.ClassTypes;
import emulator.debug.Memory;
import emulator.debug.MemoryViewImageType;
import emulator.debug.ObjInstance;
import emulator.debug.ReferencePath;
import emulator.ui.swt.Class140;
import emulator.ui.swt.Class17;
import emulator.ui.swt.Class31;
import emulator.ui.swt.ClassListComparator;
import emulator.ui.swt.EmulatorScreen;
import emulator.ui.swt.ImageViewControls;
import emulator.ui.swt.ImageViewItem;
import emulator.ui.swt.ImagesCanvasListener;
import emulator.ui.swt.ImagesComparatorByOrder;
import emulator.ui.swt.ImagesComparatorBySize;
import emulator.ui.swt.ImagesComparatorByUsage;
import emulator.ui.swt.MemoryViewControls;
import emulator.ui.swt.ObjectsTableListener;
import emulator.ui.swt.ReferencePathDisplay;
import emulator.ui.swt.SaveAllImagesListener;
import emulator.ui.swt.SaveImageListener;
import emulator.ui.swt.TableListener;
import emulator.ui.swt.Watcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.microedition.lcdui.Image;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class MemoryView
implements DisposeListener,
ControlListener {
    private Shell shell;
    public final Memory memoryMgr = Memory.getInstance();
    private boolean visible;
    private Composite imagesPanel;
    private ImageViewControls imageControls;
    private MemoryViewControls memoryControls;
    private Canvas imagesCanvas;
    private SashForm horizontalSeparator;
    private Composite memoryPanel;
    private Table classTable;
    private Table objectsTable;
    private double imageScaling = 1.0;
    private int imagesSortingMethod;
    private boolean sortImagesByAscending;
    private static final Object updateLock = new Object();
    static final ArrayList<Image> allImages = new ArrayList();
    static final ArrayList<ImageViewItem> imagesToShow = new ArrayList();
    int imagesCanvasScroll;
    private boolean imagesDrawn = true;
    private boolean imagesNeverDrawn = true;
    private boolean showReleasedImages = false;
    private boolean show2dImages = true;
    private boolean show3dImages = true;
    private boolean darkenUnused = false;
    private boolean displayPkgNames = true;
    private boolean drawImagesInfo = false;
    private Object selectedObject;
    private ArrayList<String> classesList = new ArrayList();
    private AutoUpdate autoUpdater;
    private int sortColumn = -1;
    public static final String SHELL_TYPE = "MEMORY_VIEW";
    private Group objectPaths;
    private Composite objectPathsContainer;

    public void open() {
        this.createShell();
        Rectangle clientArea = ((EmulatorScreen)Emulator.getEmulator().getScreen()).getShell().getMonitor().getClientArea();
        this.shell.setLocation(clientArea.x + (int)((double)clientArea.height * 0.025), clientArea.y + (int)((double)clientArea.height * 0.025));
        this.shell.open();
        this.shell.addDisposeListener((DisposeListener)this);
        this.updateEverything();
        this.visible = true;
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        Settings.showMemViewFrame = false;
        if (this.autoUpdater != null) {
            this.autoUpdater.stopThread();
        }
        this.memoryMgr.releasedImages.clear();
        this.visible = false;
    }

    public void dispose() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.visible = false;
    }

    public boolean isShown() {
        return this.visible;
    }

    private void createShell() {
        int shellStyle = 1264;
        this.shell = new Shell(1264);
        this.shell.setText(UILocale.get("MEMORY_VIEW_TITLE", "MemoryView"));
        this.shell.setImage(new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/res/icon")));
        this.shell.setLayout((Layout)new GridLayout(1, true));
        this.shell.setData("TYPE", (Object)SHELL_TYPE);
        this.shell.setMinimumSize(320, 300);
        Rectangle clientArea = ((EmulatorScreen)Emulator.getEmulator().getScreen()).getShell().getMonitor().getClientArea();
        this.shell.setSize((int)((double)clientArea.width * 0.4), (int)((double)clientArea.height * 0.95));
        GridData controlsLayout = new GridData();
        controlsLayout.horizontalAlignment = 4;
        controlsLayout.grabExcessHorizontalSpace = true;
        controlsLayout.verticalAlignment = 4;
        this.memoryControls = new MemoryViewControls((Composite)this.shell, this);
        this.memoryControls.setLayoutData(controlsLayout);
        this.createSeparator();
    }

    private void createSeparator() {
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.grabExcessHorizontalSpace = true;
        this.horizontalSeparator = new SashForm((Composite)this.shell, 0);
        this.horizontalSeparator.setOrientation(512);
        this.horizontalSeparator.setSashWidth(5);
        this.horizontalSeparator.setBackground(Display.getCurrent().getSystemColor(16));
        this.horizontalSeparator.setLayoutData((Object)layoutData);
        this.createMemoryView();
        this.createImagesView();
        this.horizontalSeparator.setWeights(new int[]{4, 6});
    }

    private void createMemoryView() {
        SashForm memoryPanel = new SashForm((Composite)this.horizontalSeparator, 0);
        this.classTable = new Table((Composite)memoryPanel, 67584);
        this.classTable.setHeaderVisible(true);
        this.classTable.setLinesVisible(true);
        TableListener tl = new TableListener(this);
        this.classTable.addSelectionListener((SelectionListener)tl);
        this.classTable.addMouseListener((MouseListener)tl);
        TableColumn tableColumn = new TableColumn(this.classTable, 0);
        tableColumn.setWidth(170);
        tableColumn.setText(UILocale.get("MEMORY_VIEW_CLASS", "Class"));
        tableColumn.addSelectionListener((SelectionListener)new Class31(this));
        TableColumn tableColumn2 = new TableColumn(this.classTable, 0);
        tableColumn2.setWidth(70);
        tableColumn2.setText(UILocale.get("MEMORY_VIEW_INSTANCES", "Instances"));
        tableColumn2.addSelectionListener((SelectionListener)new Class140(this));
        TableColumn tableColumn3 = new TableColumn(this.classTable, 0);
        tableColumn3.setWidth(100);
        tableColumn3.setText(UILocale.get("MEMORY_VIEW_TOTAL_HEAP_SIZE", "Total Heap Size"));
        tableColumn3.addSelectionListener((SelectionListener)new Class17(this));
        SashForm objectsPanel = new SashForm((Composite)memoryPanel, 0);
        objectsPanel.setOrientation(512);
        this.objectsTable = new Table((Composite)objectsPanel, 67584);
        this.objectsTable.setHeaderVisible(true);
        this.objectsTable.setLinesVisible(true);
        ObjectsTableListener otl = new ObjectsTableListener(this);
        this.objectsTable.addSelectionListener((SelectionListener)otl);
        this.objectsTable.addMouseListener((MouseListener)otl);
        TableColumn tableColumn4 = new TableColumn(this.objectsTable, 0);
        tableColumn4.setWidth(230);
        tableColumn4.setText(UILocale.get("MEMORY_VIEW_REFERENCE", "Reference"));
        TableColumn tableColumn5 = new TableColumn(this.objectsTable, 0);
        tableColumn5.setWidth(70);
        tableColumn5.setText(UILocale.get("MEMORY_VIEW_INSTANCE", "Instance"));
        TableColumn tableColumn6 = new TableColumn(this.objectsTable, 0);
        tableColumn6.setWidth(100);
        tableColumn6.setText(UILocale.get("MEMORY_VIEW_SIZE", "Size"));
        this.objectPaths = new Group((Composite)objectsPanel, 0);
        this.objectPaths.setLayout((Layout)new GridLayout(1, false));
        this.objectPaths.addControlListener((ControlListener)this);
        ScrolledComposite sc = new ScrolledComposite((Composite)this.objectPaths, 512);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        sc.setLayoutData((Object)gd);
        this.objectPathsContainer = new Composite((Composite)sc, 0);
        this.objectPathsContainer.setLayout((Layout)new GridLayout(1, false));
        sc.setContent((Control)this.objectPathsContainer);
        this.clearObjectPaths();
        objectsPanel.setWeights(new int[]{8, 2});
    }

    private void createImagesView() {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        this.imagesPanel = new Composite((Composite)this.horizontalSeparator, 0);
        this.imagesPanel.setLayout((Layout)layout);
        this.imageControls = new ImageViewControls(this.imagesPanel, this);
        GridData controlsLayout = new GridData();
        controlsLayout.horizontalAlignment = 4;
        controlsLayout.grabExcessHorizontalSpace = true;
        controlsLayout.verticalAlignment = 4;
        this.imageControls.setLayoutData(controlsLayout);
        GridData canvasLayout = new GridData();
        canvasLayout.horizontalAlignment = 4;
        canvasLayout.grabExcessHorizontalSpace = true;
        canvasLayout.grabExcessVerticalSpace = true;
        canvasLayout.verticalAlignment = 4;
        this.imagesCanvas = new Canvas(this.imagesPanel, 537135616);
        this.imagesCanvas.setLayout(null);
        this.imagesCanvas.setLayoutData((Object)canvasLayout);
        ImagesCanvasListener listener = new ImagesCanvasListener(this, this.imagesCanvas);
        this.imagesCanvas.addPaintListener((PaintListener)listener);
        this.imagesCanvas.addMouseListener((MouseListener)listener);
        this.imagesCanvas.getVerticalBar().addSelectionListener((SelectionListener)listener);
        Menu menuSave = new Menu((Decorations)this.shell, 8);
        MenuItem menuItem = new MenuItem(menuSave, 8);
        menuItem.setText(UILocale.get("MEMORY_VIEW_SAVE_ONE", "Export selected image"));
        menuItem.addSelectionListener((SelectionListener)new SaveImageListener(this));
        MenuItem menuItem2 = new MenuItem(menuSave, 8);
        menuItem2.setText(UILocale.get("MEMORY_VIEW_SAVE_ALL", "Export all images"));
        menuItem2.addSelectionListener((SelectionListener)new SaveAllImagesListener(this));
        this.imagesCanvas.setMenu(menuSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateModel() {
        Object object = updateLock;
        synchronized (object) {
            try {
                this.memoryMgr.updateEverything();
                this.updateImagesList();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateView() {
        if (this.shell.isDisposed()) {
            return;
        }
        try {
            this.imagesCanvas.redraw();
            this.updateClassesView();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.memoryControls.refreshStats();
        this.resortClasses();
    }

    public void updateEverything() {
        this.updateModel();
        this.updateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resortImages() {
        Object object = updateLock;
        synchronized (object) {
            Comparator<ImageViewItem> comp;
            switch (this.getSortingMethod()) {
                case 0: {
                    comp = new ImagesComparatorByOrder(this);
                    break;
                }
                case 1: {
                    comp = new ImagesComparatorBySize(this);
                    break;
                }
                case 2: {
                    comp = new ImagesComparatorByUsage(this);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported sort method");
                }
            }
            imagesToShow.sort(comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImagesList() {
        Object object = updateLock;
        synchronized (object) {
            allImages.clear();
            allImages.ensureCapacity(this.memoryMgr.images.size());
            imagesToShow.clear();
            Memory memory = this.memoryMgr;
            synchronized (memory) {
                for (Image image : this.memoryMgr.images) {
                    boolean add;
                    allImages.add(image);
                    boolean bl = add = this.imagesDrawn && image.getUsedCount() > 0 || this.imagesNeverDrawn && image.getUsedCount() == 0;
                    if (!add) continue;
                    ImageViewItem i2 = new ImageViewItem(image, false);
                    boolean add2 = this.show2dImages && i2.type == MemoryViewImageType.LCDUI || this.show3dImages && i2.type != MemoryViewImageType.LCDUI;
                    if (!add2) continue;
                    imagesToShow.add(i2);
                }
            }
            if (this.showReleasedImages) {
                for (Image image : this.memoryMgr.releasedImages) {
                    allImages.add(image);
                    imagesToShow.add(new ImageViewItem(image, true));
                }
            }
        }
        this.resortImages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectImageClicked(int x, int y) {
        Object object = updateLock;
        synchronized (object) {
            for (ImageViewItem image : imagesToShow) {
                if (image.drawnRect == null || !image.drawnRect.contains(x, y)) continue;
                this.selectedObject = image.source;
                TableItem[] array = this.classTable.getSelection();
                if (array == null || array.length < 1 || !this.selectedObject.getClass().getName().equals(array[0].getData())) {
                    for (TableItem ti : this.classTable.getItems()) {
                        if (!this.selectedObject.getClass().getName().equals(ti.getData())) continue;
                        this.classTable.setSelection(ti);
                        break;
                    }
                    this.onClassTableItemSelection();
                }
                this.syncObjectSelection();
                this.imagesCanvas.redraw();
                return;
            }
        }
    }

    private void syncObjectSelection() {
        for (int i2 = 0; i2 < this.objectsTable.getItemCount(); ++i2) {
            ObjInstance o = (ObjInstance)this.objectsTable.getItem(i2).getData();
            if (o.value != this.selectedObject) continue;
            this.objectsTable.select(i2);
            this.onObjectTableItemSelection();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintImagesCanvas(GC gc) {
        int fh = gc.getFontMetrics().getHeight();
        int canvasW = this.imagesCanvas.getClientArea().width;
        int canvasH = this.imagesCanvas.getClientArea().height;
        int y = 10 - this.imagesCanvasScroll;
        if (this.drawImagesInfo) {
            y += fh * 4;
        }
        int x = 10;
        int max = 0;
        Color background = new Color(null, 151, 150, 147);
        Color regularColor = new Color(null, 0, 0, 0);
        Color releasedColor = new Color(null, 200, 0, 0);
        Color selectedColor = new Color(null, 0, 255, 0);
        Color texColor = new Color(null, 0, 0, 200);
        gc.setBackground(background);
        gc.fillRectangle(0, 0, canvasW, canvasH);
        gc.setInterpolation(0);
        int pixels2d = 0;
        int pixels3d = 0;
        int count2d = 0;
        int count3d = 0;
        Object object = updateLock;
        synchronized (object) {
            int size = imagesToShow.size();
            for (int i2 = 0; i2 < size; ++i2) {
                ImageViewItem item = imagesToShow.get(i2);
                Image image = item.drawable;
                int imgW = (int)((double)image.getWidth() * this.imageScaling);
                int imgH = (int)((double)image.getHeight() * this.imageScaling);
                if (x + imgW + 30 > canvasW) {
                    x = 10;
                    y += max + 10;
                    if (this.drawImagesInfo) {
                        y += fh * 4;
                    }
                    max = 0;
                }
                if (y + imgH > 0 || y > canvasH) {
                    try {
                        if (item.ensureCache()) {
                            gc.drawImage(item.cache, 0, 0, image.getWidth(), image.getHeight(), x, y, imgW, imgH);
                        } else {
                            image.getImpl().copyToScreen(gc, 0, 0, image.getWidth(), image.getHeight(), x, y, imgW, imgH);
                        }
                        if (this.darkenUnused) {
                            image.getUsedRegion().copyToScreen(gc, 0, 0, image.getWidth(), image.getHeight(), x, y, imgW, imgH);
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    if (item.released) {
                        gc.setForeground(releasedColor);
                    } else if (item.source == this.selectedObject) {
                        gc.setForeground(selectedColor);
                    } else if (item.type == MemoryViewImageType.LCDUI) {
                        gc.setForeground(regularColor);
                    } else {
                        gc.setForeground(texColor);
                    }
                    if (this.drawImagesInfo) {
                        gc.drawString(item.getCaption(), x - 1, y - fh * 4, true);
                        gc.drawString(item.type2, x - 1, y - fh * 3, true);
                        gc.drawString(image.getWidth() + "*" + image.getHeight(), x - 1, y - fh * 2, true);
                        if (item.released) {
                            gc.drawString("Released", x - 1, y - fh, true);
                        } else {
                            gc.drawString("x" + image.getUsedCount(), x - 1, y - fh, true);
                        }
                    }
                    gc.drawRectangle(x - 1, y - 1, imgW + 1, imgH + 1);
                    item.drawnRect = new Rectangle(x - 1, y - 1, imgW + 1, imgH + 1);
                } else {
                    item.drawnRect = null;
                }
                if (item.type == MemoryViewImageType.LCDUI) {
                    if (!item.released) {
                        pixels2d += image.getWidth() * image.getHeight();
                        ++count2d;
                    }
                } else {
                    pixels3d += image.getWidth() * image.getHeight();
                    ++count3d;
                }
                int minImgW = this.drawImagesInfo ? 50 : 0;
                x += Math.max(imgW, minImgW) + 10;
                max = Math.max(max, imgH);
            }
        }
        background.dispose();
        releasedColor.dispose();
        regularColor.dispose();
        selectedColor.dispose();
        int anInt1144 = y + max + this.imagesCanvasScroll + 10;
        this.imagesCanvas.getVerticalBar().setMaximum(anInt1144);
        this.imagesCanvas.getVerticalBar().setThumb(Math.min(anInt1144, this.imagesCanvas.getClientArea().height));
        this.imagesCanvas.getVerticalBar().setIncrement(10);
        this.imageControls.updateStats(pixels2d, pixels3d, count2d, count3d);
    }

    void changeClassesSort(int n) {
        this.classTable.setSortColumn(this.classTable.getColumn(n));
        int x = this.classTable.getSortDirection() == 128 ? 1024 : 128;
        this.classTable.setSortDirection(x);
        this.sortColumn = n;
        this.resortClasses();
    }

    private void resortClasses() {
        if (this.sortColumn == -1) {
            return;
        }
        this.classesList.sort(new ClassListComparator(this, this.sortColumn));
        this.setClassTableContent();
    }

    private void updateClassesView() {
        this.classesList = new ArrayList<String>(this.memoryMgr.classesTable.keySet());
        for (int i2 = 0; i2 < this.classesList.size(); ++i2) {
            if (this.memoryMgr.totalObjectsSize(this.classesList.get(i2)) != 0) continue;
            this.classesList.remove(i2--);
        }
        Collections.sort(this.classesList);
        if (this.classesList.size() > this.classTable.getItemCount()) {
            for (int j = this.classesList.size() - this.classTable.getItemCount(); j > 0; --j) {
                new TableItem(this.classTable, 0);
            }
        } else {
            while (this.classTable.getItemCount() > this.classesList.size()) {
                this.classTable.remove(this.classesList.size());
            }
        }
        this.setClassTableContent();
    }

    private void setClassTableContent() {
        for (int i2 = 0; i2 < this.classesList.size(); ++i2) {
            String value = this.classesList.get(i2);
            TableItem item = this.classTable.getItem(i2);
            if (this.displayPkgNames) {
                item.setText(0, value);
            } else {
                String[] split = value.split("\\.");
                item.setText(0, split[split.length - 1]);
            }
            item.setText(1, String.valueOf(this.memoryMgr.instancesCount(value)));
            item.setText(2, String.valueOf(this.memoryMgr.totalObjectsSize(value)));
            item.setData((Object)value);
        }
    }

    void onClassTableItemSelection() {
        TableItem[] array = this.classTable.getSelection();
        if (array == null || array.length < 1) {
            return;
        }
        this.objectsTable.removeAll();
        String cls = (String)array[0].getData();
        ArrayList<ObjInstance> objs = this.memoryMgr.objs(cls);
        if (this.selectedObject != null && !this.selectedObject.getClass().getName().equals(cls)) {
            this.selectedObject = null;
        }
        for (ObjInstance o : objs) {
            TableItem ti = new TableItem(this.objectsTable, 0);
            if (o.paths.isEmpty()) {
                ti.setText(0, "Unknown reference");
            } else if (o.paths.size() == 1) {
                ti.setText(0, o.paths.iterator().next().toString(this.displayPkgNames));
            } else {
                ti.setText(0, o.paths.iterator().next().toString(this.displayPkgNames) + "; " + (o.paths.size() - 1) + " more");
            }
            String s = String.valueOf(o.value);
            if (s.length() > 128) {
                s = s.substring(0, 127) + "...";
            }
            ti.setText(1, s);
            ti.setText(2, String.valueOf(o.size));
            ti.setData((Object)o);
        }
        this.clearObjectPaths();
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.dispose();
    }

    void setAutoUpdate(boolean enabled, int interval) {
        if (this.autoUpdater != null) {
            this.autoUpdater.stopThread();
            this.autoUpdater = null;
        }
        if (enabled) {
            if (interval < 10) {
                throw new IllegalArgumentException("Too small update interval");
            }
            this.autoUpdater = new AutoUpdate(this, interval);
            this.autoUpdater.start();
        }
    }

    public void setImagesDrawn(boolean b2) {
        this.imagesDrawn = b2;
        this.updateEverything();
    }

    void setImagesNotDrawn(boolean b2) {
        this.imagesNeverDrawn = b2;
        this.updateEverything();
    }

    void setImagesAscend(boolean b2) {
        this.sortImagesByAscending = b2;
        this.resortImages();
        this.updateView();
    }

    void setImagesSorting(int i2) {
        this.imagesSortingMethod = i2;
        this.resortImages();
        this.updateView();
    }

    void setShowReleasedImages(boolean b2) {
        this.showReleasedImages = b2;
        this.updateEverything();
    }

    void setShow2dImages(boolean b2) {
        this.show2dImages = b2;
        this.updateEverything();
    }

    void setShow3dImages(boolean b2) {
        this.show3dImages = b2;
        this.updateEverything();
    }

    void setShowImagesInfo(boolean b2) {
        this.drawImagesInfo = b2;
        this.updateView();
    }

    void setDarkenUnused(boolean b2) {
        this.darkenUnused = b2;
        this.updateEverything();
    }

    void setImagesScaling(int i2) {
        double s = i2;
        if (s == 0.0) {
            s = 0.5;
        }
        this.imageScaling = s;
        this.updateView();
    }

    void setPkgNamesDisplay(boolean b2) {
        this.displayPkgNames = b2;
        this.updateClassesView();
        this.onClassTableItemSelection();
        this.syncObjectSelection();
        this.onObjectTableItemSelection();
    }

    Shell getShell() {
        return this.shell;
    }

    Object getSelectedImage() {
        return this.selectedObject;
    }

    Table getTheTable() {
        return this.classTable;
    }

    void onObjectTableItemSelection() {
        TableItem[] array = this.objectsTable.getSelection();
        if (array == null || array.length < 1) {
            this.clearObjectPaths();
            return;
        }
        ObjInstance inst = (ObjInstance)array[0].getData();
        this.displayObjectPaths(inst);
        this.selectedObject = inst.value;
        this.imagesCanvas.redraw();
    }

    private void clearObjectPaths() {
        for (Control c2 : this.objectPathsContainer.getChildren()) {
            c2.dispose();
        }
        new Label(this.objectPathsContainer, 0).setText("No objects selected. Select an object to inspect it.");
        this.objectPaths.setText("Paths to the object");
        this.objectPaths.layout(true, true);
        this.relayoutObjectSizes();
    }

    private void displayObjectPaths(ObjInstance inst) {
        for (Control c2 : this.objectPathsContainer.getChildren()) {
            c2.dispose();
        }
        for (ReferencePath o : inst.paths) {
            new ReferencePathDisplay(this.objectPathsContainer, o, this.displayPkgNames);
        }
        this.objectPaths.setText("Paths to the object (" + inst.paths.size() + ")");
        this.objectPaths.layout(true, true);
        this.relayoutObjectSizes();
    }

    private void relayoutObjectSizes() {
        this.objectPathsContainer.setSize(this.objectPathsContainer.computeSize(this.objectPathsContainer.getParent().getSize().x, -1));
    }

    void openWatcherForSelected() {
        TableItem[] array = this.objectsTable.getSelection();
        if (array == null || array.length < 1) {
            return;
        }
        Object value = ((ObjInstance)array[0].getData()).value;
        if (value != null && ClassTypes.isObject(value.getClass())) {
            new Watcher(value).open(this.shell);
        }
    }

    void openWatcherForSelectedClass() {
        TableItem[] array = this.classTable.getSelection();
        if (array == null || array.length < 1) {
            return;
        }
        try {
            new Watcher(Memory.cls(array[0].getData().toString())).open(this.getShell());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void exportSelectedImage() {
        if (this.getSelectedImage() != null) {
            for (ImageViewItem item : imagesToShow) {
                if (item.source != this.getSelectedImage()) continue;
                FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
                fileDialog.setText(UILocale.get("MEMORY_VIEW_SAVE_TO_FILE", "Save to file"));
                fileDialog.setFilterExtensions(new String[]{"*.png"});
                String open = fileDialog.open();
                if (open != null) {
                    item.drawable.getImpl().saveToFile(open);
                }
                return;
            }
        }
        Emulator.getEmulator().getScreen().showMessage("No images selected. Click at one to select it.");
    }

    int getSortingMethod() {
        return this.imagesSortingMethod;
    }

    boolean getSortByAscending() {
        return this.sortImagesByAscending;
    }

    public void controlMoved(ControlEvent controlEvent) {
    }

    public void controlResized(ControlEvent controlEvent) {
        this.relayoutObjectSizes();
    }

    public static final class AutoUpdate
    extends Thread {
        boolean shouldRun;
        long updateInterval;
        private final MemoryView mv;

        AutoUpdate(MemoryView mv, long updateInterval) {
            this.mv = mv;
            this.updateInterval = updateInterval;
            this.shouldRun = true;
        }

        @Override
        public void run() {
            while (this.shouldRun && !this.mv.getShell().isDisposed()) {
                try {
                    this.mv.updateModel();
                    this.mv.getShell().getDisplay().syncExec(this.mv::updateView);
                    Thread.sleep(this.updateInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void stopThread() {
            this.shouldRun = false;
            if (this.isAlive()) {
                this.interrupt();
            }
        }
    }
}

