/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.debug.Memory;
import emulator.ui.swt.MemoryView;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MemoryViewControls
extends Composite
implements SelectionListener,
ModifyListener,
Runnable,
FocusListener {
    private final MemoryView mv;
    private final Button autoUpdate;
    private final Text autoUpdateInterval;
    private final Button updateNow;
    private final Label objectsSize;
    private final Label totalSize;
    private final Label jvmSize;
    private final Button gc;
    private final Button packages;
    private int maxObjectsSize = 0;
    private int objSize;
    private int interval = 500;

    public MemoryViewControls(Composite parent, MemoryView mv) {
        super(parent, 0);
        this.mv = mv;
        RowLayout rl = new RowLayout();
        rl.wrap = true;
        rl.center = true;
        rl.type = 256;
        rl.spacing = 8;
        this.setLayout((Layout)rl);
        this.autoUpdate = new Button((Composite)this, 32);
        this.autoUpdate.setText("Autoupdate: each");
        this.autoUpdate.addSelectionListener((SelectionListener)this);
        this.autoUpdateInterval = new Text((Composite)this, 2048);
        this.autoUpdateInterval.setText("500");
        this.autoUpdateInterval.addModifyListener((ModifyListener)this);
        this.autoUpdateInterval.addFocusListener((FocusListener)this);
        new Label((Composite)this, 0).setText("ms");
        this.updateNow = new Button((Composite)this, 8);
        this.updateNow.setText("Update now");
        this.updateNow.addSelectionListener((SelectionListener)this);
        Group bytecodeSizeGroup = new Group((Composite)this, 0);
        bytecodeSizeGroup.setText("Bytecode size");
        bytecodeSizeGroup.setToolTipText("Total size of all loaded classes in bytes");
        bytecodeSizeGroup.setLayout((Layout)new RowLayout());
        Label bytecodeSize = new Label((Composite)bytecodeSizeGroup, 0);
        bytecodeSize.setText(Memory.getBytecodeSize() + " bytes");
        Group objectsSizeGroup = new Group((Composite)this, 0);
        objectsSizeGroup.setText("Objects size");
        objectsSizeGroup.setToolTipText("Total size of objects heap");
        objectsSizeGroup.setLayout((Layout)new RowLayout());
        new Label((Composite)objectsSizeGroup, 0).setText("Now/max: ");
        this.objectsSize = new Label((Composite)objectsSizeGroup, 0);
        this.objectsSize.setText("????????B/????????B");
        Group totalSizeGroup = new Group((Composite)this, 0);
        totalSizeGroup.setText("Total memory used");
        totalSizeGroup.setLayout((Layout)new RowLayout());
        this.totalSize = new Label((Composite)totalSizeGroup, 0);
        this.totalSize.setText("?????KiB");
        Group jvmSizeGroup = new Group((Composite)this, 0);
        jvmSizeGroup.setText("Real usage");
        jvmSizeGroup.setToolTipText("Total memory, taken by KEmulator");
        jvmSizeGroup.setLayout((Layout)new RowLayout());
        this.jvmSize = new Label((Composite)jvmSizeGroup, 0);
        this.jvmSize.setText("????/????MiB");
        this.gc = new Button((Composite)this, 8);
        this.gc.setText("GC");
        this.gc.setToolTipText("Perform garbage collection");
        this.gc.addSelectionListener((SelectionListener)this);
        this.packages = new Button((Composite)this, 32);
        this.packages.setText("Pkg names");
        this.packages.setToolTipText("If disabled, package names in class names will be hidden. Disable if you want to see \"Display\" instead of \"javax.microedition.lcdui.Display\".");
        this.packages.setSelection(true);
        this.packages.addSelectionListener((SelectionListener)this);
    }

    public void refreshStats() {
        this.objSize = this.mv.memoryMgr.objectsSize();
        this.maxObjectsSize = Math.max(this.maxObjectsSize, this.objSize);
        this.getDisplay().asyncExec((Runnable)this);
    }

    @Override
    public void run() {
        long t = Runtime.getRuntime().totalMemory();
        long f2 = Runtime.getRuntime().freeMemory();
        this.objectsSize.setText(this.objSize + "B / " + this.maxObjectsSize + "B");
        this.totalSize.setText((this.objSize + Memory.getBytecodeSize()) / 1024 + "KiB");
        this.jvmSize.setText((t - f2) / 0x100000L + "/" + t / 0x100000L + "MiB");
        this.layout(true, true);
    }

    public void widgetSelected(SelectionEvent e2) {
        if (e2.widget == this.autoUpdate) {
            this.mv.setAutoUpdate(this.autoUpdate.getSelection(), this.interval);
        } else if (e2.widget == this.updateNow) {
            this.mv.updateEverything();
        } else if (e2.widget == this.gc) {
            this.mv.updateEverything();
            System.gc();
            this.refreshStats();
        } else if (e2.widget == this.packages) {
            this.mv.setPkgNamesDisplay(this.packages.getSelection());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e2) {
    }

    public void modifyText(ModifyEvent e2) {
        try {
            this.interval = Integer.parseInt(this.autoUpdateInterval.getText());
            if (this.interval >= 10) {
                this.mv.setAutoUpdate(this.autoUpdate.getSelection(), this.interval);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void focusGained(FocusEvent e2) {
        if (e2.widget == this.autoUpdateInterval) {
            this.autoUpdateInterval.setSelection(0, this.autoUpdateInterval.getText().length());
        }
    }

    public void focusLost(FocusEvent e2) {
        if (e2.widget == this.autoUpdateInterval) {
            try {
                this.interval = Integer.parseInt(this.autoUpdateInterval.getText());
                if (this.interval >= 10) {
                    this.mv.setAutoUpdate(this.autoUpdate.getSelection(), this.interval);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.autoUpdateInterval.setText("500");
            this.interval = 500;
            this.mv.setAutoUpdate(this.autoUpdate.getSelection(), this.interval);
        }
    }
}

