/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.Controllers;
import emulator.Devices;
import emulator.Emulator;
import emulator.KeyMapping;
import emulator.Permission;
import emulator.Settings;
import emulator.UILocale;
import emulator.graphics2D.IFont;
import emulator.graphics2D.IGraphics2D;
import emulator.graphics2D.IImage;
import emulator.graphics2D.awt.FontAWT;
import emulator.graphics2D.swt.FontSWT;
import emulator.ui.IProperty;
import emulator.ui.swt.Class101;
import emulator.ui.swt.Class103;
import emulator.ui.swt.Class109;
import emulator.ui.swt.Class111;
import emulator.ui.swt.Class113;
import emulator.ui.swt.Class117;
import emulator.ui.swt.Class135;
import emulator.ui.swt.Class184;
import emulator.ui.swt.Class185;
import emulator.ui.swt.Class186;
import emulator.ui.swt.Class187;
import emulator.ui.swt.Class188;
import emulator.ui.swt.Class190;
import emulator.ui.swt.Class191;
import emulator.ui.swt.Class192;
import emulator.ui.swt.Class193;
import emulator.ui.swt.Class194;
import emulator.ui.swt.Class195;
import emulator.ui.swt.Class196;
import emulator.ui.swt.Class65;
import emulator.ui.swt.Class97;
import emulator.ui.swt.EmulatorScreen;
import emulator.ui.swt.ResizeMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import javax.microedition.rms.RecordStore;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class Property
implements IProperty,
SelectionListener {
    public static final String[][] API_LIST = new String[][]{{"FileConnection (JSR 75)", "javax.microedition.io.file"}, {"PIM (JSR 75) (Stub)", "javax.microedition.pim"}, {"Bluetooth (JSR 82) (Stub)", "javax.bluetooth"}, {"Messaging (JSR 120)", "javax.wireless.messaging"}, {"Media (JSR 135)", "javax.microedition.media"}, {"Crypto (JSR 177 SATSA)", "javax.crypto"}, {"Location (JSR 179)", "javax.microedition.location"}, {"M3G (JSR 184)", "javax.microedition.m3g"}, {"ContentHandler (JSR 211) (Stub)", "javax.microedition.content"}, {"Advanced Media (JSR 234)", "javax.microedition.amms"}, {"OpenGL ES (JSR 239)", "javax.microedition.khronos"}, {"Sensor (JSR 256)", "javax.microedition.sensor"}, {"Nokia", "com.nokia.mid"}, {"Samsung", "com.samsung"}, {"Siemens", "com.siemens"}, {"Sprint", "com.sprintpcs"}, {"Sony Ericsson", "com.sonyericsson"}, {"Motorola", "com.motorola"}, {"Vodafone", "com.vodafone"}, {"LG MMPP", "mmpp"}, {"Nokia UI", "com.nokia.mid.ui"}, {"Nokia Sound", "com.nokia.mid.sound"}, {"Nokia M3D(O)", "com.nokia.mid.m3d"}, {"Nokia Location", "com.nokia.mid.location"}, {"Nokia In-App", "com.nokia.mid.payment"}, {"Nokia IAPInfo (Stub)", "com.nokia.mid.iapinfo"}, {"MascotCapsule", "com.mascotcapsule"}, {"MEXA OpenGL", "com.mexa"}, {"com.j_phone", "com.j_phone"}, {"com.jblend", "com.jblend"}, {"Immersion VibeTonz", "com.immersion"}, {"PantechAudio", "com.pantech"}, {"RIM", "net.rim"}, {"Pigler Notifications", "org.pigler"}, {"KEmulator Notifications (Deprecated)", "ru.nnproject.kemulator.notificationapi"}, {"KEmulator Rich Presence", "ru.nnproject.kemulator.rpc"}, {"KEmulator Window API", "ru.nnproject.kemulator.windowapi"}, {"KEmulator", "kemulator"}, {"CustomItem (MIDP 2.0)", "javax.microedition.lcdui.CustomItem"}, {"Spacer (MIDP 2.0)", "javax.microedition.lcdui.Spacer"}, {"Game (MIDP 2.0)", "javax.microedition.lcdui.game"}, {"Float (CLDC 1.1)", "java.lang.Float"}, {"Double (CLDC 1.1)", "java.lang.Double"}};
    public static final String[][] PERMISSIONS = new String[][]{{"Send SMS", "messageconnection.send"}, {"Receive SMS", "messageconnection.receive"}, {"File System Access", "connector.open.file"}, {"HTTP Connection", "connector.open.http"}, {"Socket Connection", "connector.open.socket"}, {"Socket Server", "connector.open.serversocket"}, {"Camera", "media.camera"}, {"Location", "location"}, {"Open browser", "platformrequest"}};
    public static final String[][] PERMISSIONS_VALUES = new String[][]{{"Allowed", "Ask once", "Ask every time", "Never"}, {"allowed", "ask_once", "ask_always_until_no", "never"}};
    private static Display display;
    private Shell setsShell;
    private Combo deviceCombo;
    private Combo aCombo675;
    private Text aText662;
    private Text screenWidthText;
    private Text screenHeightText;
    private Text aText695;
    private Text aText702;
    private Text aText708;
    private Text aText713;
    private Text aText718;
    private Text aText723;
    private Text aText727;
    private Scale fpsScale;
    private CLabel fpsLabel;
    private CTabFolder tabFolder;
    private Composite customComp;
    private Text aText731;
    private Text aText735;
    private Text aText739;
    private Text aText742;
    private Text aText745;
    private Text aText748;
    private Text aText751;
    private Text aText754;
    private Text aText757;
    private Text aText760;
    private Text aText763;
    private Text aText766;
    private Text aText768;
    private Text aText770;
    private Text aText772;
    private Text aText774;
    private Text aText627;
    private Text aText629;
    private Text aText631;
    private Button aButton696;
    private Button aButton703;
    private Button aButton709;
    private Button aButton714;
    private Button aButton719;
    private Composite systemComp;
    private Composite coreApiComp;
    private Group sysChecksGroup;
    private Button vibrationCheck;
    private Button keyRepeatCheck;
    private Button canvasFullscreenCheck;
    private Button noNetworkBtn;
    private Button aButton746;
    private Button aButton749;
    private Button aButton752;
    private Composite sysFontComp;
    private Combo aCombo689;
    private Spinner aSpinner670;
    private Canvas aCanvas663;
    private Spinner aSpinner679;
    private Canvas aCanvas680;
    private Spinner aSpinner690;
    private Canvas aCanvas691;
    private Text aText633;
    private String device;
    private String defaultFont;
    private String rmsFolder;
    private String screenWidth;
    private String screenHeight;
    private String lsoft;
    private String rsoft;
    private String fire;
    private String up;
    private String down;
    private String left;
    private String right;
    private int fontSmallSize;
    private int fontMediumSize;
    private int fontLargeSize;
    Combo controllerCombo;
    private static String[] aStringArray661;
    private IImage anIImage671;
    private IImage anIImage674;
    private IImage anIImage693;
    private Composite recordsComp;
    private Table aTable665;
    private Composite networkComp;
    private Group networkProxyGroup;
    private Combo proxyTypeCombo;
    private Text aText635;
    private Text aText637;
    private Text aText639;
    private Text aText641;
    private Text aText643;
    private Button aButton764;
    private Button rpcBtn;
    private Button antiAliasBtn;
    private Composite mediaComp;
    private Text vlcDirText;
    private Font f;
    private Text localeText;
    private Text platformText;
    private Combo languageCombo;
    private Combo updateBranchCombo;
    private Composite keyMapControllerComp;
    private Composite keyMapTabComp;
    private Button softkeyMotFixCheck;
    private Button synchronizeKeyEventsCheck;
    private Composite m3gComp;
    private Button m3gIgnoreOverwriteCheck;
    private Button m3gForcePersCorrect;
    private Button m3gDisableLightClamp;
    private Combo m3gAACombo;
    private Combo m3gTexFilterCombo;
    private Combo m3gMipmapCombo;
    private Button vmsCheck;
    private Button globalMidiCheck;
    private Button fpsCounterCheck;
    private Button keyPressOnRepeatCheck;
    private Button antiAliasTextBtn;
    private Composite disableApiComp;
    private Table disableApiTable;
    private Composite propsComp;
    private Text propsText;
    private Button mediaDumpCheck;
    private ScrolledComposite securityComp;
    private Button mascotNo2DMixingCheck;
    private Composite mascotComp;
    private Button mascotIgnoreBgCheck;
    private Button mascotTextureFilterCheck;
    private Button mascotBackgroundFilterCheck;
    private Button securityCheck;
    private Composite securityContent;
    private Tree rmsTree;
    private Button pointerEventsCheck;
    private Button fpsLimitJlCheck;
    private Button autoUpdatesBtn;
    private Button m3gFlushImmediately;
    private Button asyncFlushCheck;
    private Button m3gThreadCheck;
    private Combo ottCombo;

    public Property() {
        this.loadProperties();
        this.updateProxy();
        UILocale.initLocale();
    }

    public void open(Shell parent) {
        display = parent.getDisplay();
        this.method372(parent);
        this.setsShell.pack();
        this.setsShell.setSize(480, this.setsShell.getSize().y);
        this.securityComp.setMinHeight(this.securityContent.computeSize((int)-1, (int)-1).y);
        this.securityComp.setExpandVertical(true);
        this.setsShell.setLocation(parent.getLocation().x + (parent.getSize().x - this.setsShell.getSize().x >> 1), parent.getLocation().y + (parent.getSize().y - this.setsShell.getSize().y >> 1));
        this.setsShell.open();
        while (!this.setsShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.anIImage671 = null;
        this.anIImage674 = null;
        this.anIImage693 = null;
    }

    @Override
    public void resetDeviceName() {
        this.device = Emulator.deviceName;
    }

    @Override
    public String getDefaultFontName() {
        return this.defaultFont;
    }

    public String getMonospaceFontName() {
        return "Consolas";
    }

    @Override
    public int getFontSmallSize() {
        return this.fontSmallSize;
    }

    @Override
    public int getFontMediumSize() {
        return this.fontMediumSize;
    }

    @Override
    public int getFontLargeSize() {
        return this.fontLargeSize;
    }

    @Override
    public void setDefaultFontName(String aString682) {
        this.defaultFont = aString682;
    }

    @Override
    public void setFontSmallSize(int anInt664) {
        this.fontSmallSize = anInt664;
    }

    @Override
    public void getFontMediumSize(int anInt681) {
        this.fontMediumSize = anInt681;
    }

    @Override
    public void getFontLargeSize(int anInt687) {
        this.fontLargeSize = anInt687;
    }

    private String method355() {
        return this.device + "_" + this.screenWidth + "x" + this.screenHeight;
    }

    @Override
    public String getRmsFolderPath() {
        String s;
        block8: {
            String substring;
            StringBuffer sb;
            block7: {
                block6: {
                    s = null;
                    s = this.rmsFolder;
                    if (!s.startsWith(".")) break block6;
                    sb = new StringBuffer().append(Emulator.getUserPath());
                    substring = s.substring(1);
                    break block7;
                }
                if (!s.startsWith("/") && !s.startsWith("\\")) break block8;
                sb = new StringBuffer().append(Emulator.getUserPath());
                substring = s;
            }
            s = sb.append(substring).toString();
        }
        File file = new File(s);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        try {
            return file.getCanonicalPath() + File.separator;
        }
        catch (IOException e2) {
            return s + File.separator;
        }
    }

    @Override
    public String getOldRmsPath() {
        return this.getRmsFolderPath() + this.method355() + File.separator;
    }

    @Override
    public void setCustomProperties() {
        if (this.device.equalsIgnoreCase(Emulator.deviceName)) {
            Devices.setProperty("SCREEN_WIDTH", this.screenWidth);
            Devices.setProperty("SCREEN_HEIGHT", this.screenHeight);
            Devices.setProperty("KEY_S1", this.lsoft);
            Devices.setProperty("KEY_S2", this.rsoft);
            Devices.setProperty("KEY_FIRE", this.fire);
            Devices.setProperty("KEY_UP", this.up);
            Devices.setProperty("KEY_DOWN", this.down);
            Devices.setProperty("KEY_LEFT", this.left);
            Devices.setProperty("KEY_RIGHT", this.right);
            Devices.writeProperties();
        }
    }

    @Override
    public void updateCustomProperties() {
        this.screenWidth = Devices.getProperty("SCREEN_WIDTH");
        this.screenHeight = Devices.getProperty("SCREEN_HEIGHT");
        this.lsoft = Devices.getProperty("KEY_S1");
        this.rsoft = Devices.getProperty("KEY_S2");
        this.fire = Devices.getProperty("KEY_FIRE");
        this.up = Devices.getProperty("KEY_UP");
        this.down = Devices.getProperty("KEY_DOWN");
        this.left = Devices.getProperty("KEY_LEFT");
        this.right = Devices.getProperty("KEY_RIGHT");
    }

    @Override
    public void loadProperties() {
        try {
            String[] sysProps;
            String property;
            if (!new File(Emulator.getUserPath() + "/property.txt").exists()) {
                throw new FileNotFoundException();
            }
            FileInputStream fileInputStream = new FileInputStream(Emulator.getUserPath() + "/property.txt");
            Properties properties = new Properties();
            properties.load(fileInputStream);
            this.device = property = properties.getProperty("DevicePreset", "SonyEricssonK800");
            Emulator.deviceName = property;
            this.defaultFont = properties.getProperty("DefaultFont", "Tahoma");
            this.rmsFolder = properties.getProperty("RMSFolder", "/rms");
            this.fontSmallSize = Integer.parseInt(properties.getProperty("FontSmallSize", String.valueOf(12)));
            this.fontMediumSize = Integer.parseInt(properties.getProperty("FontMediumSize", String.valueOf(14)));
            this.fontLargeSize = Integer.parseInt(properties.getProperty("FontLargeSize", String.valueOf(16)));
            this.screenWidth = properties.getProperty("SCREEN_WIDTH", "240");
            this.screenHeight = properties.getProperty("SCREEN_HEIGHT", "320");
            this.lsoft = properties.getProperty("KEY_LSOFT", "-6");
            this.rsoft = properties.getProperty("KEY_RSOFT", "-7");
            this.fire = properties.getProperty("KEY_FIRE", "-5");
            this.up = properties.getProperty("KEY_UP", "-1");
            this.down = properties.getProperty("KEY_DOWN", "-2");
            this.left = properties.getProperty("KEY_LEFT", "-3");
            this.right = properties.getProperty("KEY_RIGHT", "-4");
            Settings.g2d = properties.getProperty("2D_Graphics_Engine", "AWT").equalsIgnoreCase("SWT") ? 0 : 1;
            Settings.g3d = properties.getProperty("3D_Graphics_Engine", "LWJ").equalsIgnoreCase("SWERVE") ? 0 : 1;
            Settings.micro3d = properties.getProperty("Micro3D_Engine", Emulator.isX64() ? "GL" : "DLL").equalsIgnoreCase("DLL") ? 0 : 1;
            Settings.frameRate = Integer.parseInt(properties.getProperty("FrameRate", String.valueOf(30)));
            Settings.asyncFlush = Boolean.parseBoolean(properties.getProperty("AsyncFlush", "true"));
            KeyMapping.mapDeviceKey(0, KeyMapping.method601(properties.getProperty("MAP_KEY_NUM_0")));
            KeyMapping.mapDeviceKey(1, KeyMapping.method601(properties.getProperty("MAP_KEY_NUM_1")));
            KeyMapping.mapDeviceKey(2, KeyMapping.method601(properties.getProperty("MAP_KEY_NUM_2")));
            KeyMapping.mapDeviceKey(3, KeyMapping.method601(properties.getProperty("MAP_KEY_NUM_3")));
            KeyMapping.mapDeviceKey(4, KeyMapping.method601(properties.getProperty("MAP_KEY_NUM_4")));
            KeyMapping.mapDeviceKey(5, KeyMapping.method601(properties.getProperty("MAP_KEY_NUM_5")));
            KeyMapping.mapDeviceKey(6, KeyMapping.method601(properties.getProperty("MAP_KEY_NUM_6")));
            KeyMapping.mapDeviceKey(7, KeyMapping.method601(properties.getProperty("MAP_KEY_NUM_7")));
            KeyMapping.mapDeviceKey(8, KeyMapping.method601(properties.getProperty("MAP_KEY_NUM_8")));
            KeyMapping.mapDeviceKey(9, KeyMapping.method601(properties.getProperty("MAP_KEY_NUM_9")));
            KeyMapping.mapDeviceKey(10, KeyMapping.method601(properties.getProperty("MAP_KEY_STAR")));
            KeyMapping.mapDeviceKey(11, KeyMapping.method601(properties.getProperty("MAP_KEY_POUND")));
            KeyMapping.mapDeviceKey(12, KeyMapping.method601(properties.getProperty("MAP_KEY_UP")));
            KeyMapping.mapDeviceKey(13, KeyMapping.method601(properties.getProperty("MAP_KEY_DOWN")));
            KeyMapping.mapDeviceKey(14, KeyMapping.method601(properties.getProperty("MAP_KEY_LEFT")));
            KeyMapping.mapDeviceKey(15, KeyMapping.method601(properties.getProperty("MAP_KEY_RIGHT")));
            KeyMapping.mapDeviceKey(16, KeyMapping.method601(properties.getProperty("MAP_KEY_MIDDLE")));
            KeyMapping.mapDeviceKey(17, KeyMapping.method601(properties.getProperty("MAP_KEY_LSOFT")));
            KeyMapping.mapDeviceKey(18, KeyMapping.method601(properties.getProperty("MAP_KEY_RSOFT")));
            Settings.enableKeyCache = Boolean.parseBoolean(properties.getProperty("EnableKeyCache", "false"));
            Settings.canvasKeyboard = Boolean.parseBoolean(properties.getProperty("CanvasKeyboardMode", "true"));
            Settings.recordKeys = Boolean.parseBoolean(properties.getProperty("RecordKeys", "false"));
            for (Object k2 : properties.keySet()) {
                if (((String)k2).startsWith("ControllerMap.")) {
                    Settings.controllerBinds.put(((String)k2).substring("ControllerMap.".length()), properties.getProperty((String)k2));
                    continue;
                }
                if (!((String)k2).startsWith("Security.")) continue;
                Permission.permissions.put(((String)k2).substring("Security.".length()), Permission.fromString(properties.getProperty((String)k2)));
            }
            Settings.enableVibration = Boolean.parseBoolean(properties.getProperty("EnableVibration", "false"));
            Settings.enableKeyRepeat = Boolean.parseBoolean(properties.getProperty("EnableKeyRepeat", "false"));
            Settings.ignoreFullScreen = Boolean.parseBoolean(properties.getProperty("IgnoreFullScreenMode", "false"));
            Settings.networkNotAvailable = Boolean.parseBoolean(properties.getProperty("NetworkNotAvailable", "false"));
            Settings.synchronizeKeyEvents = Boolean.parseBoolean(properties.getProperty("SynchronizeKeyEvents", "false"));
            Settings.motorolaSoftKeyFix = Boolean.parseBoolean(properties.getProperty("MotorolaSoftKeyFix", "false"));
            Settings.patchSynchronizedPlayerUpdate = Boolean.parseBoolean(properties.getProperty("PatchSynchronizedPlayerUpdate", "true"));
            Settings.pollKeyboardOnRepaint = Boolean.parseBoolean(properties.getProperty("PollKeyboardOnRepaint", "true"));
            Settings.ignoreRegionRepaint = Boolean.parseBoolean(properties.getProperty("IgnoreRegionRepaint", "false"));
            Settings.startAppOnResume = Boolean.parseBoolean(properties.getProperty("StartAppOnResume", "true"));
            Settings.keyPressOnRepeat = Boolean.parseBoolean(properties.getProperty("KeyPressOnRepeat", "false"));
            Settings.ignoreServiceRepaints = Boolean.parseBoolean(properties.getProperty("IgnoreServiceRepaints", "false"));
            Settings.dontRepaintOnSetCurrent = Boolean.parseBoolean(properties.getProperty("DontRepaintOnSetCurrent", "false"));
            Settings.hasPointerEvents = Boolean.parseBoolean(properties.getProperty("HasPointerEvents", "true"));
            Settings.j2lStyleFpsLimit = Boolean.parseBoolean(properties.getProperty("FPSLimitJLStyle", "false"));
            Settings.queueSleep = Boolean.parseBoolean(properties.getProperty("EventQueueSleep", "true"));
            Settings.patchYield = Boolean.parseBoolean(properties.getProperty("PatchYield", "false"));
            Settings.ignoreGc = Boolean.parseBoolean(properties.getProperty("IgnoreGC", "true"));
            Settings.ignoreSleep = Boolean.parseBoolean(properties.getProperty("IgnoreThreadSleep", "false"));
            String[] protectedPackages = properties.getProperty("ProtectedPackages", "").split(";");
            if (protectedPackages.length > 0) {
                Settings.protectedPackages.addAll(Arrays.asList(protectedPackages));
            }
            for (String s : sysProps = properties.getProperty("SystemProperties", "").split("\n")) {
                int i2;
                if ((s = s.trim()).isEmpty() || (i2 = s.indexOf(58)) == -1) continue;
                String k3 = s.substring(0, i2).trim();
                String v = s.substring(i2 + 1).trim();
                Settings.systemProperties.put(k3, v);
            }
            Settings.fileEncoding = properties.getProperty("FileEncoding", "ISO-8859-1");
            Settings.locale = properties.getProperty("MIDPLocale", "en-US");
            Settings.microeditionPlatform = properties.getProperty("MicroeditionPlatform", "Nokia6700c-1/13.10");
            Settings.rightClickMenu = Boolean.parseBoolean(properties.getProperty("RightClickMenu", "false"));
            Settings.xrayOverlapScreen = Boolean.parseBoolean(properties.getProperty("XRayOverLapScreen", "false"));
            Settings.xrayShowClipBorder = Boolean.parseBoolean(properties.getProperty("XRayShowClipBorder", "false"));
            Settings.infoColorHex = Boolean.parseBoolean(properties.getProperty("InfoColorHex", "false"));
            Settings.recordReleasedImg = Boolean.parseBoolean(properties.getProperty("RecordReleasedImg", "false"));
            Settings.autoGenJad = Boolean.parseBoolean(properties.getProperty("AutoGenJad", "false"));
            Settings.enableNewTrack = Boolean.parseBoolean(properties.getProperty("EnableNewTrack", "false"));
            Settings.enableMethodTrack = Boolean.parseBoolean(properties.getProperty("EnableMethodTrack", "false"));
            Settings.threadMethodTrack = Boolean.parseBoolean(properties.getProperty("ShowMethodTrack", "false"));
            Settings.updateBranch = properties.getProperty("UpdateBranch", Emulator.debugBuild ? "dev" : "stable");
            Settings.autoUpdate = Integer.parseInt(properties.getProperty("AutoUpdate", "0"));
            Settings.altLessSpeedShortcuts = Boolean.parseBoolean(properties.getProperty("AltLessSpeedShortcuts", "false"));
            Settings.bypassVserv = Boolean.parseBoolean(properties.getProperty("BypassVserv", "true"));
            Settings.wavCache = Boolean.parseBoolean(properties.getProperty("WavCache", "true"));
            Settings.rpc = Boolean.parseBoolean(properties.getProperty("DiscordRichPresence", "false"));
            Settings.uiLanguage = properties.getProperty("UILanguage", "en");
            Settings.writeKemCfg = Boolean.parseBoolean(properties.getProperty("WriteKemulatorCfg", "false"));
            for (int i3 = 0; i3 < 5; ++i3) {
                Settings.recentJars[i3] = properties.getProperty("MRUList" + i3, "");
            }
            Settings.proxyType = Integer.parseInt(properties.getProperty("ProxyType", "0"));
            if (Settings.proxyType < 0 || Settings.proxyType > 2) {
                Settings.proxyType = 0;
            }
            Settings.proxyHost = properties.getProperty("ProxyHost", "");
            Settings.proxyPort = properties.getProperty("ProxyPort", "");
            Settings.proxyUser = properties.getProperty("ProxyUsername", "");
            Settings.proxyPass = properties.getProperty("ProxyPassword", "");
            Settings.proxyDomain = properties.getProperty("ProxyDomain", "");
            Settings.showLogFrame = Boolean.parseBoolean(properties.getProperty("ShowLogFrame", "false"));
            Settings.showInfoFrame = Boolean.parseBoolean(properties.getProperty("ShowInfoFrame", "false"));
            Settings.showMemViewFrame = Boolean.parseBoolean(properties.getProperty("ShowMemViewFrame", "false"));
            Settings.fpsCounter = Boolean.parseBoolean(properties.getProperty("FPSCounter", "true"));
            Settings.awtAntiAliasing = Boolean.parseBoolean(properties.getProperty("AWTAntiAliasing", "false"));
            Settings.textAntiAliasing = Boolean.parseBoolean(properties.getProperty("TextAntiAliasing", "true"));
            Settings.canvasScale = (float)Integer.parseInt(properties.getProperty("CanvasScale", String.valueOf(1))) / 100.0f;
            if (Settings.canvasScale < 1.0f || Settings.canvasScale % 0.5f != 0.0f) {
                Settings.canvasScale = 1.0f;
            }
            Settings.resizeMode = ResizeMethod.fromInt(Integer.parseInt(properties.getProperty("ResizeMode", "2")));
            Settings.interpolation = Integer.parseInt(properties.getProperty("Interpolation", "0"));
            EmulatorScreen.locX = Integer.parseInt(properties.getProperty("LocationX", String.valueOf(Integer.MIN_VALUE)));
            EmulatorScreen.locY = Integer.parseInt(properties.getProperty("LocationY", String.valueOf(Integer.MIN_VALUE)));
            EmulatorScreen.sizeW = Integer.parseInt(properties.getProperty("SizeW", "-1"));
            EmulatorScreen.sizeH = Integer.parseInt(properties.getProperty("SizeH", "-1"));
            EmulatorScreen.maximized = Boolean.parseBoolean(properties.getProperty("Maximized", "false"));
            EmulatorScreen.fullscreen = Boolean.parseBoolean(properties.getProperty("FullscreenWindow", "false"));
            Settings.alwaysOnTop = Boolean.parseBoolean(properties.getProperty("AlwaysOnTop", "false"));
            Settings.m3gIgnoreOverwrite = Boolean.parseBoolean(properties.getProperty("M3GIgnoreOverwrite", "false"));
            Settings.m3gForcePerspectiveCorrection = Boolean.parseBoolean(properties.getProperty("M3GForcePerspectiveCorrection", "false"));
            Settings.m3gDisableLightClamp = Boolean.parseBoolean(properties.getProperty("M3GDisableLightClamp", "false"));
            Settings.m3gFlushImmediately = Boolean.parseBoolean(properties.getProperty("M3GFlushImmediately", "false"));
            Settings.m3gThread = Boolean.parseBoolean(properties.getProperty("M3GThread", "true"));
            Settings.m3gAA = Integer.parseInt(properties.getProperty("M3GAA", "0"));
            Settings.m3gTexFilter = Integer.parseInt(properties.getProperty("M3GTexFilter", "0"));
            Settings.m3gMipmapping = Integer.parseInt(properties.getProperty("M3GMipmapping", "0"));
            Settings.m3gContextMode = Integer.parseInt(properties.getProperty("M3GContextMode", "0"));
            Settings.mascotNo2DMixing = Boolean.parseBoolean(properties.getProperty("MascotNo2DMixing", "false"));
            Settings.mascotIgnoreBackground = Boolean.parseBoolean(properties.getProperty("MascotIgnoreBackground", "false"));
            Settings.mascotTextureFilter = Boolean.parseBoolean(properties.getProperty("MascotTextureFilter", "false"));
            Settings.mascotBackgroundFilter = Boolean.parseBoolean(properties.getProperty("MascotBackgroundFilter", "false"));
            Settings.vlcDir = properties.getProperty("VlcDir", "");
            Settings.searchVms = Boolean.parseBoolean(properties.getProperty("MIDISearchVMS", "true"));
            Settings.reopenMidiDevice = Boolean.parseBoolean(properties.getProperty("MIDIReopenDevice", "true"));
            Settings.oneMidiAtTime = Boolean.parseBoolean(properties.getProperty("MIDIGlobalSequencer", "false"));
            Settings.enableMediaDump = Boolean.parseBoolean(properties.getProperty("EnableMediaDump", "false"));
            Settings.ottDecoder = Integer.parseInt(properties.getProperty("OTTConverter", "2"));
            Settings.xmx = Integer.parseInt(properties.getProperty("JVMHeap", "512"));
            Settings.enableSecurity = Boolean.parseBoolean(properties.getProperty("SecurityEnabled", "true"));
            Settings.ideaPath = properties.getProperty("IdeaPath", null);
            Settings.proguardPath = properties.getProperty("ProguardPath", null);
            Settings.ideaJdkTablePatched = Boolean.parseBoolean(properties.getProperty("IdeaJdkTablePatched", "false"));
            Settings.lastIdeaRepoPath = properties.getProperty("LastIdeaProjectsRepo", "");
            fileInputStream.close();
        }
        catch (Exception ex) {
            if (!(ex instanceof FileNotFoundException)) {
                System.out.println("properties load failed");
                ex.printStackTrace();
            }
            this.device = "SonyEricssonK800";
            this.defaultFont = "Tahoma";
            this.rmsFolder = "/rms";
            this.screenWidth = "240";
            this.screenHeight = "320";
            this.lsoft = "-6";
            this.rsoft = "-7";
            this.fire = "-5";
            this.up = "-1";
            this.down = "-2";
            this.left = "-3";
            this.right = "-4";
            EmulatorScreen.locX = Integer.MIN_VALUE;
            EmulatorScreen.locY = Integer.MIN_VALUE;
            Settings.fileEncoding = "ISO-8859-1";
            Settings.autoGenJad = false;
            Settings.enableNewTrack = false;
            Settings.enableMethodTrack = false;
            this.fontSmallSize = 12;
            this.fontMediumSize = 14;
            this.fontLargeSize = 16;
            for (int j = 0; j < 5; ++j) {
                Settings.recentJars[j] = "";
            }
            Settings.proxyType = 0;
            Settings.proxyHost = "";
            Settings.proxyPort = "";
            Settings.proxyUser = "";
            Settings.proxyPass = "";
            Settings.proxyDomain = "";
            Settings.showLogFrame = false;
            Settings.showInfoFrame = false;
            Settings.showMemViewFrame = false;
            Settings.canvasScale = 1.0f;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveProperties() {
        try {
            void var4_11;
            FileOutputStream fileOutputStream = new FileOutputStream(Emulator.getUserPath() + "/property.txt");
            SortProperties properties = new SortProperties();
            properties.setProperty("DevicePreset", this.device);
            properties.setProperty("DefaultFont", this.defaultFont);
            properties.setProperty("RMSFolder", this.rmsFolder);
            properties.setProperty("FontSmallSize", String.valueOf(this.fontSmallSize));
            properties.setProperty("FontMediumSize", String.valueOf(this.fontMediumSize));
            properties.setProperty("FontLargeSize", String.valueOf(this.fontLargeSize));
            properties.setProperty("SCREEN_WIDTH", this.screenWidth);
            properties.setProperty("SCREEN_HEIGHT", this.screenHeight);
            properties.setProperty("KEY_LSOFT", this.lsoft);
            properties.setProperty("KEY_RSOFT", this.rsoft);
            properties.setProperty("KEY_FIRE", this.fire);
            properties.setProperty("KEY_UP", this.up);
            properties.setProperty("KEY_DOWN", this.down);
            properties.setProperty("KEY_LEFT", this.left);
            properties.setProperty("KEY_RIGHT", this.right);
            properties.setProperty("2D_Graphics_Engine", Settings.g2d == 0 ? "SWT" : "AWT");
            properties.setProperty("3D_Graphics_Engine", Settings.g3d == 0 ? "SWERVE" : "LWJ");
            properties.setProperty("Micro3D_Engine", Settings.micro3d == 0 ? "DLL" : "GL");
            properties.setProperty("FrameRate", String.valueOf(Settings.frameRate));
            properties.setProperty("AsyncFlush", String.valueOf(Settings.asyncFlush));
            properties.setProperty("MAP_KEY_NUM_0", KeyMapping.get(0));
            properties.setProperty("MAP_KEY_NUM_1", KeyMapping.get(1));
            properties.setProperty("MAP_KEY_NUM_2", KeyMapping.get(2));
            properties.setProperty("MAP_KEY_NUM_3", KeyMapping.get(3));
            properties.setProperty("MAP_KEY_NUM_4", KeyMapping.get(4));
            properties.setProperty("MAP_KEY_NUM_5", KeyMapping.get(5));
            properties.setProperty("MAP_KEY_NUM_6", KeyMapping.get(6));
            properties.setProperty("MAP_KEY_NUM_7", KeyMapping.get(7));
            properties.setProperty("MAP_KEY_NUM_8", KeyMapping.get(8));
            properties.setProperty("MAP_KEY_NUM_9", KeyMapping.get(9));
            properties.setProperty("MAP_KEY_STAR", KeyMapping.get(10));
            properties.setProperty("MAP_KEY_POUND", KeyMapping.get(11));
            properties.setProperty("MAP_KEY_UP", KeyMapping.get(12));
            properties.setProperty("MAP_KEY_DOWN", KeyMapping.get(13));
            properties.setProperty("MAP_KEY_LEFT", KeyMapping.get(14));
            properties.setProperty("MAP_KEY_RIGHT", KeyMapping.get(15));
            properties.setProperty("MAP_KEY_MIDDLE", KeyMapping.get(16));
            properties.setProperty("MAP_KEY_LSOFT", KeyMapping.get(17));
            properties.setProperty("MAP_KEY_RSOFT", KeyMapping.get(18));
            properties.setProperty("EnableKeyCache", String.valueOf(Settings.enableKeyCache));
            properties.setProperty("CanvasKeyboardMode", String.valueOf(Settings.canvasKeyboard));
            properties.setProperty("RecordKeys", String.valueOf(Settings.recordKeys));
            for (Map.Entry<String, String> entry : Settings.controllerBinds.entrySet()) {
                properties.setProperty("ControllerMap." + entry.getKey(), entry.getValue());
            }
            properties.setProperty("EnableVibration", String.valueOf(Settings.enableVibration));
            properties.setProperty("EnableKeyRepeat", String.valueOf(Settings.enableKeyRepeat));
            properties.setProperty("IgnoreFullScreenMode", String.valueOf(Settings.ignoreFullScreen));
            properties.setProperty("NetworkNotAvailable", String.valueOf(Settings.networkNotAvailable));
            properties.setProperty("SynchronizeKeyEvents", String.valueOf(Settings.synchronizeKeyEvents));
            properties.setProperty("MotorolaSoftKeyFix", String.valueOf(Settings.motorolaSoftKeyFix));
            properties.setProperty("PatchSynchronizedPlayerUpdater", String.valueOf(Settings.patchSynchronizedPlayerUpdate));
            properties.setProperty("PollKeyboardOnRepaint", String.valueOf(Settings.pollKeyboardOnRepaint));
            properties.setProperty("IgnoreRegionRepaint", String.valueOf(Settings.ignoreRegionRepaint));
            properties.setProperty("StartAppOnResume", String.valueOf(Settings.startAppOnResume));
            properties.setProperty("KeyPressOnRepeat", String.valueOf(Settings.keyPressOnRepeat));
            properties.setProperty("IgnoreServiceRepaints", String.valueOf(Settings.ignoreServiceRepaints));
            properties.setProperty("DontRepaintOnSetCurrent", String.valueOf(Settings.dontRepaintOnSetCurrent));
            properties.setProperty("HasPointerEvents", String.valueOf(Settings.hasPointerEvents));
            properties.setProperty("FPSLimitJLStyle", String.valueOf(Settings.j2lStyleFpsLimit));
            properties.setProperty("EventQueueSleep", String.valueOf(Settings.queueSleep));
            properties.setProperty("PatchYield", String.valueOf(Settings.patchYield));
            properties.setProperty("IgnoreGC", String.valueOf(Settings.ignoreGc));
            properties.setProperty("IgnoreThreadSleep", String.valueOf(Settings.ignoreSleep));
            StringBuilder builder = new StringBuilder();
            if (!Settings.protectedPackages.isEmpty()) {
                for (String s : Settings.protectedPackages) {
                    builder.append(s).append(';');
                }
                builder.setLength(builder.length() - 1);
            }
            properties.setProperty("ProtectedPackages", builder.toString());
            builder.setLength(0);
            if (!Settings.systemProperties.isEmpty()) {
                for (String k2 : Settings.systemProperties.keySet()) {
                    builder.append(k2).append(':').append(Settings.systemProperties.get(k2)).append('\n');
                }
                builder.setLength(builder.length() - 1);
            }
            properties.setProperty("SystemProperties", builder.toString());
            properties.setProperty("FileEncoding", Settings.fileEncoding);
            properties.setProperty("MIDPLocale", Settings.locale);
            properties.setProperty("RightClickMenu", String.valueOf(Settings.rightClickMenu));
            properties.setProperty("XRayOverLapScreen", String.valueOf(Settings.xrayOverlapScreen));
            properties.setProperty("XRayShowClipBorder", String.valueOf(Settings.xrayShowClipBorder));
            properties.setProperty("InfoColorHex", String.valueOf(Settings.infoColorHex));
            properties.setProperty("RecordReleasedImg", String.valueOf(Settings.recordReleasedImg));
            properties.setProperty("AutoGenJad", String.valueOf(Settings.autoGenJad));
            properties.setProperty("EnableNewTrack", String.valueOf(Settings.enableNewTrack));
            properties.setProperty("EnableMethodTrack", String.valueOf(Settings.enableMethodTrack));
            properties.setProperty("ShowMethodTrack", String.valueOf(Settings.threadMethodTrack));
            properties.setProperty("UpdateBranch", Settings.updateBranch);
            properties.setProperty("AutoUpdate", String.valueOf(Settings.autoUpdate));
            if (properties.getProperty("AltLessSpeedShortcuts") == null) {
                properties.setProperty("AltLessSpeedShortcuts", String.valueOf(Settings.altLessSpeedShortcuts));
            }
            properties.setProperty("BypassVserv", String.valueOf(Settings.bypassVserv));
            properties.setProperty("WavCache", String.valueOf(Settings.wavCache));
            properties.setProperty("DiscordRichPresence", String.valueOf(Settings.rpc));
            properties.setProperty("UILanguage", Settings.uiLanguage);
            properties.setProperty("WriteKemulatorCfg", String.valueOf(Settings.writeKemCfg));
            boolean bl = false;
            while (var4_11 < 5) {
                properties.setProperty("MRUList" + (int)var4_11, Settings.recentJars[var4_11]);
                ++var4_11;
            }
            properties.setProperty("ProxyType", String.valueOf(Settings.proxyType));
            properties.setProperty("ProxyHost", Settings.proxyHost);
            properties.setProperty("ProxyPort", Settings.proxyPort);
            properties.setProperty("ProxyUsername", Settings.proxyUser);
            properties.setProperty("ProxyPassword", Settings.proxyPass);
            properties.setProperty("ProxyDomain", Settings.proxyDomain);
            properties.setProperty("ShowLogFrame", String.valueOf(Settings.showLogFrame));
            properties.setProperty("ShowInfoFrame", String.valueOf(Settings.showInfoFrame));
            properties.setProperty("ShowMemViewFrame", String.valueOf(Settings.showMemViewFrame));
            properties.setProperty("FPSCounter", String.valueOf(Settings.fpsCounter));
            properties.setProperty("AWTAntiAliasing", String.valueOf(Settings.awtAntiAliasing));
            properties.setProperty("TextAntiAliasing", String.valueOf(Settings.textAntiAliasing));
            properties.setProperty("CanvasScale", String.valueOf(Math.round(Settings.canvasScale * 100.0f)));
            properties.setProperty("ResizeMode", Settings.resizeMode.toString());
            properties.setProperty("Interpolation", String.valueOf(Settings.interpolation));
            properties.setProperty("LocationX", String.valueOf(EmulatorScreen.locX));
            properties.setProperty("LocationY", String.valueOf(EmulatorScreen.locY));
            properties.setProperty("SizeW", String.valueOf(EmulatorScreen.sizeW));
            properties.setProperty("SizeH", String.valueOf(EmulatorScreen.sizeH));
            properties.setProperty("Maximized", String.valueOf(EmulatorScreen.maximized));
            properties.setProperty("FullscreenWindow", String.valueOf(EmulatorScreen.fullscreen));
            properties.setProperty("AlwaysOnTop", String.valueOf(Settings.alwaysOnTop));
            properties.setProperty("M3GIgnoreOverwrite", String.valueOf(Settings.m3gIgnoreOverwrite));
            properties.setProperty("M3GForcePerspectiveCorrection", String.valueOf(Settings.m3gForcePerspectiveCorrection));
            properties.setProperty("M3GDisableLightClamp", String.valueOf(Settings.m3gDisableLightClamp));
            properties.setProperty("M3GFlushImmediately", String.valueOf(Settings.m3gFlushImmediately));
            properties.setProperty("M3GThread", String.valueOf(Settings.m3gThread));
            properties.setProperty("M3GAA", String.valueOf(Settings.m3gAA));
            properties.setProperty("M3GTexFilter", String.valueOf(Settings.m3gTexFilter));
            properties.setProperty("M3GMipmapping", String.valueOf(Settings.m3gMipmapping));
            properties.setProperty("M3GContextMode", String.valueOf(Settings.m3gContextMode));
            properties.setProperty("MascotNo2DMixing", String.valueOf(Settings.mascotNo2DMixing));
            properties.setProperty("MascotIgnoreBackground", String.valueOf(Settings.mascotIgnoreBackground));
            properties.setProperty("MascotTextureFilter", String.valueOf(Settings.mascotTextureFilter));
            properties.setProperty("MascotBackgroundFilter", String.valueOf(Settings.mascotBackgroundFilter));
            properties.setProperty("VlcDir", Settings.vlcDir);
            properties.setProperty("MIDISearchVMS", String.valueOf(Settings.searchVms));
            properties.setProperty("MIDIReopenDevice", String.valueOf(Settings.reopenMidiDevice));
            properties.setProperty("MIDIGlobalSequencer", String.valueOf(Settings.oneMidiAtTime));
            properties.setProperty("EnableMediaDump", String.valueOf(Settings.enableMediaDump));
            properties.setProperty("OTTConverter", String.valueOf(Settings.ottDecoder));
            properties.setProperty("JVMHeap", String.valueOf(Settings.xmx));
            properties.setProperty("SecurityEnabled", String.valueOf(Settings.enableSecurity));
            for (String k2 : Permission.permissions.keySet()) {
                properties.setProperty("Security." + k2, Permission.getPermissionLevelString(k2));
            }
            if (Settings.ideaPath != null) {
                properties.setProperty("IdeaPath", Settings.ideaPath);
            }
            if (Settings.proguardPath != null) {
                properties.setProperty("ProguardPath", Settings.proguardPath);
            }
            properties.setProperty("IdeaJdkTablePatched", String.valueOf(Settings.ideaJdkTablePatched));
            properties.setProperty("LastIdeaProjectsRepo", Settings.lastIdeaRepoPath);
            properties.store(fileOutputStream, "KEmulator properties");
            fileOutputStream.close();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    private void apply() {
        String trim;
        this.device = trim = this.deviceCombo.getText().trim();
        Emulator.deviceName = trim;
        Devices.curPlatform = Devices.getPlatform(Emulator.deviceName);
        this.defaultFont = this.aCombo689.getText().trim();
        this.rmsFolder = this.aText662.getText().trim();
        Settings.fileEncoding = this.aCombo675.getText().trim();
        this.fontSmallSize = this.aSpinner690.getSelection();
        this.fontMediumSize = this.aSpinner679.getSelection();
        this.fontLargeSize = this.aSpinner670.getSelection();
        this.screenWidth = this.screenWidthText.getText().trim();
        this.screenHeight = this.screenHeightText.getText().trim();
        this.lsoft = this.aText695.getText().trim();
        this.rsoft = this.aText702.getText().trim();
        this.fire = this.aText708.getText().trim();
        this.up = this.aText713.getText().trim();
        this.down = this.aText718.getText().trim();
        this.left = this.aText723.getText().trim();
        this.right = this.aText727.getText().trim();
        KeyMapping.mapDeviceKey(17, KeyMapping.method601(aStringArray661[17]));
        KeyMapping.mapDeviceKey(18, KeyMapping.method601(aStringArray661[18]));
        KeyMapping.mapDeviceKey(14, KeyMapping.method601(aStringArray661[14]));
        KeyMapping.mapDeviceKey(15, KeyMapping.method601(aStringArray661[15]));
        KeyMapping.mapDeviceKey(12, KeyMapping.method601(aStringArray661[12]));
        KeyMapping.mapDeviceKey(13, KeyMapping.method601(aStringArray661[13]));
        KeyMapping.mapDeviceKey(16, KeyMapping.method601(aStringArray661[16]));
        KeyMapping.mapDeviceKey(10, KeyMapping.method601(aStringArray661[10]));
        KeyMapping.mapDeviceKey(11, KeyMapping.method601(aStringArray661[11]));
        KeyMapping.mapDeviceKey(1, KeyMapping.method601(aStringArray661[1]));
        KeyMapping.mapDeviceKey(2, KeyMapping.method601(aStringArray661[2]));
        KeyMapping.mapDeviceKey(3, KeyMapping.method601(aStringArray661[3]));
        KeyMapping.mapDeviceKey(4, KeyMapping.method601(aStringArray661[4]));
        KeyMapping.mapDeviceKey(5, KeyMapping.method601(aStringArray661[5]));
        KeyMapping.mapDeviceKey(6, KeyMapping.method601(aStringArray661[6]));
        KeyMapping.mapDeviceKey(7, KeyMapping.method601(aStringArray661[7]));
        KeyMapping.mapDeviceKey(8, KeyMapping.method601(aStringArray661[8]));
        KeyMapping.mapDeviceKey(9, KeyMapping.method601(aStringArray661[9]));
        KeyMapping.mapDeviceKey(0, KeyMapping.method601(aStringArray661[0]));
        Devices.setProperty("SCREEN_WIDTH", this.screenWidth);
        Devices.setProperty("SCREEN_HEIGHT", this.screenHeight);
        Devices.setProperty("KEY_S1", this.lsoft);
        Devices.setProperty("KEY_S2", this.rsoft);
        Devices.setProperty("KEY_FIRE", this.fire);
        Devices.setProperty("KEY_UP", this.up);
        Devices.setProperty("KEY_DOWN", this.down);
        Devices.setProperty("KEY_LEFT", this.left);
        Devices.setProperty("KEY_RIGHT", this.right);
        Devices.writeProperties();
        KeyMapping.init();
        if (Settings.enableKeyCache != this.aButton696.getSelection()) {
            KeyMapping.keyCacheStack.clear();
            Settings.enableKeyCache = this.aButton696.getSelection();
        }
        if (Settings.enableVibration != this.vibrationCheck.getSelection() && !(Settings.enableVibration = this.vibrationCheck.getSelection())) {
            Emulator.getEmulator().getScreen().stopVibra();
        }
        Settings.enableKeyRepeat = this.keyRepeatCheck.getSelection();
        Settings.ignoreFullScreen = this.canvasFullscreenCheck.getSelection();
        Settings.networkNotAvailable = this.noNetworkBtn.getSelection();
        Settings.synchronizeKeyEvents = this.synchronizeKeyEventsCheck.getSelection();
        Settings.motorolaSoftKeyFix = this.softkeyMotFixCheck.getSelection();
        Settings.xrayOverlapScreen = this.aButton746.getSelection();
        Settings.xrayShowClipBorder = this.aButton749.getSelection();
        Settings.infoColorHex = this.aButton752.getSelection();
        Settings.recordReleasedImg = this.aButton703.getSelection();
        Settings.autoGenJad = this.aButton709.getSelection();
        Settings.enableNewTrack = this.aButton714.getSelection();
        Settings.enableMethodTrack = this.aButton719.getSelection();
        Settings.proxyType = this.proxyTypeCombo.getSelectionIndex();
        Settings.proxyHost = this.aText635.getText().trim();
        Settings.proxyPort = this.aText637.getText().trim();
        Settings.proxyUser = this.aText639.getText().trim();
        Settings.proxyPass = this.aText641.getText();
        Settings.proxyDomain = this.aText643.getText().trim();
        Settings.rpc = this.rpcBtn.getSelection();
        Settings.awtAntiAliasing = this.antiAliasBtn.getSelection();
        Settings.textAntiAliasing = this.antiAliasTextBtn.getSelection();
        Settings.vlcDir = this.vlcDirText.getText().trim();
        Settings.locale = this.localeText.getText().trim();
        Settings.microeditionPlatform = this.platformText.getText().trim();
        Settings.uiLanguage = this.languageCombo.getText().trim();
        if (!this.languageCombo.getText().trim().equals(Settings.uiLanguage)) {
            UILocale.initLocale();
            Emulator.getEmulator().updateLanguage();
        }
        Settings.updateBranch = this.updateBranchCombo.getText().trim();
        Settings.m3gIgnoreOverwrite = this.m3gIgnoreOverwriteCheck.getSelection();
        Settings.m3gForcePerspectiveCorrection = this.m3gForcePersCorrect.getSelection();
        Settings.m3gDisableLightClamp = this.m3gDisableLightClamp.getSelection();
        Settings.m3gFlushImmediately = this.m3gFlushImmediately.getSelection();
        Settings.m3gThread = this.m3gThreadCheck.getSelection();
        Settings.m3gAA = this.m3gAACombo.getSelectionIndex();
        Settings.m3gTexFilter = this.m3gTexFilterCombo.getSelectionIndex();
        Settings.m3gMipmapping = this.m3gMipmapCombo.getSelectionIndex();
        Settings.mascotIgnoreBackground = this.mascotIgnoreBgCheck.getSelection();
        Settings.mascotTextureFilter = this.mascotTextureFilterCheck.getSelection();
        Settings.mascotBackgroundFilter = this.mascotBackgroundFilterCheck.getSelection();
        Settings.mascotNo2DMixing = this.mascotNo2DMixingCheck.getSelection();
        Settings.searchVms = this.vmsCheck.getSelection();
        Settings.oneMidiAtTime = this.globalMidiCheck.getSelection();
        Settings.fpsCounter = this.fpsCounterCheck.getSelection();
        Settings.keyPressOnRepeat = this.keyPressOnRepeatCheck.getSelection();
        Settings.hasPointerEvents = this.pointerEventsCheck.getSelection();
        Settings.j2lStyleFpsLimit = this.fpsLimitJlCheck.getSelection();
        Settings.asyncFlush = this.asyncFlushCheck.getSelection();
        String sysProps = this.propsText.getText();
        Settings.systemProperties.clear();
        if (!sysProps.isEmpty()) {
            String[] a2;
            for (String s : a2 = sysProps.split("\n")) {
                int i2;
                if ((s = s.trim()).isEmpty() || (i2 = s.indexOf(58)) == -1) continue;
                String k2 = s.substring(0, i2).trim();
                String v = s.substring(i2 + 1).trim();
                Settings.systemProperties.put(k2, v);
            }
        }
        Settings.enableMediaDump = this.mediaDumpCheck.getSelection();
        Settings.ottDecoder = this.ottCombo.getSelectionIndex();
        Settings.enableSecurity = this.securityCheck.getSelection();
        Settings.autoUpdate = this.autoUpdatesBtn.getSelection() ? 2 : 1;
        this.updateProxy();
    }

    private void method372(Shell shell) {
        this.setsShell = new Shell(shell, 67680);
        this.setsShell.setText(UILocale.get("OPTION_FRAME_TITLE", "Options & Properties"));
        this.setsShell.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/res/icon")));
        try {
            if (this.f == null) {
                FontData fd = this.setsShell.getFont().getFontData()[0];
                fd.height = fd.height / (float)(-fd.data.lfHeight) * 12.0f;
                this.f = new Font((Device)shell.getDisplay(), fd);
            }
            this.setsShell.setFont(this.f);
        }
        catch (Error fd) {
            // empty catch block
        }
        GridLayout layout = new GridLayout();
        new GridLayout().numColumns = 2;
        this.setsShell.setLayout((Layout)layout);
        this.method393();
        this.method390();
    }

    private void setupDeviceCombo() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.horizontalSpan = 3;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        layoutData.verticalSpan = 1;
        layoutData.verticalAlignment = 2;
        this.deviceCombo = new Combo(this.customComp, 12);
        this.deviceCombo.setLayoutData((Object)layoutData);
        Enumeration method620 = Devices.method620();
        while (method620.hasMoreElements()) {
            String text = (String)method620.nextElement();
            this.deviceCombo.add(text);
            if (!this.device.equalsIgnoreCase(text)) continue;
            this.deviceCombo.setText(text);
        }
        this.deviceCombo.addModifyListener((ModifyListener)new Class117(this));
    }

    private void genLanguageList() {
        File[] files;
        GridData compLayoutData = new GridData();
        compLayoutData.horizontalAlignment = 4;
        compLayoutData.verticalAlignment = 4;
        compLayoutData.grabExcessHorizontalSpace = true;
        GridLayout langLayout = new GridLayout();
        langLayout.numColumns = 2;
        langLayout.marginWidth = 0;
        langLayout.marginHeight = 0;
        Composite langComposite = new Composite((Composite)this.sysChecksGroup, 0);
        langComposite.setLayout((Layout)langLayout);
        langComposite.setLayoutData((Object)compLayoutData);
        GridData labelLayoutData = new GridData();
        labelLayoutData.horizontalAlignment = 4;
        labelLayoutData.verticalAlignment = 2;
        CLabel label = new CLabel(langComposite, 0);
        label.setText(UILocale.get("OPTION_SYSTEM_UI_LANGUAGE", "UI Language:"));
        label.setLayoutData((Object)labelLayoutData);
        GridData comboLayoutData = new GridData();
        comboLayoutData.horizontalAlignment = 4;
        comboLayoutData.grabExcessHorizontalSpace = true;
        this.languageCombo = new Combo(langComposite, 12);
        this.languageCombo.setLayoutData((Object)comboLayoutData);
        this.languageCombo.setFont(this.f);
        File folder = new File(Emulator.getAbsolutePath() + "/lang/");
        if (folder.exists() && folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".txt")) continue;
                String fileNameWithoutExtension = file.getName().substring(0, file.getName().length() - 4);
                this.languageCombo.add(fileNameWithoutExtension);
            }
        }
        this.languageCombo.setText(Settings.uiLanguage);
        GridData labelLayoutData2 = new GridData();
        labelLayoutData2.horizontalAlignment = 4;
        labelLayoutData2.verticalAlignment = 2;
        label = new CLabel(langComposite, 0);
        label.setText(UILocale.get("OPTION_SYSTEM_UPDATE_BRANCH", "Update branch:"));
        label.setLayoutData((Object)labelLayoutData2);
        GridData comboLayoutData2 = new GridData();
        comboLayoutData2.horizontalAlignment = 4;
        comboLayoutData2.grabExcessHorizontalSpace = true;
        this.updateBranchCombo = new Combo(langComposite, 12);
        this.updateBranchCombo.setLayoutData((Object)comboLayoutData2);
        this.updateBranchCombo.setFont(this.f);
        this.updateBranchCombo.add("stable");
        this.updateBranchCombo.add("dev");
        this.updateBranchCombo.setText(Settings.updateBranch);
    }

    private void setupEncodingField() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.verticalAlignment = 2;
        this.aCombo675 = new Combo(this.customComp, 8);
        this.aCombo675.setLayoutData((Object)layoutData);
        SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
        ArrayList<String> list2 = new ArrayList<String>(availableCharsets.keySet());
        Collections.sort(list2);
        String s = list2.get(0);
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            String e2 = list2.get(i2);
            if (!e2.equalsIgnoreCase("ISO-8859-1") && !e2.equalsIgnoreCase("UTF-8") && !e2.equalsIgnoreCase("Shift_JIS") && !e2.equalsIgnoreCase("EUC-KR")) continue;
            this.aCombo675.add(e2);
            if (!Settings.fileEncoding.equalsIgnoreCase(e2)) continue;
            s = e2;
        }
        Settings.fileEncoding = s;
        this.aCombo675.setText(s);
    }

    private void setupCustomProperties() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        GridData layoutData2 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData2.grabExcessHorizontalSpace = true;
        layoutData2.verticalAlignment = 2;
        GridData layoutData3 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData3.grabExcessHorizontalSpace = true;
        layoutData3.verticalAlignment = 2;
        GridData layoutData4 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData4.grabExcessHorizontalSpace = true;
        layoutData4.verticalAlignment = 2;
        GridData layoutData5 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData5.grabExcessHorizontalSpace = true;
        layoutData5.verticalAlignment = 2;
        GridData layoutData6 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData6.grabExcessHorizontalSpace = true;
        layoutData6.verticalAlignment = 2;
        GridData layoutData7 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData7.grabExcessHorizontalSpace = true;
        layoutData7.verticalAlignment = 2;
        GridData layoutData8 = new GridData();
        new GridData().horizontalAlignment = 1;
        layoutData8.verticalAlignment = 2;
        GridData layoutData9 = new GridData();
        new GridData().horizontalAlignment = 1;
        layoutData9.grabExcessHorizontalSpace = false;
        layoutData9.verticalAlignment = 2;
        GridData layoutData10 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData10.grabExcessHorizontalSpace = true;
        layoutData10.verticalAlignment = 2;
        GridData layoutData11 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData11.grabExcessHorizontalSpace = true;
        layoutData11.verticalAlignment = 2;
        GridLayout layout = new GridLayout();
        new GridLayout().numColumns = 4;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 5;
        GridData layoutData12 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData12.horizontalSpan = 4;
        layoutData12.grabExcessHorizontalSpace = true;
        layoutData12.grabExcessVerticalSpace = true;
        layoutData12.verticalAlignment = 4;
        Group aGroup660 = new Group(this.customComp, 0);
        aGroup660.setText(UILocale.get("OPTION_CUSTOM_PROPERTIES", "Custom Properties"));
        aGroup660.setLayout((Layout)layout);
        aGroup660.setLayoutData((Object)layoutData12);
        CLabel aCLabel694 = new CLabel((Composite)aGroup660, 0);
        aCLabel694.setText(UILocale.get("OPTION_CUSTOM_SCREEN_WIDTH", "Screen Width:"));
        aCLabel694.setLayoutData((Object)layoutData9);
        this.screenWidthText = new Text((Composite)aGroup660, 2048);
        this.screenWidthText.setLayoutData((Object)layoutData11);
        CLabel aCLabel701 = new CLabel((Composite)aGroup660, 0);
        aCLabel701.setText(UILocale.get("OPTION_CUSTOM_SCREEN_HEIGHT", "Screen Height:"));
        aCLabel701.setLayoutData((Object)layoutData8);
        this.screenHeightText = new Text((Composite)aGroup660, 2048);
        this.screenHeightText.setLayoutData((Object)layoutData10);
        CLabel aCLabel707 = new CLabel((Composite)aGroup660, 0);
        aCLabel707.setText(UILocale.get("OPTION_CUSTOM_KEY_LSK", "Left Soft Key:"));
        this.aText695 = new Text((Composite)aGroup660, 2048);
        this.aText695.setLayoutData((Object)layoutData7);
        CLabel aCLabel712 = new CLabel((Composite)aGroup660, 0);
        aCLabel712.setText(UILocale.get("OPTION_CUSTOM_KEY_RSK", "Right Soft Key:"));
        this.aText702 = new Text((Composite)aGroup660, 2048);
        this.aText702.setLayoutData((Object)layoutData6);
        CLabel aCLabel717 = new CLabel((Composite)aGroup660, 0);
        aCLabel717.setText(UILocale.get("OPTION_CUSTOM_KEY_MIDDLE", "Fire/Middle:"));
        this.aText708 = new Text((Composite)aGroup660, 2048);
        this.aText708.setLayoutData((Object)layoutData5);
        CLabel aCLabel722 = new CLabel((Composite)aGroup660, 0);
        aCLabel722 = new CLabel((Composite)aGroup660, 0);
        aCLabel722 = new CLabel((Composite)aGroup660, 0);
        aCLabel722.setText(UILocale.get("OPTION_CUSTOM_KEY_UP", "Up:"));
        this.aText713 = new Text((Composite)aGroup660, 2048);
        this.aText713.setLayoutData((Object)layoutData4);
        CLabel aCLabel726 = new CLabel((Composite)aGroup660, 0);
        aCLabel726.setText(UILocale.get("OPTION_CUSTOM_KEY_DOWN", "Down:"));
        this.aText718 = new Text((Composite)aGroup660, 2048);
        this.aText718.setLayoutData((Object)layoutData3);
        CLabel aCLabel730 = new CLabel((Composite)aGroup660, 0);
        aCLabel730.setText(UILocale.get("OPTION_CUSTOM_KEY_LEFT", "Left:"));
        this.aText723 = new Text((Composite)aGroup660, 2048);
        this.aText723.setLayoutData((Object)layoutData2);
        CLabel aCLabel734 = new CLabel((Composite)aGroup660, 0);
        aCLabel734.setText(UILocale.get("OPTION_CUSTOM_KEY_RIGHT", "Right:"));
        this.aText727 = new Text((Composite)aGroup660, 2048);
        this.aText727.setLayoutData((Object)layoutData);
        this.method387();
    }

    private void method387() {
        this.screenWidthText.setText(this.screenWidth);
        this.screenHeightText.setText(this.screenHeight);
        this.aText695.setText(this.lsoft);
        this.aText702.setText(this.rsoft);
        this.aText708.setText(this.fire);
        this.aText713.setText(this.up);
        this.aText718.setText(this.down);
        this.aText723.setText(this.left);
        this.aText727.setText(this.right);
    }

    private void method390() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.horizontalSpan = 2;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        int x = 80;
        Composite aComposite667 = new Composite((Composite)this.setsShell, 0);
        aComposite667.setLayoutData((Object)layoutData);
        Button aButton676 = new Button(aComposite667, 0x800008);
        aButton676.setBounds(new Rectangle(62 + x, 1, 68, 19));
        aButton676.setSelection(false);
        aButton676.setText(UILocale.get("DIALOG_OK", "OK"));
        aButton676.addSelectionListener((SelectionListener)new Class113(this));
        Button aButton685 = new Button(aComposite667, 0x800008);
        aButton685.setBounds(new Rectangle(197 + x, 0, 66, 21));
        aButton685.setText(UILocale.get("DIALOG_CANCEL", "Cancel"));
        aButton685.addSelectionListener((SelectionListener)new Class111(this));
    }

    private void method393() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.horizontalSpan = 2;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        this.tabFolder = new CTabFolder((Composite)this.setsShell, 0x800800);
        this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(22));
        this.tabFolder.setSimple(true);
        this.tabFolder.setFont(this.f);
        this.tabFolder.setMRUVisible(false);
        this.tabFolder.setUnselectedCloseVisible(false);
        this.tabFolder.setUnselectedImageVisible(false);
        this.tabFolder.setLayoutData((Object)layoutData);
        this.setupCustomComp();
        this.setupKeyMapComp();
        this.setupSystemComp();
        this.setupCoreApiComp();
        this.setupDisableApiComp();
        this.setupPropsComp();
        this.setupSysFontComp();
        this.setupRecordsComp();
        this.setupNetworkComp();
        this.setupMediaComp();
        this.setupM3GComp();
        this.setupMascotComp();
        this.setupSecurityComp();
        CTabItem deviceTab = new CTabItem(this.tabFolder, 0);
        deviceTab.setText(UILocale.get("OPTION_TAB_CUSTOM", "General"));
        deviceTab.setControl((Control)this.customComp);
        CTabItem keymapTab = new CTabItem(this.tabFolder, 0);
        keymapTab.setText(UILocale.get("OPTION_TAB_KEYMAP", "KeyMap"));
        keymapTab.setControl((Control)this.keyMapTabComp);
        CTabItem sysFontTab = new CTabItem(this.tabFolder, 0);
        sysFontTab.setText(UILocale.get("OPTION_TAB_FONT", "Font"));
        sysFontTab.setControl((Control)this.sysFontComp);
        CTabItem systemTab = new CTabItem(this.tabFolder, 0);
        systemTab.setText(UILocale.get("OPTION_TAB_SYSTEM", "System"));
        systemTab.setControl((Control)this.systemComp);
        CTabItem coreApiTab = new CTabItem(this.tabFolder, 0);
        coreApiTab.setText(UILocale.get("OPTION_TAB_COREAPI", "CoreAPI"));
        coreApiTab.setControl((Control)this.coreApiComp);
        CTabItem disableApiTab = new CTabItem(this.tabFolder, 0);
        disableApiTab.setText(UILocale.get("OPTION_TAB_DISABLE_API", "Disable APIs"));
        disableApiTab.setControl((Control)this.disableApiComp);
        CTabItem rmsTab = new CTabItem(this.tabFolder, 0);
        rmsTab.setText(UILocale.get("OPTION_TAB_RECORDS", "Records"));
        rmsTab.setControl((Control)this.recordsComp);
        CTabItem networkTab = new CTabItem(this.tabFolder, 0);
        networkTab.setText(UILocale.get("OPTION_TAB_NETWORK", "Network"));
        networkTab.setControl((Control)this.networkComp);
        CTabItem mediaTab = new CTabItem(this.tabFolder, 0);
        mediaTab.setText(UILocale.get("OPTION_TAB_MEDIA", "Media"));
        mediaTab.setControl((Control)this.mediaComp);
        CTabItem m3gTab = new CTabItem(this.tabFolder, 0);
        m3gTab.setText(UILocale.get("OPTION_TAB_M3G", "M3G"));
        m3gTab.setControl((Control)this.m3gComp);
        CTabItem mascotTab = new CTabItem(this.tabFolder, 0);
        mascotTab.setText(UILocale.get("OPTION_TAB_MASCOT", "MascotCapsule"));
        mascotTab.setControl((Control)this.mascotComp);
        CTabItem securityTab = new CTabItem(this.tabFolder, 0);
        securityTab.setText(UILocale.get("OPTION_TAB_SECURITY", "Security"));
        securityTab.setControl((Control)this.securityComp);
        CTabItem propsTab = new CTabItem(this.tabFolder, 0);
        propsTab.setText(UILocale.get("OPTION_TAB_SYSTEM_PROPERTIES", "Properties"));
        propsTab.setControl((Control)this.propsComp);
    }

    private void setupCustomComp() {
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.customComp = new Composite((Composite)this.tabFolder, 0);
        GridData layoutData2 = new GridData();
        layoutData2.horizontalAlignment = 4;
        layoutData2.horizontalSpan = 3;
        layoutData2.grabExcessHorizontalSpace = true;
        layoutData2.verticalAlignment = 2;
        GridData layoutData3 = new GridData();
        layoutData3.horizontalAlignment = 4;
        layoutData3.verticalAlignment = 2;
        GridData layoutData4 = new GridData();
        layoutData4.horizontalAlignment = 4;
        layoutData4.verticalAlignment = 2;
        GridData layoutData5 = new GridData();
        layoutData5.horizontalAlignment = 4;
        layoutData5.verticalAlignment = 2;
        GridData layoutData8 = new GridData();
        layoutData8.horizontalAlignment = 4;
        layoutData8.verticalAlignment = 2;
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 5;
        layout.makeColumnsEqualWidth = false;
        this.customComp.setLayout((Layout)layout);
        this.customComp.setFont(this.f);
        CLabel aCLabel658 = new CLabel(this.customComp, 0);
        aCLabel658.setText("Device preset:");
        aCLabel658.setLayoutData((Object)layoutData3);
        this.setupDeviceCombo();
        CLabel aCLabel673 = new CLabel(this.customComp, 0);
        aCLabel673.setText("Default encoding:");
        aCLabel673.setLayoutData((Object)layoutData4);
        this.setupEncodingField();
        CLabel labelLocale = new CLabel(this.customComp, 0);
        labelLocale.setText("MIDP Locale:");
        labelLocale.setLayoutData((Object)layoutData5);
        GridData layoutData6 = new GridData();
        layoutData6.horizontalAlignment = 4;
        layoutData6.grabExcessHorizontalSpace = true;
        layoutData6.verticalAlignment = 2;
        this.localeText = new Text(this.customComp, 2048);
        this.localeText.setLayoutData((Object)layoutData6);
        this.localeText.setText(Settings.locale);
        CLabel labelPlatform = new CLabel(this.customComp, 0);
        labelPlatform.setText("MIDP Platform:");
        labelPlatform.setLayoutData((Object)layoutData8);
        GridData layoutData7 = new GridData();
        layoutData7.horizontalAlignment = 4;
        layoutData7.horizontalSpan = 3;
        layoutData7.grabExcessHorizontalSpace = true;
        layoutData7.verticalAlignment = 2;
        this.platformText = new Text(this.customComp, 2048);
        this.platformText.setLayoutData((Object)layoutData7);
        this.platformText.setText(Settings.microeditionPlatform);
        this.setupCustomProperties();
        this.fpsLabel = new CLabel(this.customComp, 0);
        this.fpsLabel.setText(UILocale.get("OPTION_CUSTOM_MAX_FPS", "Max FPS:") + " " + (Settings.frameRate > 120 ? "\u221e" : String.valueOf(Settings.frameRate)));
        this.fpsLabel.setLayoutData((Object)layoutData);
        this.fpsScale = new Scale(this.customComp, 256);
        this.fpsScale.setIncrement(1);
        this.fpsScale.setMaximum(121);
        this.fpsScale.setPageIncrement(5);
        this.fpsScale.setSelection(Settings.frameRate);
        this.fpsScale.setMinimum(1);
        this.fpsScale.setLayoutData((Object)layoutData2);
        this.fpsScale.addSelectionListener((SelectionListener)new Class109(this));
    }

    private void setupKeyMapComp() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.verticalAlignment = 2;
        GridData layoutData2 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData2.verticalAlignment = 2;
        layoutData2.horizontalAlignment = 4;
        GridData layoutData3 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData3.verticalAlignment = 2;
        layoutData3.horizontalAlignment = 4;
        GridData layoutData4 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData4.verticalAlignment = 2;
        layoutData4.horizontalAlignment = 4;
        GridData layoutData5 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData5.verticalAlignment = 2;
        layoutData5.horizontalAlignment = 4;
        GridData layoutData6 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData6.verticalAlignment = 2;
        layoutData6.horizontalAlignment = 4;
        GridData layoutData7 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData7.verticalAlignment = 2;
        layoutData7.horizontalAlignment = 4;
        GridData layoutData8 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData8.verticalAlignment = 2;
        layoutData8.horizontalAlignment = 4;
        GridData layoutData9 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData9.verticalAlignment = 2;
        layoutData9.horizontalAlignment = 4;
        GridData layoutData10 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData10.verticalAlignment = 2;
        layoutData10.horizontalAlignment = 4;
        GridData layoutData11 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData11.verticalAlignment = 2;
        layoutData11.horizontalAlignment = 4;
        GridData layoutData12 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData12.verticalAlignment = 2;
        layoutData12.horizontalAlignment = 4;
        GridData layoutData13 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData13.verticalAlignment = 2;
        layoutData13.horizontalAlignment = 4;
        GridData layoutData14 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData14.verticalAlignment = 2;
        layoutData14.horizontalAlignment = 4;
        GridData layoutData15 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData15.verticalAlignment = 2;
        layoutData15.horizontalAlignment = 4;
        GridData layoutData16 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData16.verticalAlignment = 2;
        layoutData16.horizontalAlignment = 4;
        GridData layoutData17 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData17.verticalAlignment = 2;
        layoutData17.horizontalAlignment = 4;
        GridData layoutData18 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData18.verticalAlignment = 2;
        layoutData18.horizontalAlignment = 4;
        GridData layoutData19 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData19.verticalAlignment = 2;
        layoutData19.horizontalAlignment = 4;
        GridData layoutData20 = new GridData();
        new GridData().grabExcessHorizontalSpace = false;
        layoutData20.verticalAlignment = 2;
        layoutData20.horizontalAlignment = 4;
        GridData layoutData21 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData21.verticalAlignment = 2;
        layoutData21.widthHint = 30;
        GridData layoutData22 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData22.verticalAlignment = 2;
        GridData layoutData23 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData23.verticalAlignment = 2;
        GridData layoutData24 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData24.verticalAlignment = 2;
        GridData layoutData25 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData25.verticalAlignment = 2;
        layoutData25.widthHint = 30;
        GridData layoutData26 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData26.verticalAlignment = 2;
        GridData layoutData27 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData27.verticalAlignment = 2;
        GridData layoutData28 = new GridData();
        new GridData().horizontalSpan = 2;
        layoutData28.verticalAlignment = 2;
        layoutData28.horizontalAlignment = 4;
        GridData layoutData29 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData29.verticalAlignment = 2;
        GridData layoutData30 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData30.verticalAlignment = 2;
        GridData layoutData31 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData31.verticalAlignment = 2;
        GridData layoutData32 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData32.verticalAlignment = 2;
        GridData layoutData33 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData33.verticalAlignment = 2;
        GridData layoutData34 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData34.verticalAlignment = 2;
        GridData layoutData35 = new GridData();
        new GridData().horizontalAlignment = 4;
        GridData layoutData36 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData36.verticalAlignment = 2;
        GridData layoutData37 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData37.verticalAlignment = 2;
        GridData layoutData38 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData38.verticalAlignment = 2;
        GridData layoutData39 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData39.verticalAlignment = 2;
        GridData layoutData40 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData40.grabExcessHorizontalSpace = false;
        layoutData40.verticalAlignment = 2;
        this.keyMapTabComp = new Composite((Composite)this.tabFolder, 0);
        this.keyMapTabComp.setFont(this.f);
        GridLayout l = new GridLayout();
        l.marginWidth = 0;
        l.marginHeight = 0;
        this.keyMapTabComp.setLayout((Layout)l);
        this.keyMapControllerComp = new Composite(this.keyMapTabComp, 0);
        this.keyMapControllerComp.setLayoutData((Object)new GridData(768));
        l = new GridLayout();
        l.numColumns = 6;
        this.keyMapControllerComp.setLayout((Layout)l);
        Composite keyMapBindsComp = new Composite(this.keyMapTabComp, 0);
        keyMapBindsComp.setLayoutData((Object)new GridData(768));
        VerifyListener verify = new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                verifyEvent.doit = verifyEvent.start == 0 && verifyEvent.text != null;
            }
        };
        GridLayout layout = new GridLayout();
        new GridLayout().numColumns = 4;
        layout.horizontalSpacing = 45;
        keyMapBindsComp.setLayout((Layout)layout);
        CLabel aCLabel646 = new CLabel(this.keyMapControllerComp, 0);
        aCLabel646.setText(UILocale.get("OPTION_KEYMAP_CONTROLLER", "Controller:"));
        aCLabel646.setLayoutData((Object)layoutData);
        this.method400();
        CLabel aCLabel741 = new CLabel(keyMapBindsComp, 0);
        aCLabel741.setText(UILocale.get("OPTION_KEYMAP_LSK", "LeftSoftKey:"));
        aCLabel741.setLayoutData((Object)layoutData38);
        this.aText731 = new Text(keyMapBindsComp, 2048);
        this.aText731.setEditable(true);
        this.aText731.setLayoutData((Object)layoutData20);
        this.aText731.setText(KeyMapping.get(17));
        this.aText731.addKeyListener((KeyListener)new Class135(this.aText731, 17));
        this.aText731.addVerifyListener(verify);
        CLabel aCLabel744 = new CLabel(keyMapBindsComp, 0);
        aCLabel744.setText(UILocale.get("OPTION_KEYMAP_RSK", "RightSoftKey:"));
        aCLabel744.setLayoutData((Object)layoutData37);
        this.aText735 = new Text(keyMapBindsComp, 2048);
        this.aText735.setEditable(true);
        this.aText735.setLayoutData((Object)layoutData2);
        this.aText735.setText(KeyMapping.get(18));
        this.aText735.addKeyListener((KeyListener)new Class135(this.aText735, 18));
        this.aText735.addVerifyListener(verify);
        CLabel aCLabel762 = new CLabel(keyMapBindsComp, 0);
        aCLabel762.setText(UILocale.get("OPTION_KEYMAP_NUM_1", "Num_1:"));
        aCLabel762.setLayoutData((Object)layoutData40);
        this.aText754 = new Text(keyMapBindsComp, 2048);
        this.aText754.setEditable(true);
        this.aText754.setLayoutData((Object)layoutData16);
        this.aText754.setText(KeyMapping.get(1));
        this.aText754.addKeyListener((KeyListener)new Class135(this.aText754, 1));
        this.aText754.addVerifyListener(verify);
        CLabel aCLabel765 = new CLabel(keyMapBindsComp, 0);
        aCLabel765.setText(UILocale.get("OPTION_KEYMAP_NUM_2", "Num_2:"));
        aCLabel765.setLayoutData((Object)layoutData32);
        this.aText757 = new Text(keyMapBindsComp, 2048);
        this.aText757.setEditable(true);
        this.aText757.setLayoutData((Object)layoutData5);
        this.aText757.setText(KeyMapping.get(2));
        this.aText757.addKeyListener((KeyListener)new Class135(this.aText757, 2));
        this.aText757.addVerifyListener(verify);
        CLabel aCLabel767 = new CLabel(keyMapBindsComp, 0);
        aCLabel767.setText(UILocale.get("OPTION_KEYMAP_NUM_3", "Num_3:"));
        aCLabel767.setLayoutData((Object)layoutData31);
        this.aText760 = new Text(keyMapBindsComp, 2048);
        this.aText760.setEditable(true);
        this.aText760.setLayoutData((Object)layoutData15);
        this.aText760.setText(KeyMapping.get(3));
        this.aText760.addKeyListener((KeyListener)new Class135(this.aText760, 3));
        this.aText760.addVerifyListener(verify);
        CLabel aCLabel769 = new CLabel(keyMapBindsComp, 0);
        aCLabel769.setText(UILocale.get("OPTION_KEYMAP_NUM_4", "Num_4:"));
        aCLabel769.setLayoutData((Object)layoutData27);
        this.aText763 = new Text(keyMapBindsComp, 2048);
        this.aText763.setEditable(true);
        this.aText763.setLayoutData((Object)layoutData6);
        this.aText763.setText(KeyMapping.get(4));
        this.aText763.addKeyListener((KeyListener)new Class135(this.aText763, 4));
        this.aText763.addVerifyListener(verify);
        CLabel aCLabel771 = new CLabel(keyMapBindsComp, 0);
        aCLabel771.setText(UILocale.get("OPTION_KEYMAP_NUM_5", "Num_5:"));
        aCLabel771.setLayoutData((Object)layoutData25);
        this.aText766 = new Text(keyMapBindsComp, 2048);
        this.aText766.setEditable(true);
        this.aText766.setLayoutData((Object)layoutData14);
        this.aText766.setText(KeyMapping.get(5));
        this.aText766.addKeyListener((KeyListener)new Class135(this.aText766, 5));
        this.aText766.addVerifyListener(verify);
        CLabel aCLabel773 = new CLabel(keyMapBindsComp, 0);
        aCLabel773.setText(UILocale.get("OPTION_KEYMAP_NUM_6", "Num_6:"));
        aCLabel773.setLayoutData((Object)layoutData26);
        this.aText768 = new Text(keyMapBindsComp, 2048);
        this.aText768.setEditable(true);
        this.aText768.setLayoutData((Object)layoutData7);
        this.aText768.setText(KeyMapping.get(6));
        this.aText768.addKeyListener((KeyListener)new Class135(this.aText768, 6));
        this.aText768.addVerifyListener(verify);
        CLabel aCLabel626 = new CLabel(keyMapBindsComp, 0);
        aCLabel626.setText(UILocale.get("OPTION_KEYMAP_NUM_7", "Num_7:"));
        aCLabel626.setLayoutData((Object)layoutData24);
        this.aText770 = new Text(keyMapBindsComp, 2048);
        this.aText770.setEditable(true);
        this.aText770.setLayoutData((Object)layoutData13);
        this.aText770.setText(KeyMapping.get(7));
        this.aText770.addKeyListener((KeyListener)new Class135(this.aText770, 7));
        this.aText770.addVerifyListener(verify);
        CLabel aCLabel628 = new CLabel(keyMapBindsComp, 0);
        aCLabel628.setText(UILocale.get("OPTION_KEYMAP_NUM_8", "Num_8:"));
        aCLabel628.setLayoutData((Object)layoutData23);
        this.aText772 = new Text(keyMapBindsComp, 2048);
        this.aText772.setEditable(true);
        this.aText772.setLayoutData((Object)layoutData8);
        this.aText772.setText(KeyMapping.get(8));
        this.aText772.addKeyListener((KeyListener)new Class135(this.aText772, 8));
        this.aText772.addVerifyListener(verify);
        CLabel aCLabel630 = new CLabel(keyMapBindsComp, 0);
        aCLabel630.setText(UILocale.get("OPTION_KEYMAP_NUM_9", "Num_9:"));
        aCLabel630.setLayoutData((Object)layoutData21);
        this.aText774 = new Text(keyMapBindsComp, 2048);
        this.aText774.setEditable(true);
        this.aText774.setLayoutData((Object)layoutData12);
        this.aText774.setText(KeyMapping.get(9));
        this.aText774.addKeyListener((KeyListener)new Class135(this.aText774, 9));
        this.aText774.addVerifyListener(verify);
        CLabel aCLabel632 = new CLabel(keyMapBindsComp, 0);
        aCLabel632.setText(UILocale.get("OPTION_KEYMAP_NUM_0", "Num_0:"));
        aCLabel632.setLayoutData((Object)layoutData22);
        this.aText627 = new Text(keyMapBindsComp, 2048);
        this.aText627.setEditable(true);
        this.aText627.setLayoutData((Object)layoutData9);
        this.aText627.setText(KeyMapping.get(0));
        this.aText627.addKeyListener((KeyListener)new Class135(this.aText627, 0));
        this.aText627.addVerifyListener(verify);
        CLabel aCLabel634 = new CLabel(keyMapBindsComp, 0);
        aCLabel634.setText(UILocale.get("OPTION_KEYMAP_KEY_*", "Key *:"));
        aCLabel634.setLayoutData((Object)layoutData30);
        this.aText629 = new Text(keyMapBindsComp, 2048);
        this.aText629.setEditable(true);
        this.aText629.setLayoutData((Object)layoutData11);
        this.aText629.setText(KeyMapping.get(10));
        this.aText629.addKeyListener((KeyListener)new Class135(this.aText629, 10));
        this.aText629.addVerifyListener(verify);
        CLabel aCLabel636 = new CLabel(keyMapBindsComp, 0);
        aCLabel636.setText(UILocale.get("OPTION_KEYMAP_KEY_#", "Key #:"));
        aCLabel636.setLayoutData((Object)layoutData29);
        this.aText631 = new Text(keyMapBindsComp, 2048);
        this.aText631.setEditable(true);
        this.aText631.setLayoutData((Object)layoutData10);
        this.aText631.setText(KeyMapping.get(11));
        this.aText631.addKeyListener((KeyListener)new Class135(this.aText631, 11));
        this.aText631.addVerifyListener(verify);
        CLabel aCLabel747 = new CLabel(keyMapBindsComp, 0);
        aCLabel747.setText(UILocale.get("OPTION_KEYMAP_PAD_LEFT", "Pad_Left:"));
        aCLabel747.setLayoutData((Object)layoutData35);
        this.aText739 = new Text(keyMapBindsComp, 2048);
        this.aText739.setEditable(true);
        this.aText739.setLayoutData((Object)layoutData19);
        this.aText739.setText(KeyMapping.get(14));
        this.aText739.addKeyListener((KeyListener)new Class135(this.aText739, 14));
        this.aText739.addVerifyListener(verify);
        CLabel aCLabel750 = new CLabel(keyMapBindsComp, 0);
        aCLabel750.setText(UILocale.get("OPTION_KEYMAP_PAD_RIGHT", "Pad_Right:"));
        aCLabel750.setLayoutData((Object)layoutData36);
        this.aText742 = new Text(keyMapBindsComp, 2048);
        this.aText742.setEditable(true);
        this.aText742.setLayoutData((Object)layoutData3);
        this.aText742.setText(KeyMapping.get(15));
        this.aText742.addKeyListener((KeyListener)new Class135(this.aText742, 15));
        this.aText742.addVerifyListener(verify);
        CLabel aCLabel753 = new CLabel(keyMapBindsComp, 0);
        aCLabel753.setText(UILocale.get("OPTION_KEYMAP_PAD_UP", "Pad_Up:"));
        aCLabel753.setLayoutData((Object)layoutData34);
        this.aText745 = new Text(keyMapBindsComp, 2048);
        this.aText745.setEditable(true);
        this.aText745.setLayoutData((Object)layoutData18);
        this.aText745.setText(KeyMapping.get(12));
        this.aText745.addKeyListener((KeyListener)new Class135(this.aText745, 12));
        this.aText745.addVerifyListener(verify);
        CLabel aCLabel756 = new CLabel(keyMapBindsComp, 0);
        aCLabel756.setText(UILocale.get("OPTION_KEYMAP_PAD_DOWN", "Pad_Down:"));
        aCLabel756.setLayoutData((Object)layoutData33);
        this.aText748 = new Text(keyMapBindsComp, 2048);
        this.aText748.setEditable(true);
        this.aText748.setLayoutData((Object)layoutData4);
        this.aText748.setText(KeyMapping.get(13));
        this.aText748.addKeyListener((KeyListener)new Class135(this.aText748, 13));
        this.aText748.addVerifyListener(verify);
        CLabel aCLabel759 = new CLabel(keyMapBindsComp, 0);
        aCLabel759.setText(UILocale.get("OPTION_KEYMAP_PAD_MIDDLE", "Pad_Middle:"));
        aCLabel759.setLayoutData((Object)layoutData39);
        this.aText751 = new Text(keyMapBindsComp, 2048);
        this.aText751.setEditable(true);
        this.aText751.setLayoutData((Object)layoutData17);
        this.aText751.setText(KeyMapping.get(16));
        this.aText751.addKeyListener((KeyListener)new Class135(this.aText751, 16));
        this.aText751.addVerifyListener(verify);
        this.aButton696 = new Button(keyMapBindsComp, 32);
        this.aButton696.setText(UILocale.get("OPTION_KEYMAP_KEY_CACHE", "Enable Key Cache"));
        this.aButton696.setLayoutData((Object)layoutData28);
        this.aButton696.setSelection(Settings.enableKeyCache);
        this.method404();
    }

    private void method400() {
        GridData layoutData = new GridData();
        new GridData().horizontalSpan = 2;
        layoutData.verticalAlignment = 2;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.controllerCombo = new Combo(this.keyMapControllerComp, 8);
        this.controllerCombo.setLayoutData((Object)layoutData);
        this.controllerCombo.addModifyListener((ModifyListener)new Class185(this));
        GridData layoutData2 = new GridData();
        new GridData().horizontalAlignment = 2;
        layoutData2.verticalAlignment = 2;
        Button keymapRefreshBtn = new Button(this.keyMapControllerComp, 0x800008);
        keymapRefreshBtn.setText(UILocale.get("OPTION_KEYMAP_REFRESH", "Refresh"));
        keymapRefreshBtn.setLayoutData((Object)layoutData2);
        keymapRefreshBtn.addSelectionListener((SelectionListener)new Class184(this));
        Button keymapClearBtn = new Button(this.keyMapControllerComp, 0x800008);
        keymapClearBtn.setText(UILocale.get("OPTION_KEYMAP_CLEAR", "Clear"));
        GridData layoutData3 = new GridData();
        layoutData3.horizontalAlignment = 2;
        layoutData3.verticalAlignment = 2;
        keymapClearBtn.setLayoutData((Object)layoutData3);
        keymapClearBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                Property.this.aText627.setText("");
                Property.this.aText754.setText("");
                Property.this.aText757.setText("");
                Property.this.aText760.setText("");
                Property.this.aText763.setText("");
                Property.this.aText766.setText("");
                Property.this.aText768.setText("");
                Property.this.aText770.setText("");
                Property.this.aText772.setText("");
                Property.this.aText774.setText("");
                Property.this.aText629.setText("");
                Property.this.aText631.setText("");
                Property.this.aText739.setText("");
                Property.this.aText742.setText("");
                Property.this.aText745.setText("");
                Property.this.aText748.setText("");
                Property.this.aText751.setText("");
                Property.this.aText731.setText("");
                Property.this.aText735.setText("");
                if (Property.this.controllerCombo.getText().equals("Keyboard")) {
                    for (int i2 = 0; i2 < aStringArray661.length; ++i2) {
                        aStringArray661[i2] = "";
                        KeyMapping.mapDeviceKey(i2, "");
                    }
                } else {
                    for (int i3 = 0; i3 < 19; ++i3) {
                        Controllers.bind(Property.this.controllerCombo.getSelectionIndex() - 1, i3, "");
                    }
                }
            }
        });
        Button keymapResetBtn = new Button(this.keyMapControllerComp, 0x800008);
        keymapResetBtn.setText(UILocale.get("OPTION_KEYMAP_RESET", "Reset"));
        GridData layoutData4 = new GridData();
        layoutData4.horizontalAlignment = 2;
        layoutData4.verticalAlignment = 2;
        keymapResetBtn.setLayoutData((Object)layoutData4);
        keymapResetBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                if (Property.this.controllerCombo.getText().equals("Keyboard")) {
                    KeyMapping.mapDeviceKey(0, "48");
                    KeyMapping.mapDeviceKey(1, "55");
                    KeyMapping.mapDeviceKey(2, "56");
                    KeyMapping.mapDeviceKey(3, "57");
                    KeyMapping.mapDeviceKey(4, "52");
                    KeyMapping.mapDeviceKey(5, "53");
                    KeyMapping.mapDeviceKey(6, "54");
                    KeyMapping.mapDeviceKey(7, "49");
                    KeyMapping.mapDeviceKey(8, "50");
                    KeyMapping.mapDeviceKey(9, "51");
                    KeyMapping.mapDeviceKey(10, "42");
                    KeyMapping.mapDeviceKey(11, "47");
                    KeyMapping.mapDeviceKey(12, "1");
                    KeyMapping.mapDeviceKey(13, "2");
                    KeyMapping.mapDeviceKey(14, "3");
                    KeyMapping.mapDeviceKey(15, "4");
                    KeyMapping.mapDeviceKey(16, "13");
                    KeyMapping.mapDeviceKey(17, "10");
                    KeyMapping.mapDeviceKey(18, "11");
                    for (int i2 = 0; i2 < aStringArray661.length; ++i2) {
                        aStringArray661[i2] = KeyMapping.get(i2);
                    }
                } else {
                    int i3 = Property.this.controllerCombo.getSelectionIndex() - 1;
                    Controllers.bind(i3, 0, "0");
                    Controllers.bind(i3, 1, "1");
                    Controllers.bind(i3, 2, "2");
                    Controllers.bind(i3, 3, "3");
                    Controllers.bind(i3, 4, "4");
                    Controllers.bind(i3, 5, "5");
                    Controllers.bind(i3, 6, "6");
                    Controllers.bind(i3, 7, "7");
                    Controllers.bind(i3, 8, "8");
                    Controllers.bind(i3, 9, "12");
                    Controllers.bind(i3, 10, "13");
                    Controllers.bind(i3, 11, "14");
                    Controllers.bind(i3, 12, "UP");
                    Controllers.bind(i3, 13, "DOWN");
                    Controllers.bind(i3, 14, "LEFT");
                    Controllers.bind(i3, 15, "RIGHT");
                    Controllers.bind(i3, 16, "9");
                    Controllers.bind(i3, 17, "10");
                    Controllers.bind(i3, 18, "11");
                }
                Property.this.method406();
            }
        });
        this.method402();
    }

    private void method402() {
        this.controllerCombo.removeAll();
        this.controllerCombo.add("Keyboard");
        int method740 = Controllers.getControllersCount();
        for (int i2 = 0; i2 < method740; ++i2) {
            this.controllerCombo.add(Controllers.getController(i2).getName());
        }
        this.controllerCombo.setText("Keyboard");
    }

    private void method404() {
        Property.aStringArray661[0] = this.aText627.getText().trim();
        Property.aStringArray661[1] = this.aText754.getText().trim();
        Property.aStringArray661[2] = this.aText757.getText().trim();
        Property.aStringArray661[3] = this.aText760.getText().trim();
        Property.aStringArray661[4] = this.aText763.getText().trim();
        Property.aStringArray661[5] = this.aText766.getText().trim();
        Property.aStringArray661[6] = this.aText768.getText().trim();
        Property.aStringArray661[7] = this.aText770.getText().trim();
        Property.aStringArray661[8] = this.aText772.getText().trim();
        Property.aStringArray661[9] = this.aText774.getText().trim();
        Property.aStringArray661[10] = this.aText629.getText().trim();
        Property.aStringArray661[11] = this.aText631.getText().trim();
        Property.aStringArray661[14] = this.aText739.getText().trim();
        Property.aStringArray661[15] = this.aText742.getText().trim();
        Property.aStringArray661[12] = this.aText745.getText().trim();
        Property.aStringArray661[13] = this.aText748.getText().trim();
        Property.aStringArray661[16] = this.aText751.getText().trim();
        Property.aStringArray661[17] = this.aText731.getText().trim();
        Property.aStringArray661[18] = this.aText735.getText().trim();
    }

    private void method406() {
        String method744;
        Text text;
        int selectionIndex = this.controllerCombo.getSelectionIndex();
        if (selectionIndex < 0 || this.aText627 == null || this.aText627.isDisposed()) {
            return;
        }
        if (selectionIndex == 0) {
            this.aText627.setText(aStringArray661[0]);
            this.aText754.setText(aStringArray661[1]);
            this.aText757.setText(aStringArray661[2]);
            this.aText760.setText(aStringArray661[3]);
            this.aText763.setText(aStringArray661[4]);
            this.aText766.setText(aStringArray661[5]);
            this.aText768.setText(aStringArray661[6]);
            this.aText770.setText(aStringArray661[7]);
            this.aText772.setText(aStringArray661[8]);
            this.aText774.setText(aStringArray661[9]);
            this.aText629.setText(aStringArray661[10]);
            this.aText631.setText(aStringArray661[11]);
            this.aText739.setText(aStringArray661[14]);
            this.aText742.setText(aStringArray661[15]);
            this.aText745.setText(aStringArray661[12]);
            this.aText748.setText(aStringArray661[13]);
            this.aText751.setText(aStringArray661[16]);
            this.aText731.setText(aStringArray661[17]);
            text = this.aText735;
            method744 = aStringArray661[18];
        } else {
            int n = selectionIndex - 1;
            this.aText627.setText(Controllers.getBind(n, 0));
            this.aText754.setText(Controllers.getBind(n, 1));
            this.aText757.setText(Controllers.getBind(n, 2));
            this.aText760.setText(Controllers.getBind(n, 3));
            this.aText763.setText(Controllers.getBind(n, 4));
            this.aText766.setText(Controllers.getBind(n, 5));
            this.aText768.setText(Controllers.getBind(n, 6));
            this.aText770.setText(Controllers.getBind(n, 7));
            this.aText772.setText(Controllers.getBind(n, 8));
            this.aText774.setText(Controllers.getBind(n, 9));
            this.aText629.setText(Controllers.getBind(n, 10));
            this.aText631.setText(Controllers.getBind(n, 11));
            this.aText739.setText(Controllers.getBind(n, 14));
            this.aText742.setText(Controllers.getBind(n, 15));
            this.aText745.setText(Controllers.getBind(n, 12));
            this.aText748.setText(Controllers.getBind(n, 13));
            this.aText751.setText(Controllers.getBind(n, 16));
            this.aText731.setText(Controllers.getBind(n, 17));
            text = this.aText735;
            method744 = Controllers.getBind(n, 18);
        }
        text.setText(method744);
    }

    @Override
    public boolean updateController() {
        if (this.controllerCombo == null || this.controllerCombo.isDisposed()) {
            return false;
        }
        display.asyncExec((Runnable)new Class193(this));
        return true;
    }

    private void setupSystemComp() {
        this.systemComp = new Composite((Composite)this.tabFolder, 0);
        this.systemComp.setLayout((Layout)new GridLayout());
        this.initSystemComp();
    }

    private void setupCoreApiComp() {
        this.coreApiComp = new Composite((Composite)this.tabFolder, 0);
        this.coreApiComp.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData();
        new GridData().grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.horizontalAlignment = 4;
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.verticalAlignment = 4;
        Group coreApiGroup = new Group(this.coreApiComp, 0);
        coreApiGroup.setLayout((Layout)new GridLayout());
        coreApiGroup.setLayoutData((Object)layoutData);
        this.vibrationCheck = new Button((Composite)coreApiGroup, 32);
        this.vibrationCheck.setText(UILocale.get("OPTION_COREAPI_VIBRATION", "Enable Vibration APIs."));
        this.vibrationCheck.setLayoutData((Object)gridData);
        this.vibrationCheck.setSelection(Settings.enableVibration);
        this.vibrationCheck.setToolTipText("Shakes the window during vibration");
        this.keyRepeatCheck = new Button((Composite)coreApiGroup, 32);
        this.keyRepeatCheck.setText(UILocale.get("OPTION_COREAPI_KEY_REPEAT", "Enable Canvas.keyRepeated(int)."));
        this.keyRepeatCheck.setLayoutData((Object)gridData);
        this.keyRepeatCheck.setSelection(Settings.enableKeyRepeat);
        this.keyRepeatCheck.setToolTipText("Enables key repeats");
        this.canvasFullscreenCheck = new Button((Composite)coreApiGroup, 32);
        this.canvasFullscreenCheck.setText(UILocale.get("OPTION_COREAPI_FULLSCREEN", "Ignore Canvas.setFullScreenMode(boolean)."));
        this.canvasFullscreenCheck.setLayoutData((Object)gridData);
        this.canvasFullscreenCheck.setSelection(Settings.ignoreFullScreen);
        this.canvasFullscreenCheck.setToolTipText("Forces full screen mode");
        this.synchronizeKeyEventsCheck = new Button((Composite)coreApiGroup, 32);
        this.synchronizeKeyEventsCheck.setText(UILocale.get("OPTION_COREAPI_SYNC_KEYEVENTS", "Synchronize key events"));
        this.synchronizeKeyEventsCheck.setLayoutData((Object)gridData);
        this.synchronizeKeyEventsCheck.setSelection(Settings.synchronizeKeyEvents);
        this.synchronizeKeyEventsCheck.setToolTipText("Compatibility option");
        this.softkeyMotFixCheck = new Button((Composite)coreApiGroup, 32);
        this.softkeyMotFixCheck.setText(UILocale.get("OPTION_COREAPI_SOFTKEY_FIX", "Send keyPressed with commandAction"));
        this.softkeyMotFixCheck.setLayoutData((Object)gridData);
        this.softkeyMotFixCheck.setSelection(Settings.motorolaSoftKeyFix);
        this.softkeyMotFixCheck.setToolTipText("Compatibility tweak for certain Motorola Triplets games");
        this.keyPressOnRepeatCheck = new Button((Composite)coreApiGroup, 32);
        this.keyPressOnRepeatCheck.setText(UILocale.get("OPTION_COREAPI_KEYPRESS_ON_REPEAT", "Send keyPressed on repeats"));
        this.keyPressOnRepeatCheck.setLayoutData((Object)gridData);
        this.keyPressOnRepeatCheck.setSelection(Settings.keyPressOnRepeat);
        this.keyPressOnRepeatCheck.setToolTipText("Compatibility tweak for The Elder Scrolls: Oblivion");
        this.pointerEventsCheck = new Button((Composite)coreApiGroup, 32);
        this.pointerEventsCheck.setText(UILocale.get("OPTION_COREAPI_POINTER_EVENTS", "Canvas.hasPointerEvents() return value"));
        this.pointerEventsCheck.setLayoutData((Object)gridData);
        this.pointerEventsCheck.setSelection(Settings.hasPointerEvents);
        this.fpsLimitJlCheck = new Button((Composite)coreApiGroup, 32);
        this.fpsLimitJlCheck.setText(UILocale.get("OPTION_COREAPI_FPS_LIMIT_JL", "J2ME-Loader style FPS limit"));
        this.fpsLimitJlCheck.setLayoutData((Object)gridData);
        this.fpsLimitJlCheck.setSelection(Settings.j2lStyleFpsLimit);
        this.fpsLimitJlCheck.setToolTipText("Compatibility tweak for chinese version of Castlevania");
        this.asyncFlushCheck = new Button((Composite)coreApiGroup, 32);
        this.asyncFlushCheck.setText(UILocale.get("OPTION_COREAPI_ASYNC_FLUSH", "Async flush"));
        this.asyncFlushCheck.setLayoutData((Object)gridData);
        this.asyncFlushCheck.setSelection(Settings.asyncFlush);
        this.asyncFlushCheck.setToolTipText("If disabled, window refresh delay is passed to app. Restart after changing this property.");
    }

    private void setupDisableApiComp() {
        this.disableApiComp = new Composite((Composite)this.tabFolder, 0);
        this.disableApiComp.setLayout((Layout)new GridLayout());
        GridData d = new GridData();
        d.horizontalAlignment = 4;
        d.grabExcessHorizontalSpace = true;
        d.grabExcessVerticalSpace = true;
        d.verticalAlignment = 4;
        d.heightHint = 240;
        this.disableApiTable = new Table(this.disableApiComp, 2592);
        this.disableApiTable.setLayoutData((Object)d);
        for (String[] a2 : API_LIST) {
            TableItem i2 = new TableItem(this.disableApiTable, 0);
            i2.setText(0, a2[0]);
            i2.setChecked(Settings.protectedPackages.contains(a2[1]));
        }
        this.disableApiTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                int idx = Property.this.disableApiTable.indexOf(item);
                if (item.getChecked()) {
                    Settings.protectedPackages.add(API_LIST[idx][1]);
                } else {
                    Settings.protectedPackages.remove(API_LIST[idx][1]);
                }
            }
        });
    }

    private void setupPropsComp() {
        this.propsComp = new Composite((Composite)this.tabFolder, 0);
        this.propsComp.setLayout((Layout)new GridLayout());
        GridData d = new GridData();
        d.horizontalAlignment = 4;
        d.grabExcessHorizontalSpace = true;
        d.grabExcessVerticalSpace = true;
        d.verticalAlignment = 4;
        this.propsText = new Text(this.propsComp, 2050);
        this.propsText.setLayoutData((Object)d);
        this.propsText.setToolTipText("foo.bar: Example");
        StringBuilder s = new StringBuilder();
        for (String k2 : Settings.systemProperties.keySet()) {
            s.append(k2).append(": ").append(Settings.systemProperties.get(k2)).append('\n');
        }
        this.propsText.setText(s.toString());
    }

    private void setupMediaComp() {
        this.mediaComp = new Composite((Composite)this.tabFolder, 0);
        this.mediaComp.setLayout((Layout)new GridLayout());
        GridData fill = new GridData();
        fill.horizontalAlignment = 4;
        fill.grabExcessHorizontalSpace = true;
        fill.grabExcessVerticalSpace = true;
        fill.verticalAlignment = 4;
        GridData fillHor = new GridData();
        fillHor.horizontalAlignment = 4;
        fillHor.grabExcessHorizontalSpace = true;
        GridData fillHor2 = new GridData();
        fillHor2.horizontalAlignment = 4;
        fillHor2.grabExcessHorizontalSpace = true;
        Group mediaGroup = new Group(this.mediaComp, 0);
        mediaGroup.setText(UILocale.get("OPTION_TAB_MEDIA", "Media"));
        mediaGroup.setLayout((Layout)new GridLayout());
        mediaGroup.setLayoutData((Object)fill);
        new Label((Composite)mediaGroup, 32).setText(UILocale.get("OPTION_MEDIA_VLC_DIR", "VLC Path") + (System.getProperty("os.arch").contains("64") ? " (64-bit)" : " (32-bit)") + ":");
        this.vlcDirText = new Text((Composite)mediaGroup, 2048);
        this.vlcDirText.setEditable(true);
        this.vlcDirText.setEnabled(true);
        this.vlcDirText.setLayoutData((Object)fillHor2);
        this.vlcDirText.setText(Settings.vlcDir);
        this.vmsCheck = new Button((Composite)mediaGroup, 32);
        this.vmsCheck.setText(UILocale.get("OPTION_MEDIA_VMS", "Search for VirtualMIDISynth as MIDI device"));
        this.vmsCheck.setLayoutData((Object)fillHor);
        this.vmsCheck.setSelection(Settings.searchVms);
        this.globalMidiCheck = new Button((Composite)mediaGroup, 32);
        this.globalMidiCheck.setText(UILocale.get("OPTION_MEDIA_GLOBAL_MIDI", "Allow only one MIDI playback at time (reduces lag)"));
        this.globalMidiCheck.setLayoutData((Object)fillHor);
        this.globalMidiCheck.setSelection(Settings.oneMidiAtTime);
        this.mediaDumpCheck = new Button((Composite)mediaGroup, 32);
        this.mediaDumpCheck.setText(UILocale.get("OPTION_MEDIA_DUMP", "Enable media exporting (higher memory usage)"));
        this.mediaDumpCheck.setLayoutData((Object)fillHor);
        this.mediaDumpCheck.setSelection(Settings.enableMediaDump);
        this.setupOttChoice(mediaGroup);
    }

    private void setupOttChoice(Group mediaGroup) {
        GridData compLayoutData = new GridData();
        compLayoutData.horizontalAlignment = 4;
        compLayoutData.verticalAlignment = 4;
        compLayoutData.grabExcessHorizontalSpace = true;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        Composite comp = new Composite((Composite)mediaGroup, 0);
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)compLayoutData);
        GridData labelLayoutData = new GridData();
        labelLayoutData.horizontalAlignment = 4;
        labelLayoutData.verticalAlignment = 2;
        CLabel label = new CLabel(comp, 0);
        label.setText("Nokia Tone Decoder:");
        label.setLayoutData((Object)labelLayoutData);
        GridData comboLayoutData = new GridData();
        comboLayoutData.horizontalAlignment = 4;
        comboLayoutData.grabExcessHorizontalSpace = true;
        this.ottCombo = new Combo(comp, 12);
        this.ottCombo.setLayoutData((Object)comboLayoutData);
        this.ottCombo.setFont(this.f);
        String[] items = new String[]{"Disabled", "KEmulator", "FreeJ2ME-Plus"};
        this.ottCombo.setItems(items);
        this.ottCombo.setText(items[Settings.ottDecoder]);
    }

    private void setupM3GComp() {
        this.m3gComp = new Composite((Composite)this.tabFolder, 0);
        this.m3gComp.setLayout((Layout)new GridLayout());
        this.initM3GComp();
    }

    private void initM3GComp() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        GridData groupData = new GridData();
        groupData.horizontalAlignment = 4;
        groupData.grabExcessHorizontalSpace = true;
        groupData.grabExcessVerticalSpace = true;
        groupData.verticalAlignment = 1;
        Group lwjglGroup = new Group(this.m3gComp, 0);
        lwjglGroup.setText(UILocale.get("OPTION_M3G_LWJGL_SETTINGS", "LWJGL Settings"));
        lwjglGroup.setLayout((Layout)layout);
        lwjglGroup.setLayoutData((Object)groupData);
        GridData labelGridData = new GridData();
        labelGridData.horizontalAlignment = 4;
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.horizontalSpan = 2;
        this.m3gIgnoreOverwriteCheck = new Button((Composite)lwjglGroup, 32);
        this.m3gIgnoreOverwriteCheck.setText(UILocale.get("OPTION_M3G_IGNORE_OVERWRITE", "Ignore M3G overwrite hint"));
        this.m3gIgnoreOverwriteCheck.setLayoutData((Object)labelGridData);
        this.m3gIgnoreOverwriteCheck.setSelection(Settings.m3gIgnoreOverwrite);
        this.m3gForcePersCorrect = new Button((Composite)lwjglGroup, 32);
        this.m3gForcePersCorrect.setText(UILocale.get("OPTION_M3G_FORCE_PERSPECTIVE_CORRECTION", "Force perspective correction"));
        this.m3gForcePersCorrect.setLayoutData((Object)labelGridData);
        this.m3gForcePersCorrect.setSelection(Settings.m3gForcePerspectiveCorrection);
        this.m3gDisableLightClamp = new Button((Composite)lwjglGroup, 32);
        this.m3gDisableLightClamp.setText(UILocale.get("OPTION_M3G_DISABLE_LIGHT_CLAMPING", "Disable light clamping"));
        this.m3gDisableLightClamp.setLayoutData((Object)labelGridData);
        this.m3gDisableLightClamp.setSelection(Settings.m3gDisableLightClamp);
        this.m3gFlushImmediately = new Button((Composite)lwjglGroup, 32);
        this.m3gFlushImmediately.setText(UILocale.get("OPTION_M3G_FLUSH_IMMEDIATELY", "Flush contents immediately (slow!)"));
        this.m3gFlushImmediately.setLayoutData((Object)labelGridData);
        this.m3gFlushImmediately.setSelection(Settings.m3gFlushImmediately);
        this.m3gFlushImmediately.setToolTipText("Fixes background in Angry Birds Seasons");
        this.m3gThreadCheck = new Button((Composite)lwjglGroup, 32);
        this.m3gThreadCheck.setText(UILocale.get("OPTION_M3G_THREAD", "Single threaded M3G"));
        this.m3gThreadCheck.setLayoutData((Object)labelGridData);
        this.m3gThreadCheck.setSelection(Settings.m3gThread);
        this.m3gThreadCheck.setToolTipText("Fixes some games, but less performance. Restart after changing this property.");
        GridData dataFillLabel = new GridData();
        dataFillLabel.horizontalAlignment = 4;
        GridData dataFillLabel2 = new GridData();
        dataFillLabel2.horizontalAlignment = 4;
        GridData dataFillLabel3 = new GridData();
        dataFillLabel3.horizontalAlignment = 4;
        GridData listGridData = new GridData();
        listGridData.horizontalAlignment = 4;
        listGridData.grabExcessHorizontalSpace = true;
        CLabel tmpLabel = new CLabel((Composite)lwjglGroup, 0);
        tmpLabel.setText(UILocale.get("OPTION_M3G_AA", "Anti-aliasing:"));
        tmpLabel.setLayoutData((Object)dataFillLabel);
        this.m3gAACombo = new Combo((Composite)lwjglGroup, 12);
        this.m3gAACombo.setLayoutData((Object)listGridData);
        this.m3gAACombo.add(UILocale.get("OPTION_M3G_APP_CONTROLLED", "Application-controlled"));
        this.m3gAACombo.add(UILocale.get("OPTION_M3G_FORCE_OFF", "Force off"));
        this.m3gAACombo.add(UILocale.get("OPTION_M3G_FORCE_ON", "Force on"));
        this.m3gAACombo.setText(this.m3gAACombo.getItem(Settings.m3gAA));
        tmpLabel = new CLabel((Composite)lwjglGroup, 0);
        tmpLabel.setText(UILocale.get("OPTION_M3G_TEXTURE_FILTER", "Texture filter:"));
        tmpLabel.setLayoutData((Object)dataFillLabel2);
        this.m3gTexFilterCombo = new Combo((Composite)lwjglGroup, 12);
        this.m3gTexFilterCombo.setLayoutData((Object)listGridData);
        this.m3gTexFilterCombo.add(UILocale.get("OPTION_M3G_APP_CONTROLLED", "Application-controlled"));
        this.m3gTexFilterCombo.add(UILocale.get("OPTION_M3G_FORCE_NEAREST", "Force nearest"));
        this.m3gTexFilterCombo.add(UILocale.get("OPTION_M3G_FORCE_LINEAR", "Force linear"));
        this.m3gTexFilterCombo.setText(this.m3gTexFilterCombo.getItem(Settings.m3gTexFilter));
        tmpLabel = new CLabel((Composite)lwjglGroup, 0);
        tmpLabel.setText(UILocale.get("OPTION_M3G_MIPMAPPING", "Mipmapping:"));
        tmpLabel.setLayoutData((Object)dataFillLabel3);
        this.m3gMipmapCombo = new Combo((Composite)lwjglGroup, 12);
        this.m3gMipmapCombo.setLayoutData((Object)listGridData);
        this.m3gMipmapCombo.add(UILocale.get("OPTION_M3G_APP_CONTROLLED", "Application-controlled"));
        this.m3gMipmapCombo.add(UILocale.get("OPTION_M3G_FORCE_OFF", "Force off"));
        this.m3gMipmapCombo.add(UILocale.get("OPTION_M3G_FORCE_BILINEAR", "Force bilinear"));
        this.m3gMipmapCombo.add(UILocale.get("OPTION_M3G_FORCE_TRILINEAR", "Force trilinear"));
        this.m3gMipmapCombo.add(UILocale.get("OPTION_M3G_FORCE_ANISO_2X", "Force anisotropic 2x"));
        this.m3gMipmapCombo.add(UILocale.get("OPTION_M3G_FORCE_ANISO_4X", "Force anisotropic 4x"));
        this.m3gMipmapCombo.add(UILocale.get("OPTION_M3G_FORCE_ANISO_8X", "Force anisotropic 8x"));
        this.m3gMipmapCombo.add(UILocale.get("OPTION_M3G_FORCE_ANISO_16X", "Force anisotropic 16x"));
        this.m3gMipmapCombo.setText(this.m3gMipmapCombo.getItem(Settings.m3gMipmapping));
    }

    private void setupMascotComp() {
        this.mascotComp = new Composite((Composite)this.tabFolder, 0);
        this.mascotComp.setLayout((Layout)new GridLayout());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        GridData groupData = new GridData();
        groupData.horizontalAlignment = 4;
        groupData.grabExcessHorizontalSpace = true;
        groupData.grabExcessVerticalSpace = true;
        groupData.verticalAlignment = 1;
        Group lwjglGroup = new Group(this.mascotComp, 0);
        lwjglGroup.setText(UILocale.get("OPTION_M3G_LWJGL_SETTINGS", "LWJGL Settings"));
        lwjglGroup.setLayout((Layout)layout);
        lwjglGroup.setLayoutData((Object)groupData);
        GridData labelGridData = new GridData();
        labelGridData.horizontalAlignment = 4;
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.horizontalSpan = 2;
        this.mascotNo2DMixingCheck = new Button((Composite)lwjglGroup, 32);
        this.mascotNo2DMixingCheck.setText(UILocale.get("OPTION_MASCOT_NO_2D_MIXING", "No 2D mixing"));
        this.mascotNo2DMixingCheck.setLayoutData((Object)labelGridData);
        this.mascotNo2DMixingCheck.setSelection(Settings.mascotNo2DMixing);
        this.mascotIgnoreBgCheck = new Button((Composite)lwjglGroup, 32);
        this.mascotIgnoreBgCheck.setText(UILocale.get("OPTION_MASCOT_IGNORE_BACKGROUND", "Ignore background"));
        this.mascotIgnoreBgCheck.setLayoutData((Object)labelGridData);
        this.mascotIgnoreBgCheck.setSelection(Settings.mascotIgnoreBackground);
        this.mascotTextureFilterCheck = new Button((Composite)lwjglGroup, 32);
        this.mascotTextureFilterCheck.setText(UILocale.get("OPTION_MASCOT_TEXTURE_FILTER", "Texture filter"));
        this.mascotTextureFilterCheck.setLayoutData((Object)labelGridData);
        this.mascotTextureFilterCheck.setSelection(Settings.mascotTextureFilter);
        this.mascotBackgroundFilterCheck = new Button((Composite)lwjglGroup, 32);
        this.mascotBackgroundFilterCheck.setText(UILocale.get("OPTION_MASCOT_BACKGROUND_FILTER", "Background filter"));
        this.mascotBackgroundFilterCheck.setLayoutData((Object)labelGridData);
        this.mascotBackgroundFilterCheck.setSelection(Settings.mascotBackgroundFilter);
    }

    private void setupSecurityComp() {
        this.securityComp = new ScrolledComposite((Composite)this.tabFolder, 512);
        this.securityContent = new Composite((Composite)this.securityComp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        this.securityContent.setLayout((Layout)new GridLayout());
        GridData labelGridData = new GridData();
        labelGridData.horizontalAlignment = 4;
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.horizontalSpan = 2;
        GridData comboData = new GridData();
        comboData.horizontalAlignment = 4;
        comboData.grabExcessHorizontalSpace = true;
        GridData groupData = new GridData();
        groupData.horizontalAlignment = 4;
        groupData.grabExcessHorizontalSpace = true;
        groupData.grabExcessVerticalSpace = true;
        groupData.verticalAlignment = 1;
        this.securityCheck = new Button(this.securityContent, 32);
        this.securityCheck.setText(UILocale.get("OPTION_SECURITY_ENABLE", "Enable security"));
        this.securityCheck.setLayoutData((Object)labelGridData);
        this.securityCheck.setSelection(Settings.enableSecurity);
        Group permGroup = new Group(this.securityContent, 0);
        permGroup.setText(UILocale.get("OPTION_SECURITY_PERMISSIONS", "Permissions"));
        permGroup.setLayout((Layout)layout);
        permGroup.setLayoutData((Object)groupData);
        for (String[] s : PERMISSIONS) {
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            CLabel label = new CLabel((Composite)permGroup, 0);
            label.setText(s[0]);
            label.setLayoutData((Object)data);
            Combo combo = new Combo((Composite)permGroup, 12);
            combo.addSelectionListener((SelectionListener)this);
            combo.setData((Object)s[1]);
            combo.setItems(PERMISSIONS_VALUES[0]);
            String p = Permission.getPermissionLevelString(s[1]);
            for (int i2 = 0; i2 < PERMISSIONS_VALUES[1].length; ++i2) {
                if (!PERMISSIONS_VALUES[1][i2].equals(p)) continue;
                combo.setText(PERMISSIONS_VALUES[0][i2]);
                break;
            }
            combo.setLayoutData((Object)comboData);
        }
        this.securityComp.setContent((Control)this.securityContent);
        this.securityComp.setExpandHorizontal(true);
    }

    private void initSystemComp() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.verticalAlignment = 4;
        this.sysChecksGroup = new Group(this.systemComp, 0);
        this.sysChecksGroup.setLayout((Layout)new GridLayout());
        this.sysChecksGroup.setLayoutData((Object)layoutData);
        this.genLanguageList();
        this.autoUpdatesBtn = new Button((Composite)this.sysChecksGroup, 32);
        this.autoUpdatesBtn.setText(UILocale.get("OPTION_SYSTEM_AUTO_UPDATES", "Automatically check for updates"));
        this.autoUpdatesBtn.setSelection(Settings.autoUpdate == 2);
        this.aButton746 = new Button((Composite)this.sysChecksGroup, 32);
        this.aButton746.setText(UILocale.get("OPTION_SYSTEM_XRAY_BG", "X-Ray View: OverLap images."));
        this.aButton746.setSelection(Settings.xrayOverlapScreen);
        this.aButton749 = new Button((Composite)this.sysChecksGroup, 32);
        this.aButton749.setText(UILocale.get("OPTION_SYSTEM_XRAY_CLIP", "X-Ray View: Show image clipping region."));
        this.aButton749.setSelection(Settings.xrayShowClipBorder);
        this.aButton752 = new Button((Composite)this.sysChecksGroup, 32);
        this.aButton752.setText(UILocale.get("OPTION_SYSTEM_INFO_COLOR", "Info View: Show color in (R,G,B)."));
        this.aButton752.setSelection(Settings.infoColorHex);
        this.aButton703 = new Button((Composite)this.sysChecksGroup, 32);
        this.aButton703.setText(UILocale.get("OPTION_SYSTEM_RELEASED_IMG", "Memory View: Record released images."));
        this.aButton703.setSelection(Settings.recordReleasedImg);
        this.aButton709 = new Button((Composite)this.sysChecksGroup, 32);
        this.aButton709.setText(UILocale.get("OPTION_SYSTEM_AUTOGEN_JAD", "Auto Generate Jad file with \"KEmu-Platform\"."));
        this.aButton709.setSelection(Settings.autoGenJad);
        this.aButton714 = new Button((Composite)this.sysChecksGroup, 32);
        this.aButton714.setText(UILocale.get("OPTION_SYSTEM_TRACK_NEW", "Track \"new/new[]...\" operations."));
        this.aButton714.setSelection(Settings.enableNewTrack);
        this.aButton719 = new Button((Composite)this.sysChecksGroup, 32);
        this.aButton719.setText(UILocale.get("OPTION_SYSTEM_TRACK_METHOD", "Track method calls."));
        this.aButton719.setSelection(Settings.enableMethodTrack);
        this.rpcBtn = new Button((Composite)this.sysChecksGroup, 32);
        this.rpcBtn.setText(UILocale.get("OPTION_SYSTEM_DISCORD_RICHPRESENCE", "Discord Rich Presence"));
        this.rpcBtn.setSelection(Settings.rpc);
        this.antiAliasBtn = new Button((Composite)this.sysChecksGroup, 32);
        this.antiAliasBtn.setText(UILocale.get("OPTION_SYSTEM_AWT_ANTIALIASING", "AWT Smooth drawing"));
        this.antiAliasBtn.setSelection(Settings.awtAntiAliasing);
        this.fpsCounterCheck = new Button((Composite)this.sysChecksGroup, 32);
        this.fpsCounterCheck.setText(UILocale.get("OPTION_SYSTEM_FPS_COUNT", "FPS Counter"));
        this.fpsCounterCheck.setSelection(Settings.fpsCounter);
    }

    private void setupSysFontComp() {
        GridData layoutData = new GridData();
        new GridData().horizontalSpan = 2;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 2;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.grabExcessHorizontalSpace = true;
        GridData layoutData2 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData2.verticalAlignment = 2;
        GridData layoutData3 = new GridData();
        new GridData().horizontalAlignment = 1;
        layoutData3.verticalAlignment = 2;
        GridLayout layout = new GridLayout();
        new GridLayout().numColumns = 3;
        this.sysFontComp = new Composite((Composite)this.tabFolder, 0);
        this.sysFontComp.setLayout((Layout)layout);
        CLabel aCLabel638 = new CLabel(this.sysFontComp, 0);
        aCLabel638.setText(UILocale.get("OPTION_FONT_DEFAULT_FONT", "Default Font:"));
        aCLabel638.setLayoutData((Object)layoutData2);
        this.method418();
        CLabel aCLabel640 = new CLabel(this.sysFontComp, 0);
        aCLabel640.setText(UILocale.get("OPTION_FONT_LARGE_SIZE", "Large Size:"));
        aCLabel640.setLayoutData((Object)layoutData3);
        this.aSpinner670 = new Spinner(this.sysFontComp, 2048);
        this.aSpinner670.setMinimum(1);
        this.aSpinner670.setSelection(this.fontLargeSize);
        this.aSpinner670.addModifyListener((ModifyListener)new Class186(this));
        this.method420();
        CLabel aCLabel642 = new CLabel(this.sysFontComp, 0);
        aCLabel642.setText(UILocale.get("OPTION_FONT_MIDDLE_SIZE", "Medium Size:"));
        this.aSpinner679 = new Spinner(this.sysFontComp, 2048);
        this.aSpinner679.setMinimum(1);
        this.aSpinner679.setSelection(this.fontMediumSize);
        this.aSpinner679.addModifyListener((ModifyListener)new Class187(this));
        this.method422();
        CLabel aCLabel644 = new CLabel(this.sysFontComp, 0);
        aCLabel644.setText(UILocale.get("OPTION_FONT_SMALL_SIZE", "Small Size:"));
        this.aSpinner690 = new Spinner(this.sysFontComp, 2048);
        this.aSpinner690.setMinimum(1);
        this.aSpinner690.setSelection(this.fontSmallSize);
        this.aSpinner690.addModifyListener((ModifyListener)new Class188(this));
        this.method424();
        CLabel aCLabel645 = new CLabel(this.sysFontComp, 0);
        aCLabel645.setText(UILocale.get("OPTION_FONT_TEST_TEXT", "Test Text:"));
        this.aText633 = new Text(this.sysFontComp, 2048);
        this.aText633.setText(UILocale.get("OPTION_FONT_TEST_TEXT_TXT", "This is an Example."));
        this.aText633.setLayoutData((Object)layoutData);
        this.aText633.addModifyListener((ModifyListener)new Class192(this));
        GridData layoutData4 = new GridData();
        new GridData().horizontalSpan = 3;
        this.antiAliasTextBtn = new Button(this.sysFontComp, 32);
        this.antiAliasTextBtn.setText(UILocale.get("OPTION_SYSTEM_TEXT_ANTIALIASING", "Text Antialiasing"));
        this.antiAliasTextBtn.setSelection(Settings.textAntiAliasing);
        this.antiAliasTextBtn.setLayoutData((Object)layoutData4);
    }

    /*
     * WARNING - void declaration
     */
    private void method418() {
        void var7_11;
        FontData[] fontList2;
        GridData layoutData = new GridData();
        new GridData().horizontalSpan = 2;
        layoutData.verticalAlignment = 2;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.aCombo689 = new Combo(this.sysFontComp, 8);
        this.aCombo689.setLayoutData((Object)layoutData);
        this.aCombo689.addModifyListener((ModifyListener)new Class191(this));
        FontData[] fontList = display.getFontList(null, true);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("Nokia");
        list2.add("Series 60");
        for (FontData fontData : fontList) {
            if (list2.contains(fontData.getName()) || fontData.getName().startsWith("@")) continue;
            list2.add(fontData.getName());
        }
        FontData[] fontDataArray = fontList2 = display.getFontList(null, false);
        int n = fontDataArray.length;
        boolean bl = false;
        while (var7_11 < n) {
            FontData fontData = fontDataArray[var7_11];
            if (!list2.contains(fontData.getName()) && !fontData.getName().startsWith("@")) {
                list2.add(fontData.getName());
            }
            ++var7_11;
        }
        Collections.sort(list2);
        String aString682 = (String)list2.get(0);
        for (Comparable comparable : list2) {
            this.aCombo689.add((String)((Object)comparable));
            if (!this.defaultFont.equalsIgnoreCase((String)((Object)comparable))) continue;
            aString682 = (String)((Object)comparable);
        }
        this.defaultFont = aString682;
        this.aCombo689.setText(this.defaultFont);
    }

    private void method420() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        this.aCanvas663 = new Canvas(this.sysFontComp, 264192);
        this.aCanvas663.setLayoutData((Object)layoutData);
        this.aCanvas663.addPaintListener((PaintListener)new Class190(this));
    }

    private void method422() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        this.aCanvas680 = new Canvas(this.sysFontComp, 264192);
        this.aCanvas680.setLayoutData((Object)layoutData);
        this.aCanvas680.addPaintListener((PaintListener)new Class196(this));
    }

    private void method424() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        this.aCanvas691 = new Canvas(this.sysFontComp, 264192);
        this.aCanvas691.setLayoutData((Object)layoutData);
        this.aCanvas691.addPaintListener((PaintListener)new Class195(this));
    }

    private void method360(int n) {
        block18: {
            FontSWT font;
            block21: {
                IFont font4;
                block20: {
                    block19: {
                        block14: {
                            block17: {
                                IFont font3;
                                block16: {
                                    block15: {
                                        block10: {
                                            block13: {
                                                IFont font2;
                                                block12: {
                                                    block11: {
                                                        if (!this.setsShell.isVisible()) {
                                                            return;
                                                        }
                                                        font = null;
                                                        if ((n & 1) == 0) break block10;
                                                        if (Settings.g2d != 0) break block11;
                                                        font2 = new FontSWT(this.aCombo689.getText(), this.aSpinner670.getSelection(), 0);
                                                        break block12;
                                                    }
                                                    if (Settings.g2d != 1) break block13;
                                                    font2 = new FontAWT(this.aCombo689.getText(), this.aSpinner670.getSelection(), 0, false);
                                                }
                                                font = font2;
                                            }
                                            int x = this.aCanvas663.getSize().x;
                                            int y = this.aCanvas663.getSize().y;
                                            this.anIImage671 = Emulator.getEmulator().newImage(x, y, false, 0);
                                            IGraphics2D graphics = this.anIImage671.createGraphics();
                                            graphics.setColor(65280, false);
                                            graphics.setFont(font);
                                            graphics.drawString(this.aText633.getText(), 1, y >> 1);
                                            this.aCanvas663.redraw();
                                        }
                                        if ((n & 2) == 0) break block14;
                                        if (Settings.g2d != 0) break block15;
                                        font3 = new FontSWT(this.aCombo689.getText(), this.aSpinner679.getSelection(), 0);
                                        break block16;
                                    }
                                    if (Settings.g2d != 1) break block17;
                                    font3 = new FontAWT(this.aCombo689.getText(), this.aSpinner679.getSelection(), 0, false);
                                }
                                font = font3;
                            }
                            int x2 = this.aCanvas680.getSize().x;
                            int y2 = this.aCanvas680.getSize().y;
                            this.anIImage674 = Emulator.getEmulator().newImage(x2, y2, false, 0);
                            IGraphics2D graphics2 = this.anIImage674.createGraphics();
                            graphics2.setColor(65280, false);
                            graphics2.setFont(font);
                            graphics2.drawString(this.aText633.getText(), 1, y2 >> 1);
                            this.aCanvas680.redraw();
                        }
                        if ((n & 4) == 0) break block18;
                        if (Settings.g2d != 0) break block19;
                        font4 = new FontSWT(this.aCombo689.getText(), this.aSpinner690.getSelection(), 0);
                        break block20;
                    }
                    if (Settings.g2d != 1) break block21;
                    font4 = new FontAWT(this.aCombo689.getText(), this.aSpinner690.getSelection(), 0, false);
                }
                font = font4;
            }
            int x3 = this.aCanvas691.getSize().x;
            int y3 = this.aCanvas691.getSize().y;
            this.anIImage693 = Emulator.getEmulator().newImage(x3, y3, false, 0);
            IGraphics2D graphics3 = this.anIImage693.createGraphics();
            graphics3.setColor(65280, false);
            graphics3.setFont(font);
            graphics3.drawString(this.aText633.getText(), 1, y3 >> 1);
            this.aCanvas691.redraw();
        }
    }

    private void setupRecordsComp() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 2;
        layoutData.verticalAlignment = 2;
        GridData layoutData2 = new GridData();
        new GridData().horizontalSpan = 3;
        layoutData2.verticalAlignment = 2;
        layoutData2.horizontalAlignment = 4;
        GridData layoutData3 = new GridData();
        new GridData().horizontalSpan = 3;
        layoutData3.verticalAlignment = 4;
        layoutData3.grabExcessHorizontalSpace = true;
        layoutData3.grabExcessVerticalSpace = true;
        layoutData3.heightHint = 160;
        layoutData3.horizontalAlignment = 4;
        GridData layoutData4 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData4.grabExcessHorizontalSpace = true;
        layoutData4.verticalAlignment = 2;
        GridData layoutData5 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData5.verticalAlignment = 2;
        GridLayout layout = new GridLayout();
        new GridLayout().numColumns = 3;
        this.recordsComp = new Composite((Composite)this.tabFolder, 0);
        this.recordsComp.setLayout((Layout)layout);
        CLabel aCLabel683 = new CLabel(this.recordsComp, 0);
        aCLabel683.setText(UILocale.get("OPTION_RECORDS_RMS_FOLDER", "RMS Folder:"));
        aCLabel683.setLayoutData((Object)layoutData5);
        this.aText662 = new Text(this.recordsComp, 2048);
        this.aText662.setEditable(true);
        this.aText662.setEnabled(true);
        this.aText662.setLayoutData((Object)layoutData4);
        this.aText662.setText(this.rmsFolder);
        Button aButton666 = new Button(this.recordsComp, 0x800008);
        aButton666.setText("...");
        aButton666.addSelectionListener((SelectionListener)new Class101(this));
        if (Emulator.midletClassName != null) {
            CLabel aCLabel647 = new CLabel(this.recordsComp, 0);
            aCLabel647.setText(UILocale.get("OPTION_RECORDS_RMS_TEXT", "All Records in current midlet:"));
            aCLabel647.setLayoutData((Object)layoutData2);
            this.aTable665 = new Table(this.recordsComp, 2080);
            this.aTable665.setHeaderVisible(false);
            this.aTable665.setLayoutData((Object)layoutData3);
            this.aTable665.setLinesVisible(true);
            Button aButton761 = new Button(this.recordsComp, 0x800000);
            aButton761.setText(UILocale.get("OPTION_RECORDS_SELECT_ALL", "Select All"));
            aButton761.addSelectionListener((SelectionListener)new Class194(this));
            Button clearRecordsBtn = new Button(this.recordsComp, 0x800000);
            clearRecordsBtn.setText(UILocale.get("OPTION_RECORDS_CLEAR_RECORD", "Clear Selected Records"));
            clearRecordsBtn.setLayoutData((Object)layoutData);
            clearRecordsBtn.addSelectionListener((SelectionListener)new Class103(this));
            new TableColumn(this.aTable665, 0).setWidth(200);
            this.method428();
        } else {
            this.rmsTree = new Tree(this.recordsComp, 2818);
            this.rmsTree.setLayoutData((Object)layoutData3);
            final String rootPath = this.getRmsFolderPath();
            this.rmsTree.addTreeListener(new TreeListener(){

                public void treeCollapsed(TreeEvent treeEvent) {
                }

                public void treeExpanded(TreeEvent e2) {
                    try {
                        TreeItem[] items;
                        TreeItem root = (TreeItem)e2.item;
                        for (TreeItem item : items = root.getItems()) {
                            if (item.getData() != null) {
                                return;
                            }
                            item.dispose();
                        }
                        String d = (String)root.getData();
                        if (d == null || d.startsWith("r")) {
                            return;
                        }
                        d = d.substring(1);
                        String[] list2 = new File(rootPath + d).list();
                        if (list2 != null) {
                            for (String s : list2) {
                                String l = Property.this.decodeBase64(s);
                                if (l == null) continue;
                                TreeItem t = new TreeItem(root, 0);
                                t.setData((Object)("r" + d + "/" + s));
                                t.setChecked(root.getChecked());
                                t.setText(l);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            String[] list2 = new File(rootPath).list();
            if (list2 != null) {
                for (String s : list2) {
                    String l = this.decodeBase64(s);
                    if (l == null) continue;
                    TreeItem t = new TreeItem(this.rmsTree, 0);
                    t.setData((Object)("m" + s));
                    t.setText(l);
                    new TreeItem(t, 0);
                }
            }
            Button clearRecordsBtn = new Button(this.recordsComp, 0x800000);
            clearRecordsBtn.setText(UILocale.get("OPTION_RECORDS_CLEAR_RECORD", "Clear Selected Records"));
            clearRecordsBtn.setLayoutData((Object)layoutData);
            clearRecordsBtn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TreeItem[] items = Property.this.rmsTree.getSelection();
                    if (items == null) {
                        return;
                    }
                    for (TreeItem item : items) {
                        String d = (String)item.getData();
                        if (d == null || d.startsWith("m")) continue;
                        item.dispose();
                        try {
                            File file = new File(rootPath + d.substring(1));
                            for (File value : file.listFiles()) {
                                value.delete();
                            }
                            file.delete();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
        }
    }

    private String decodeBase64(String name) {
        try {
            return new String(Base64.getDecoder().decode(name.replace('-', '/').getBytes("UTF-8")), "UTF-8");
        }
        catch (Exception e2) {
            return null;
        }
    }

    private String method374() {
        String s;
        block6: {
            String substring;
            StringBuffer sb;
            block5: {
                block4: {
                    s = null;
                    s = this.aText662.getText().trim();
                    if (!s.startsWith(".")) break block4;
                    sb = new StringBuffer().append(Emulator.getUserPath());
                    substring = s.substring(1);
                    break block5;
                }
                if (!s.startsWith("/") && !s.startsWith("\\")) break block6;
                sb = new StringBuffer().append(Emulator.getUserPath());
                substring = s;
            }
            s = sb.append(substring).toString();
        }
        File file = new File(s);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        return s + "/";
    }

    private void method428() {
        if (this.rmsTree != null) {
            this.rmsTree.removeAll();
            String rootPath = this.method374();
            String[] list2 = new File(rootPath).list();
            if (list2 != null) {
                for (String s : list2) {
                    String l = this.decodeBase64(s);
                    if (l == null) continue;
                    TreeItem t = new TreeItem(this.rmsTree, 0);
                    t.setData((Object)("m" + s));
                    t.setText(l);
                    new TreeItem(t, 0);
                }
            }
            return;
        }
        this.aTable665.removeAll();
        String[] rms = RecordStore.listRecordStores();
        if (rms == null) {
            return;
        }
        for (String s : rms) {
            TableItem ti = new TableItem(this.aTable665, 0);
            ti.setText(0, s);
            ti.setChecked(false);
        }
    }

    private void setupNetworkComp() {
        this.networkComp = new Composite((Composite)this.tabFolder, 0);
        this.networkComp.setLayout((Layout)new GridLayout());
        this.setupNetworkTabContent();
    }

    private void setupNetworkTabContent() {
        GridData layoutData = new GridData();
        new GridData().horizontalSpan = 2;
        layoutData.verticalAlignment = 2;
        layoutData.horizontalAlignment = 2;
        GridData layoutData2 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData2.grabExcessHorizontalSpace = true;
        layoutData2.verticalAlignment = 2;
        GridData layoutData3 = new GridData();
        new GridData().horizontalAlignment = 3;
        layoutData3.verticalAlignment = 2;
        GridData layoutData4 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData4.grabExcessHorizontalSpace = true;
        layoutData4.verticalAlignment = 2;
        GridData layoutData5 = new GridData();
        new GridData().horizontalAlignment = 3;
        layoutData5.verticalAlignment = 2;
        GridData layoutData6 = new GridData();
        new GridData().horizontalAlignment = 3;
        layoutData6.verticalAlignment = 2;
        GridData gridData = new GridData();
        new GridData().horizontalAlignment = 4;
        gridData.widthHint = 40;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        GridData layoutData7 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData7.widthHint = 50;
        layoutData7.grabExcessHorizontalSpace = true;
        layoutData7.verticalAlignment = 2;
        GridLayout layout = new GridLayout();
        new GridLayout().numColumns = 4;
        GridData layoutData8 = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData8.grabExcessHorizontalSpace = true;
        layoutData8.verticalAlignment = 1;
        this.networkProxyGroup = new Group(this.networkComp, 0);
        this.networkProxyGroup.setText(UILocale.get("OPTION_NETWORK_PROXY", "Proxy"));
        this.networkProxyGroup.setLayout((Layout)layout);
        this.networkProxyGroup.setLayoutData((Object)layoutData8);
        CLabel aCLabel648 = new CLabel((Composite)this.networkProxyGroup, 0);
        aCLabel648.setText(UILocale.get("OPTION_NETWORK_PROXY_TYPE", "ProxyType:"));
        this.setupProxyCombo();
        CLabel aCLabel651 = new CLabel((Composite)this.networkProxyGroup, 0);
        aCLabel651.setText("");
        CLabel aCLabel649 = new CLabel((Composite)this.networkProxyGroup, 0);
        aCLabel649.setText(UILocale.get("OPTION_NETWORK_HOST", "Host:"));
        aCLabel649.setLayoutData((Object)layoutData6);
        this.aText635 = new Text((Composite)this.networkProxyGroup, 2048);
        this.aText635.setLayoutData((Object)layoutData7);
        this.aText635.setText(Settings.proxyHost);
        CLabel aCLabel650 = new CLabel((Composite)this.networkProxyGroup, 0);
        aCLabel650.setText(UILocale.get("OPTION_NETWORK_PORT", "Port:"));
        this.aText637 = new Text((Composite)this.networkProxyGroup, 2048);
        this.aText637.setText(Settings.proxyPort);
        this.aText637.setLayoutData((Object)gridData);
        CLabel aCLabel652 = new CLabel((Composite)this.networkProxyGroup, 0);
        aCLabel652.setText(UILocale.get("OPTION_NETWORK_USERNAME", "Username:"));
        aCLabel652.setLayoutData((Object)layoutData5);
        this.aText639 = new Text((Composite)this.networkProxyGroup, 2048);
        this.aText639.setLayoutData((Object)layoutData4);
        this.aText639.setText(Settings.proxyUser);
        CLabel aCLabel653 = new CLabel((Composite)this.networkProxyGroup, 0);
        aCLabel653.setText(UILocale.get("OPTION_NETWORK_PASSWORD", "Password:"));
        this.aText641 = new Text((Composite)this.networkProxyGroup, 0x400800);
        this.aText641.setText(Settings.proxyPass);
        this.aText641.setLayoutData((Object)gridData);
        CLabel aCLabel654 = new CLabel((Composite)this.networkProxyGroup, 0);
        aCLabel654.setText(UILocale.get("OPTION_NETWORK_DOMAIN", "Domain:"));
        aCLabel654.setLayoutData((Object)layoutData3);
        this.aText643 = new Text((Composite)this.networkProxyGroup, 2048);
        this.aText643.setLayoutData((Object)layoutData2);
        this.aText643.setText(Settings.proxyDomain);
        this.aButton764 = new Button((Composite)this.networkProxyGroup, 0x800000);
        this.aButton764.setText(UILocale.get("OPTION_NETWORK_CONNECT", "Connect"));
        this.aButton764.setLayoutData((Object)layoutData);
        this.aButton764.addSelectionListener((SelectionListener)new Class97(this));
        this.proxyTypeCombo.addModifyListener((ModifyListener)new Class65(this));
        this.proxyTypeCombo.select(Settings.proxyType);
        GridData gridData2 = new GridData();
        new GridData().horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 1;
        this.noNetworkBtn = new Button(this.networkComp, 32);
        this.noNetworkBtn.setText(UILocale.get("OPTION_COREAPI_NO_NETWORK", "Restrict network connections"));
        this.noNetworkBtn.setLayoutData((Object)gridData2);
        this.noNetworkBtn.setSelection(Settings.networkNotAvailable);
    }

    private void setupProxyCombo() {
        GridData layoutData = new GridData();
        new GridData().horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalSpan = 2;
        layoutData.verticalAlignment = 2;
        this.proxyTypeCombo = new Combo((Composite)this.networkProxyGroup, 8);
        this.proxyTypeCombo.setLayoutData((Object)layoutData);
        this.proxyTypeCombo.add("None Proxy");
        this.proxyTypeCombo.add("HTTP Proxy");
        this.proxyTypeCombo.add("Socks5 Proxy");
    }

    private static void removeProxyProperties() {
        System.getProperties().remove("http.proxyHost");
        System.getProperties().remove("http.proxyPort");
        System.getProperties().remove("http.auth.ntlm.domain");
        System.getProperties().remove("socksProxyHost");
        System.getProperties().remove("socksProxyPort");
    }

    private void method352() {
        Emulator.getEmulator().getScreen();
        EmulatorScreen.pauseStep();
        if (this.aText635.getText().trim().length() < 1) {
            MessageBox messageBox = new MessageBox(this.setsShell);
            messageBox.setText(UILocale.get("OPTION_NETWORK_PROXY_TEST", "Proxy Test"));
            messageBox.setMessage(UILocale.get("OPTION_NETWORK_PROXY_EMPTY", "Empty proxy host!"));
            messageBox.open();
        } else {
            MessageBox messageBox2 = new MessageBox(this.setsShell);
            messageBox2.setText(UILocale.get("OPTION_NETWORK_PROXY_TEST", "Proxy Test"));
            messageBox2.setMessage(UILocale.get("OPTION_NETWORK_PROXY_UNIMP", "Proxy test is underimplemented!"));
            messageBox2.open();
        }
        ((EmulatorScreen)Emulator.getEmulator().getScreen()).resumeStep();
    }

    private void updateProxy() {
        Property.removeProxyProperties();
        int anInt1257 = Settings.proxyType;
        if (anInt1257 == 0) {
            return;
        }
        if (anInt1257 == 1) {
            System.setProperty("http.proxyHost", Settings.proxyHost);
            System.setProperty("http.proxyPort", Settings.proxyPort);
            if (Settings.proxyDomain.length() > 0) {
                System.setProperty("http.auth.ntlm.domain", Settings.proxyDomain);
            }
        } else if (anInt1257 == 2) {
            System.setProperty("socksProxyHost", Settings.proxyHost);
            System.setProperty("socksProxyPort", Settings.proxyPort);
        }
        Authenticator.setDefault(new MyAuthenticator(this, Settings.proxyUser, Settings.proxyPass));
    }

    static Combo method361(Property class38) {
        return class38.deviceCombo;
    }

    static void method362(Property class38) {
        class38.method387();
    }

    static void method375(Property class38) {
        class38.apply();
    }

    static Shell method364(Property class38) {
        return class38.setsShell;
    }

    static Scale method370(Property class38) {
        return class38.fpsScale;
    }

    static CLabel method363(Property class38) {
        return class38.fpsLabel;
    }

    static Combo method376(Property class38) {
        return class38.controllerCombo;
    }

    static Text method366(Property class38) {
        return class38.aText731;
    }

    static String[] method365() {
        return aStringArray661;
    }

    static Text method377(Property class38) {
        return class38.aText735;
    }

    static Text method380(Property class38) {
        return class38.aText754;
    }

    static Text method385(Property class38) {
        return class38.aText757;
    }

    static Text method388(Property class38) {
        return class38.aText760;
    }

    static Text method391(Property class38) {
        return class38.aText763;
    }

    static Text method394(Property class38) {
        return class38.aText766;
    }

    static Text method397(Property class38) {
        return class38.aText768;
    }

    static Text method399(Property class38) {
        return class38.aText770;
    }

    static Text method401(Property class38) {
        return class38.aText772;
    }

    static Text method403(Property class38) {
        return class38.aText774;
    }

    static Text method405(Property class38) {
        return class38.aText627;
    }

    static Text method407(Property class38) {
        return class38.aText629;
    }

    static Text method409(Property class38) {
        return class38.aText631;
    }

    static Text method411(Property class38) {
        return class38.aText739;
    }

    static Text method413(Property class38) {
        return class38.aText742;
    }

    static Text method415(Property class38) {
        return class38.aText745;
    }

    static Text method417(Property class38) {
        return class38.aText748;
    }

    static Text method419(Property class38) {
        return class38.aText751;
    }

    static void method381(Property class38) {
        class38.method406();
    }

    static void method386(Property class38) {
        class38.method402();
    }

    static void method369(Property class38, int n) {
        class38.method360(n);
    }

    static IImage method356(Property class38) {
        return class38.anIImage671;
    }

    static IImage method378(Property class38) {
        return class38.anIImage674;
    }

    static IImage method382(Property class38) {
        return class38.anIImage693;
    }

    static Table method367(Property class38) {
        return class38.aTable665;
    }

    static String method368(Property class38) {
        return class38.method374();
    }

    static void method389(Property class38) {
        class38.method428();
    }

    static Text method421(Property class38) {
        return class38.aText662;
    }

    static void method392(Property class38) {
        class38.method352();
    }

    static Combo method383(Property class38) {
        return class38.proxyTypeCombo;
    }

    static Text method423(Property class38) {
        return class38.aText635;
    }

    static Text method425(Property class38) {
        return class38.aText637;
    }

    static Text method427(Property class38) {
        return class38.aText639;
    }

    static Text method429(Property class38) {
        return class38.aText641;
    }

    static Text method431(Property class38) {
        return class38.aText643;
    }

    static Button method357(Property class38) {
        return class38.aButton764;
    }

    static void method395(Property class38) {
        Property.removeProxyProperties();
    }

    public void widgetSelected(SelectionEvent e2) {
        if (e2.widget instanceof Combo) {
            Permission.permissions.put((String)e2.widget.getData(), Permission.fromString(PERMISSIONS_VALUES[1][((Combo)e2.widget).getSelectionIndex()]));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e2) {
        this.widgetSelected(e2);
    }

    static {
        aStringArray661 = new String[19];
    }

    private final class SortProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        private SortProperties() {
        }

        @Override
        public Enumeration keys() {
            ArrayList<Object> list2 = Collections.list(super.keys());
            Collections.sort(list2);
            return Collections.enumeration(list2);
        }
    }

    private final class MyAuthenticator
    extends Authenticator {
        private final String aString780;
        private final String aString781;

        MyAuthenticator(Property class38, String aString780, String aString781) {
            this.aString780 = aString780;
            this.aString781 = aString781;
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.aString780, this.aString781.toCharArray());
        }
    }
}

