/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.debug.ClassTypes;
import emulator.debug.Memory;
import emulator.debug.ReferencePath;
import emulator.ui.swt.Watcher;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class ReferencePathDisplay
extends Composite
implements SelectionListener {
    private final String rootName;

    public ReferencePathDisplay(Composite parent, ReferencePath path, boolean fullNames) {
        super(parent, 0);
        Label l;
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        this.setLayoutData(gd);
        RowLayout rl = new RowLayout();
        rl.wrap = true;
        rl.center = true;
        rl.type = 256;
        this.setLayout((Layout)rl);
        if (path.isRootStatic) {
            this.rootName = path.root;
            l = new Link((Composite)this, 0);
            if (fullNames) {
                l.setText("<a>" + path.root + "</a>");
            } else {
                String[] split = path.root.split("\\.");
                l.setText("<a>" + split[split.length - 1] + "</a>");
            }
            l.setToolTipText("Static class, click to open watcher");
            l.setLinkForeground(null);
            l.addSelectionListener((SelectionListener)this);
        } else {
            this.rootName = null;
            l = new Label((Composite)this, 0);
            l.setText(path.root);
            l.setToolTipText("This object was found in internal memory. Watcher can't be opened here");
        }
        for (final ReferencePath.ReferencePathEntry e2 : path.getPath()) {
            Link l2;
            if (!e2.isIndex) {
                new Label((Composite)this, 0).setText(" -> ");
            }
            if (ClassTypes.isObject(e2.object.getClass())) {
                l2 = new Link((Composite)this, 0);
                if (e2.isIndex) {
                    l2.setText("[<a>" + e2.fieldName + "</a>]");
                } else {
                    l2.setText("<a>" + e2.fieldName + "</a>");
                }
                l2.setToolTipText("Object of type \"" + e2.object.getClass().getName() + "\", click to open watcher");
                l2.setLinkForeground(null);
                l2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        new Watcher(e2.object).open(ReferencePathDisplay.this.getShell());
                    }
                });
                continue;
            }
            l2 = new Label((Composite)this, 0);
            l2.setText(e2.toString());
            l2.setToolTipText("Object of type \"" + e2.object.getClass().getName() + "\"");
        }
    }

    public void widgetSelected(SelectionEvent e2) {
        new Watcher(Memory.cls(this.rootName)).open(this.getShell());
    }

    public void widgetDefaultSelected(SelectionEvent e2) {
    }
}

