/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.Devices;
import emulator.Emulator;
import emulator.Settings;
import emulator.graphics2D.IFont;
import emulator.graphics2D.IImage;
import emulator.graphics2D.awt.FontAWT;
import emulator.graphics2D.awt.ImageAWT;
import emulator.graphics2D.swt.FontSWT;
import emulator.graphics2D.swt.ImageSWT;
import emulator.graphics3D.IGraphics3D;
import emulator.ui.IEmulatorFrontend;
import emulator.ui.ILogStream;
import emulator.ui.IMessage;
import emulator.ui.IPlugin;
import emulator.ui.IProperty;
import emulator.ui.IScreen;
import emulator.ui.swt.EmulatorScreen;
import emulator.ui.swt.InfosBox;
import emulator.ui.swt.KeyPad;
import emulator.ui.swt.Log;
import emulator.ui.swt.M3GViewUI;
import emulator.ui.swt.MediaView;
import emulator.ui.swt.MemoryView;
import emulator.ui.swt.MessageConsole;
import emulator.ui.swt.Methods;
import emulator.ui.swt.Property;
import emulator.ui.swt.Watcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.swt.widgets.Display;

public final class SWTFrontend
implements IEmulatorFrontend {
    private static Display display;
    private Vector plugins;
    private int screenDepth;
    private Methods methods;
    private MemoryView memoryView;
    private MediaView mediaView;
    private Watcher classWatcher;
    private Watcher profiler;
    private Property iproperty;
    private EmulatorScreen screen;
    private Log ilogstream;
    private KeyPad keyPad;
    private InfosBox infos;
    private M3GViewUI m3gView;
    private MessageConsole sms;
    public Properties midletProps;
    private static Hashtable<String, FontSWT> swtFontsCache;

    public SWTFrontend() {
        display = new Display();
        this.plugins = new Vector();
        this.screenDepth = display.getDepth();
        this.iproperty = new Property();
        this.ilogstream = new Log();
        this.sms = new MessageConsole();
        this.infos = new InfosBox();
        this.keyPad = new KeyPad();
        this.classWatcher = Watcher.createForStatics();
        this.profiler = Watcher.createForProfiler();
        this.methods = new Methods();
    }

    @Override
    public void dispose() {
        if (!display.isDisposed()) {
            display.dispose();
        }
    }

    public static Display getDisplay() {
        return display;
    }

    public static void syncExec(Runnable runnable) {
        if (!display.isDisposed()) {
            display.syncExec(runnable);
        }
    }

    @Override
    public final int getScreenDepth() {
        return this.screenDepth;
    }

    public final Watcher getClassWatcher() {
        return this.classWatcher;
    }

    public final Watcher getProfiler() {
        return this.profiler;
    }

    public final MemoryView getMemory() {
        if (this.memoryView == null) {
            this.memoryView = new MemoryView();
        }
        return this.memoryView;
    }

    public final MediaView getMedia() {
        if (this.mediaView == null) {
            this.mediaView = new MediaView();
        }
        return this.mediaView;
    }

    public final Methods getMethods() {
        return this.methods;
    }

    public final InfosBox getInfos() {
        return this.infos;
    }

    public final KeyPad getKeyPad() {
        return this.keyPad;
    }

    public final M3GViewUI getM3GView() {
        if (this.m3gView == null) {
            this.m3gView = new M3GViewUI();
        }
        return this.m3gView;
    }

    @Override
    public final void disposeSubWindows() {
        Settings.showLogFrame = this.ilogstream.isLogOpen();
        Settings.showInfoFrame = this.infos.isShown();
        this.keyPad.dipose();
        this.ilogstream.dispose();
        this.sms.dispose();
        this.infos.dispose();
        Settings.showMemViewFrame = this.memoryView != null && this.memoryView.isShown();
        this.methods.dispose();
        if (this.memoryView != null) {
            this.memoryView.dispose();
        }
        if (this.mediaView != null) {
            this.mediaView.dispose();
        }
        this.classWatcher.dispose();
        this.profiler.dispose();
        if (this.m3gView != null) {
            this.m3gView.close();
        }
        while (Watcher.activeWatchers.size() > 0) {
            Watcher.activeWatchers.get(0).dispose();
        }
        for (Object o : this.plugins) {
            ((IPlugin)o).close();
        }
    }

    @Override
    public final void pushPlugin(IPlugin plugin) {
        this.plugins.add(plugin);
    }

    @Override
    public final ILogStream getLogStream() {
        return this.ilogstream;
    }

    @Override
    public final IProperty getProperty() {
        return this.iproperty;
    }

    @Override
    public final IScreen getScreen() {
        if (this.screen == null) {
            this.screen = new EmulatorScreen(Devices.getPropertyInt("SCREEN_WIDTH"), Devices.getPropertyInt("SCREEN_HEIGHT"));
        }
        return this.screen;
    }

    @Override
    public final IMessage getMessage() {
        return this.sms;
    }

    private String getFontName(int face) {
        if (face == 32) {
            return this.iproperty.getMonospaceFontName();
        }
        return this.iproperty.getDefaultFontName();
    }

    @Override
    public final IFont newFont(int face, int size, int style) {
        String name = this.getFontName(face);
        if (Settings.g2d == 0) {
            String s = name + "." + size + "." + style;
            if (swtFontsCache.containsKey(s)) {
                return swtFontsCache.get(s);
            }
            FontSWT f2 = new FontSWT(name, size, style & 0xFFFFFFFB);
            swtFontsCache.put(s, f2);
            return f2;
        }
        if (Settings.g2d == 1) {
            return new FontAWT(name, size, style, false);
        }
        return null;
    }

    @Override
    public final IFont newCustomFont(int face, int size, int style, boolean height) {
        return this.newFont(this.getFontName(face), style, size, height);
    }

    @Override
    public final IFont newFont(String name, int style, int pixelSize) {
        return this.newFont(name, style, pixelSize, false);
    }

    private IFont newFont(String name, int style, int size, boolean height) {
        if (Settings.g2d == 0) {
            String s = name + "." + size + "." + style + height;
            if (swtFontsCache.containsKey(s)) {
                return swtFontsCache.get(s);
            }
            FontSWT f2 = new FontSWT(name, size, style & 0xFFFFFFFB, height);
            swtFontsCache.put(s, f2);
            return f2;
        }
        if (Settings.g2d == 1) {
            return new FontAWT(name, size, style, height);
        }
        return null;
    }

    @Override
    public final IFont loadFont(InputStream fontData, int size) throws IOException {
        if (Settings.g2d == 1) {
            return new FontAWT(fontData, size);
        }
        return null;
    }

    @Override
    public final IImage newImage(int n, int n2, boolean transparent) {
        if (Settings.g2d == 0) {
            return new ImageSWT(n, n2, transparent, -1);
        }
        if (Settings.g2d == 1) {
            return new ImageAWT(n, n2, transparent, -1);
        }
        return null;
    }

    @Override
    public final IImage newImage(int n, int n2, boolean b2, int n3) {
        return Settings.g2d == 0 ? new ImageSWT(n, n2, b2, n3) : (Settings.g2d == 1 ? new ImageAWT(n, n2, b2, n3) : null);
    }

    @Override
    public final IImage newImage(byte[] array) throws IOException {
        if (Settings.g2d == 0) {
            return new ImageSWT(array);
        }
        if (Settings.g2d == 1) {
            return new ImageAWT(array);
        }
        return null;
    }

    @Override
    public final IGraphics3D getGraphics3D() {
        return Emulator.getPlatform().getGraphics3D();
    }

    @Override
    public final void syncValues() {
        for (int i2 = 0; i2 < Watcher.activeWatchers.size(); ++i2) {
            display.asyncExec((Runnable)Watcher.activeWatchers.get(i2));
        }
        if (this.methods.method438()) {
            display.asyncExec((Runnable)this.methods);
        }
    }

    @Override
    public final String getAppProperty(String s) {
        String property;
        if (this.midletProps != null && (property = this.midletProps.getProperty(s)) != null) {
            return property.trim();
        }
        return null;
    }

    @Override
    public Properties getAppProperties() {
        return this.midletProps;
    }

    @Override
    public void setAppProperties(Properties p) {
        this.midletProps = p;
    }

    @Override
    public void updateLanguage() {
        ((EmulatorScreen)this.getScreen()).updateLanguage();
    }

    static {
        swtFontsCache = new Hashtable();
    }
}

