/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.UILocale;
import emulator.ui.swt.MemoryView;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.DirectoryDialog;

final class SaveAllImagesListener
extends SelectionAdapter {
    private final MemoryView mv;

    SaveAllImagesListener(MemoryView mv) {
        this.mv = mv;
    }

    public final void widgetSelected(SelectionEvent selectionEvent) {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.mv.getShell());
        directoryDialog.setText(UILocale.get("MEMORY_VIEW_SAVE_ALL", "Export all images"));
        directoryDialog.setMessage(UILocale.get("MEMORY_VIEW_CHOOSE_DIRECTORY", "Choose a directory"));
        directoryDialog.setFilterPath(System.getProperty("user.dir"));
        String open = directoryDialog.open();
        if (open != null) {
            for (int i2 = 0; i2 < MemoryView.imagesToShow.size(); ++i2) {
                try {
                    MemoryView.imagesToShow.get((int)i2).drawable.getImpl().saveToFile(open + "/" + i2 + ".png");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

