/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.UILocale;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScreenSizeDialog
extends Dialog {
    protected int[] result;

    public ScreenSizeDialog(Shell parent, int width, int height) {
        super(parent, 67680);
        this.result = new int[]{width, height};
    }

    public int[] open() {
        Shell parentShell = this.getParent();
        Shell shell = new Shell(parentShell, this.getStyle());
        shell.setText(UILocale.get("SCREEN_SIZE_DIALOG_TITLE", "Set screen size"));
        this.createContents(shell);
        shell.pack();
        shell.setLocation(parentShell.getLocation().x + (parentShell.getSize().x - shell.getSize().x >> 1), parentShell.getLocation().y + (parentShell.getSize().y - shell.getSize().y >> 1));
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout(2, true));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        final Text width = new Text((Composite)shell, 2048);
        width.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                event.doit = event.keyCode == 8 || event.keyCode == 127 || event.keyCode == 0x1000003 || event.keyCode == 0x1000004 || Character.isDigit(event.character);
            }
        });
        width.setText(String.valueOf(this.result[0]));
        data = new GridData(768);
        data.horizontalSpan = 2;
        width.setLayoutData((Object)data);
        final Text height = new Text((Composite)shell, 2048);
        height.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                event.doit = event.keyCode == 8 || event.keyCode == 127 || event.keyCode == 0x1000003 || event.keyCode == 0x1000004 || Character.isDigit(event.character);
            }
        });
        height.setText(String.valueOf(this.result[1]));
        data = new GridData(768);
        data.horizontalSpan = 2;
        height.setLayoutData((Object)data);
        Button ok = new Button((Composite)shell, 8);
        ok.setText(UILocale.get("DIALOG_SET", "Set"));
        data = new GridData(768);
        ok.setLayoutData((Object)data);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ScreenSizeDialog.this.result = new int[]{Integer.parseInt(width.getText()), Integer.parseInt(height.getText())};
                shell.close();
            }
        });
        Button cancel = new Button((Composite)shell, 8);
        cancel.setText(UILocale.get("DIALOG_CANCEL", "Cancel"));
        data = new GridData(768);
        cancel.setLayoutData((Object)data);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ScreenSizeDialog.this.result = null;
                shell.close();
            }
        });
        shell.setDefaultButton(ok);
        width.setFocus();
    }
}

