/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.Emulator;
import emulator.UILocale;
import emulator.debug.ClassTypes;
import emulator.debug.Instance;
import emulator.ui.swt.ClassListFiller;
import emulator.ui.swt.SWTFrontend;
import emulator.ui.swt.WatcherFieldEditorHandler;
import emulator.ui.swt.WatcherTreeMouseHandler;
import emulator.ui.swt.WatcherType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public final class Watcher
extends SelectionAdapter
implements Runnable,
DisposeListener,
TreeListener {
    private Shell shell;
    private Display display;
    private Combo classCombo;
    private Text filterInput;
    private Button hexDecSwitch;
    private Button exportBtn;
    private boolean visible;
    public final Map<String, Instance> selectableClasses = new HashMap<String, Instance>();
    public final WatcherType type;
    private Tree tree;
    private TreeEditor treeEditor;
    public static final Vector<Watcher> activeWatchers = new Vector();
    private boolean disposed;
    private boolean updateInProgress;
    private float propCol1;
    private float propCol2;
    private float propCol3;
    private TreeColumn column1;
    private TreeColumn column2;
    private TreeColumn column3;
    private long lastShellResizeEvent;
    public static final String SHELL_TYPE = "WATCHER";

    private Watcher(WatcherType type) {
        this.type = type;
    }

    public static Watcher createForStatics() {
        return new Watcher(WatcherType.Static);
    }

    public static Watcher createForProfiler() {
        return new Watcher(WatcherType.Profiler);
    }

    public Watcher(Object o) {
        this(WatcherType.Instance);
        Instance c2 = new Instance(o.getClass().getName(), o);
        c2.updateFields(null);
        this.selectableClasses.put(o.toString(), c2);
    }

    public Watcher(Class cls) {
        this(WatcherType.Static);
        Instance c2 = new Instance(cls.getName(), null);
        c2.updateFields(null);
        this.selectableClasses.put(cls.getName(), c2);
    }

    public void fillClassList() {
        new Thread(new ClassListFiller(this)).start();
    }

    public Instance getWatched() {
        return this.selectableClasses.get(this.classCombo.getText());
    }

    private void updateContent() {
        Instance c2 = this.getWatched();
        if (c2 == null) {
            this.tree.removeAll();
            return;
        }
        String filterText = this.filterInput == null ? "" : this.filterInput.getText();
        c2.updateFields(filterText.isEmpty() ? null : filterText);
        switch (this.type) {
            case Static: {
                String s = c2.getCls().getName();
                this.shell.setText(s + " (static) - " + UILocale.get("WATCHES_FRAME_TITLE", "Class Watcher"));
                break;
            }
            case Profiler: {
                this.shell.setText(this.classCombo.getText());
                break;
            }
            case Instance: {
                Object o = c2.getInstance();
                String s = o.getClass().getName();
                String hash = Integer.toHexString(o.hashCode());
                this.shell.setText(s + " (" + hash + ") - " + UILocale.get("WATCHES_FRAME_TITLE", "Class Watcher"));
                break;
            }
        }
        this.tree.removeAll();
        for (int i2 = 0; i2 < c2.getFields().size(); ++i2) {
            Object value = c2.getFields().get(i2);
            if (value instanceof Field) {
                Field field = (Field)c2.getFields().get(i2);
                TreeItem treeItem = new TreeItem(this.tree, 0);
                treeItem.setText(0, field.getName());
                if (this.type == WatcherType.Profiler) continue;
                this.tree.getItem(i2).setText(2, ClassTypes.getReadableClassName(field.getType()));
                if (!field.getType().isArray()) continue;
                new TreeItem(treeItem, 0).setText(0, "");
                continue;
            }
            new TreeItem(this.tree, 0).setText(0, value.getClass().getName());
            if (this.type != WatcherType.Instance) continue;
            this.tree.getItem(i2).setText(2, value.getClass().getName());
        }
    }

    private void method301(Instance c2, Field field, TreeItem treeItem) {
        String name = ClassTypes.getReadableClassName(field.getType());
        if (field.getType().isArray()) {
            Object method870 = ClassTypes.getFieldValue(c2.getInstance(), field);
            Watcher.method305(method870, Watcher.method303(method870, name.substring(0, name.length() - 2)), treeItem);
        }
    }

    private static String method303(Object o, String method870) {
        if (method870.equalsIgnoreCase("java.lang.Object")) {
            try {
                String string;
                int index;
                if (Array.getLength(o) > 0 && (index = (string = Array.get(o, 0).toString()).indexOf(64)) != -1) {
                    method870 = ClassTypes.method870(string.substring(0, index));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method870;
    }

    private static void method305(Object o, String s, TreeItem treeItem) {
        treeItem.removeAll();
        if (o != null) {
            int length = Array.getLength(o);
            for (int i2 = 0; i2 < length; ++i2) {
                TreeItem treeItem2 = new TreeItem(treeItem, 0);
                treeItem2.setText(0, Integer.toString(i2));
                treeItem2.setText(2, s);
                if (s.charAt(s.length() - 1) != ']') continue;
                new TreeItem(treeItem2, 0).setText(0, "");
            }
            return;
        }
        new TreeItem(treeItem, 0).setText(0, "");
    }

    public void treeExpanded(TreeEvent treeEvent) {
        String s2;
        TreeItem item = (TreeItem)treeEvent.item;
        if (item.getExpanded()) {
            return;
        }
        Instance c2 = this.getWatched();
        if (item.getParentItem() == null) {
            this.method301(c2, (Field)c2.getFields().get(item.getParent().indexOf(item)), item);
            this.display.asyncExec((Runnable)this);
            return;
        }
        TreeItem parentItem = item;
        Stack<TreeItem> stack = new Stack<TreeItem>();
        while (parentItem.getParentItem() != null) {
            stack.push(parentItem);
            parentItem = parentItem.getParentItem();
        }
        Field field = (Field)c2.getFields().get(parentItem.getParent().indexOf(parentItem));
        Object o = ClassTypes.getFieldValue(c2.getInstance(), field);
        String method869 = ClassTypes.getReadableClassName(field.getType());
        String s = Watcher.method303(o, method869.substring(0, method869.length() - 2));
        while (true) {
            s2 = s;
            if (stack.isEmpty()) break;
            TreeItem treeItem2 = (TreeItem)stack.pop();
            o = Array.get(o, treeItem2.getParentItem().indexOf(treeItem2));
            s = s2.substring(0, s2.length() - 2);
        }
        Watcher.method305(o, s2, item);
        this.display.asyncExec((Runnable)this);
    }

    public void treeCollapsed(TreeEvent var1) {
    }

    public final void openWatcherForSelected() {
        Class<?> clazz;
        Object o;
        TreeItem[] array = this.tree.getSelection();
        if (array == null || array.length == 0) {
            return;
        }
        Instance c2 = this.getWatched();
        if (array[0].getParentItem() == null) {
            Field field = (Field)c2.getFields().get(array[0].getParent().indexOf(array[0]));
            o = ClassTypes.getFieldValue(c2.getInstance(), field);
            clazz = field.getType();
        } else {
            TreeItem parentItem = array[0];
            Stack<TreeItem> stack = new Stack<TreeItem>();
            while (parentItem.getParentItem() != null) {
                stack.push(parentItem);
                parentItem = parentItem.getParentItem();
            }
            o = ClassTypes.getFieldValue(c2.getInstance(), (Field)c2.getFields().get(parentItem.getParent().indexOf(parentItem)));
            clazz = o.getClass().getComponentType();
            while (!stack.isEmpty()) {
                TreeItem treeItem = (TreeItem)stack.pop();
                int index = treeItem.getParentItem().indexOf(treeItem);
                clazz = o.getClass().getComponentType();
                o = Array.get(o, index);
            }
        }
        if (o != null && ClassTypes.isObject(clazz)) {
            new Watcher(o).open(this.shell);
        }
    }

    public void startFieldEditingForSelected() {
        int targetIndex;
        Field targetField;
        Object target;
        TreeItem[] array = this.tree.getSelection();
        if (array == null || array.length == 0) {
            return;
        }
        TreeItem treeItem = array[0];
        Instance c2 = this.getWatched();
        if (treeItem.getParentItem() == null) {
            target = c2.getInstance();
            targetField = (Field)c2.getFields().get(treeItem.getParent().indexOf(treeItem));
            targetIndex = -1;
        } else {
            Object o2;
            TreeItem parentItem = treeItem;
            Stack<TreeItem> stack = new Stack<TreeItem>();
            while (parentItem.getParentItem() != null) {
                stack.push(parentItem);
                parentItem = parentItem.getParentItem();
            }
            int n = parentItem.getParent().indexOf(parentItem);
            Object o = ClassTypes.getFieldValue(c2.getInstance(), (Field)c2.getFields().get(n));
            block1: while (true) {
                o2 = o;
                while (!stack.isEmpty()) {
                    TreeItem treeItem2 = (TreeItem)stack.pop();
                    n = treeItem2.getParentItem().indexOf(treeItem2);
                    if (stack.isEmpty()) continue;
                    o = Array.get(o2, n);
                    continue block1;
                }
                break;
            }
            target = o2;
            targetIndex = n;
            targetField = null;
        }
        if (target == null && targetField == null) {
            return;
        }
        if (targetField != null) {
            if (!ClassTypes.canSetFieldValue(targetField)) {
                return;
            }
            if (target == null && !Modifier.isStatic(targetField.getModifiers())) {
                return;
            }
        }
        Text control = new Text((Composite)this.tree, 0);
        control.setText(treeItem.getText(1));
        control.selectAll();
        control.setFocus();
        WatcherFieldEditorHandler handler = new WatcherFieldEditorHandler(this, treeItem, control, target, targetField, targetIndex);
        control.addFocusListener((FocusListener)handler);
        control.addKeyListener((KeyListener)handler);
        this.treeEditor.setEditor((Control)control, treeItem, 1);
    }

    public final void open(Shell parent) {
        this.display = parent.getDisplay();
        this.createWidgets();
        this.updateContent();
        this.setInitialRect(parent);
        this.shell.open();
        this.shell.addDisposeListener((DisposeListener)this);
        this.shell.setData("TYPE", (Object)SHELL_TYPE);
        this.updateColumnSizes();
        this.disposed = false;
        this.visible = true;
        this.display.asyncExec((Runnable)this);
        activeWatchers.addElement(this);
        Display display = SWTFrontend.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.visible = false;
    }

    private void setInitialRect(Shell parent) {
        String type = String.valueOf(parent.getData("TYPE"));
        int WIDTH = 400;
        int HEIGHT = 500;
        int OFFSET = 40;
        Rectangle dsp = this.shell.getMonitor().getClientArea();
        if (parent.getMaximized()) {
            this.shell.setSize(400, 500);
            return;
        }
        switch (type) {
            case "WATCHER": {
                Point ps = parent.getSize();
                Point plc = parent.getLocation();
                this.shell.setSize(ps);
                if (plc.y + 40 + ps.y > dsp.height) {
                    this.shell.setLocation(plc.x - 40, 40);
                    break;
                }
                if (plc.x + 40 + ps.x > dsp.width) {
                    this.shell.setLocation(plc.x - 40, plc.y + 40);
                    break;
                }
                this.shell.setLocation(plc.x + 40, plc.y + 40);
                break;
            }
            case "MEMORY_VIEW": {
                this.shell.setSize(400, 500);
                this.shell.setLocation(parent.getLocation().x + parent.getSize().x + 10, parent.getLocation().y);
                break;
            }
            default: {
                this.shell.setSize(400, 500);
                if (parent.getSize().x < 500 || parent.getSize().y < 600) {
                    this.shell.setLocation(parent.getLocation().x + parent.getSize().x + 10, parent.getLocation().y);
                    break;
                }
                int x = parent.getLocation().x + parent.getSize().x - 400;
                int y = parent.getLocation().y + parent.getSize().y - 500;
                this.shell.setLocation(x, y);
                break;
            }
        }
    }

    public final void dispose() {
        this.disposed = true;
        activeWatchers.removeElement(this);
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.visible = false;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    private void fillClassCombo() {
        if (!this.selectableClasses.isEmpty()) {
            Set<String> classes = this.selectableClasses.keySet();
            List<Object> list2 = Arrays.asList(classes.toArray());
            Collections.sort(list2);
            Enumeration<Object> enumeration = Collections.enumeration(list2);
            while (enumeration.hasMoreElements()) {
                this.classCombo.add(enumeration.nextElement().toString());
            }
            this.classCombo.select(0);
        }
    }

    @Override
    public final synchronized void run() {
        if (this.selectableClasses.isEmpty() || !this.visible || this.updateInProgress || this.disposed) {
            return;
        }
        this.updateInProgress = true;
        Instance c2 = this.getWatched();
        int n = 0;
        try {
            for (int i2 = 0; i2 < c2.getFields().size(); ++i2) {
                Field field = (Field)c2.getFields().get(i2);
                if (this.disposed) {
                    this.updateInProgress = false;
                    return;
                }
                String s = !Modifier.isStatic(field.getModifiers()) && c2.getInstance() == null ? "" : ClassTypes.method874(c2.getInstance(), field, this.hexDecSwitch != null && this.hexDecSwitch.getSelection());
                TreeItem item = this.tree.getItem(n++);
                item.setText(1, s);
                this.fillArraySubtree(ClassTypes.getFieldValue(c2.getInstance(), field), item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateInProgress = false;
    }

    private void fillArraySubtree(Object o, TreeItem treeItem) {
        if (o == null) {
            return;
        }
        if (treeItem.getExpanded()) {
            for (int i2 = treeItem.getItemCount() - 1; i2 >= 0; --i2) {
                TreeItem item = treeItem.getItem(i2);
                item.setText(1, ClassTypes.getArrayValue(o, i2, this.hexDecSwitch != null && this.hexDecSwitch.getSelection()));
                this.fillArraySubtree(Array.get(o, i2), item);
            }
        }
    }

    private void updateProportionsFromColumnWidths() {
        if (System.currentTimeMillis() - this.lastShellResizeEvent < 100L) {
            return;
        }
        float sum = this.tree.getClientArea().width;
        this.propCol1 = (float)this.column1.getWidth() / sum;
        if (this.column3 == null) {
            this.propCol2 = 1.0f - this.propCol1;
        } else {
            this.propCol2 = (float)this.column2.getWidth() / sum;
            this.propCol3 = 1.0f - (this.propCol1 + this.propCol2);
        }
    }

    private void updateColumnSizes() {
        this.lastShellResizeEvent = System.currentTimeMillis();
        int width = this.tree.getClientArea().width;
        this.tree.setRedraw(false);
        this.column1.setWidth((int)((float)width * this.propCol1) - 1);
        this.column2.setWidth((int)((float)width * this.propCol2) - 1);
        if (this.column3 != null) {
            this.column3.setWidth((int)((float)width * this.propCol3) - 1);
        }
        this.tree.setRedraw(true);
    }

    private void createWidgets() {
        this.shell = new Shell();
        this.shell.setText(UILocale.get("WATCHES_FRAME_TITLE", "Watches"));
        this.shell.setImage(new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/res/icon")));
        this.shell.setMinimumSize(160, 140);
        boolean isClassComboUseful = this.createClassCombo();
        GridLayout shellLayout = new GridLayout();
        shellLayout.numColumns = isClassComboUseful ? 2 : 3;
        this.shell.setLayout((Layout)shellLayout);
        if (isClassComboUseful) {
            this.createExportBtn();
        }
        if (this.type != WatcherType.Profiler) {
            this.createFilter();
            this.createHexSwitch();
        }
        if (!isClassComboUseful) {
            this.createExportBtn();
        }
        GridData treeLayout = new GridData();
        treeLayout.horizontalAlignment = 4;
        treeLayout.horizontalSpan = isClassComboUseful ? 2 : 3;
        treeLayout.grabExcessHorizontalSpace = true;
        treeLayout.grabExcessVerticalSpace = true;
        treeLayout.verticalAlignment = 4;
        this.tree = new Tree((Composite)this.shell, 0x10010800);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.tree.setLayoutData((Object)treeLayout);
        if (this.type != WatcherType.Profiler) {
            this.tree.setToolTipText("Right click: open watcher\nDouble click: edit value");
            this.tree.addMouseListener((MouseListener)new WatcherTreeMouseHandler(this));
        }
        this.tree.addTreeListener((TreeListener)this);
        this.column1 = new TreeColumn(this.tree, 16384);
        this.column1.setText("Name");
        this.column1.setMoveable(false);
        this.column2 = new TreeColumn(this.tree, 16384);
        this.column2.setText("Value");
        this.column2.setMoveable(false);
        ControlAdapter onColumnResized = new ControlAdapter(){

            public void controlResized(ControlEvent e2) {
                Watcher.this.updateProportionsFromColumnWidths();
            }
        };
        ControlAdapter onShellResized = new ControlAdapter(){

            public void controlResized(ControlEvent e2) {
                Watcher.this.updateColumnSizes();
            }
        };
        this.column1.addControlListener((ControlListener)onColumnResized);
        this.column2.addControlListener((ControlListener)onColumnResized);
        if (this.type != WatcherType.Profiler) {
            this.column3 = new TreeColumn(this.tree, 16384);
            this.column3.setText("Type");
            this.column3.setMoveable(false);
            this.column3.addControlListener((ControlListener)onColumnResized);
            this.propCol3 = 0.33333334f;
            this.propCol2 = 0.33333334f;
            this.propCol1 = 0.33333334f;
        } else {
            this.column3 = null;
            this.propCol2 = 0.5f;
            this.propCol1 = 0.5f;
        }
        this.shell.addControlListener((ControlListener)onShellResized);
        this.treeEditor = new TreeEditor(this.tree);
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
    }

    private void createFilter() {
        GridData filterLayout = new GridData();
        filterLayout.horizontalAlignment = 4;
        filterLayout.grabExcessHorizontalSpace = true;
        filterLayout.verticalAlignment = 2;
        this.filterInput = new Text((Composite)this.shell, 2048);
        this.filterInput.setLayoutData((Object)filterLayout);
        this.filterInput.setMessage("Filter fields");
        this.filterInput.setToolTipText("Filtering will be performed only by fields' names.");
        this.filterInput.addModifyListener(this::onFilterTextModify);
    }

    private void createHexSwitch() {
        this.hexDecSwitch = new Button((Composite)this.shell, 32);
        this.hexDecSwitch.setText("HEX");
        this.hexDecSwitch.setToolTipText("If checked, numbers will be shown in hexadecimal form.");
        this.hexDecSwitch.addSelectionListener((SelectionListener)this);
    }

    private void createExportBtn() {
        this.exportBtn = new Button((Composite)this.shell, 8);
        this.exportBtn.setText("Export");
        this.exportBtn.setToolTipText("Watcher content will be saved to data folder");
        this.exportBtn.addSelectionListener((SelectionListener)this);
    }

    public void widgetSelected(SelectionEvent se) {
        if (se.widget == this.hexDecSwitch) {
            this.display.asyncExec((Runnable)this);
        } else if (se.widget == this.exportBtn) {
            new Thread(this::exportValues).start();
        }
    }

    private void onFilterTextModify(ModifyEvent modifyEvent) {
        this.updateContent();
        this.display.asyncExec((Runnable)this);
    }

    private boolean createClassCombo() {
        boolean isUseful;
        this.classCombo = new Combo((Composite)this.shell, 8);
        this.classCombo.setVisibleItemCount(24);
        this.fillClassCombo();
        this.classCombo.addModifyListener(this::onClassSelect);
        boolean bl = isUseful = this.classCombo.getItemCount() > 1;
        if (isUseful) {
            GridData layoutData = new GridData();
            layoutData.horizontalAlignment = 4;
            layoutData.grabExcessHorizontalSpace = true;
            layoutData.verticalAlignment = 2;
            this.classCombo.setLayoutData((Object)layoutData);
        } else {
            GridData layoutData = new GridData();
            layoutData.exclude = true;
            this.classCombo.setLayoutData((Object)layoutData);
            this.classCombo.setSize(0, 0);
            this.classCombo.setVisible(false);
        }
        return isUseful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClassSelect(ModifyEvent me) {
        Watcher watcher = this;
        synchronized (watcher) {
            this.updateContent();
        }
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportValues() {
        try {
            File file = new File(Emulator.getUserPath() + "/classwatcher.txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            try (PrintStream ps = new PrintStream(new FileOutputStream(file));){
                List<Object> list2 = Arrays.asList(this.selectableClasses.keySet().toArray());
                Collections.sort(list2);
                for (Object o : list2) {
                    ps.println(o);
                    Instance c2 = this.selectableClasses.get(o);
                    c2.updateFields(null);
                    Vector fields = c2.getFields();
                    for (int i2 = 0; i2 < fields.size(); ++i2) {
                        Object f2 = fields.get(i2);
                        if (!(f2 instanceof Field)) continue;
                        Field field = (Field)c2.getFields().get(i2);
                        Class<?> type = field.getType();
                        ps.print(" " + field.getDeclaringClass().getName() + "> " + ClassTypes.getReadableClassName(type) + " " + field.getName());
                        try {
                            Object v = field.get(c2.getInstance());
                            if (type.isArray()) {
                                int l = Array.getLength(v);
                                ps.println(" = " + ClassTypes.getReadableClassName(v.getClass()).replaceFirst("\\[\\]", "[" + l + "]"));
                                ps.print(" [");
                                for (int n = 0; n < l; ++n) {
                                    ps.print(ClassTypes.asd(v, n, false));
                                    if (n == l - 1) continue;
                                    ps.print(", ");
                                }
                                ps.println("]");
                                continue;
                            }
                            String s = v.toString();
                            if (v instanceof String) {
                                StringBuilder sb = new StringBuilder();
                                sb.append('\"');
                                for (char ch : s.toCharArray()) {
                                    if (ch == '\r') {
                                        sb.append("\\r");
                                        continue;
                                    }
                                    if (ch == '\n') {
                                        sb.append("\\n");
                                        continue;
                                    }
                                    sb.append(ch);
                                }
                                sb.append('\"');
                                s = sb.toString();
                            }
                            ps.println(" = " + s);
                            continue;
                        }
                        catch (NullPointerException e2) {
                            ps.println(" = null");
                            continue;
                        }
                        catch (Exception e3) {
                            ps.println();
                            ps.println(" " + e3);
                        }
                    }
                    ps.println();
                }
            }
        }
        catch (Exception e4) {
            e4.printStackTrace();
        }
    }

    public final void widgetDisposed(DisposeEvent disposeEvent) {
        this.dispose();
    }
}

