/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import emulator.debug.ClassTypes;
import emulator.ui.swt.Watcher;
import java.lang.reflect.Field;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

final class WatcherFieldEditorHandler
extends KeyAdapter
implements FocusListener {
    private final TreeItem item;
    private final Text text;
    private final Watcher w;
    private Object targetObject;
    private Field targetField;
    private int targetIndex;

    WatcherFieldEditorHandler(Watcher w, TreeItem item, Text text, Object targetObject, Field targetField, int targetIndex) {
        this.w = w;
        this.item = item;
        this.text = text;
        this.targetObject = targetObject;
        this.targetField = targetField;
        this.targetIndex = targetIndex;
    }

    public final void focusLost(FocusEvent focusEvent) {
        this.item.setText(1, this.text.getText());
        this.apply();
        this.text.dispose();
    }

    public void focusGained(FocusEvent var1) {
    }

    public final void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.keyCode) {
            case 13: {
                this.item.setText(1, this.text.getText());
                this.apply();
                this.text.dispose();
                break;
            }
            case 27: {
                this.text.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply() {
        Watcher watcher = this.w;
        synchronized (watcher) {
            if (this.targetField == null) {
                ClassTypes.setArrayValue(this.targetObject, this.targetIndex, this.text.getText());
            } else {
                ClassTypes.setFieldValue(this.targetObject, this.targetField, this.text.getText());
            }
        }
    }
}

