/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt;

import com.sun.jna.platform.win32.User32;
import emulator.ReflectUtil;
import emulator.Utils;
import emulator.ui.swt.EmulatorScreen;
import java.lang.reflect.Method;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Shell;

public class Win32KeyboardPoller {
    private EmulatorScreen screen;
    private long lastPollTime;
    boolean win = Utils.win;
    private final boolean[] lastKeyboardButtonStates = new boolean[256];
    private final boolean[] keyboardButtonStates = new boolean[this.lastKeyboardButtonStates.length];
    private final long[] keyboardButtonDownTimes = new long[this.keyboardButtonStates.length];
    private final long[] keyboardButtonHoldTimes = new long[this.keyboardButtonStates.length];
    private static Class win32OS;
    private static Method win32OSGetKeyState;

    public Win32KeyboardPoller(EmulatorScreen screen) {
        this.screen = screen;
        try {
            if (win32OS == null) {
                win32OS = Class.forName("org.eclipse.swt.internal.win32.OS");
            }
            if (win32OSGetKeyState == null) {
                win32OSGetKeyState = ReflectUtil.getMethod(win32OS, "GetAsyncKeyState", Integer.TYPE);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void pollKeyboard(Canvas canvas) {
        if (!this.win || canvas == null || canvas.isDisposed()) {
            return;
        }
        long now = System.currentTimeMillis();
        Shell shell = canvas.getShell();
        if (now - this.lastPollTime < 10L) {
            return;
        }
        this.lastPollTime = now;
        boolean active = canvas.getDisplay().getActiveShell() == shell && shell.isVisible() && canvas.isFocusControl();
        try {
            for (int i2 = 0; i2 < this.keyboardButtonStates.length; ++i2) {
                boolean pressed;
                this.lastKeyboardButtonStates[i2] = this.keyboardButtonStates[i2];
                short keyState = win32OSGetKeyState != null ? ((Short)win32OSGetKeyState.invoke(null, i2)).shortValue() : User32.INSTANCE.GetAsyncKeyState(i2);
                boolean bl = pressed = active && ((keyState & 0x8000) == 32768 || (keyState & 1) == 1);
                if (!this.keyboardButtonStates[i2]) {
                    if (pressed) {
                        this.keyboardButtonStates[i2] = true;
                        this.keyboardButtonHoldTimes[i2] = 0L;
                        this.keyboardButtonDownTimes[i2] = now;
                    }
                } else if (!pressed) {
                    this.keyboardButtonStates[i2] = false;
                    this.keyboardButtonHoldTimes[i2] = 0L;
                    this.screen.onKeyUp(this.convertKey(i2), shell);
                }
                if (!this.lastKeyboardButtonStates[i2] || !pressed || now - this.keyboardButtonDownTimes[i2] < 460L) continue;
                if (this.keyboardButtonHoldTimes[i2] == 0L || this.keyboardButtonDownTimes[i2] > this.keyboardButtonHoldTimes[i2]) {
                    this.keyboardButtonHoldTimes[i2] = now;
                }
                if (now - this.keyboardButtonHoldTimes[i2] < 40L) continue;
                this.keyboardButtonHoldTimes[i2] = now;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private int convertKey(int n) {
        if (n <= 7) {
            return -1;
        }
        if (n >= 14 && n <= 31) {
            return -1;
        }
        if (n >= 91 && n <= 95) {
            return -1;
        }
        if (n >= 41 && n <= 47) {
            return -1;
        }
        if (n >= 124 && n <= 186) {
            return -1;
        }
        if (n > 190) {
            return -1;
        }
        if (n >= 65 && n <= 90) {
            n += 32;
        } else if (n >= 96 && n <= 105) {
            n = n - 96 + 48;
        } else if (n >= 112 && n <= 123) {
            n = n - 112 + 10;
        } else {
            switch (n) {
                case 33: {
                    n = 5;
                    break;
                }
                case 34: {
                    n = 6;
                    break;
                }
                case 35: {
                    n = 8;
                    break;
                }
                case 36: {
                    n = 7;
                    break;
                }
                case 37: {
                    n = 3;
                    break;
                }
                case 38: {
                    n = 1;
                    break;
                }
                case 39: {
                    n = 4;
                    break;
                }
                case 40: {
                    n = 2;
                    break;
                }
                case 106: {
                    n = 42;
                    break;
                }
                case 107: {
                    n = 43;
                    break;
                }
                case 109: {
                    n = 45;
                    break;
                }
                case 110: {
                    n = 46;
                    break;
                }
                case 111: {
                    n = 47;
                    break;
                }
                case 187: {
                    n = 61;
                    break;
                }
                case 188: {
                    n = 44;
                    break;
                }
                case 189: {
                    n = 45;
                    break;
                }
                case 190: {
                    n = 46;
                }
            }
        }
        return n;
    }
}

