/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt.devutils;

import emulator.Utils;
import emulator.ui.swt.devutils.ClasspathEntryType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClasspathEntry {
    public final String path;
    public final ClasspathEntryType type;
    public final boolean isLocalPath;

    public ClasspathEntry(String path, ClasspathEntryType type, boolean localPath) {
        this.path = path;
        this.type = type;
        this.isLocalPath = localPath;
    }

    public ClasspathEntry(String path, ClasspathEntryType type) {
        this.path = path;
        this.type = type;
        this.isLocalPath = !Utils.isPathAbsolute(path);
    }

    public boolean isSourceCode() {
        return this.type == ClasspathEntryType.Source || this.type == ClasspathEntryType.LibrarySource;
    }

    public boolean isJar() {
        return this.type == ClasspathEntryType.HeaderLibrary || this.type == ClasspathEntryType.ExportedLibrary;
    }

    public Path getAbsolutePath(Path projectRoot) {
        if (this.isLocalPath) {
            return projectRoot.resolve(this.path).normalize();
        }
        return Paths.get(this.path, new String[0]);
    }

    public static ClasspathEntry[] readAnything(Path projectDir) throws ParserConfigurationException, IOException, SAXException {
        Path eclipse = projectDir.resolve(".classpath");
        if (Files.exists(eclipse, new LinkOption[0])) {
            System.out.println("Found eclipse classpath, parsing...");
            return ClasspathEntry.readFromEclipse(eclipse);
        }
        Path iml = ClasspathEntry.findImlAt(projectDir);
        if (iml != null) {
            System.out.println("Found IDEA module, parsing...");
            return ClasspathEntry.readFromIml(iml);
        }
        System.out.println("Found no configurations, thinking up project structure from files...");
        return ClasspathEntry.readFromConfigless(projectDir);
    }

    public static ClasspathEntry[] readFromEclipse(Path eclipseClasspath) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ArrayList<ClasspathEntry> list2 = new ArrayList<ClasspathEntry>();
        Document inputDoc = builder.parse(eclipseClasspath.toFile());
        NodeList entries = inputDoc.getElementsByTagName("classpathentry");
        for (int i2 = 0; i2 < entries.getLength(); ++i2) {
            Element entry = (Element)entries.item(i2);
            String kind = entry.getAttribute("kind");
            String path = entry.getAttribute("path");
            if ("src".equals(kind)) {
                if (path.endsWith("res")) {
                    list2.add(new ClasspathEntry(path, ClasspathEntryType.Resource));
                    continue;
                }
                if (path.startsWith("lib")) {
                    list2.add(new ClasspathEntry(path, ClasspathEntryType.LibrarySource));
                    continue;
                }
                list2.add(new ClasspathEntry(path, ClasspathEntryType.Source));
                continue;
            }
            if (!"lib".equals(kind)) continue;
            if ("true".equals(entry.getAttribute("exported"))) {
                list2.add(new ClasspathEntry(path, ClasspathEntryType.ExportedLibrary));
                continue;
            }
            list2.add(new ClasspathEntry(path, ClasspathEntryType.HeaderLibrary));
        }
        return list2.toArray(new ClasspathEntry[0]);
    }

    public static ClasspathEntry[] readFromIml(Path imlPath) throws ParserConfigurationException, IOException, SAXException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(imlPath.toFile());
        ArrayList<ClasspathEntry> list2 = new ArrayList<ClasspathEntry>();
        NodeList orderEntries = doc.getElementsByTagName("orderEntry");
        for (int i2 = 0; i2 < orderEntries.getLength(); ++i2) {
            Element orderEntry = (Element)orderEntries.item(i2);
            if (!"module-library".equals(orderEntry.getAttribute("type"))) continue;
            ClasspathEntryType entryType = orderEntry.hasAttribute("exported") && orderEntry.getAttribute("exported").isEmpty() ? ClasspathEntryType.ExportedLibrary : ClasspathEntryType.HeaderLibrary;
            Element library = (Element)orderEntry.getElementsByTagName("library").item(0);
            Element classes = (Element)library.getElementsByTagName("CLASSES").item(0);
            NodeList roots = classes.getElementsByTagName("root");
            for (int i1 = 0; i1 < roots.getLength(); ++i1) {
                String path;
                Element root = (Element)roots.item(i1);
                String url = root.getAttribute("url");
                if (url.startsWith("jar://$MODULE_DIR$/")) {
                    path = url.substring("jar://$MODULE_DIR$/".length(), url.length() - 2);
                    list2.add(new ClasspathEntry(path, entryType, true));
                    continue;
                }
                if (url.startsWith("jar://")) {
                    path = url.substring("jar://".length(), url.length() - 2);
                    list2.add(new ClasspathEntry(path, entryType, false));
                    continue;
                }
                throw new RuntimeException("Unknown library entry: " + url);
            }
        }
        NodeList sourceEntries = doc.getElementsByTagName("sourceFolder");
        for (int i3 = 0; i3 < sourceEntries.getLength(); ++i3) {
            Element sourceFolder = (Element)sourceEntries.item(i3);
            String url = sourceFolder.getAttribute("url");
            if (url.startsWith("file://$MODULE_DIR$/")) {
                url = url.substring("file://$MODULE_DIR$/".length());
            } else if (url.startsWith("file://")) {
                url = url.substring("file://".length());
            } else {
                throw new IllegalArgumentException("Unknown source folder entry: " + url);
            }
            if (sourceFolder.getAttribute("type").equals("java-resource")) {
                list2.add(new ClasspathEntry(url, ClasspathEntryType.Resource));
                continue;
            }
            if (url.startsWith("lib")) {
                list2.add(new ClasspathEntry(url, ClasspathEntryType.LibrarySource));
                continue;
            }
            list2.add(new ClasspathEntry(url, ClasspathEntryType.Source));
        }
        return list2.toArray(new ClasspathEntry[0]);
    }

    public static ClasspathEntry[] readFromConfigless(Path projectRoot) {
        Path libs;
        File[] files;
        ArrayList<ClasspathEntry> list2 = new ArrayList<ClasspathEntry>();
        list2.add(new ClasspathEntry("src", ClasspathEntryType.Source, true));
        if (Files.exists(projectRoot.resolve("res"), new LinkOption[0])) {
            list2.add(new ClasspathEntry("res", ClasspathEntryType.Resource, true));
        }
        if ((files = (libs = projectRoot.resolve("lib")).toFile().listFiles()) != null) {
            for (File c2 : files) {
                if (c2.isFile() && c2.getName().endsWith(".jar")) {
                    list2.add(new ClasspathEntry("lib/" + c2.getName(), ClasspathEntryType.ExportedLibrary, true));
                }
                if (!c2.isDirectory()) continue;
                if (Files.exists(projectRoot.resolve("lib").resolve(c2.getName()).resolve("src"), new LinkOption[0])) {
                    list2.add(new ClasspathEntry("lib/" + c2.getName() + "/src", ClasspathEntryType.LibrarySource, true));
                }
                if (!Files.exists(projectRoot.resolve("lib").resolve(c2.getName()).resolve("res"), new LinkOption[0])) continue;
                list2.add(new ClasspathEntry("lib/" + c2.getName() + "/res", ClasspathEntryType.Resource, true));
            }
        }
        return list2.toArray(new ClasspathEntry[0]);
    }

    public static Path findImlAt(Path projectDir) {
        Path imlPath = null;
        for (File file : projectDir.toFile().listFiles()) {
            if (!file.getName().endsWith(".iml")) continue;
            if (imlPath != null) {
                throw new IllegalArgumentException("KEmulator-based IDEA projects are expected to have single IML file, two found.");
            }
            imlPath = Paths.get(file.getAbsolutePath(), new String[0]);
        }
        return imlPath;
    }
}

