/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt.devutils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class JavaTypeValidator {
    private static final Set<String> JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"));

    public static boolean isValidJavaTypeName(String name) {
        String[] parts;
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (name.startsWith("java.") || name.startsWith("javax.")) {
            return false;
        }
        if (name.startsWith(".") || name.endsWith(".")) {
            return false;
        }
        for (String part : parts = name.split("\\.")) {
            if (part.isEmpty()) {
                return false;
            }
            if (JAVA_KEYWORDS.contains(part)) {
                return false;
            }
            char firstChar = part.charAt(0);
            if (firstChar >= '0' && firstChar <= '9') {
                return false;
            }
            for (int i2 = 0; i2 < part.length(); ++i2) {
                boolean isValidChar;
                char c2 = part.charAt(i2);
                boolean bl = isValidChar = c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9';
                if (isValidChar) continue;
                return false;
            }
        }
        return true;
    }
}

