/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt.devutils.idea;

import emulator.Emulator;
import emulator.Settings;
import emulator.Utils;
import emulator.ui.swt.devutils.idea.IdeaSetupWindows;
import emulator.ui.swt.devutils.idea.IdeaSetupXdgLinux;
import emulator.ui.swt.devutils.idea.IdeaUtils;
import emulator.ui.swt.devutils.idea.JdkTablePatcher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public abstract class IdeaSetup
implements DisposeListener,
SelectionListener {
    public static final String JAVADOCS_DEFAULT_PATH = "/usr/share/doc/j2me";
    public static final String PROGUARD_URL = "https://nnproject.cc/dl/d/proguard.zip";
    public static final String JAVADOCS_URL = "https://github.com/nikita36078/J2ME_Docs/archive/refs/heads/master.zip";
    public static final String PROGUARD_DEFAULT_PATH_UNIX = "/opt/proguard6.2.2/proguard.jar";
    public static final String PROGUARD_AUR_PATH_UNIX = "/usr/share/proguard/proguard.jar";
    public static final String DEB_DEFAULT_JDK = "/usr/lib/jvm/java-8-openjdk";
    public static final String RPM_DEFAULT_JDK = "/usr/lib/jvm/java-1.8-openjdk";
    private boolean didInstallation = false;
    private boolean useOnlineDocs = false;
    private String localDocsPath;
    private String jdkHome = null;
    private String invalidJdkHome = null;
    private final Shell shell;
    private final Shell parent;
    private Button chooseIdeaManuallyBtn;
    private Button refreshInstalledListBtn;
    private Link nnchanProguardBtn;
    private Link githubProguardBtn;
    private Button selectProguardBtn;
    private Link ideaDownloadLink;
    private Link jmeDocsBtn;
    private Button selectJmeDocsBtn;
    private Button manualConfigBtn;
    private StyledText log;
    private Button proguardAutoBtn;
    private Button installDocsToUsr;
    private final Path proguardDefaultLocalPath = Paths.get(Emulator.getAbsolutePath(), "proguard.jar");
    private Button proguardAutoLocalBtn;
    private Button useOnlineDocsBtn;
    private Button selectJdkBtn;
    private Link oracleJdk;
    private Link pkgJdk;

    public IdeaSetup(Shell parent) {
        if (Settings.ideaJdkTablePatched) {
            throw new RuntimeException("Attempt to run setup when not needed.");
        }
        this.parent = parent;
        this.shell = new Shell(parent, 1264);
        this.shell.setText("Intellij IDEA setup");
        this.shell.addDisposeListener((DisposeListener)this);
        this.shell.setMinimumSize(450, 600);
        this.shell.setSize(450, 600);
        GridLayout layout = new GridLayout(1, true);
        this.shell.setLayout((Layout)layout);
    }

    private GridData genGd() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    private RowLayout genGLo() {
        RowLayout l = new RowLayout(512);
        l.spacing = 5;
        return l;
    }

    public void open() {
        this.refreshContent();
        this.shell.open();
    }

    private void refreshContent() {
        for (Control c2 : this.shell.getChildren()) {
            c2.dispose();
        }
        if (Settings.ideaJdkTablePatched) {
            throw new RuntimeException("Attempt to run setup when not needed.");
        }
        if (Utils.macos) {
            new Label((Composite)this.shell, 0).setText("Mac OS is not supported yet. Reach us to become a tester!");
            this.shell.layout(true, true);
            return;
        }
        if (!Files.exists(Paths.get(Emulator.getAbsolutePath(), new String[0]).resolve("uei"), new LinkOption[0])) {
            new Label((Composite)this.shell, 0).setText("UEI directory is missing in your KEmulator setup.");
            new Label((Composite)this.shell, 0).setText("It contains libraries for your IDE.");
            new Label((Composite)this.shell, 0).setText("Find a KEmulator distribution package with them.");
            this.shell.layout(true, true);
            return;
        }
        if (JdkTablePatcher.getDevTimeJars().isEmpty()) {
            new Label((Composite)this.shell, 0).setText("No UEI libraries found.");
            new Label((Composite)this.shell, 0).setText("Find a KEmulator distribution package with them.");
            this.shell.layout(true, true);
            return;
        }
        if (Settings.proguardPath == null) {
            if (Files.exists(this.proguardDefaultLocalPath, new LinkOption[0])) {
                Settings.proguardPath = this.proguardDefaultLocalPath.toString();
                this.refreshContent();
                return;
            }
            if (this instanceof IdeaSetupXdgLinux) {
                if (Files.exists(Paths.get(PROGUARD_DEFAULT_PATH_UNIX, new String[0]), new LinkOption[0])) {
                    Settings.proguardPath = PROGUARD_DEFAULT_PATH_UNIX;
                    this.refreshContent();
                    return;
                }
                if (Files.exists(Paths.get(PROGUARD_AUR_PATH_UNIX, new String[0]), new LinkOption[0])) {
                    Settings.proguardPath = PROGUARD_AUR_PATH_UNIX;
                    this.refreshContent();
                    return;
                }
            }
            this.makeProguardForm();
            this.shell.layout(true, true);
            return;
        }
        if (Settings.ideaPath == null) {
            Group findGroup = new Group((Composite)this.shell, 0);
            findGroup.setText("Find installed IDE");
            findGroup.setLayout((Layout)this.genGLo());
            findGroup.setLayoutData((Object)this.genGd());
            new Label((Composite)findGroup, 0).setText("Please choose an IDEA installation you are going to work with.");
            Set<String> existing = this.getIdeaInstallationPath();
            if (existing.isEmpty()) {
                new Label((Composite)findGroup, 0).setText("Failed to automatically find any installed IDEAs!");
            } else {
                for (final String installation : existing) {
                    new Label((Composite)findGroup, 0).setText(" ");
                    new Label((Composite)findGroup, 0).setText(installation);
                    Button b2 = new Button((Composite)findGroup, 0x800000);
                    b2.setText("Use this");
                    b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            Settings.ideaPath = installation;
                            IdeaSetup.this.refreshContent();
                        }
                    });
                }
                new Label((Composite)findGroup, 0).setText(" ");
            }
            this.chooseIdeaManuallyBtn = new Button((Composite)findGroup, 8);
            this.chooseIdeaManuallyBtn.setText("Choose manually");
            this.chooseIdeaManuallyBtn.addSelectionListener((SelectionListener)this);
            Group installGroup = new Group((Composite)this.shell, 0);
            installGroup.setText("Install");
            installGroup.setLayout((Layout)this.genGLo());
            installGroup.setLayoutData((Object)this.genGd());
            if (this.didInstallation) {
                new Label((Composite)installGroup, 0).setText("If it didn't appear in list, make sure you created launch menu entry.");
                this.refreshInstalledListBtn = new Button((Composite)installGroup, 8);
                this.refreshInstalledListBtn.setText("Refresh again");
                this.refreshInstalledListBtn.addSelectionListener((SelectionListener)this);
            } else {
                new Label((Composite)installGroup, 0).setText("If you don't have one installed:");
                this.ideaDownloadLink = new Link((Composite)installGroup, 0);
                this.ideaDownloadLink.setText("1. Go to <a>download page</a>, grab a release and install it.");
                this.ideaDownloadLink.addSelectionListener((SelectionListener)this);
                if (this instanceof IdeaSetupXdgLinux) {
                    new Label((Composite)installGroup, 0).setText("2. Launch installed IDE.");
                } else {
                    new Label((Composite)installGroup, 0).setText("2. Launch installed IDE and create desktop shortcut.");
                }
                new Label((Composite)installGroup, 0).setText("3. Do NOT touch any settings related to JDKs. Close IDE and return here.");
                if (this instanceof IdeaSetupXdgLinux) {
                    this.refreshInstalledListBtn = new Button((Composite)installGroup, 8);
                    this.refreshInstalledListBtn.setText("I did it, refresh list of installed IDEs");
                    this.refreshInstalledListBtn.addSelectionListener((SelectionListener)this);
                } else {
                    new Label((Composite)installGroup, 0).setText("4. Select Intellij binary via button above.");
                }
            }
            this.shell.layout(true, true);
            return;
        }
        if (this.localDocsPath == null && !this.useOnlineDocs) {
            try {
                Path path2 = Paths.get(Emulator.getAbsolutePath(), "uei", "javadocs");
                IdeaSetup.checkDocsPathValid(path2);
                this.localDocsPath = path2.toAbsolutePath().toString();
                this.refreshContent();
                return;
            }
            catch (Exception path2) {
                if (this instanceof IdeaSetupXdgLinux) {
                    try {
                        IdeaSetup.checkDocsPathValid(Paths.get(JAVADOCS_DEFAULT_PATH, new String[0]));
                        this.localDocsPath = Paths.get(JAVADOCS_DEFAULT_PATH, new String[0]).toAbsolutePath().toString();
                        this.refreshContent();
                        return;
                    }
                    catch (Exception path2) {
                        // empty catch block
                    }
                }
                new Label((Composite)this.shell, 0).setText("UEI libs contain no javadocs. You need an external source of them.");
                Group jmeDocsGroup = new Group((Composite)this.shell, 0);
                jmeDocsGroup.setText("External javadocs: manual setup");
                jmeDocsGroup.setLayout((Layout)this.genGLo());
                jmeDocsGroup.setLayoutData((Object)this.genGd());
                new Label((Composite)jmeDocsGroup, 0).setText("1. Download them from one of the sources, or take from SDK.");
                this.jmeDocsBtn = new Link((Composite)jmeDocsGroup, 0);
                this.jmeDocsBtn.setText("<a>Nikita36068's repository</a>");
                this.jmeDocsBtn.addSelectionListener((SelectionListener)this);
                new Label((Composite)jmeDocsGroup, 0).setText("2. Select location where you placed them:");
                this.selectJmeDocsBtn = new Button((Composite)jmeDocsGroup, 8);
                this.selectJmeDocsBtn.setText("Choose documentation root");
                this.selectJmeDocsBtn.addSelectionListener((SelectionListener)this);
                Group autoGroup = new Group((Composite)this.shell, 0);
                autoGroup.setText("External javadocs: auto setup");
                autoGroup.setLayout((Layout)this.genGLo());
                autoGroup.setLayoutData((Object)this.genGd());
                if (this instanceof IdeaSetupXdgLinux) {
                    this.installDocsToUsr = new Button((Composite)autoGroup, 8);
                    this.installDocsToUsr.setText("Install to /usr/");
                    this.installDocsToUsr.addSelectionListener((SelectionListener)this);
                    new Label((Composite)autoGroup, 0).setText("Required tools: wget, unzip, rm, cp, pkexec.");
                } else {
                    new Label((Composite)autoGroup, 0).setText("Not available.");
                }
                Group onlineGroup = new Group((Composite)this.shell, 0);
                onlineGroup.setText("Online javadocs");
                onlineGroup.setLayout((Layout)this.genGLo());
                onlineGroup.setLayoutData((Object)this.genGd());
                this.useOnlineDocsBtn = new Button((Composite)onlineGroup, 8);
                this.useOnlineDocsBtn.setText("Use nikita36068's repo as web docs");
                this.useOnlineDocsBtn.addSelectionListener((SelectionListener)this);
                new Label((Composite)onlineGroup, 0).setText("Not all docs will be connected, only the most important ones.");
                this.shell.layout(true, true);
                return;
            }
        }
        if (this.jdkHome == null) {
            if (Utils.isJava9()) {
                new Label((Composite)this.shell, 0).setText("KEmulator is launched with java " + System.getProperty("java.version") + ".");
                new Label((Composite)this.shell, 0).setText("Please install JDK 1.8 and select it.");
                new Label((Composite)this.shell, 0).setText("You can run KEmulator with it for auto setup.");
            } else {
                String _jdkHome = Utils.getJdkHome();
                if (_jdkHome != null) {
                    this.jdkHome = _jdkHome;
                    this.refreshContent();
                    return;
                }
                new Label((Composite)this.shell, 0).setText("KEmulator is launched with JRE without JDK.");
                new Label((Composite)this.shell, 0).setText("Please install JDK 1.8 and select it.");
                new Label((Composite)this.shell, 0).setText("You can run KEmulator with it for auto setup.");
            }
            if (this instanceof IdeaSetupXdgLinux) {
                if (IdeaSetup.is8(DEB_DEFAULT_JDK)) {
                    this.jdkHome = DEB_DEFAULT_JDK;
                    this.refreshContent();
                    return;
                }
                if (IdeaSetup.is8(RPM_DEFAULT_JDK)) {
                    this.jdkHome = RPM_DEFAULT_JDK;
                    this.refreshContent();
                    return;
                }
            }
            if (this instanceof IdeaSetupWindows) {
                Path jdkLocs = Emulator.isX64() ? Paths.get("C:\\Program Files\\Java", new String[0]) : Paths.get("C:\\Program Files (x86)\\Java", new String[0]);
                for (File f2 : jdkLocs.toFile().listFiles()) {
                    String path = f2.getAbsolutePath();
                    if (!path.toLowerCase().contains("jdk") || !IdeaSetup.is8(path)) continue;
                    this.jdkHome = path;
                    this.refreshContent();
                    return;
                }
            }
            if (this instanceof IdeaSetupWindows) {
                Group jdkSetupGroup = new Group((Composite)this.shell, 0);
                jdkSetupGroup.setText("JDKs from PATH");
                jdkSetupGroup.setLayout((Layout)this.genGLo());
                jdkSetupGroup.setLayoutData((Object)this.genGd());
                String[] paths = System.getenv("PATH").split(";");
                boolean found = false;
                for (String path : paths) {
                    final Path ppath = Paths.get(path, new String[0]);
                    if (!Files.exists(ppath.resolve("java.exe"), new LinkOption[0]) || !Files.exists(ppath.resolve("javac.exe"), new LinkOption[0])) continue;
                    try {
                        if (!Utils.getProcessOutput(new String[]{ppath.resolve("java.exe").toAbsolutePath().toString(), "-version"}, true).contains("1.8.")) continue;
                        found = true;
                        Button b3 = new Button((Composite)jdkSetupGroup, 0x800000);
                        b3.setText(path);
                        b3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                IdeaSetup.this.jdkHome = ppath.getParent().toAbsolutePath().toString();
                                IdeaSetup.this.refreshContent();
                            }
                        });
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!found) {
                    new Label((Composite)jdkSetupGroup, 0).setText("Nothing found.");
                }
            }
            Group manualJdkSetupGroup = new Group((Composite)this.shell, 0);
            manualJdkSetupGroup.setText("Manual selection");
            manualJdkSetupGroup.setLayout((Layout)this.genGLo());
            manualJdkSetupGroup.setLayoutData((Object)this.genGd());
            this.selectJdkBtn = new Button((Composite)manualJdkSetupGroup, 8);
            this.selectJdkBtn.setText("Choose JDK home");
            this.selectJdkBtn.addSelectionListener((SelectionListener)this);
            if (this.invalidJdkHome != null) {
                Link ignoreVerMismatch = new Link((Composite)manualJdkSetupGroup, 0);
                ignoreVerMismatch.setText("<a>Ignore inappropriate version of last selected JDK and use it</a>");
                ignoreVerMismatch.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        IdeaSetup.this.jdkHome = IdeaSetup.this.invalidJdkHome;
                        IdeaSetup.this.invalidJdkHome = null;
                        IdeaSetup.this.refreshContent();
                    }
                });
                new Label((Composite)manualJdkSetupGroup, 0).setText("This will cause issues, make sure to fix your config later.");
            }
            this.oracleJdk = new Link((Composite)this.shell, 0);
            this.oracleJdk.setText("<a>Download from Oracle</a>");
            this.oracleJdk.addSelectionListener((SelectionListener)this);
            if (this instanceof IdeaSetupXdgLinux) {
                this.pkgJdk = new Link((Composite)this.shell, 0);
                this.pkgJdk.setText("<a>Search how to install a JDK from your repository</a>");
                this.pkgJdk.addSelectionListener((SelectionListener)this);
            }
            this.shell.layout(true, true);
            return;
        }
        new Label((Composite)this.shell, 0).setText("Select configuration folder that your IDEA uses:");
        new Label((Composite)this.shell, 0).setText(" ");
        IdeaDataFolder defaultFolderTemp = null;
        try {
            List<IdeaDataFolder> folders = this.getIdeaDataFolders();
            for (IdeaDataFolder folder : folders) {
                if (!folder.isDefault) continue;
                defaultFolderTemp = folder;
                break;
            }
            if (folders.isEmpty()) {
                new Label((Composite)this.shell, 0).setText("No config folders found!");
            } else {
                final IdeaDataFolder defaultFolder = defaultFolderTemp;
                if (defaultFolder != null) {
                    Group defaultGroup = new Group((Composite)this.shell, 0);
                    defaultGroup.setText("The most relevant");
                    defaultGroup.setLayout((Layout)this.genGLo());
                    defaultGroup.setLayoutData((Object)this.genGd());
                    new Label((Composite)defaultGroup, 0).setText("If you didn't touch IDEA's paths, this is yours.");
                    Button autoConfigBtn = new Button((Composite)defaultGroup, 8);
                    autoConfigBtn.setText("Choose \"" + defaultFolder.path.toAbsolutePath() + "\"");
                    autoConfigBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            String table = defaultFolder.path.resolve("options").resolve("jdk.table.xml").toString();
                            IdeaSetup.this.patchJdkTable(table);
                        }
                    });
                }
                if (folders.size() != (defaultFolder == null ? 0 : 1)) {
                    Group othersGroup = new Group((Composite)this.shell, 0);
                    othersGroup.setText("Other folders");
                    othersGroup.setLayout((Layout)this.genGLo());
                    othersGroup.setLayoutData((Object)this.genGd());
                    for (final IdeaDataFolder folder : folders) {
                        if (folder.isDefault) continue;
                        Link autoConfigBtn = new Link((Composite)othersGroup, 8);
                        autoConfigBtn.setText("<a>Choose</a> \"" + folder.path.toAbsolutePath() + "\"");
                        autoConfigBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                String table = folder.path.resolve("options").resolve("jdk.table.xml").toString();
                                IdeaSetup.this.patchJdkTable(table);
                            }
                        });
                    }
                }
            }
        }
        catch (IOException e2) {
            new Label((Composite)this.shell, 0).setText("Failed to automatically find config folder!");
            this.errorMsg("Failed to automatically find config folder!", e2.toString());
        }
        Group manualGroup = new Group((Composite)this.shell, 0);
        manualGroup.setText("Non-standard setup");
        manualGroup.setLayout((Layout)this.genGLo());
        manualGroup.setLayoutData((Object)this.genGd());
        new Label((Composite)manualGroup, 0).setText("1. Find config folder that your IDEA version uses.");
        new Label((Composite)manualGroup, 0).setText("2. Navigate to \"options\" subfolder and choose \"jdk.table.xml\" file.");
        this.manualConfigBtn = new Button((Composite)manualGroup, 8);
        this.manualConfigBtn.setText("Choose arbitrary config XML");
        this.manualConfigBtn.addSelectionListener((SelectionListener)this);
        this.shell.layout(true, true);
    }

    private void makeProguardForm() {
        new Label((Composite)this.shell, 0).setText("ProGuard is needed for packaging MIDlets into JARs.");
        Group pgGroup = new Group((Composite)this.shell, 0);
        pgGroup.setText("Manual setup");
        pgGroup.setLayout((Layout)this.genGLo());
        pgGroup.setLayoutData((Object)this.genGd());
        new Label((Composite)pgGroup, 0).setText("1. Download it from one of the sources.");
        this.nnchanProguardBtn = new Link((Composite)pgGroup, 0);
        this.nnchanProguardBtn.setText("<a>v6.2.2 from NNP archive</a> (recommended)");
        this.nnchanProguardBtn.addSelectionListener((SelectionListener)this);
        this.githubProguardBtn = new Link((Composite)pgGroup, 0);
        this.githubProguardBtn.setText("<a>Project's github</a>");
        this.githubProguardBtn.addSelectionListener((SelectionListener)this);
        new Label((Composite)pgGroup, 0).setText("2. Unpack the archive where you want and select main program file:");
        this.selectProguardBtn = new Button((Composite)pgGroup, 8);
        this.selectProguardBtn.setText("Choose proguard JAR");
        this.selectProguardBtn.addSelectionListener((SelectionListener)this);
        Group autoGroup = new Group((Composite)this.shell, 0);
        autoGroup.setText("Auto setup");
        autoGroup.setLayout((Layout)this.genGLo());
        autoGroup.setLayoutData((Object)this.genGd());
        boolean autoSetupAvailable = false;
        if (this instanceof IdeaSetupXdgLinux) {
            this.proguardAutoBtn = new Button((Composite)autoGroup, 8);
            this.proguardAutoBtn.setText("Install to /opt/");
            this.proguardAutoBtn.addSelectionListener((SelectionListener)this);
            new Label((Composite)autoGroup, 0).setText("Required tools: wget, rm, bash, unzip, install, pkexec.");
            autoSetupAvailable = true;
        }
        if (Emulator.isPortable) {
            this.proguardAutoLocalBtn = new Button((Composite)autoGroup, 8);
            this.proguardAutoLocalBtn.setText("Install to KEmulator folder");
            this.proguardAutoLocalBtn.addSelectionListener((SelectionListener)this);
            autoSetupAvailable = true;
        }
        if (!autoSetupAvailable) {
            new Label((Composite)autoGroup, 0).setText("Not available in your configuration.");
        }
    }

    private void makeLogWindow() {
        for (Control c2 : this.shell.getChildren()) {
            c2.dispose();
        }
        this.log = new StyledText((Composite)this.shell, 2632);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.log.setLayoutData((Object)gd);
        this.shell.layout(true, true);
    }

    public void widgetSelected(SelectionEvent e2) {
        block44: {
            if (e2.widget == this.ideaDownloadLink) {
                Emulator.openUrlExternallySilent("https://www.jetbrains.com/idea/download/");
            } else if (e2.widget == this.refreshInstalledListBtn) {
                this.didInstallation = true;
                this.refreshContent();
            } else if (e2.widget == this.chooseIdeaManuallyBtn) {
                this.chooseIdeaLauncherManually();
            } else if (e2.widget == this.githubProguardBtn) {
                Emulator.openUrlExternallySilent("https://github.com/Guardsquare/proguard/releases/");
            } else if (e2.widget == this.nnchanProguardBtn) {
                Emulator.openUrlExternallySilent(PROGUARD_URL);
            } else if (e2.widget == this.proguardAutoBtn) {
                this.makeLogWindow();
                new Thread(() -> {
                    try {
                        Settings.proguardPath = this.autoInstallProguard();
                        this.shell.getDisplay().syncExec(this::refreshContent);
                    }
                    catch (Exception ex) {
                        this.shell.getDisplay().syncExec(() -> this.errorMsg("Failed to install proguard", ex.getMessage()));
                        this.shell.getDisplay().syncExec(this::refreshContent);
                    }
                }).start();
            } else if (e2.widget == this.proguardAutoLocalBtn) {
                this.makeLogWindow();
                new Thread(() -> {
                    try {
                        this.autoInstallProguardLocally();
                        Settings.proguardPath = this.proguardDefaultLocalPath.toString();
                        this.shell.getDisplay().syncExec(this::refreshContent);
                    }
                    catch (Exception ex) {
                        this.shell.getDisplay().syncExec(() -> this.errorMsg("Failed to install proguard", ex.getMessage()));
                        this.shell.getDisplay().syncExec(this::refreshContent);
                    }
                }).start();
            } else if (e2.widget == this.selectProguardBtn) {
                FileDialog fd = new FileDialog(this.shell, 4096);
                fd.setText("Choose ProGuard JAR binary (\"path/proguard/lib/proguard.jar\")");
                fd.setFilterExtensions(new String[]{"proguard.jar"});
                String path = fd.open();
                if (path == null) {
                    return;
                }
                Settings.proguardPath = path;
                this.refreshContent();
            } else if (e2.widget == this.jmeDocsBtn) {
                Emulator.openUrlExternallySilent("https://github.com/nikita36078/J2ME_Docs/");
            } else if (e2.widget == this.selectJmeDocsBtn) {
                DirectoryDialog dd = new DirectoryDialog(this.shell, 4096);
                dd.setText("Choose \"docs\" folder");
                dd.setFilterPath("docs");
                String path = dd.open();
                if (path == null) {
                    return;
                }
                try {
                    IdeaSetup.checkDocsPathValid(Paths.get(path, new String[0]));
                    this.localDocsPath = path;
                    Settings.ideaJdkTablePatched = false;
                    this.refreshContent();
                }
                catch (IOException | RuntimeException ex) {
                    this.errorMsg("Documentation location", "Failed to find documentation file for \"MIDlet\" class. You are expected to choose \"docs\" folder, it contains subfolders for each jsr/api.");
                }
            } else if (e2.widget == this.installDocsToUsr) {
                this.makeLogWindow();
                new Thread(() -> {
                    try {
                        this.localDocsPath = this.autoInstallDocs();
                        Settings.ideaJdkTablePatched = false;
                        this.shell.getDisplay().syncExec(this::refreshContent);
                    }
                    catch (Exception ex) {
                        this.shell.getDisplay().syncExec(() -> this.errorMsg("Failed to install javadocs", ex.getMessage()));
                        this.shell.getDisplay().syncExec(this::refreshContent);
                    }
                }).start();
            } else if (e2.widget == this.useOnlineDocsBtn) {
                this.useOnlineDocs = true;
                Settings.ideaJdkTablePatched = false;
                this.refreshContent();
            } else if (e2.widget == this.manualConfigBtn) {
                FileDialog fd = new FileDialog(this.shell, 4096);
                fd.setText("Choose IDEA JDK table (\"IntelliJIdeaXXXX.Y/options/jdk.table.xml\")");
                fd.setFilterExtensions(new String[]{"jdk.table.xml"});
                String path = fd.open();
                if (path == null) {
                    return;
                }
                this.patchJdkTable(path);
            } else if (e2.widget == this.selectJdkBtn) {
                DirectoryDialog dd = new DirectoryDialog(this.shell, 4096);
                dd.setText("Choose JDK home folder");
                String path = dd.open();
                if (path == null) {
                    return;
                }
                Path ppath = Paths.get(path, new String[0]);
                if (Files.exists(ppath.resolve("bin").resolve(Utils.win ? "java.exe" : "java"), new LinkOption[0]) && Files.exists(ppath.resolve("bin").resolve(Utils.win ? "javac.exe" : "javac"), new LinkOption[0])) {
                    try {
                        String javaVer = Utils.getProcessOutput(new String[]{ppath.resolve("bin").resolve(Utils.win ? "java.exe" : "java").toAbsolutePath().toString(), "-version"}, true);
                        if (javaVer.contains("1.8.")) {
                            this.jdkHome = path;
                            this.refreshContent();
                            break block44;
                        }
                        this.errorMsg("JDK home", "Selected JDK says it's not 1.8.\n\n" + javaVer);
                        this.invalidJdkHome = path;
                        this.refreshContent();
                    }
                    catch (IOException ex) {
                        this.errorMsg("JDK home", "Failed to run java binary.");
                    }
                } else {
                    this.errorMsg("JDK home", "Selected folder is not JDK home. Select a folder with \"bin\", \"jre\", \"lib\" subfolders.");
                }
            } else if (e2.widget == this.oracleJdk) {
                Emulator.openUrlExternallySilent("https://www.oracle.com/java/technologies/javase/javase8u211-later-archive-downloads.html");
            } else if (e2.widget == this.pkgJdk) {
                try {
                    String distroName = Utils.getProcessOutput(new String[]{"/usr/bin/bash", "-c", "source /etc/os-release && echo $NAME"}, false).trim();
                    Emulator.openUrlExternallySilent("https://duckduckgo.com/?q=" + distroName.replace(" ", "+") + "+openjdk+1.8+package");
                }
                catch (IOException ex) {
                    this.errorMsg("Failed to get distro name", ex.toString());
                }
            }
        }
    }

    private static void checkDocsPathValid(Path path) throws IOException, RuntimeException {
        try (Stream<Path> list2 = Files.list(path);){
            long found = list2.filter(p -> Files.exists(p.resolve("javax").resolve("microedition").resolve("midlet").resolve("MIDlet.html"), new LinkOption[0])).count();
            if (found == 0L) {
                throw new RuntimeException();
            }
        }
    }

    private void patchJdkTable(String jdkTablePath) {
        Path lockFile = Paths.get(jdkTablePath, new String[0]).getParent().getParent().resolve(".lock");
        if (Files.exists(lockFile, new LinkOption[0])) {
            MessageBox mb = new MessageBox(this.shell, 1281);
            mb.setText("Config location");
            mb.setMessage("Your IntelliJ IDEA is running. Close it to continue, or else things will break. If you are absolutely sure that it is closed, choose \"Retry\" to continue.");
            if (mb.open() == 256) {
                this.refreshContent();
                return;
            }
        }
        try {
            block12: {
                JdkTablePatcher.updateJdkTable(jdkTablePath, this.useOnlineDocs ? null : this.localDocsPath, this.jdkHome);
                String repairer = Paths.get(Settings.ideaPath, new String[0]).getParent().resolve(Utils.win ? "repair.exe" : "repair").toAbsolutePath().toString();
                try {
                    Runtime.getRuntime().exec(new String[]{repairer, "caches", "--clear"}).waitFor();
                }
                catch (IOException ex) {
                    String defaultFolderName = IdeaSetup.getDefaultIdeaDataFolderName();
                    if (defaultFolderName == null) break block12;
                    try {
                        Path path;
                        if (Utils.win) {
                            path = Paths.get(System.getenv("LOCALAPPDATA") + "\\JetBrains\\" + defaultFolderName, new String[0]);
                            if (Files.exists(path, new LinkOption[0])) {
                                this.deleteRecursive(path.toFile());
                            } else {
                                throw new RuntimeException();
                            }
                        }
                        if (!Utils.linux) break block12;
                        path = Paths.get(System.getenv("HOME") + "/.cache/JetBrains/" + defaultFolderName, new String[0]);
                        if (Files.exists(path, new LinkOption[0])) {
                            Runtime.getRuntime().exec(new String[]{"/usr/bin/rm", "-rf", path.toAbsolutePath().toString()}).waitFor();
                        }
                        throw new RuntimeException();
                    }
                    catch (Exception ignored) {
                        this.errorMsg("Failed to clear caches", "If your IDE behaves wrong, try do that via \"File > Invalidate caches...\" menu there. Everything else is done successfully, you may get to work.");
                    }
                }
            }
            Settings.ideaJdkTablePatched = true;
        }
        catch (Exception ex) {
            this.errorMsg("Config patch", "Failed to modify config table. Logs may help you.\n\nException: " + ex);
            this.refreshContent();
            return;
        }
        this.shell.close();
        this.shell.dispose();
        IdeaUtils.open(this.parent);
    }

    private void chooseIdeaLauncherManually() {
        FileDialog fd = new FileDialog(this.shell, 4096);
        fd.setText("Choose IDEA binary (\"idea\", \"idea.exe\" or \"idea.sh\")");
        if (Utils.win) {
            fd.setFilterExtensions(new String[]{"idea*.exe", "idea*.bat"});
        } else if (Utils.linux) {
            fd.setFilterExtensions(new String[]{"idea", "idea*.sh"});
        }
        String path = fd.open();
        if (path == null) {
            return;
        }
        Settings.ideaPath = path;
        this.refreshContent();
    }

    public void widgetDefaultSelected(SelectionEvent e2) {
    }

    public void widgetDisposed(DisposeEvent e2) {
    }

    protected abstract Set<String> getIdeaInstallationPath();

    protected abstract Path getJetBrainsDataRoot();

    protected abstract String autoInstallProguard() throws IOException, InterruptedException;

    protected abstract String autoInstallDocs() throws IOException, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void autoInstallProguardLocally() throws IOException {
        Path tempZip;
        Object tmp;
        if (!Emulator.isPortable) {
            throw new UnsupportedOperationException();
        }
        if (this instanceof IdeaSetupWindows) {
            Path appData = Paths.get(System.getenv("APPDATA"), new String[0]).toAbsolutePath();
            tmp = appData.getParent().resolve("Local").resolve("Temp");
            tempZip = Files.createTempFile((Path)tmp, "proguard", ".zip", new FileAttribute[0]).toAbsolutePath();
        } else {
            tempZip = Files.createTempFile("proguard", ".zip", new FileAttribute[0]).toAbsolutePath();
        }
        try {
            this.appendLog("Downloading manually, wait...\n");
            InputStream in = new URL(PROGUARD_URL).openStream();
            tmp = null;
            try {
                Files.copy(in, tempZip, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                tmp = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (tmp != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)tmp).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            this.appendLog("Installing...\n");
            ZipFile zipFile = new ZipFile(tempZip.toString());
            ZipEntry entry = zipFile.getEntry("proguard6.2.2/lib/proguard.jar");
            if (entry == null) {
                throw new IOException("Broken archive");
            }
            try (InputStream entryStream = zipFile.getInputStream(entry);){
                Files.copy(entryStream, this.proguardDefaultLocalPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        finally {
            try {
                Files.deleteIfExists(tempZip);
            }
            catch (IOException iOException) {}
        }
    }

    protected void appendLog(char c2) {
        this.shell.getDisplay().asyncExec(() -> this.log.append(String.valueOf(c2)));
    }

    protected void appendLog(String s) {
        this.shell.getDisplay().asyncExec(() -> this.log.append(s));
    }

    private void errorMsg(String header, String text) {
        MessageBox mb = new MessageBox(this.shell, 33);
        mb.setText(header);
        mb.setMessage(text);
        mb.open();
    }

    protected static String getDefaultIdeaDataFolderName() throws IOException {
        Path infoPath = Settings.ideaPath.equals("/usr/bin/idea") ? Paths.get("/usr/share/idea/product-info.json", new String[0]) : Paths.get(Settings.ideaPath, new String[0]).getParent().getParent().resolve("product-info.json");
        String content = String.join((CharSequence)"", Files.readAllLines(infoPath));
        Pattern pattern = Pattern.compile("\"dataDirectoryName\"\\s*:\\s*\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    protected static boolean is8(String jdkHome) {
        Path bin = Paths.get(jdkHome, new String[0]).resolve("bin").resolve(Utils.win ? "java.exe" : "java").toAbsolutePath();
        if (!Files.exists(bin, new LinkOption[0])) {
            return false;
        }
        try {
            return Utils.getProcessOutput(new String[]{bin.toString(), "-version"}, true).contains("1.8.");
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private void deleteRecursive(File f2) {
        if (f2.isDirectory()) {
            for (File c2 : f2.listFiles()) {
                this.deleteRecursive(c2);
            }
        }
        f2.delete();
    }

    protected List<IdeaDataFolder> getIdeaDataFolders() throws IOException {
        String defaultName = IdeaSetup.getDefaultIdeaDataFolderName();
        try (Stream<Path> list2 = Files.list(this.getJetBrainsDataRoot());){
            List<IdeaDataFolder> list3 = list2.filter(p -> {
                String name = p.getFileName().toString();
                if (name.toLowerCase().contains("idea")) {
                    return true;
                }
                if (defaultName == null) {
                    return false;
                }
                return name.equalsIgnoreCase(defaultName);
            }).map(p -> new IdeaDataFolder((Path)p, p.getFileName().toString().equalsIgnoreCase(defaultName))).collect(Collectors.toList());
            return list3;
        }
    }

    protected static class IdeaDataFolder {
        public final Path path;
        public final boolean isDefault;

        public IdeaDataFolder(Path path, boolean isDefault) {
            this.path = path;
            this.isDefault = isDefault;
        }
    }
}

