/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt.devutils.idea;

import emulator.Utils;
import emulator.ui.swt.devutils.idea.IdeaSetup;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.swt.widgets.Shell;

public class IdeaSetupWindows
extends IdeaSetup {
    public IdeaSetupWindows(Shell parent) {
        super(parent);
    }

    @Override
    protected Set<String> getIdeaInstallationPath() {
        HashSet<String> set = new HashSet<String>();
        IdeaSetupWindows.checkStartMenuShortcuts(set);
        return set;
    }

    @Override
    protected Path getJetBrainsDataRoot() {
        return Paths.get(System.getenv("USERPROFILE"), "AppData", "Roaming", "JetBrains");
    }

    @Override
    protected String autoInstallProguard() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected String autoInstallDocs() throws IOException, InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static void checkStartMenuShortcuts(Set<String> set) {
        String userProfile;
        ArrayList<Path> startMenuDirs = new ArrayList<Path>();
        String programData = System.getenv("ProgramData");
        if (programData != null) {
            startMenuDirs.add(Paths.get(programData, "Microsoft", "Windows", "Start Menu", "Programs"));
        }
        if ((userProfile = System.getenv("USERPROFILE")) != null) {
            startMenuDirs.add(Paths.get(userProfile, "AppData", "Roaming", "Microsoft", "Windows", "Start Menu", "Programs"));
        }
        for (Path dir : startMenuDirs) {
            if (!Files.exists(dir, new LinkOption[0])) continue;
            try {
                String dirPath = dir.toString().replace("'", "''");
                String powershellCommand = "$shell = New-Object -ComObject WScript.Shell; Get-ChildItem -Path '" + dirPath + "' -Recurse -Filter *.lnk | ForEach-Object {     try {         $sc = $shell.CreateShortcut($_.FullName);         $targetPath = $sc.TargetPath;         if ($targetPath -match '\\\\(idea64|idea)\\.exe$') {             if (Test-Path -LiteralPath $targetPath -PathType Leaf) {                 $targetPath             }         }     } catch {} }";
                String output = Utils.getProcessOutput(new String[]{"powershell", "-Command", powershellCommand}, false);
                for (String i2 : output.split("[\\r\\n]+")) {
                    if ((i2 = i2.trim()).isEmpty()) continue;
                    set.add(i2);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private static void checkToolboxPaths(Set<String> set) {
        String localAppData = System.getenv("LOCALAPPDATA");
        if (localAppData == null) {
            return;
        }
        Path toolboxDir = Paths.get(localAppData, "JetBrains", "Toolbox", "apps", "IDEA");
        if (!Files.exists(toolboxDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.list(toolboxDir);){
            String path = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(dir -> dir.resolve("bin").resolve("idea.exe")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toString).findFirst().orElse(null);
            try {
                if (path != null) {
                    set.add(path);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

