/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt.devutils.idea;

import emulator.Utils;
import emulator.ui.swt.devutils.idea.IdeaSetup;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.swt.widgets.Shell;

public class IdeaSetupXdgLinux
extends IdeaSetup {
    public IdeaSetupXdgLinux(Shell parent) {
        super(parent);
    }

    @Override
    protected Set<String> getIdeaInstallationPath() {
        HashSet<String> set = new HashSet<String>();
        IdeaSetupXdgLinux.checkPath(set);
        IdeaSetupXdgLinux.checkDesktopFiles(set);
        return set;
    }

    @Override
    protected Path getJetBrainsDataRoot() {
        String cfgFolder = System.getenv("XDG_CONFIG_HOME");
        if (cfgFolder == null) {
            cfgFolder = System.getenv("HOME") + "/.config";
        }
        return Paths.get(cfgFolder + "/JetBrains", new String[0]);
    }

    @Override
    protected String autoInstallProguard() throws IOException, InterruptedException {
        if (Files.exists(Paths.get("/opt/proguard6.2.2", new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("Folder \"/opt/proguard6.2.2\" already exists. Maybe you already installed it?");
        }
        String tempZipName = "/tmp/proguard" + System.currentTimeMillis() + ".zip";
        String tempFolderName = "/tmp/proguard" + System.currentTimeMillis() + "_ext";
        this.appendLog("Downloading with wget, wait...\n");
        this.downloadWithWget("https://nnproject.cc/dl/d/proguard.zip", tempZipName);
        this.appendLog("\nExtracting archive...\n");
        this.unzip(tempZipName, tempFolderName);
        this.appendLog("\nRunning installation...\n");
        Process pkexec = Runtime.getRuntime().exec(new String[]{"/usr/bin/pkexec", "bash", "-c", "/usr/bin/install -Dm644 " + tempFolderName + "/proguard6.2.2/lib/* -t /opt/proguard6.2.2/"});
        if (pkexec.waitFor() != 0) {
            throw new RuntimeException("pkexec or install failed, code: " + pkexec.exitValue());
        }
        this.appendLog("\nDeleting caches...\n");
        Runtime.getRuntime().exec(new String[]{"/usr/bin/rm", "-rf", tempFolderName}).waitFor();
        Runtime.getRuntime().exec(new String[]{"/usr/bin/rm", tempZipName}).waitFor();
        return "/opt/proguard6.2.2/proguard.jar";
    }

    @Override
    protected String autoInstallDocs() throws IOException, InterruptedException {
        if (Files.exists(Paths.get("/usr/share/doc/j2me", new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("Folder \"/usr/share/doc/j2me\" already exists. Maybe you already installed it?");
        }
        String tempZipName = "/tmp/j2medocs" + System.currentTimeMillis() + ".zip";
        String tempFolderName = "/tmp/j2medocs" + System.currentTimeMillis() + "_ext";
        this.appendLog("Downloading with wget, wait...\n");
        this.downloadWithWget("https://github.com/nikita36078/J2ME_Docs/archive/refs/heads/master.zip", tempZipName);
        this.appendLog("\nExtracting archive...\n");
        this.unzip(tempZipName, tempFolderName);
        this.appendLog("\nDeleting unneeded docs...\n");
        Runtime.getRuntime().exec(new String[]{"/usr/bin/rm", "-rf", tempFolderName + "/J2ME_Docs-master/docs/BlackBerry_API_7_1_0"}).waitFor();
        Runtime.getRuntime().exec(new String[]{"/usr/bin/rm", "-rf", tempFolderName + "/J2ME_Docs-master/docs/midp-3_0-fr-javadoc"}).waitFor();
        this.appendLog("\nRunning installation...\n");
        int c2 = Runtime.getRuntime().exec(new String[]{"/usr/bin/pkexec", "/usr/bin/cp", "-r", tempFolderName + "/J2ME_Docs-master/docs/", "/usr/share/doc/j2me"}).waitFor();
        if (c2 != 0) {
            throw new RuntimeException("pkexec or cp failed, code: " + c2);
        }
        this.appendLog("\nDeleting caches...\n");
        Runtime.getRuntime().exec(new String[]{"/usr/bin/rm", "-rf", tempFolderName}).waitFor();
        Runtime.getRuntime().exec(new String[]{"/usr/bin/rm", tempZipName}).waitFor();
        return "/usr/share/doc/j2me";
    }

    private void downloadWithWget(String from, String to) throws IOException, InterruptedException {
        Process wget = Runtime.getRuntime().exec(new String[]{"/usr/bin/wget", "-v", "-O", to, from});
        try (InputStream is = wget.getInputStream();){
            int c2;
            while ((c2 = is.read()) != -1) {
                this.appendLog((char)c2);
            }
        }
        switch (wget.waitFor()) {
            case 0: {
                break;
            }
            case 3: {
                throw new IOException("I/O error when writing downloaded file");
            }
            case 4: {
                throw new IOException("Network error");
            }
            default: {
                throw new RuntimeException("wget failed with exit code: " + wget.exitValue());
            }
        }
    }

    private void unzip(String zip, String target) throws IOException, InterruptedException {
        Process unzip = Runtime.getRuntime().exec(new String[]{"/usr/bin/unzip", "-q", zip, "-d", target});
        try (InputStream is = unzip.getInputStream();){
            int c2;
            while ((c2 = is.read()) != -1) {
                this.appendLog((char)c2);
            }
        }
        unzip.waitFor();
        if (unzip.exitValue() != 0) {
            throw new RuntimeException("unzip failed, code: " + unzip.exitValue());
        }
    }

    private static void checkPath(Set<String> set) {
        String pathEnv = System.getenv("PATH");
        if (pathEnv == null) {
            return;
        }
        for (String root : pathEnv.split(":")) {
            File f2 = new File(root, "idea");
            if (!f2.exists()) continue;
            set.add(f2.getAbsolutePath());
        }
    }

    private static void checkDesktopFiles(Set<String> set) {
        Path[] appDirs;
        for (Path dir : appDirs = new Path[]{Paths.get("/usr/share/applications", new String[0]), Paths.get(System.getProperty("user.home"), ".local/share/applications")}) {
            if (!Files.exists(dir, new LinkOption[0])) continue;
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                List all = stream.filter(p -> p.toString().endsWith(".desktop")).collect(Collectors.toList());
                for (Path path : all) {
                    String binPath = IdeaSetupXdgLinux.parseExecFromDesktopFile(path);
                    if (binPath == null || !binPath.endsWith("idea") && !binPath.endsWith("idea.sh") && !binPath.endsWith("idea64.sh")) continue;
                    set.add(binPath);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String parseExecFromDesktopFile(Path desktopFile) {
        try {
            List<String> lines = Files.readAllLines(desktopFile);
            for (String line : lines) {
                File exeFile;
                String execLine;
                if (!line.startsWith("Exec=") || !(execLine = line.substring(5).split(" ")[0].replace("%f", "").replace("%F", "").trim()).startsWith("\"") || !(execLine = execLine.substring(1, execLine.indexOf(34, 1))).startsWith("/") || !(exeFile = new File(execLine)).exists()) continue;
                return exeFile.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void checkStandardLocations(Set<String> set) {
        String[] locations;
        for (String location : locations = new String[]{"/opt", System.getProperty("user.home") + "/.local/share/JetBrains", System.getProperty("user.home") + "/opt"}) {
            File root = new File(location);
            if (!root.exists()) continue;
            try (Stream<Path> stream = Files.walk(root.toPath(), new FileVisitOption[0]);){
                List result = stream.filter(p -> p.getFileName() != null && p.getFileName().toString().matches("idea?")).map(p -> p.toAbsolutePath().toString()).filter(path -> path.contains("bin")).collect(Collectors.toList());
                for (String path2 : result) {
                    set.add(path2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static String getVersion(String path) throws IOException {
        String[] output = Utils.getProcessOutput(new String[]{path, "--version"}, false).split(System.lineSeparator());
        String ver = null;
        for (String line : output) {
            if (!line.startsWith("IntelliJ")) continue;
            ver = line;
            break;
        }
        if (ver == null) {
            throw new IllegalArgumentException();
        }
        return ver;
    }
}

