/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt.devutils.idea;

import emulator.Emulator;
import emulator.Settings;
import emulator.Utils;
import emulator.ui.swt.devutils.JavaTypeValidator;
import emulator.ui.swt.devutils.idea.IdeaSetupWindows;
import emulator.ui.swt.devutils.idea.IdeaSetupXdgLinux;
import emulator.ui.swt.devutils.idea.JdkTablePatcher;
import emulator.ui.swt.devutils.idea.ProjectGenerator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IdeaUtils
implements SelectionListener,
ModifyListener {
    private final Shell shell;
    private final Shell parent;
    private final Button chooseEclipse;
    private final Text projectName;
    private final Text midletClassName;
    private final Text midletName;
    private final Text reposPath;
    private final Button chooseProjectsPath;
    private final Button createProject;
    private final Button fixClonedBtn;
    private final Button restartSetup;
    private final Label creationStatus;
    private final Group createNewProject;
    private final Link docsLink;

    IdeaUtils(Shell parent) {
        if (!Settings.ideaJdkTablePatched) {
            throw new RuntimeException("Attempt to open utils window when IDE is not configured.");
        }
        this.parent = parent;
        this.shell = new Shell(parent, 1264);
        this.shell.setText("Intellij IDEA support");
        this.shell.setMinimumSize(450, 600);
        this.shell.setSize(450, 600);
        GridLayout layout = new GridLayout(1, true);
        this.shell.setLayout((Layout)layout);
        Group fixupIdeaClonedProject = new Group((Composite)this.shell, 0);
        fixupIdeaClonedProject.setText("Fix a project after clone");
        fixupIdeaClonedProject.setLayout((Layout)this.genGLo());
        fixupIdeaClonedProject.setLayoutData((Object)this.genGd());
        new Label((Composite)fixupIdeaClonedProject, 0).setText("Some files are gitignored by default because they contain absolute paths.");
        new Label((Composite)fixupIdeaClonedProject, 0).setText("They should be recreated if you downloaded someone's project.");
        this.fixClonedBtn = new Button((Composite)fixupIdeaClonedProject, 0x800000);
        this.fixClonedBtn.setText("Choose a project");
        this.fixClonedBtn.addSelectionListener((SelectionListener)this);
        this.createNewProject = new Group((Composite)this.shell, 0);
        this.createNewProject.setText("Create a new project");
        this.createNewProject.setLayout((Layout)this.genGLo());
        this.createNewProject.setLayoutData((Object)this.genGd());
        this.projectName = new Text((Composite)this.createNewProject, 2048);
        this.projectName.setMessage("Project name");
        this.projectName.setToolTipText("Name of folder, JAR file, various configurations. Only ASCII letters, numbers, hyphen and underscore allowed.\nExample: \"mahocart_midp\"");
        this.projectName.setLayoutData((Object)new RowData(400, -1));
        this.projectName.addModifyListener((ModifyListener)this);
        this.midletClassName = new Text((Composite)this.createNewProject, 2048);
        this.midletClassName.setMessage("MIDlet class name");
        this.midletClassName.setToolTipText("Full name of your MIDlet class. Must be valid java type name.\n\nExample: \"ru.symansel.mahocart.MahoCartMIDlet\"");
        this.midletClassName.setLayoutData((Object)new RowData(400, -1));
        this.midletClassName.addModifyListener((ModifyListener)this);
        this.midletName = new Text((Composite)this.createNewProject, 2048);
        this.midletName.setMessage("Readable MIDlet name");
        this.midletName.setToolTipText("Name of your MIDlet, shown to user. Can contain any symbols except commas, just make sure your target device has enough fonts to display the name.\n\nExample: \"\u041c\u0410\u0425\u041e\u041a\u0410\u0420\u0422\ud83d\udea8\ud83d\udea8\ud83d\udea8\"");
        this.midletName.setLayoutData((Object)new RowData(400, -1));
        this.midletName.addModifyListener((ModifyListener)this);
        this.reposPath = new Text((Composite)this.createNewProject, 2048);
        this.reposPath.setText(Settings.lastIdeaRepoPath);
        this.reposPath.setMessage("Project location");
        this.reposPath.setToolTipText("Location of folder where the project's folder will be created.\n\nExample: \"" + (Utils.linux ? "/mnt/projects/" : "D:\\projects\\") + "\"");
        this.reposPath.setLayoutData((Object)new RowData(400, -1));
        this.reposPath.addModifyListener((ModifyListener)this);
        this.chooseProjectsPath = new Button((Composite)this.createNewProject, 0x800000);
        this.chooseProjectsPath.setText("Choose location via file explorer");
        this.chooseProjectsPath.addSelectionListener((SelectionListener)this);
        this.createProject = new Button((Composite)this.createNewProject, 0x800000);
        this.createProject.setText("Create project");
        this.createProject.addSelectionListener((SelectionListener)this);
        this.createProject.setEnabled(false);
        this.creationStatus = new Label((Composite)this.createNewProject, 0);
        this.creationStatus.setText("Hover fields to see tooltips with details.");
        this.creationStatus.setSize(400, -1);
        Group convertGroup = new Group((Composite)this.shell, 0);
        convertGroup.setText("Convert a project");
        convertGroup.setLayout((Layout)this.genGLo());
        convertGroup.setLayoutData((Object)this.genGd());
        this.chooseEclipse = new Button((Composite)convertGroup, 0x800000);
        this.chooseEclipse.setText("Eclipse MTJ -> IDEA");
        this.chooseEclipse.addSelectionListener((SelectionListener)this);
        this.docsLink = new Link((Composite)convertGroup, 0);
        this.docsLink.setText("See <a>documentation</a> to learn limitations and known issues.");
        this.docsLink.addSelectionListener((SelectionListener)this);
        Group maintenanceGroup = new Group((Composite)this.shell, 0);
        maintenanceGroup.setText("Maintenance");
        maintenanceGroup.setLayout((Layout)this.genGLo());
        maintenanceGroup.setLayoutData((Object)this.genGd());
        this.restartSetup = new Button((Composite)maintenanceGroup, 8);
        this.restartSetup.setText("Reset all settings and run setup again");
        this.restartSetup.addSelectionListener((SelectionListener)this);
        this.shell.layout(true, true);
    }

    public static void open(Shell p) {
        if (Settings.ideaPath != null && !Files.exists(Paths.get(Settings.ideaPath, new String[0]), new LinkOption[0])) {
            Settings.ideaPath = null;
        }
        if (Settings.proguardPath != null && !Files.exists(Paths.get(Settings.proguardPath, new String[0]), new LinkOption[0])) {
            Settings.proguardPath = null;
        }
        if (!Files.exists(Paths.get(Emulator.getAbsolutePath(), new String[0]).resolve("uei"), new LinkOption[0])) {
            Settings.ideaJdkTablePatched = false;
        }
        if (JdkTablePatcher.getDevTimeJars().isEmpty()) {
            Settings.ideaJdkTablePatched = false;
        }
        if (Settings.ideaJdkTablePatched && Settings.ideaPath != null && Settings.proguardPath != null) {
            new IdeaUtils((Shell)p).shell.open();
        } else {
            Settings.ideaJdkTablePatched = false;
            if (Utils.linux) {
                new IdeaSetupXdgLinux(p).open();
            } else {
                new IdeaSetupWindows(p).open();
            }
        }
    }

    private GridData genGd() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    private RowLayout genGLo() {
        RowLayout l = new RowLayout(512);
        l.spacing = 5;
        return l;
    }

    private void errorMsg(String header, String text) {
        MessageBox mb = new MessageBox(this.shell, 33);
        mb.setText(header);
        mb.setMessage(text);
        mb.open();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private static boolean isValidRepoName(String input) {
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char c2 = input.charAt(i2);
            if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '_') continue;
            return false;
        }
        return true;
    }

    private static String validateInput(String repoName, String className, String appName, String location) {
        if (repoName.isEmpty()) {
            return "Project name must not be empty.";
        }
        if (!IdeaUtils.isValidRepoName(repoName)) {
            return "Project name must meet certain restrictions, check tooltip on the field.";
        }
        if (className.isEmpty()) {
            return "Class name must not be empty.";
        }
        if (!JavaTypeValidator.isValidJavaTypeName(className)) {
            return "Class name must be a valid Java class name.";
        }
        if (appName.isEmpty()) {
            return "MIDlet name must not be empty.";
        }
        if (appName.indexOf(44) != -1) {
            return "MIDlet name must not contain commas.";
        }
        if (location.isEmpty() || ".".equals(location)) {
            return "Specify location for the project";
        }
        if (!Files.exists(Paths.get(location, new String[0]), new LinkOption[0])) {
            return "Location for project doesn't exist.";
        }
        if (Files.exists(Paths.get(location, repoName), new LinkOption[0])) {
            return "Folder with the specified name already exists. Do something with it.";
        }
        return null;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String validation;
        String repoName = this.projectName.getText().trim();
        String className = this.midletClassName.getText().trim();
        String appName = this.midletName.getText().trim();
        String location = this.reposPath.getText().trim();
        if (location.endsWith("/") || location.endsWith("\\")) {
            location = location.substring(0, location.length() - 1);
        }
        if ((validation = IdeaUtils.validateInput(repoName, className, appName, location)) != null) {
            this.creationStatus.setText(validation);
        } else {
            this.creationStatus.setText("Code will be placed at " + Paths.get(location, repoName, "src"));
        }
        this.createProject.setEnabled(true);
        this.createNewProject.layout(true, true);
    }

    public void widgetSelected(SelectionEvent e2) {
        if (e2.widget == this.chooseProjectsPath) {
            DirectoryDialog dd = new DirectoryDialog(this.shell, 4096);
            dd.setText("Choose folder where you store your projects");
            String path = dd.open();
            if (path != null) {
                this.reposPath.setText(path);
            }
        } else if (e2.widget == this.createProject) {
            this.createProject();
        } else if (e2.widget == this.fixClonedBtn) {
            this.restoreProject();
        } else if (e2.widget == this.chooseEclipse) {
            this.convertProject();
        } else if (e2.widget == this.restartSetup) {
            Settings.ideaJdkTablePatched = false;
            Settings.proguardPath = null;
            Settings.ideaPath = null;
            this.shell.close();
            this.shell.dispose();
            IdeaUtils.open(this.parent);
        } else if (e2.widget == this.docsLink) {
            Emulator.openUrlExternallySilent("https://github.com/shinovon/KEmulator/blob/main/IdeaSupport.md");
        }
    }

    private void createProject() {
        String validation;
        String repoName = this.projectName.getText().trim();
        String className = this.midletClassName.getText().trim();
        String appName = this.midletName.getText().trim();
        String location = this.reposPath.getText().trim();
        if (location.endsWith("/") || location.endsWith("\\")) {
            location = location.substring(0, location.length() - 1);
        }
        if ((validation = IdeaUtils.validateInput(repoName, className, appName, location)) != null) {
            this.errorMsg("Project creation", validation);
            return;
        }
        try {
            String code = ProjectGenerator.create(location, repoName, className, appName);
            Settings.lastIdeaRepoPath = location;
            Runtime.getRuntime().exec(new String[]{Settings.ideaPath, Paths.get(location, repoName).toString(), code});
            this.shell.close();
            this.shell.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errorMsg("Project creation", "Failed to generate project: " + ex.getMessage());
        }
    }

    private void restoreProject() {
        FileDialog fd = new FileDialog(this.shell, 4096);
        fd.setText("Choose IDEA project file");
        fd.setFilterExtensions(new String[]{"*.iml"});
        String path = fd.open();
        if (path == null) {
            return;
        }
        if (!path.endsWith(".iml")) {
            this.errorMsg("Project restore", "Selected not an IDEA project file.");
            return;
        }
        String dir = Paths.get(path, new String[0]).getParent().toString();
        try {
            boolean runIdea = ProjectGenerator.restore(dir);
            if (runIdea) {
                Runtime.getRuntime().exec(new String[]{Settings.ideaPath, dir});
            }
            this.shell.close();
            this.shell.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errorMsg("Project restore", "Failed to generate project: " + ex.getMessage() + "\nNote that this works only with projects created by KEmulator.");
        }
    }

    private void convertProject() {
        FileDialog fd = new FileDialog(this.shell, 4096);
        fd.setText("Choose Eclipse application descriptor");
        fd.setFilterExtensions(new String[]{"Application Descriptor"});
        String path = fd.open();
        if (path == null) {
            return;
        }
        try {
            String dir = ProjectGenerator.convertEclipse(path);
            Runtime.getRuntime().exec(new String[]{Settings.ideaPath, dir});
            this.shell.close();
            this.shell.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex instanceof IllegalArgumentException) {
                this.errorMsg("Project conversion", "Failed to convert project: " + ex.getMessage());
            }
            this.errorMsg("Project conversion", "Failed to convert project: " + ex);
        }
    }

    private static void checkConfigured() {
        if (!Settings.ideaJdkTablePatched) {
            System.out.println("IDE support is not configured, please run setup first.");
            System.exit(2);
        }
        if (!Files.exists(Paths.get(Settings.ideaPath, new String[0]), new LinkOption[0])) {
            System.out.println("IDE binary is gone. Please run setup again.");
            System.exit(2);
        }
        if (!Files.exists(Paths.get(Settings.proguardPath, new String[0]), new LinkOption[0])) {
            System.out.println("Proguard is gone. Please run setup again.");
            System.exit(2);
        }
        if (!Files.exists(Paths.get(Emulator.getAbsolutePath(), new String[0]).resolve("uei"), new LinkOption[0])) {
            System.out.println("UEI libs folder is missing. Please run setup again.");
            System.exit(2);
        }
        if (JdkTablePatcher.getDevTimeJars().isEmpty()) {
            System.out.println("No UEI libraries found. Please run setup again.");
            System.exit(2);
        }
    }

    public static void restoreProjectCLI(String path) {
        try {
            System.out.println("Fixing project at " + path);
            ProjectGenerator.restore(path);
            System.out.println("OK");
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println("Failed!");
            System.out.println(ex.getMessage());
            System.exit(1);
        }
    }

    public static void createProjectCLI(String path) {
        IdeaUtils.checkConfigured();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("\u001b[92mPlease enter project name.\u001b[0m");
            System.out.println("Name of folder, JAR file, various configurations. Only ASCII letters, numbers, hyphen and underscore allowed.");
            System.out.print("> ");
            String name = br.readLine();
            System.out.println("\u001b[92mPlease enter MIDlet class name.\u001b[0m");
            System.out.println("Full name of your MIDlet class. Must be valid java type name.");
            System.out.print("> ");
            String className = br.readLine();
            System.out.println("\u001b[92mPlease enter MIDlet name.\u001b[0m");
            System.out.println("Name of your MIDlet, shown to user. Can contain any symbols except commas, just make sure your target device has enough fonts to display the name.");
            System.out.print("> ");
            String midletName = br.readLine();
            String validation = IdeaUtils.validateInput(name, className, midletName, path);
            if (validation != null) {
                System.out.println(validation);
                System.exit(1);
            }
            ProjectGenerator.create(path, name, className, midletName);
            Settings.lastIdeaRepoPath = path;
            System.out.println("OK");
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println("Failed!");
            System.out.println(ex.getMessage());
            System.exit(1);
        }
    }

    public static void convertProjectCLI(String path) {
        IdeaUtils.checkConfigured();
        try {
            ProjectGenerator.convertEclipse(Paths.get(path, new String[0]).resolve("Application Descriptor").toAbsolutePath().toString());
            System.out.println("OK");
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println("Failed!");
            System.out.println(ex.getMessage());
            System.exit(1);
        }
    }

    public static void editProjectCLI(String path) {
        IdeaUtils.checkConfigured();
        try {
            Runtime.getRuntime().exec(new String[]{Settings.ideaPath, path});
            System.out.println("OK");
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println("Failed!");
            System.out.println(ex.getMessage());
            System.exit(1);
        }
    }
}

