/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt.devutils.idea;

import emulator.Emulator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JdkTablePatcher {
    public static final String[] NIKITA_DOCS = new String[]{"https://nikita36078.github.io/J2ME_Docs/docs/cldc-1.1", "https://nikita36078.github.io/J2ME_Docs/docs/midp-2.0", "https://nikita36078.github.io/J2ME_Docs/docs/jsr75", "https://nikita36078.github.io/J2ME_Docs/docs/jsr75-pim", "https://nikita36078.github.io/J2ME_Docs/docs/jsr82_1.1.1_javadoc", "https://nikita36078.github.io/J2ME_Docs/docs/jsr135", "https://nikita36078.github.io/J2ME_Docs/docs/jsr179-1_1-mrel-javadoc", "https://nikita36078.github.io/J2ME_Docs/docs/jsr184", "https://nikita36078.github.io/J2ME_Docs/docs/nokiaapi2"};
    public static final String CLDC_DEVTIME = "1.8 CLDC Devtime";
    public static final String CLDC_RUNTIME = "1.8 CLDC Runtime";

    private static List<String> getRuntimeJars() {
        Vector<String> libs = new Vector<String>();
        libs.add("KEmulator.jar");
        libs.addAll(Arrays.asList(Emulator.platform.getLwjglLibraryNames()));
        if (Emulator.platform.isX64()) {
            libs.add(Emulator.platform.getSwtLibraryName());
        }
        return libs;
    }

    public static boolean checkJdkTable(String tablePath) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        Element projectJdkTable = JdkTablePatcher.getProjectJdkTableElement(JdkTablePatcher.loadDocument(tablePath));
        return JdkTablePatcher.jdkExists(projectJdkTable, CLDC_DEVTIME) && JdkTablePatcher.jdkExists(projectJdkTable, CLDC_RUNTIME);
    }

    public static void updateJdkTable(String configFilePath, String localDocs, String jdk8home) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        Document doc = JdkTablePatcher.loadDocument(configFilePath);
        Element projectJdkTable = JdkTablePatcher.getProjectJdkTableElement(doc);
        if (JdkTablePatcher.jdkExists(projectJdkTable, CLDC_DEVTIME)) {
            JdkTablePatcher.removeJdk(projectJdkTable, CLDC_DEVTIME);
        }
        projectJdkTable.appendChild(JdkTablePatcher.createDevTimeJdk(doc, jdk8home, localDocs));
        if (JdkTablePatcher.jdkExists(projectJdkTable, CLDC_RUNTIME)) {
            JdkTablePatcher.removeJdk(projectJdkTable, CLDC_RUNTIME);
        }
        projectJdkTable.appendChild(JdkTablePatcher.createRuntimeJdk(doc, jdk8home));
        JdkTablePatcher.saveDocument(doc, configFilePath);
    }

    private static Document loadDocument(String path) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        Document doc;
        Element root;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        File configFile = new File(path);
        if (!configFile.exists() || configFile.length() == 0L) {
            Document newDoc = builder.newDocument();
            Element application = newDoc.createElement("application");
            Element component = newDoc.createElement("component");
            component.setAttribute("name", "ProjectJdkTable");
            application.appendChild(component);
            newDoc.appendChild(application);
            JdkTablePatcher.saveDocument(newDoc, path);
        }
        if (!"application".equals((root = (doc = builder.parse(configFile)).getDocumentElement()).getNodeName())) {
            throw new SAXException("Invalid root element: " + root.getNodeName());
        }
        NodeList components = root.getElementsByTagName("component");
        boolean hasJdkTable = false;
        for (int i2 = 0; i2 < components.getLength(); ++i2) {
            Element comp = (Element)components.item(i2);
            if (!"ProjectJdkTable".equals(comp.getAttribute("name"))) continue;
            hasJdkTable = true;
            break;
        }
        if (!hasJdkTable) {
            Element component = doc.createElement("component");
            component.setAttribute("name", "ProjectJdkTable");
            root.appendChild(component);
        }
        return doc;
    }

    private static void saveDocument(Document doc, String path) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(path));
        transformer.transform(source, result);
    }

    private static void removeJdk(Element projectJdkTable, String jdkName) {
        NodeList jdks = projectJdkTable.getElementsByTagName("jdk");
        ArrayList<Element> toRemove = new ArrayList<Element>();
        for (int i2 = 0; i2 < jdks.getLength(); ++i2) {
            Element jdk = (Element)jdks.item(i2);
            Element nameElement = (Element)jdk.getElementsByTagName("name").item(0);
            if (!jdkName.equals(nameElement.getAttribute("value"))) continue;
            toRemove.add(jdk);
        }
        if (toRemove.isEmpty()) {
            throw new RuntimeException("Empty list for deletion!");
        }
        for (Element node : toRemove) {
            projectJdkTable.removeChild(node);
        }
    }

    private static Element getProjectJdkTableElement(Document doc) {
        NodeList components = doc.getElementsByTagName("component");
        for (int i2 = 0; i2 < components.getLength(); ++i2) {
            Element component = (Element)components.item(i2);
            if (!"ProjectJdkTable".equals(component.getAttribute("name"))) continue;
            return component;
        }
        throw new RuntimeException("ProjectJdkTable component not found");
    }

    private static boolean jdkExists(Element projectJdkTable, String jdkName) {
        NodeList jdks = projectJdkTable.getElementsByTagName("jdk");
        for (int i2 = 0; i2 < jdks.getLength(); ++i2) {
            Element jdk = (Element)jdks.item(i2);
            Element nameElement = (Element)jdk.getElementsByTagName("name").item(0);
            if (!jdkName.equals(nameElement.getAttribute("value"))) continue;
            return true;
        }
        return false;
    }

    private static Element createDevTimeJdk(Document doc, String java8Path, String localDocs) {
        Element jdk = doc.createElement("jdk");
        jdk.setAttribute("version", "2");
        JdkTablePatcher.addElement(doc, jdk, "name", CLDC_DEVTIME);
        JdkTablePatcher.addElement(doc, jdk, "type", "JavaSDK");
        JdkTablePatcher.addElement(doc, jdk, "version", "1.8.0");
        JdkTablePatcher.addElement(doc, jdk, "homePath", java8Path);
        Element roots = doc.createElement("roots");
        roots.appendChild(JdkTablePatcher.createAnnotationsPath(doc));
        roots.appendChild(JdkTablePatcher.createClassPath(doc, JdkTablePatcher.getDevTimeClassPaths()));
        roots.appendChild(JdkTablePatcher.createJavadocPath(doc, localDocs == null ? Arrays.asList(NIKITA_DOCS) : JdkTablePatcher.getDevTimeJavadocPaths(localDocs)));
        roots.appendChild(JdkTablePatcher.createSourcePath(doc));
        jdk.appendChild(roots);
        return jdk;
    }

    private static Element createRuntimeJdk(Document doc, String java8Path) {
        Element jdk = doc.createElement("jdk");
        jdk.setAttribute("version", "2");
        JdkTablePatcher.addElement(doc, jdk, "name", CLDC_RUNTIME);
        JdkTablePatcher.addElement(doc, jdk, "type", "JavaSDK");
        JdkTablePatcher.addElement(doc, jdk, "version", "1.8.0");
        JdkTablePatcher.addElement(doc, jdk, "homePath", java8Path);
        Element roots = doc.createElement("roots");
        roots.appendChild(JdkTablePatcher.createAnnotationsPath(doc));
        roots.appendChild(JdkTablePatcher.createClassPath(doc, JdkTablePatcher.getRuntimeClassPaths(java8Path)));
        roots.appendChild(JdkTablePatcher.createJavadocPath(doc, Collections.singletonList("https://docs.oracle.com/javase/8/docs/api/")));
        roots.appendChild(JdkTablePatcher.createSourcePath(doc));
        jdk.appendChild(roots);
        return jdk;
    }

    private static void addElement(Document doc, Element parent, String tagName, String value) {
        Element element = doc.createElement(tagName);
        element.setAttribute("value", value);
        parent.appendChild(element);
    }

    private static Element createAnnotationsPath(Document doc) {
        Element annotationsPath = doc.createElement("annotationsPath");
        Element root = doc.createElement("root");
        root.setAttribute("type", "composite");
        annotationsPath.appendChild(root);
        return annotationsPath;
    }

    private static Element createClassPath(Document doc, List<String> urls) {
        Element classPath = doc.createElement("classPath");
        Element compositeRoot = JdkTablePatcher.createCompositeRoot(doc, urls);
        classPath.appendChild(compositeRoot);
        return classPath;
    }

    private static Element createJavadocPath(Document doc, List<String> urls) {
        Element javadocPath = doc.createElement("javadocPath");
        Element compositeRoot = JdkTablePatcher.createCompositeRoot(doc, urls);
        javadocPath.appendChild(compositeRoot);
        return javadocPath;
    }

    private static Element createSourcePath(Document doc) {
        Element sourcePath = doc.createElement("sourcePath");
        Element root = doc.createElement("root");
        root.setAttribute("type", "composite");
        sourcePath.appendChild(root);
        return sourcePath;
    }

    private static Element createCompositeRoot(Document doc, List<String> urls) {
        Element root = doc.createElement("root");
        root.setAttribute("type", "composite");
        for (String url : urls) {
            Element childRoot = doc.createElement("root");
            childRoot.setAttribute("url", url);
            childRoot.setAttribute("type", "simple");
            root.appendChild(childRoot);
        }
        return root;
    }

    public static ArrayList<String> getDevTimeJars() {
        try {
            Path uei = Paths.get(Emulator.getAbsolutePath(), new String[0]).resolve("uei");
            ArrayList<String> paths = new ArrayList<String>();
            for (File c2 : uei.toFile().listFiles()) {
                if (!c2.getName().endsWith(".jar") || c2.getName().equalsIgnoreCase("emulator.jar")) continue;
                paths.add(c2.getAbsolutePath().toString());
            }
            return paths;
        }
        catch (RuntimeException ex) {
            return new ArrayList<String>();
        }
    }

    private static List<String> getDevTimeClassPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (String p : JdkTablePatcher.getDevTimeJars()) {
            paths.add("jar://" + p.replace("\\", "/") + "!/");
        }
        return paths;
    }

    private static List<String> getRuntimeClassPaths(String java8Path) {
        String kemnnPath = Emulator.getAbsolutePath();
        ArrayList<String> paths = new ArrayList<String>();
        Path libPath = Paths.get(java8Path, "jre", "lib");
        try (Stream<Path> stream = Files.walk(libPath, new FileVisitOption[0]);){
            stream.filter(p -> p.toString().endsWith(".jar")).filter(p -> !p.toString().contains("security") || !p.toString().contains("policy")).forEach(p -> paths.add("jar://" + p.toString().replace("\\", "/") + "!/"));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        for (String jar : JdkTablePatcher.getRuntimeJars()) {
            paths.add("jar://" + Paths.get(kemnnPath, jar).toString().replace("\\", "/") + "!/");
        }
        return paths;
    }

    private static List<String> getDevTimeJavadocPaths(String javadocBase) {
        ArrayList<String> paths = new ArrayList<String>();
        try (Stream<Path> s = Files.list(Paths.get(javadocBase, new String[0]));){
            s.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(p -> {
                if (p.endsWith("KTF_WIPI_API") || p.endsWith("WIPI_API_1_1_1") || p.endsWith("midp-3_0-fr-javadoc") || p.endsWith("BlackBerry_API_7_1_0")) {
                    return;
                }
                paths.add("file://" + p.toString().replace("\\", "/"));
            });
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return paths;
    }
}

