/*
 * Decompiled with CFR 0.152.
 */
package emulator.ui.swt.devutils.idea;

import emulator.Utils;
import emulator.ui.swt.devutils.ClasspathEntry;
import emulator.ui.swt.devutils.DevtimeMIDlet;
import emulator.ui.swt.devutils.idea.ProjectConfigGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProjectGenerator {
    public static final String PROGUARD_LOCAL_CFG = "proguard-local.cfg";
    public static final String PROGUARD_GLOBAL_CFG = "proguard.cfg";

    public static String create(String location, String projectName, String midletClassName, String readableName) throws IOException, ParserConfigurationException, TransformerException, SAXException {
        Path dir = Paths.get(location, projectName).toAbsolutePath();
        ProjectGenerator.createDirectories(dir);
        Files.write(dir.resolve(".gitignore"), "### IntelliJ IDEA ###\nout/\n!**/src/main/**/out/\n!**/src/test/**/out/\nproguard-local.cfg\n.idea/runConfigurations\n\n### Eclipse ###\n.apt_generated\n.classpath\n.factorypath\n.project\n.settings\nbin/\ndeployed/\n\n### NetBeans ###\n/nbproject/private/\n/nbbuild/\n/dist/\n/nbdist/\n/.nb-gradle/\n\n### VS Code ###\n.vscode/\n\n### Mac OS ###\n.DS_Store".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        ProjectConfigGenerator.generateIML(null, dir.resolve(projectName + ".iml"));
        ProjectGenerator.generateProGuardConfig(dir, projectName, new ClasspathEntry[0]);
        Files.write(dir.resolve("META-INF").resolve("MANIFEST.MF"), ProjectConfigGenerator.buildManifest(projectName, midletClassName, readableName).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String midletCodePath = ProjectGenerator.generateDummyMidlet(dir, midletClassName);
        ProjectGenerator.generateMiscXmls(dir, projectName);
        ProjectGenerator.generateBuildConfigs(dir, projectName, false);
        ProjectGenerator.generateRunConfigs(dir, projectName, new DevtimeMIDlet[]{new DevtimeMIDlet(midletClassName, readableName)});
        return midletCodePath;
    }

    public static boolean restore(String dir) throws IOException, InterruptedException {
        DevtimeMIDlet[] midletNames;
        Path dirp = Paths.get(dir, new String[0]);
        Path appDecrPath = dirp.resolve("Application Descriptor");
        Path mfPath = dirp.resolve("META-INF").resolve("MANIFEST.MF");
        Path imlPath = ClasspathEntry.findImlAt(dirp);
        ProjectGenerator.createDirectories(dirp);
        boolean isEclipse = Files.exists(appDecrPath, new LinkOption[0]);
        if (Files.exists(mfPath, new LinkOption[0])) {
            if (isEclipse) {
                System.out.println("Warning: both \"Application Descriptor\" and \"MANIFEST.MF\" exist. Run configurations will be updated based on \"Application Descriptor\".");
                ProjectGenerator.fixManifestWithVersion(mfPath);
                ProjectGenerator.fixManifestWithVersion(appDecrPath);
                midletNames = DevtimeMIDlet.readMidletsList(appDecrPath);
            } else {
                ProjectGenerator.fixManifestWithVersion(mfPath);
                midletNames = DevtimeMIDlet.readMidletsList(mfPath);
            }
        } else if (isEclipse) {
            ProjectGenerator.fixManifestWithVersion(appDecrPath);
            midletNames = DevtimeMIDlet.readMidletsList(appDecrPath);
        } else {
            throw new IllegalArgumentException("Neither \"Application Descriptor\" nor \"MANIFEST.MF\" files found!");
        }
        String projectName = dirp.getFileName().toString();
        if (imlPath != null) {
            try {
                ClasspathEntry[] classpath = ClasspathEntry.readFromIml(imlPath);
                ProjectGenerator.generateProGuardConfig(dirp, projectName, classpath);
            }
            catch (Exception e2) {
                System.out.println("Failed to parse IML! No libraries will be exported.");
                ProjectGenerator.generateProGuardConfig(dirp, projectName, new ClasspathEntry[0]);
            }
            ProjectGenerator.generateRunConfigs(dirp, projectName, midletNames);
            if (!"1.8 CLDC Devtime".equals(ProjectGenerator.getProjectJdkName(dirp.resolve(".idea").resolve("misc.xml")))) {
                System.out.println("For compatibility reasons, it's recommended to name project's JDK as \"1.8 CLDC Devtime\". You can rerun IDE setup to bring your configuration to recommended one.");
            }
        } else {
            System.out.println("No IML found! Run configuration will not be created.");
            ProjectGenerator.generateProGuardConfig(dirp, projectName, new ClasspathEntry[0]);
        }
        return imlPath != null;
    }

    public static String convertEclipse(String appDescriptorPath) throws IOException, InterruptedException, ParserConfigurationException, TransformerException, SAXException {
        Path dir = Paths.get(appDescriptorPath, new String[0]).getParent().toAbsolutePath();
        String projectName = dir.getFileName().toString();
        if (Files.exists(dir.resolve("META-INF").resolve("MANIFEST.MF"), new LinkOption[0])) {
            System.out.println("MANIFEST.MF found! It will be ignored, converted projects use \"Application Descriptor\".");
        }
        ProjectGenerator.createDirectories(dir);
        HashSet<Object> gitignore = new HashSet();
        if (Files.exists(dir.resolve(".gitignore"), new LinkOption[0])) {
            gitignore = new HashSet<String>(Files.readAllLines(dir.resolve(".gitignore")));
        }
        try (BufferedWriter gi = new BufferedWriter(new FileWriter(dir.resolve(".gitignore").toString(), true));){
            if (!(gitignore.contains(".idea") || gitignore.contains(".idea/") || gitignore.contains(".idea/*") || gitignore.contains(".idea/runConfigurations"))) {
                gi.write(".idea/runConfigurations");
                gi.newLine();
            }
            if (!gitignore.contains(PROGUARD_GLOBAL_CFG)) {
                gi.write(PROGUARD_LOCAL_CFG);
                gi.newLine();
            }
        }
        ClasspathEntry[] cp = ProjectConfigGenerator.generateIML(dir.resolve(".classpath"), dir.resolve(projectName + ".iml"));
        ProjectGenerator.generateProGuardConfig(dir, projectName, cp);
        ProjectGenerator.fixManifestWithVersion(Paths.get(appDescriptorPath, new String[0]));
        DevtimeMIDlet[] midlets = DevtimeMIDlet.readMidletsList(dir.resolve("Application Descriptor"));
        ProjectGenerator.generateMiscXmls(dir, projectName);
        ProjectGenerator.generateBuildConfigs(dir, projectName, true);
        ProjectGenerator.generateRunConfigs(dir, projectName, midlets);
        return dir.toString();
    }

    private static void fixManifestWithVersion(Path manifestPath) throws IOException {
        List<String> manifest = Files.readAllLines(manifestPath);
        boolean hasVersion = false;
        for (String line : manifest) {
            if (!line.startsWith("Manifest-Version:")) continue;
            hasVersion = true;
            break;
        }
        if (!hasVersion) {
            manifest.add(0, "Manifest-Version: 1.0");
            Files.write(manifestPath, manifest, new OpenOption[0]);
        }
    }

    private static void createDirectories(Path dir) throws IOException {
        Files.createDirectories(dir.resolve(".idea"), new FileAttribute[0]);
        Files.createDirectories(dir.resolve(".idea").resolve("artifacts"), new FileAttribute[0]);
        Files.createDirectories(dir.resolve(".idea").resolve("runConfigurations"), new FileAttribute[0]);
        ProjectGenerator.createDirSilently(dir.resolve("src"));
        ProjectGenerator.createDirSilently(dir.resolve("res"));
        ProjectGenerator.createDirSilently(dir.resolve("bin"));
        ProjectGenerator.createDirSilently(dir.resolve("deployed"));
        ProjectGenerator.createDirSilently(dir.resolve("META-INF"));
    }

    private static void createDirSilently(Path path) throws IOException {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    private static void generateRunConfigs(Path dir, String projectName, DevtimeMIDlet[] midletNames) throws IOException {
        for (int i2 = 0; i2 < midletNames.length; ++i2) {
            Path configPath = dir.resolve(".idea").resolve("runConfigurations").resolve("Run_with_KEmulator_" + (i2 + 1) + ".xml");
            String configText = ProjectConfigGenerator.buildKemRunConfig(projectName, midletNames[i2].readableName, midletNames[i2].className);
            Files.write(configPath, configText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        Files.write(dir.resolve(".idea").resolve("runConfigurations").resolve("Package.xml"), ProjectConfigGenerator.buildPackageRunConfig(projectName).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(dir.resolve(".idea").resolve("runConfigurations").resolve("Restore_project.xml"), ProjectConfigGenerator.buildRestoreRunConfig(projectName).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static void generateBuildConfigs(Path dir, String projectName, boolean eclipseManifest) throws IOException {
        Path path = dir.resolve(".idea").resolve("artifacts").resolve(projectName + ".xml");
        Files.write(path, ProjectConfigGenerator.buildArtifactConfig(projectName, eclipseManifest).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static void generateMiscXmls(Path dir, String projectName) throws IOException {
        Files.write(dir.resolve(".idea").resolve("encodings.xml"), "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project version=\"4\">\n  <component name=\"Encoding\" addBOMForNewFiles=\"with BOM under Windows, with no BOM otherwise\" />\n</project>".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(dir.resolve(".idea").resolve("misc.xml"), "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project version=\"4\">\n  <component name=\"ProjectRootManager\" version=\"2\" languageLevel=\"JDK_1_3\" project-jdk-name=\"1.8 CLDC Devtime\" project-jdk-type=\"JavaSDK\">\n    <output url=\"file://$PROJECT_DIR$/bin\" />\n  </component>\n</project>".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(dir.resolve(".idea").resolve(".gitignore"), "# Default ignored files\n/shelf/\n/workspace.xml\n# Editor-based HTTP Client requests\n/httpRequests/\n# Datasource local storage ignored files\n/dataSources/\n/dataSources.local.xml\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(dir.resolve(".idea").resolve(".name"), projectName.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(dir.resolve(".idea").resolve("modules.xml"), ProjectConfigGenerator.buildModulesFile(projectName).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static String generateDummyMidlet(Path dir, String midletName) throws IOException {
        Path midletCodePath;
        Path src = dir.resolve("src");
        if (midletName.indexOf(46) != -1) {
            String[] splitted = ProjectConfigGenerator.splitByLastDot(midletName);
            Path midletFolder = Paths.get(src.toString(), splitted[0].replace('.', File.separatorChar));
            Files.createDirectories(midletFolder, new FileAttribute[0]);
            midletCodePath = midletFolder.resolve(splitted[1] + ".java");
            Files.write(midletCodePath, ProjectConfigGenerator.buildDummyMidlet(midletName).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        } else {
            midletCodePath = src.resolve(midletName + ".java");
            Files.write(midletCodePath, ProjectConfigGenerator.buildDummyMidlet(midletName).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        return midletCodePath.toString();
    }

    private static void generateProGuardConfig(Path dir, String projName, ClasspathEntry[] classpath) throws IOException {
        Files.write(dir.resolve(PROGUARD_LOCAL_CFG), ProjectConfigGenerator.buildLocalProguardConfig(dir.toString(), projName, classpath).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        if (!Files.exists(dir.resolve(PROGUARD_GLOBAL_CFG), new LinkOption[0])) {
            Files.write(dir.resolve(PROGUARD_GLOBAL_CFG), System.lineSeparator().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public static String getProjectJdkName(Path miscXml) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(miscXml.toFile());
            NodeList components = doc.getElementsByTagName("component");
            for (int i2 = 0; i2 < components.getLength(); ++i2) {
                Element component = (Element)components.item(i2);
                if (!"ProjectRootManager".equals(component.getAttribute("name"))) continue;
                return component.getAttribute("project-jdk-name");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String readManifestFromNetbeans(Path projPropsPath) throws IOException {
        List<String> lines = Files.readAllLines(projPropsPath);
        Hashtable<String, String> manifestProps = new Hashtable<String, String>();
        for (String line : lines) {
            if (!line.startsWith("manifest.")) continue;
            String[] split = line.split("=", 2);
            manifestProps.put(split[0].substring("manifest.".length()), Utils.translateEscapes(split[1]));
        }
        return "Manifest-Version: 1.0\n" + (String)manifestProps.get("midlets") + (String)manifestProps.get("apipermissions") + (String)manifestProps.get("others") + (String)manifestProps.get("manifest");
    }
}

