/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.bluetooth.L2CAPConnection;
import javax.microedition.io.Connection;

public class L2CAPConnectionImpl
implements L2CAPConnection {
    Socket socket;
    InputStream in;
    OutputStream out;

    protected L2CAPConnectionImpl(Socket aSocket315) throws IOException {
        this.socket = aSocket315;
        this.in = aSocket315.getInputStream();
        this.out = aSocket315.getOutputStream();
        aSocket315.setReceiveBufferSize(672);
        aSocket315.setSendBufferSize(672);
    }

    @Override
    public int getTransmitMTU() throws IOException {
        return this.socket.getSendBufferSize();
    }

    @Override
    public int getReceiveMTU() throws IOException {
        return this.socket.getReceiveBufferSize();
    }

    @Override
    public void send(byte[] array) throws IOException {
        this.out.write(array, 0, Math.min(672, array.length));
    }

    @Override
    public int receive(byte[] array) throws IOException {
        return this.in.read(array, 0, Math.min(672, array.length));
    }

    @Override
    public boolean ready() throws IOException {
        return this.in.available() > 0;
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    public static Connection open(String s) throws IOException {
        int n = s.indexOf("://") + 3;
        String substring = s.substring(n, s.indexOf(":", n));
        int index = s.indexOf(";");
        return new L2CAPConnectionImpl(new Socket(substring, Integer.parseInt(s.substring(s.indexOf(":", n) + 1, index < 0 ? s.length() : index))));
    }
}

