/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import com.nttdocomo.io.maker.ScratchPadConnection;
import com.sun.cdc.io.ConnectionBaseInterface;
import emulator.Emulator;
import emulator.Permission;
import emulator.Settings;
import emulator.sensor.SensorImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.HttpConnectionImpl;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import javax.microedition.io.ResourceConnectionImpl;
import javax.microedition.io.ServerSocketImpl;
import javax.microedition.io.SocketConnectionImpl;
import javax.microedition.io.VServConnectionWrapper;
import javax.microedition.io.file.FileConnectionImpl;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;
import javax.wireless.messaging.MessageConnectionImpl;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;

    private Connector() {
    }

    public static Connection open(String s) throws IOException {
        return Connector.open(s, 3);
    }

    public static Connection open(String s, int n) throws IOException {
        return Connector.open(s, n, false);
    }

    public static Connection open(String s, int n, boolean b2) throws IOException {
        if (s.startsWith("resource:")) {
            return new ResourceConnectionImpl(s);
        }
        if (s.startsWith("vserv:")) {
            return new VServConnectionWrapper(s);
        }
        if (s.startsWith("scratchpad:")) {
            return ScratchPadConnection.open(s);
        }
        if (s.startsWith("file://") && !Settings.protectedPackages.contains("javax.microedition.io.file")) {
            Permission.checkPermission("connector.open.file");
            return new FileConnectionImpl(s);
        }
        if (s.startsWith("sms://") && !Settings.protectedPackages.contains("javax.wireless.messaging")) {
            Permission.checkPermission("connector.open.sms");
            return new MessageConnectionImpl(s);
        }
        if (s.startsWith("sensor:") && !Settings.protectedPackages.contains("javax.microedition.sensor")) {
            SensorInfo[] sensors = SensorManager.findSensors(s);
            if (sensors.length > 0) {
                ((SensorImpl)sensors[0]).method239();
                return (SensorConnection)((Object)sensors[0]);
            }
            return null;
        }
        if (Settings.networkNotAvailable) {
            Emulator.getEmulator().getLogStream().println("MIDlet tried to open: " + s);
            throw new IOException("Network not available");
        }
        if (s.startsWith("http://")) {
            Permission.checkPermission("connector.open.http");
            if (Emulator.doja) {
                return new com.nttdocomo.io.maker.HttpConnectionImpl(s, n);
            }
            return Connector.checkVserv(s) ? new VServConnectionWrapper(s) : new HttpConnectionImpl(s);
        }
        if (s.startsWith("https://")) {
            Permission.checkPermission("connector.open.http");
            return Connector.checkVserv(s) ? new VServConnectionWrapper(s) : new HttpConnectionImpl(s);
        }
        if (s.startsWith("socket://:")) {
            Permission.checkPermission("connector.open.serversocket");
            return new ServerSocketImpl(s);
        }
        if (s.startsWith("socket://")) {
            Permission.checkPermission("connector.open.socket");
            return new SocketConnectionImpl(s);
        }
        Connection openPrim = null;
        String protocol = "";
        if (s.indexOf(58) == -1) {
            throw new ConnectionNotFoundException("unknown protocol: " + s);
        }
        protocol = s.substring(0, s.indexOf(58));
        try {
            openPrim = ((ConnectionBaseInterface)Class.forName("com.sun.cdc.io.j2me." + protocol + ".Protocol").newInstance()).openPrim(s.substring(s.indexOf(58) + 1), n, b2);
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new ConnectionNotFoundException("unknown protocol: " + s, ex);
        }
        return openPrim;
    }

    private static boolean checkVserv(String s) {
        return Settings.bypassVserv && (s.startsWith("http://a.vserv.mobi/") || s.contains("vserv.mobi/") && s.contains("/adapi"));
    }

    public static DataInputStream openDataInputStream(String s) throws IOException {
        InputConnection inputConnection = (InputConnection)Connector.open(s, 1);
        return inputConnection.openDataInputStream();
    }

    public static DataOutputStream openDataOutputStream(String s) throws IOException {
        OutputConnection outputConnection = (OutputConnection)Connector.open(s, 2);
        return outputConnection.openDataOutputStream();
    }

    public static InputStream openInputStream(String s) throws IOException {
        return Connector.openDataInputStream(s);
    }

    public static OutputStream openOutputStream(String s) throws IOException {
        return Connector.openDataOutputStream(s);
    }
}

