/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import emulator.Emulator;
import emulator.Settings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.microedition.io.HttpConnection;

public final class HttpConnectionImpl
implements HttpConnection {
    HttpURLConnection connection;
    private String url;
    private int state;
    private int headerOffset;

    private void method134(String s) {
        if (this.url.startsWith("http://10.0.0.172")) {
            try {
                String substring = this.url.substring("http://10.0.0.172".length());
                String s2 = "http://" + s + "/";
                int index = substring.indexOf(47);
                if (index != -1) {
                    s2 = s2 + substring.substring(index + 1);
                }
                Emulator.getEmulator().getLogStream().println("update Connect to: " + s2);
                this.connection = (HttpURLConnection)new URL(s2).openConnection();
                this.connection.setDoInput(true);
                this.connection.setDoOutput(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public HttpConnectionImpl(String url) throws IOException {
        this.url = url;
        Emulator.getEmulator().getLogStream().println("Connect to: " + url);
        this.connection = (HttpURLConnection)new URL(url).openConnection();
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
    }

    @Override
    public final String getURL() {
        return this.connection.getURL().toString();
    }

    @Override
    public final String getProtocol() {
        return this.connection.getURL().getProtocol();
    }

    @Override
    public final String getHost() {
        return this.connection.getURL().getHost();
    }

    @Override
    public final String getFile() {
        return this.connection.getURL().getFile();
    }

    @Override
    public final String getRef() {
        return this.connection.getURL().getRef();
    }

    @Override
    public final String getQuery() {
        return this.connection.getURL().getQuery();
    }

    @Override
    public final int getPort() {
        return this.connection.getURL().getPort();
    }

    @Override
    public final String getRequestMethod() {
        if (this.connection == null) {
            return "GET";
        }
        return this.connection.getRequestMethod();
    }

    @Override
    public final void setRequestMethod(String requestMethod) throws IOException {
        if (this.connection != null) {
            this.connection.setRequestMethod(requestMethod);
        }
    }

    @Override
    public final String getRequestProperty(String s) {
        return this.connection.getRequestProperty(s);
    }

    @Override
    public final void setRequestProperty(String s, String s2) throws IOException {
        if ("X-Online-Host".equalsIgnoreCase(s)) {
            this.method134(s2);
        }
        this.connection.setRequestProperty(s, s2);
    }

    private void connect() throws IOException {
        if (this.state != 0) {
            return;
        }
        this.state = 1;
        try {
            if (this.getRequestProperty("User-Agent") == null) {
                if (Emulator.httpUserAgent != null) {
                    this.connection.setRequestProperty("User-Agent", Emulator.httpUserAgent);
                } else {
                    this.connection.setRequestProperty("User-Agent", Emulator.deviceName + " (KEmulator/" + Emulator.version + "; Profile/MIDP-2.1 Configuration/CLDC-1.1)");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection.connect();
        try {
            this.headerOffset = this.connection.getHeaderFieldKey(0) == null && this.connection.getHeaderFieldKey(1) != null ? 1 : 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final int getResponseCode() throws IOException {
        if (Settings.networkNotAvailable) {
            return 502;
        }
        if (this.connection == null) {
            return 200;
        }
        this.connect();
        try {
            return this.connection.getResponseCode();
        }
        catch (ConnectException e2) {
            throw new IOException(e2);
        }
    }

    @Override
    public final String getResponseMessage() throws IOException {
        this.connect();
        if (this.connection == null) {
            return "OK";
        }
        return this.connection.getResponseMessage();
    }

    @Override
    public final long getExpiration() throws IOException {
        this.connect();
        return this.connection.getExpiration();
    }

    @Override
    public final long getDate() throws IOException {
        this.connect();
        return this.connection.getDate();
    }

    @Override
    public final long getLastModified() throws IOException {
        this.connect();
        return this.connection.getLastModified();
    }

    @Override
    public final String getHeaderField(String s) throws IOException {
        this.connect();
        return this.connection.getHeaderField(s);
    }

    @Override
    public final int getHeaderFieldInt(String s, int n) throws IOException {
        this.connect();
        return this.connection.getHeaderFieldInt(s, n);
    }

    @Override
    public final long getHeaderFieldDate(String s, long n) throws IOException {
        this.connect();
        return this.connection.getHeaderFieldDate(s, n);
    }

    @Override
    public final String getHeaderField(int n) throws IOException {
        this.connect();
        return this.connection.getHeaderField(n + this.headerOffset);
    }

    @Override
    public final String getHeaderFieldKey(int n) throws IOException {
        this.connect();
        return this.connection.getHeaderFieldKey(n + this.headerOffset);
    }

    @Override
    public final void close() throws IOException {
        if (this.state == 2) {
            return;
        }
        this.state = 2;
        this.connection.disconnect();
    }

    @Override
    public final String getType() {
        try {
            this.connect();
            return this.connection.getContentType();
        }
        catch (IOException e2) {
            return null;
        }
    }

    @Override
    public final String getEncoding() {
        try {
            this.connect();
            return this.connection.getContentEncoding();
        }
        catch (IOException e2) {
            return null;
        }
    }

    @Override
    public final long getLength() {
        try {
            this.connect();
            return this.connection.getContentLength();
        }
        catch (IOException e2) {
            return -1L;
        }
    }

    @Override
    public final DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    @Override
    public final InputStream openInputStream() throws IOException {
        if (this.state == 2) {
            throw new IOException();
        }
        this.connect();
        try {
            return this.connection.getInputStream();
        }
        catch (IOException e2) {
            InputStream i2 = this.connection.getErrorStream();
            if (i2 != null) {
                return i2;
            }
            throw e2;
        }
    }

    @Override
    public final DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    @Override
    public final OutputStream openOutputStream() throws IOException {
        if (this.state != 0) {
            throw new IOException();
        }
        try {
            return this.connection.getOutputStream();
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }
}

