/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import emulator.Emulator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.microedition.io.SocketConnection;

final class SocketConnectionImpl
implements SocketConnection {
    Socket socket;

    public SocketConnectionImpl(String s) throws IOException {
        Emulator.getEmulator().getLogStream().println("Socket opened: " + s);
        int n = s.indexOf("://") + 3;
        int n2 = s.lastIndexOf(":") + 1;
        this.socket = new Socket(s.substring(n, n2 - 1), Integer.parseInt(s.substring(n2)));
    }

    public SocketConnectionImpl(Socket socket) throws IOException {
        this.socket = socket;
    }

    @Override
    public final String getAddress() throws IOException {
        return this.socket.getInetAddress().getHostAddress();
    }

    @Override
    public final String getLocalAddress() throws IOException {
        return this.socket.getLocalAddress().getHostAddress();
    }

    @Override
    public final int getLocalPort() throws IOException {
        return this.socket.getLocalPort();
    }

    @Override
    public final int getPort() throws IOException {
        return this.socket.getPort();
    }

    @Override
    public final int getSocketOption(byte b2) throws IllegalArgumentException, IOException {
        if (this.socket != null && this.socket.isClosed()) {
            throw new IOException("socket closed");
        }
        switch (b2) {
            case 0: {
                return this.socket.getTcpNoDelay() ? 1 : 0;
            }
            case 1: {
                int value = this.socket.getSoLinger();
                return value == -1 ? 0 : value;
            }
            case 2: {
                return this.socket.getKeepAlive() ? 1 : 0;
            }
            case 3: {
                return this.socket.getReceiveBufferSize();
            }
            case 4: {
                return this.socket.getSendBufferSize();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final void setSocketOption(byte option, int value) throws IllegalArgumentException, IOException {
        switch (option) {
            case 0: {
                this.socket.setTcpNoDelay(value != 0);
                break;
            }
            case 1: {
                if (value <= 0) {
                    throw new IllegalArgumentException();
                }
                this.socket.setSoLinger(value != 0, value);
                break;
            }
            case 2: {
                this.socket.setKeepAlive(value != 0);
                break;
            }
            case 3: {
                if (value <= 0) {
                    throw new IllegalArgumentException();
                }
                this.socket.setReceiveBufferSize(value);
                break;
            }
            case 4: {
                if (value <= 0) {
                    throw new IllegalArgumentException();
                }
                this.socket.setSendBufferSize(value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public final void close() throws IOException {
        this.socket.close();
    }

    @Override
    public final DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    @Override
    public final InputStream openInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public final DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    @Override
    public final OutputStream openOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }
}

