/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io.file;

import emulator.Emulator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.io.file.ConnectionClosedException;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileConnectionListEn;
import javax.microedition.io.file.FileConnectionListEn2;
import javax.microedition.io.file.FileFilterr;

public class FileConnectionImpl
implements FileConnection {
    private String origUrl;
    private String systemPath;
    private File file;
    private boolean closed;
    private static String aString441 = Emulator.getUserPath() + "/file/root/";
    private boolean aBoolean440;
    private String aString442;

    public FileConnectionImpl(String url) throws IOException {
        Emulator.getEmulator().getLogStream().println("File opened: " + url);
        if (url.length() > 300) {
            throw new IOException("Path too long");
        }
        this.origUrl = url;
        this.closed = false;
        File file = new File(aString441);
        if (!file.exists() || file.isFile()) {
            file.mkdirs();
        }
        if ((url = FileConnectionImpl.method216(FileConnectionImpl.method216(FileConnectionImpl.method216(url.replaceFirst("localhost", "").substring("file://".length()), "c"), "d"), "e")).startsWith("/")) {
            url = url.substring(1);
        }
        this.systemPath = Emulator.getUserPath() + "/file/" + url;
        this.file = new File(this.systemPath);
    }

    private static void method134(String s) {
        int index;
        int length = (Emulator.getUserPath() + "/file/").length();
        String s2 = s;
        String s3 = "/";
        int n = length;
        while ((index = s2.indexOf(s3, n)) >= 0 && index >= length) {
            File file = new File(s.substring(0, index));
            if (!file.exists() && new File(s).isFile()) {
                file.mkdirs();
            }
            s2 = s;
            s3 = "/";
            n = index + 1;
        }
    }

    private static String method216(String s, String s2) {
        String replaceFirst = s;
        if (s.contains(s2 + ":")) {
            File file = new File(Emulator.getUserPath() + "/file/" + s2 + "/");
            if (!file.exists() || file.isFile()) {
                file.mkdirs();
            }
            replaceFirst = s.replaceFirst(s2 + ":", s2);
        }
        return replaceFirst;
    }

    @Override
    public long availableSize() {
        if (this.file == null) {
            return 1000000000L;
        }
        return this.file.getFreeSpace();
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public void create() throws IOException {
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        if (this.file.exists() || this.file.isDirectory()) {
            throw new IOException("File already exists");
        }
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        this.file.createNewFile();
    }

    @Override
    public void delete() throws IOException {
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        if (!this.file.exists() || this.file.isDirectory()) {
            throw new IOException();
        }
        this.file.delete();
    }

    @Override
    public long directorySize(boolean b2) throws IOException {
        if (this.file.isFile()) {
            throw new IOException();
        }
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        return this.method217(b2);
    }

    private int method217(boolean b2) {
        int n = 0;
        if (this.file.isDirectory()) {
            File[] listFiles = this.file.listFiles();
            for (int i2 = 0; i2 < listFiles.length; ++i2) {
                int n2;
                if (listFiles[i2].isFile()) {
                    n2 = (int)((long)n + listFiles[i2].length());
                } else {
                    if (!b2) continue;
                    n2 = n + this.method217(true);
                }
                n = n2;
            }
        }
        return n;
    }

    @Override
    public boolean exists() {
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        return this.file.exists();
    }

    @Override
    public long fileSize() throws IOException {
        if (this.file.isDirectory()) {
            throw new IOException();
        }
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        return this.file.length();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getPath() {
        return this.origUrl.replaceFirst("localhost", "").substring("file://".length());
    }

    @Override
    public String getURL() {
        return this.origUrl;
    }

    @Override
    public boolean isDirectory() {
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        return this.file.isDirectory();
    }

    @Override
    public boolean isHidden() {
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        return this.file.isHidden();
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public long lastModified() {
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        return this.file.lastModified();
    }

    @Override
    public Enumeration list() throws IOException {
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        if (!this.file.exists() || this.file.isFile()) {
            throw new IOException();
        }
        File[] listFiles = this.file.listFiles();
        if (listFiles != null) {
            return new FileConnectionListEn2(this, listFiles);
        }
        return null;
    }

    @Override
    public Enumeration list(String s, boolean b2) throws IOException {
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        if (!this.file.exists() || this.file.isFile()) {
            throw new IOException();
        }
        File[] listFiles = this.file.listFiles(new FileFilterr(s, b2));
        if (listFiles != null) {
            return new FileConnectionListEn(this, listFiles);
        }
        return null;
    }

    @Override
    public void mkdir() throws IOException {
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        if (this.file.exists() || this.file.isFile()) {
            throw new IOException();
        }
        this.file.mkdir();
    }

    @Override
    public DataInputStream openDataInputStream() throws IOException {
        if (!this.file.exists() || this.file.isDirectory()) {
            throw new IOException();
        }
        return new DataInputStream(new FileInputStream(this.file));
    }

    @Override
    public DataOutputStream openDataOutputStream() throws IOException {
        if (!this.file.exists() || this.file.isDirectory()) {
            throw new IOException(!this.file.exists() ? "File doesn't exist" : "No access to file");
        }
        return new DataOutputStream(new FileOutputStream(this.file));
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (!this.file.exists() || this.file.isDirectory()) {
            throw new IOException();
        }
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        if (!this.file.exists() || this.file.isDirectory()) {
            throw new IOException();
        }
        return new FileOutputStream(this.file);
    }

    @Override
    public OutputStream openOutputStream(long n) throws IOException {
        if (!this.file.exists() || this.file.isDirectory()) {
            throw new IOException();
        }
        FileInputStream fileInputStream = new FileInputStream(this.file);
        byte[] array = new byte[(int)Math.min(n, (long)fileInputStream.available())];
        fileInputStream.read(array);
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        fileOutputStream.write(array);
        fileOutputStream.flush();
        return fileOutputStream;
    }

    @Override
    public void rename(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        this.file.renameTo(new File(this.file.getParent() + "//" + s));
    }

    @Override
    public void setFileConnection(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        File file = new File(this.file + "//" + s);
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        this.origUrl = "file://" + file.getAbsolutePath().substring(aString441.length());
        this.closed = false;
        this.systemPath = file.getAbsolutePath();
        this.file = new File(this.systemPath);
    }

    @Override
    public void setHidden(boolean b2) throws IOException {
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        if (!this.file.exists()) {
            throw new IOException();
        }
    }

    @Override
    public void setReadable(boolean b2) throws IOException {
    }

    @Override
    public void setWritable(boolean b2) throws IOException {
    }

    @Override
    public long totalSize() {
        return 100000000L;
    }

    @Override
    public void truncate(long n) throws IOException {
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        if (!this.file.exists() || this.file.isDirectory()) {
            throw new IOException();
        }
        FileInputStream fileInputStream = new FileInputStream(this.file);
        byte[] array = new byte[(int)Math.min(n, (long)fileInputStream.available())];
        fileInputStream.read(array);
        fileInputStream.close();
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        fileOutputStream.write(array);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    @Override
    public long usedSize() {
        return 1000000L;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    public String getRealPath() {
        return this.file.toString();
    }

    public File getFile() {
        return this.file;
    }
}

