/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.Emulator;
import emulator.UILocale;
import emulator.lcdui.LCDUIUtils;
import emulator.lcdui.TextUtils;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Screen;

public class Alert
extends Screen {
    public static final Command DISMISS_COMMAND = new Command(UILocale.get("LCDUI_ALERT_DISMISS_COMMAND", "OK"), 4, 0);
    public static final int FOREVER = -2;
    int timeout;
    String string;
    private String[] textArr;
    Displayable lastDisplayed;
    private Gauge gauge;
    private long timeShown = System.currentTimeMillis();

    public Alert(String s) {
        this(s, null, null, null);
    }

    public Alert(String s, String aString172, Image image, AlertType alertType) {
        super(s);
        this.string = aString172;
        this.timeout = this.getDefaultTimeout();
        this.lastDisplayed = Display.current;
        super.addCommand(DISMISS_COMMAND);
    }

    @Override
    public void addCommand(Command command) {
        if (command == DISMISS_COMMAND) {
            return;
        }
        super.removeCommand(DISMISS_COMMAND);
        super.addCommand(command);
    }

    @Override
    public void removeCommand(Command command) {
        super.removeCommand(command);
        if (this.isCommandsEmpty()) {
            super.addCommand(DISMISS_COMMAND);
        }
    }

    public int getDefaultTimeout() {
        return 2000;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        if (n < 0 && n != -2) {
            throw new IllegalArgumentException("time should be positive");
        }
        this.timeout = n;
    }

    @Override
    protected void _shown() {
        super._shown();
        try {
            Emulator.getEventQueue().waitRepaint();
            this.repaintScreen();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        this.timeShown = System.currentTimeMillis();
    }

    public Image getImage() {
        return null;
    }

    public void setImage(Image image) {
    }

    public Gauge getIndicator() {
        return this.gauge;
    }

    public void setIndicator(Gauge gauge) {
        if (gauge != null && gauge.isInteractive()) {
            throw new IllegalArgumentException();
        }
        this.gauge = gauge;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public void setType(AlertType alertType) {
    }

    protected void close() {
        Emulator.getCurrentDisplay().setCurrent(this.lastDisplayed);
    }

    @Override
    protected void _paint(Graphics g) {
        int n = this.bounds[2] - 8;
        this.textArr = TextUtils.textArr(this.string, Screen.font, n, n);
        g.setColor(LCDUIUtils.foregroundColor);
        int h2 = Screen.fontHeight4 - this.scroll;
        g.setClip(this.bounds[0], this.bounds[1], this.bounds[2], this.bounds[3]);
        for (int i2 = 0; i2 < this.textArr.length; ++i2) {
            g.drawString(this.textArr[i2], 4, h2 + 2, 0);
            h2 += Screen.fontHeight4;
        }
        if (this.gauge != null) {
            this.gauge.screen = this;
            this.gauge.bounds[0] = 0;
            this.gauge.bounds[1] = h2;
            this.gauge.paint(g, 2, h2, this.bounds[2] - 4, 0);
        }
        if (this.lastDisplayed != null && this.timeShown != 0L && this.timeout >= 0 && this.commands.size() <= 1 && System.currentTimeMillis() - this.timeShown > (long)this.timeout) {
            this.close();
        }
    }

    @Override
    public int _repaintInterval() {
        return this.gauge != null || this.timeout >= 0 || this.ticker != null ? 500 : -1;
    }

    @Override
    protected void _keyScroll(int key, boolean repeat) {
        if (key == 1) {
            this.scroll = Math.max(0, this.scroll - Screen.fontHeight4);
            this.repaintScreen();
            this.timeout = -2;
            return;
        }
        if (key == 6) {
            this.scroll = Math.min(this.textArr != null ? Screen.fontHeight4 * this.textArr.length : 0, this.scroll + Screen.fontHeight4);
            this.repaintScreen();
            this.timeout = -2;
        }
    }
}

