/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.nokia.mid.ui.CanvasGraphicsItem;
import com.nokia.mid.ui.CanvasItem;
import com.nokia.mid.ui.TextEditor;
import emulator.Emulator;
import emulator.KeyMapping;
import emulator.Settings;
import emulator.graphics2D.IImage;
import emulator.ui.IScreen;
import java.util.ArrayList;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Screen;

public abstract class Canvas
extends Displayable {
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;
    protected int m_keyStates;
    private Graphics graphics;
    private int vKeyStates;
    private final ArrayList<CanvasItem> nokiaCanvasItems;
    private CanvasItem tappedCanvasItem;

    protected Canvas() {
        this.setFullScreenMode(false);
        this.nokiaCanvasItems = new ArrayList();
    }

    public void _invokePaint(IImage buffer, IImage xray) {
        if (!Settings.xrayView) {
            xray = null;
        }
        if (this.graphics == null) {
            this.graphics = new Graphics(buffer, xray);
        }
        this.graphics._reset(buffer, xray);
        this.paint(this.graphics);
        this.graphics._reset(buffer, xray);
        this._paintOverlay(this.graphics);
    }

    public void _invokePaint(IImage buffer, IImage xray, int x, int y, int w, int h2) {
        if (!Settings.xrayView) {
            xray = null;
        }
        if (this.graphics == null) {
            this.graphics = new Graphics(buffer, xray);
        }
        this.graphics._reset(buffer, xray);
        this.graphics.setClip(x, y, w, h2);
        this.paint(this.graphics);
        this.graphics._reset(buffer, xray);
        this._paintOverlay(this.graphics);
    }

    protected void _paintOverlay(Graphics graphics) {
        super._paintTicker(graphics);
        super._paintSoftMenu(graphics);
        for (CanvasItem i2 : this.nokiaCanvasItems) {
            if (!i2.isVisible()) continue;
            if (i2 instanceof CanvasGraphicsItem) {
                graphics.setClip(i2.getPositionX(), i2.getPositionY(), i2.getWidth(), i2.getHeight());
                graphics.translate(-i2.getPositionX(), -i2.getPositionY());
                ((CanvasGraphicsItem)i2)._invokePaint(graphics);
                graphics._reset();
                continue;
            }
            if (!(i2 instanceof TextEditor)) continue;
            ((TextEditor)i2)._invokePaint(graphics);
        }
    }

    public void _invokeKeyReleased(int n) {
        int i2 = 1 << this.getGameAction(n);
        if ((this.m_keyStates & i2) != 0) {
            this.m_keyStates &= ~i2;
        }
        if ((this.vKeyStates & (i2 = this.getKeyBit(n))) != 0) {
            this.vKeyStates &= ~i2;
        }
        this.keyReleased(n);
    }

    public void _invokeKeyPressed(int n) {
        this.m_keyStates |= 1 << this.getGameAction(n);
        this.vKeyStates |= this.getKeyBit(n);
        this.keyPressed(n);
    }

    public void _invokeKeyRepeated(int n) {
        this.keyRepeated(n);
    }

    public void _invokeHideNotify() {
        this.hideNotify();
    }

    public void _invokeShowNotify() {
        this.showNotify();
        IScreen s = Emulator.getEmulator().getScreen();
        if (this.w != s.getWidth() || this.h != this.getActualHeight()) {
            this._invokeSizeChanged(s.getWidth(), s.getHeight());
        }
    }

    int getActualHeight() {
        int h2 = Emulator.getEmulator().getScreen().getHeight();
        if (!this.fullScreen) {
            h2 -= this.ticker == null ? Screen.fontHeight4 : Screen.fontHeight4 * 2;
        }
        return h2;
    }

    @Override
    public void _invokeSizeChanged(int w, int h2) {
        if (!this.fullScreen) {
            h2 -= this.ticker == null ? Screen.fontHeight4 : Screen.fontHeight4 * 2;
        }
        if (this.w != w || this.h != h2 || this.forceUpdateSize) {
            this.w = this.bounds[2] = w;
            this.h = this.bounds[3] = h2;
            this.sizeChanged(w, h2);
            if (!Settings.dontRepaintOnSetCurrent) {
                this.repaint();
            }
        }
    }

    protected abstract void paint(Graphics var1);

    protected void keyReleased(int n) {
    }

    protected void keyPressed(int n) {
    }

    protected void keyRepeated(int n) {
    }

    public void repaint() {
        this.repaint(0, 0, this.w, this.h);
    }

    public void repaint(int x, int y, int w, int h2) {
        if (this != Emulator.getCurrentDisplay().getCurrent()) {
            return;
        }
        Emulator.getEventQueue().queueRepaint(x, y, w, h2);
    }

    public void serviceRepaints() {
        if (this != Emulator.getCurrentDisplay().getCurrent()) {
            return;
        }
        Emulator.getEventQueue().serviceRepaints();
    }

    protected void hideNotify() {
    }

    protected void showNotify() {
    }

    @Override
    public int getWidth() {
        return this.w;
    }

    public void setFullScreenMode(boolean b2) {
        if (!Settings.ignoreFullScreen) {
            if (b2 == this.fullScreen) {
                return;
            }
            this.fullScreen = b2;
            this.updateSize(true);
        } else if (!this.fullScreen) {
            this.fullScreen = true;
            this.updateSize(true);
        }
    }

    @Override
    protected void sizeChanged(int n, int n2) {
    }

    protected void pointerPressed(int n, int n2) {
    }

    protected void pointerReleased(int n, int n2) {
    }

    protected void pointerDragged(int n, int n2) {
    }

    public void invokePointerPressed(int x, int y) {
        CanvasItem i2 = this.getCanvasItemAt(x, y);
        if (i2 != null) {
            this.tappedCanvasItem = i2;
            if (i2 instanceof TextEditor) {
                ((TextEditor)i2).setFocus(true);
            }
            return;
        }
        this.pointerPressed(x, y);
    }

    public void invokePointerReleased(int x, int y) {
        if (this.tappedCanvasItem != null) {
            this.tappedCanvasItem = null;
            return;
        }
        this.pointerReleased(x, y);
    }

    public void invokePointerDragged(int x, int y) {
        if (this.tappedCanvasItem != null) {
            return;
        }
        this.pointerDragged(x, y);
    }

    public int getGameAction(int n) {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 49: {
                n3 = 9;
                break;
            }
            case 51: {
                n3 = 10;
                break;
            }
            case 55: {
                n3 = 11;
                break;
            }
            case 57: {
                n3 = 12;
                break;
            }
            default: {
                if (n == KeyMapping.getArrowKeyFromDevice(1) || n == 50) {
                    n3 = 1;
                    break;
                }
                if (n == KeyMapping.getArrowKeyFromDevice(6) || n == 56) {
                    n3 = 6;
                    break;
                }
                if (n == KeyMapping.getArrowKeyFromDevice(2) || n == 52) {
                    n3 = 2;
                    break;
                }
                if (n == KeyMapping.getArrowKeyFromDevice(5) || n == 54) {
                    n3 = 5;
                    break;
                }
                if (n == KeyMapping.getArrowKeyFromDevice(8) || n == 53) {
                    n3 = 8;
                    break;
                }
                return n2;
            }
        }
        n2 = n3;
        return n2;
    }

    public int getKeyCode(int n) {
        int r = 0;
        switch (n) {
            case 1: {
                r = KeyMapping.getArrowKeyFromDevice(1);
                break;
            }
            case 6: {
                r = KeyMapping.getArrowKeyFromDevice(6);
                break;
            }
            case 2: {
                r = KeyMapping.getArrowKeyFromDevice(2);
                break;
            }
            case 5: {
                r = KeyMapping.getArrowKeyFromDevice(5);
                break;
            }
            case 8: {
                r = KeyMapping.getArrowKeyFromDevice(8);
                break;
            }
            case 9: {
                r = 49;
                break;
            }
            case 10: {
                r = 51;
                break;
            }
            case 11: {
                r = 55;
                break;
            }
            case 12: {
                r = 57;
                break;
            }
        }
        return r;
    }

    public String getKeyName(int n) {
        if (n == 8) {
            return "Backspace";
        }
        if (n == 32) {
            return "Space";
        }
        if (n >= 32 && n <= 126) {
            return String.valueOf((char)n);
        }
        String s = "";
        switch (n) {
            case 48: {
                s = "0";
                break;
            }
            case 49: {
                s = "1";
                break;
            }
            case 50: {
                s = "2";
                break;
            }
            case 51: {
                s = "3";
                break;
            }
            case 52: {
                s = "4";
                break;
            }
            case 53: {
                s = "5";
                break;
            }
            case 54: {
                s = "6";
                break;
            }
            case 55: {
                s = "7";
                break;
            }
            case 56: {
                s = "8";
                break;
            }
            case 57: {
                s = "9";
                break;
            }
            case 42: {
                s = "*";
                break;
            }
            case 35: {
                s = "#";
                break;
            }
            default: {
                if (n == KeyMapping.getArrowKeyFromDevice(1)) {
                    s = "Up";
                    break;
                }
                if (n == KeyMapping.getArrowKeyFromDevice(6)) {
                    s = "Down";
                    break;
                }
                if (n == KeyMapping.getArrowKeyFromDevice(2)) {
                    s = "Left";
                    break;
                }
                if (n == KeyMapping.getArrowKeyFromDevice(5)) {
                    s = "Right";
                    break;
                }
                if (n == KeyMapping.getArrowKeyFromDevice(8)) {
                    s = "Select";
                    break;
                }
                return s;
            }
        }
        return s;
    }

    public boolean hasPointerEvents() {
        return Settings.hasPointerEvents;
    }

    public boolean hasPointerMotionEvents() {
        return Settings.hasPointerEvents;
    }

    public boolean hasRepeatEvents() {
        return Settings.enableKeyRepeat;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    private int getKeyBit(int vKey) {
        switch (this.getGameAction(vKey)) {
            case 1: {
                return 4096;
            }
            case 2: {
                return 8192;
            }
            case 5: {
                return 16384;
            }
            case 6: {
                return 32768;
            }
            case 8: {
                return 65536;
            }
            case 11: {
                return 524288;
            }
        }
        switch (vKey) {
            case 48: {
                return 1;
            }
            case 49: {
                return 2;
            }
            case 50: {
                return 4;
            }
            case 51: {
                return 8;
            }
            case 52: {
                return 16;
            }
            case 53: {
                return 32;
            }
            case 54: {
                return 64;
            }
            case 55: {
                return 128;
            }
            case 56: {
                return 256;
            }
            case 57: {
                return 512;
            }
            case 42: {
                return 1024;
            }
            case 35: {
                return 2048;
            }
        }
        if (KeyMapping.isLeftSoft(vKey)) {
            return 131072;
        }
        if (KeyMapping.isRightSoft(vKey)) {
            return 262144;
        }
        return 0;
    }

    public int _getKeyStatesVodafone() {
        return this.vKeyStates;
    }

    public void _removeNokiaCanvasItem(CanvasItem i2) {
        this.nokiaCanvasItems.remove(i2);
    }

    public void _addNokiaCanvasItem(CanvasItem i2) {
        this.nokiaCanvasItems.add(i2);
    }

    private CanvasItem getCanvasItemAt(int x, int y) {
        if (this.nokiaCanvasItems.isEmpty()) {
            return null;
        }
        for (CanvasItem i2 : this.nokiaCanvasItems) {
            if (!i2.isVisible()) continue;
            int ix = i2.getPositionX();
            int iy = i2.getPositionY();
            if (x < ix || x > ix + i2.getWidth() || y < iy || y > iy + i2.getHeight()) continue;
            return i2;
        }
        return null;
    }

    @Override
    protected void defocus() {
        super.defocus();
        if (this.nokiaCanvasItems.isEmpty()) {
            return;
        }
        for (CanvasItem i2 : this.nokiaCanvasItems) {
            if (!i2.isVisible() || !(i2 instanceof TextEditor)) continue;
            ((TextEditor)i2).setFocus(false);
        }
    }
}

