/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.Emulator;
import emulator.KeyMapping;
import emulator.lcdui.TextUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Row;

public abstract class CustomItem
extends Item {
    protected static final int TRAVERSE_HORIZONTAL = 1;
    protected static final int TRAVERSE_VERTICAL = 2;
    protected static final int KEY_PRESS = 4;
    protected static final int KEY_RELEASE = 8;
    protected static final int KEY_REPEAT = 16;
    protected static final int POINTER_PRESS = 32;
    protected static final int POINTER_RELEASE = 64;
    protected static final int POINTER_DRAG = 128;
    protected static final int NONE = 0;
    private Image img;
    private Graphics g;
    int[] anIntArray429 = new int[4];
    private boolean wasHidden = true;
    private int lastWidth;
    private int lastHeight;
    private boolean repaintPending;
    private int contentWidth;
    private int contentHeight;

    protected CustomItem(String s) {
        super(s);
    }

    public int getGameAction(int n) {
        int n2 = n;
        switch (n) {
            case 49: {
                n2 = 9;
                break;
            }
            case 51: {
                n2 = 10;
                break;
            }
            case 55: {
                n2 = 11;
                break;
            }
            case 57: {
                n2 = 12;
                break;
            }
            default: {
                if (n == KeyMapping.getArrowKeyFromDevice(1)) {
                    n2 = 1;
                    break;
                }
                if (n == KeyMapping.getArrowKeyFromDevice(6)) {
                    n2 = 6;
                    break;
                }
                if (n == KeyMapping.getArrowKeyFromDevice(2)) {
                    n2 = 2;
                    break;
                }
                if (n == KeyMapping.getArrowKeyFromDevice(5)) {
                    n2 = 5;
                    break;
                }
                if (n != KeyMapping.getArrowKeyFromDevice(8)) break;
                n2 = 8;
            }
        }
        return n2;
    }

    protected final int getInteractionModes() {
        return 255;
    }

    protected abstract int getMinContentWidth();

    protected abstract int getMinContentHeight();

    protected abstract int getPrefContentWidth(int var1);

    protected abstract int getPrefContentHeight(int var1);

    protected void sizeChanged(int w, int h2) {
    }

    protected final void invalidate() {
        this.repaintPending = true;
        this.repaintForm();
    }

    protected abstract void paint(Graphics var1, int var2, int var3);

    protected final void repaint() {
        this.repaintPending = true;
        this.repaintForm();
    }

    protected final void repaint(int n, int n2, int n3, int n4) {
        this.repaint();
    }

    protected boolean traverse(int n, int n2, int n3, int[] array) {
        return false;
    }

    protected void traverseOut() {
    }

    protected void keyPressed(int n) {
        if (n == KeyMapping.getArrowKeyFromDevice(8) && this.itemCommandListener != null && this.defaultCommand != null) {
            Emulator.getEventQueue().commandAction(this.defaultCommand, this);
        }
    }

    protected void keyReleased(int n) {
    }

    protected void keyRepeated(int n) {
    }

    @Override
    protected void pointerPressed(int n, int n2) {
    }

    protected void pointerReleased(int n, int n2) {
    }

    protected void pointerDragged(int n, int n2) {
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    @Override
    void hidden() {
        super.hidden();
        if (this.img == null) {
            return;
        }
        this.g.dispose();
        this.g = null;
        this.img.dispose();
        this.img = null;
        try {
            this.wasHidden = true;
            this.hideNotify();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    void paint(Graphics graphics, int x, int y, int w, int h2) {
        super.paint(graphics, x, y, w, h2);
        if (this.wasHidden) {
            try {
                this.showNotify();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.wasHidden = false;
        }
        if (this.img == null) {
            this.img = Image.createImage(Emulator.getEmulator().getScreen().getWidth(), Emulator.getEmulator().getScreen().getHeight());
            this.g = this.img.getGraphics();
            this.repaintPending = true;
        }
        int n = x + 2;
        int n2 = y + 2;
        if (this.repaintPending) {
            this.g.setColor(-1);
            this.g.fillRect(0, 0, this.screen.w, this.screen.h);
            this.g.setColor(0);
            this.contentWidth = this.getPrefContentWidth(w);
            this.contentHeight = this.getPrefContentHeight(h2);
            this.paint(this.g, this.contentWidth, this.contentHeight);
        }
        if (this.labelArr != null && this.labelArr.length > 0) {
            graphics.setFont(this.labelFont);
            for (int i2 = 0; i2 < this.labelArr.length; ++i2) {
                graphics.drawString(this.labelArr[i2], x + 4, n2 + 2, 0);
                n2 += this.labelFont.getHeight() + 4;
            }
        }
        graphics.drawRegion(this.img, 0, 0, Math.min(this.img.getWidth(), Math.min(w, this.contentWidth)), Math.min(this.img.getHeight(), Math.min(h2 - n2 + y, this.contentHeight)), 0, n, n2, 0);
    }

    @Override
    void layout(Row row) {
        super.layout(row);
        int n = 0;
        int w = Math.min(row.getAvailableWidth(this.screen.bounds[2]), this.getPreferredWidth() - 8);
        if (this.hasLabel()) {
            this.labelArr = TextUtils.textArr(this.label, this.labelFont, w, w);
            n = (this.labelFont.getHeight() + 4) * this.labelArr.length;
        } else {
            this.labelArr = null;
        }
        int h2 = this.getPrefContentHeight(this.bounds[3]);
        this.bounds[3] = n + (h2 + 4);
        w = this.getPreferredWidth();
        if (this.lastWidth != w || this.lastHeight != h2) {
            try {
                this.sizeChanged(w, h2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastWidth = w;
            this.lastHeight = h2;
        }
    }

    protected boolean callTraverse(int n) {
        if (this.screen == null) {
            return false;
        }
        if (this.anIntArray429 == null) {
            return false;
        }
        return this.traverse(this.getGameAction(n), this.screen.w, this.screen.h, this.anIntArray429);
    }

    @Override
    boolean isFocusable() {
        return true;
    }
}

