/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.Emulator;
import emulator.lcdui.TextUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Row;
import javax.microedition.lcdui.Screen;

public class DateField
extends Item {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATE_TIME = 3;
    private static int width1 = Item.font.stringWidth("00") + 2;
    private static int width2 = Item.font.stringWidth("0000") + 2;
    private static int width3 = Item.font.stringWidth(":") + 2;
    private int mode;
    private Date date;
    private int pos;
    private boolean updateFocus;
    private int caretX;
    private int caretY;
    private StringBuffer buffer;
    private boolean typing;

    public DateField(String s, int n) {
        this(s, n, null);
    }

    public DateField(String s, int inputMode, TimeZone timeZone) {
        super(s);
        this.setInputMode(inputMode);
        this.setDate(new Date());
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date aDate348) {
        this.date = aDate348;
        this.repaintForm();
    }

    public int getInputMode() {
        return this.mode;
    }

    public void setInputMode(int anInt349) {
        if (anInt349 != 1 && anInt349 != 2 && anInt349 != 3) {
            throw new IllegalArgumentException();
        }
        this.mode = anInt349;
        this.repaintForm();
    }

    @Override
    void focus() {
        super.focus();
        Emulator.getEmulator().getScreen().getCaret().focusItem(this, this.caretX, this.caretY);
        this.updateFocus = true;
    }

    @Override
    void defocus() {
        if (this.focused || !this.updateFocus) {
            Emulator.getEmulator().getScreen().getCaret().defocusItem(this);
        }
        if (this.focused) {
            this._input('\u0000');
        }
        super.defocus();
        this.updateFocus = true;
    }

    @Override
    void hidden() {
        if (this.focused || !this.updateFocus) {
            Emulator.getEmulator().getScreen().getCaret().defocusItem(this);
        }
        this.updateFocus = true;
    }

    @Override
    synchronized void paint(Graphics g, int x, int y, int w, int h2) {
        int xo;
        super.paint(g, x, y, w, h2);
        g.setColor(0);
        int yo = y;
        if (this.labelArr != null && this.labelArr.length > 0) {
            g.setFont(this.labelFont);
            for (int i2 = 0; i2 < this.labelArr.length; ++i2) {
                g.drawString(this.labelArr[i2], x + 4, yo + 2, 0);
                yo += this.labelFont.getHeight() + 4;
            }
        }
        if (this.focused) {
            g.setColor(-8355712);
        }
        g.drawRect(2, yo, w - 4, this.bounds[3] - yo + y - 2);
        g.setFont(Screen.font);
        g.setColor(0);
        int fh = Screen.font.getHeight();
        Calendar c2 = Calendar.getInstance();
        c2.setTime(this.date);
        int cx = xo = x + 4;
        int pos = this.pos;
        String s = "";
        if ((this.mode & 1) != 0) {
            if (this.focused && pos == 0) {
                if (this.typing) {
                    s = this.buffer.toString();
                } else {
                    g.setColor(-11178603);
                    g.fillRect(xo, yo, width1, fh);
                    g.setColor(-1);
                }
            }
            if (!(this.focused && pos == 0 && this.typing || (s = Integer.toString(c2.get(5))).length() >= 2)) {
                s = "0".concat(s);
            }
            g.drawString(s, xo, yo, 0);
            if (pos == 0) {
                cx = xo + Screen.font.stringWidth(s);
            }
            g.setColor(0);
            g.drawString(".", xo += width1, yo, 0);
            xo += width3;
            if (this.focused && pos == 1) {
                if (this.typing) {
                    s = this.buffer.toString();
                } else {
                    g.setColor(-11178603);
                    g.fillRect(xo, yo, width1, fh);
                    g.setColor(-1);
                }
            }
            if (!(this.focused && pos == 1 && this.typing || (s = Integer.toString(c2.get(2) + 1)).length() >= 2)) {
                s = "0".concat(s);
            }
            g.drawString(s, xo, yo, 0);
            if (pos == 1) {
                cx = xo + Screen.font.stringWidth(s);
            }
            g.setColor(0);
            g.drawString(".", xo += width1, yo, 0);
            xo += width3;
            if (this.focused && pos == 2) {
                if (this.typing) {
                    s = this.buffer.toString();
                } else {
                    g.setColor(-11178603);
                    g.fillRect(xo, yo, width2, fh);
                    g.setColor(-1);
                }
            }
            if (!this.focused || pos != 2 || !this.typing) {
                s = Integer.toString(c2.get(1));
                while (s.length() < 4) {
                    s = "0".concat(s);
                }
            }
            g.drawString(s, xo, yo, 0);
            if (pos == 2) {
                cx = xo + Screen.font.stringWidth(s);
            }
            xo += width2 + width3 + 8;
            pos -= 3;
        }
        if ((this.mode & 2) != 0) {
            g.setColor(0);
            if (this.focused && pos == 0) {
                if (this.typing) {
                    s = this.buffer.toString();
                } else {
                    g.setColor(-11178603);
                    g.fillRect(xo, yo, width1, fh);
                    g.setColor(-1);
                }
            }
            if (!(this.focused && pos == 0 && this.typing || (s = Integer.toString(c2.get(11))).length() >= 2)) {
                s = "0".concat(s);
            }
            g.drawString(s, xo, yo, 0);
            if (pos == 0) {
                cx = xo + Screen.font.stringWidth(s);
            }
            g.setColor(0);
            g.drawString(":", xo += width1, yo, 0);
            xo += width3;
            if (this.focused && pos == 1) {
                if (this.typing) {
                    s = this.buffer.toString();
                } else {
                    g.setColor(-11178603);
                    g.fillRect(xo, yo, width1, fh);
                    g.setColor(-1);
                }
            }
            if (!(this.focused && pos == 1 && this.typing || (s = Integer.toString(c2.get(12))).length() >= 2)) {
                s = "0".concat(s);
            }
            g.drawString(s, xo, yo, 0);
            if (pos == 1) {
                cx = xo + Screen.font.stringWidth(s);
            }
        }
        if ((this.caretX != cx || this.caretY != yo + 2 || this.updateFocus) && this.focused) {
            this.updateFocus = false;
            this.caretX = cx;
            this.caretY = yo + 2;
            Emulator.getEmulator().getScreen().getCaret().focusItem(this, this.caretX, this.caretY);
        }
    }

    @Override
    void layout(Row row) {
        super.layout(row);
        int n = 4;
        int availableWidth = row.getAvailableWidth(this.screen.bounds[2]) - 8;
        if (this.hasLabel()) {
            this.labelArr = TextUtils.textArr(this.label, this.labelFont, availableWidth, availableWidth);
            n = 4 + (this.labelFont.getHeight() + 4) * this.labelArr.length;
        } else {
            this.labelArr = null;
        }
        this.bounds[3] = Math.min(n + Screen.font.getHeight(), this.screen.bounds[3]);
    }

    @Override
    public int getMinimumWidth() {
        return Item.font.stringWidth("Some example text") + 6;
    }

    @Override
    public int getMinimumHeight() {
        return (Item.font.getHeight() + 4) * (this.hasLabel() ? 2 : 1);
    }

    @Override
    boolean isFocusable() {
        return true;
    }

    @Override
    boolean keyScroll(int key, boolean repeat) {
        if (key == 2) {
            if (--this.pos < 0) {
                this.pos = 0;
                return false;
            }
            this._input('\u0000');
            return true;
        }
        if (key == 5) {
            int m2;
            int n = this.mode == 3 ? 5 : (m2 = this.mode == 1 ? 3 : 2);
            if (++this.pos >= m2) {
                this.pos = m2 - 1;
                return false;
            }
            this._input('\u0000');
            return true;
        }
        return false;
    }

    private static int monthDays(int month, int year) {
        switch (month) {
            case 1: {
                return year % 400 == 0 || year % 100 != 0 && year % 4 == 0 ? 29 : 28;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
        }
        return 31;
    }

    public synchronized void _input(char n) {
        int pos = this.pos;
        if (this.mode == 2) {
            pos += 3;
        }
        Calendar c2 = Calendar.getInstance();
        c2.setTime(this.date);
        if (!this.typing && n != '\u0000') {
            this.typing = true;
            this.buffer = new StringBuffer().append(n);
        } else if (this.buffer != null) {
            if (n != '\u0000') {
                this.buffer.append(n);
            }
            if (pos == 2) {
                if (this.buffer.length() >= 4 || n == '\u0000') {
                    int i2 = Integer.parseInt(this.buffer.toString());
                    c2.set(5, Math.min(c2.get(5), DateField.monthDays(c2.get(2), i2)));
                    c2.set(1, i2);
                    this.buffer = null;
                    this.typing = false;
                    this.setDate(c2.getTime());
                }
            } else if (this.buffer.length() >= 2 || n == '\u0000') {
                int i3 = Math.max(0, Integer.parseInt(this.buffer.toString()));
                switch (pos) {
                    case 0: {
                        i3 = Math.min(Math.max(1, i3), DateField.monthDays(c2.get(2), c2.get(1)));
                        c2.set(5, i3);
                        break;
                    }
                    case 1: {
                        i3 = Math.max(1, Math.min(i3, 12)) - 1;
                        c2.set(5, Math.min(c2.get(5), DateField.monthDays(i3, c2.get(1))));
                        c2.set(2, i3);
                        break;
                    }
                    case 3: {
                        i3 = Math.min(i3, 23);
                        c2.set(11, i3);
                        c2.set(13, 0);
                        break;
                    }
                    case 4: {
                        i3 = Math.min(i3, 59);
                        c2.set(12, i3);
                        c2.set(13, 0);
                    }
                }
                this.buffer = null;
                this.typing = false;
                this.setDate(c2.getTime());
            }
        }
        this.repaintForm();
    }
}

