/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.Emulator;
import emulator.Settings;
import emulator.lcdui.LCDUIUtils;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class Display {
    public static final int LIST_ELEMENT = 1;
    public static final int CHOICE_GROUP_ELEMENT = 2;
    public static final int ALERT = 3;
    public static final int COLOR_BACKGROUND = 0;
    public static final int COLOR_FOREGROUND = 1;
    public static final int COLOR_HIGHLIGHTED_BACKGROUND = 2;
    public static final int COLOR_HIGHLIGHTED_FOREGROUND = 3;
    public static final int COLOR_BORDER = 4;
    public static final int COLOR_HIGHLIGHTED_BORDER = 5;
    static Displayable current;
    static Hashtable displays;
    private static Display staticDisplay;
    private MIDlet midlet;

    public Display() {
    }

    public Display(MIDlet midlet) {
        this.midlet = midlet;
    }

    public boolean isColor() {
        return true;
    }

    public int numColors() {
        return Integer.MAX_VALUE;
    }

    public int numAlphaLevels() {
        return 256;
    }

    public Displayable getCurrent() {
        return current;
    }

    public void setCurrent(Displayable d) {
        if (d == current) {
            return;
        }
        if (current != null) {
            current.defocus();
            Emulator.getEventQueue().notifyHidden(d);
        }
        Emulator.getEmulator().getScreen().getCaret().displayableChanged();
        if (d != null) {
            current = d;
            if (d instanceof Canvas) {
                if (Settings.blackberryApi) {
                    ((Canvas)d).setFullScreenMode(true);
                }
                Emulator.setCanvas((Canvas)d);
                Emulator.getEventQueue().queue(15);
                if (!Settings.dontRepaintOnSetCurrent) {
                    Emulator.getEventQueue().queueRepaint();
                }
            } else if (d instanceof Screen) {
                Emulator.setScreen((Screen)d);
                d._shown();
                Emulator.getEventQueue().queue(4);
                if (d instanceof TextBox) {
                    ((TextBox)d).focusCaret();
                }
            }
            d.updateCommands();
        }
    }

    public static Display getDisplay(MIDlet midlet) {
        if (staticDisplay != null) {
            return staticDisplay;
        }
        if (midlet == null) {
            staticDisplay = new Display();
            return staticDisplay;
        }
        if (displays.get(midlet) == null) {
            displays.put(midlet, new Display(midlet));
        }
        return (Display)displays.get(midlet);
    }

    public void callSerially(Runnable run) {
        Emulator.getEventQueue().callSerially(run);
    }

    public boolean flashBacklight(int n) {
        return false;
    }

    public boolean flashBacklight(long n) {
        return false;
    }

    public boolean vibrate(int n) {
        if (n == 0) {
            Emulator.getEmulator().getScreen().stopVibra();
        } else {
            Emulator.getEmulator().getScreen().startVibra(n);
        }
        return true;
    }

    public int getBestImageWidth(int n) {
        return this.getBestImageHeight(n);
    }

    public int getBestImageHeight(int n) {
        switch (n) {
            case 1: {
                return 48;
            }
            case 2: 
            case 3: {
                return 16;
            }
        }
        return 0;
    }

    public int getBorderStyle(boolean b2) {
        return 0;
    }

    public int getColor(int n) {
        switch (n) {
            case 0: {
                return LCDUIUtils.backgroundColor;
            }
            case 1: {
                return LCDUIUtils.foregroundColor;
            }
            case 2: {
                return LCDUIUtils.highlightedBackgroundColor;
            }
            case 3: {
                return LCDUIUtils.highlightedForegroundColor;
            }
            case 4: {
                return LCDUIUtils.borderColor;
            }
            case 5: {
                return LCDUIUtils.highlightedBorderColor;
            }
        }
        return 0;
    }

    public void dispose() {
        displays.put(this.midlet, null);
    }

    public void setCurrent(Alert alert, Displayable ret) {
        if (alert == null || ret == null) {
            throw new NullPointerException();
        }
        if (ret instanceof Alert) {
            throw new IllegalArgumentException();
        }
        if (current != null) {
            current.defocus();
        }
        current = alert;
        alert.lastDisplayed = ret;
        Emulator.setScreen(alert);
        alert._shown();
        Emulator.getEventQueue().queue(4);
        alert.updateCommands();
    }

    public void setCurrentItem(Item item) {
        if (item == null) {
            throw new NullPointerException();
        }
        if (item.screen == null || item.screen instanceof Alert) {
            throw new IllegalArgumentException();
        }
        this.setCurrent(item.screen);
        ((Form)item.screen).setCurrentItem(item);
    }

    static {
        displays = new Hashtable();
    }
}

