/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.Emulator;
import emulator.KeyMapping;
import emulator.Settings;
import emulator.UILocale;
import emulator.debug.Profiler;
import emulator.lcdui.LCDUIUtils;
import emulator.media.capture.CapturePlayerImpl;
import emulator.ui.CommandsMenuPosition;
import emulator.ui.IScreen;
import emulator.ui.TargetedCommand;
import java.util.Arrays;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.Ticker;

public class Displayable {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int W = 2;
    public static final int H = 3;
    String title;
    Vector commands;
    CommandListener cmdListener = null;
    Item focusedItem = null;
    int w;
    int h;
    int[] bounds;
    Ticker ticker;
    int tickerX;
    private static long lastFrameTime;
    private static long lastFpsUpdateTime;
    private static int framesCount;
    boolean fullScreen;
    private static final long MILLI_TO_NANO = 1000000L;
    boolean forceUpdateSize;
    private Command leftCommand;
    private Command rightCommand;
    private final Vector<Command> menuCommands = new Vector();
    final Object lock = new Object();

    public Displayable() {
        this.commands = new Vector();
        IScreen s = Emulator.getEmulator().getScreen();
        this.w = s.getWidth();
        this.h = s.getHeight();
        this.bounds = this instanceof Canvas ? new int[]{0, 0, this.w, this.h - Screen.fontHeight4} : new int[]{0, Screen.fontHeight4, this.w - 4, this.h - Screen.fontHeight4};
    }

    public int getWidth() {
        return this.bounds[2];
    }

    public int getHeight() {
        return this.bounds[3];
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isShown() {
        return Display.current == this && (!Settings.hideDisplayableOnMinimize || Emulator.getEmulator().getScreen().isShown());
    }

    protected void defocus() {
        if (this.focusedItem != null) {
            this.focusedItem.defocus();
            this.focusedItem = null;
        }
    }

    protected void setItemCommands(Item item) {
        this.focusedItem = item;
        this.updateCommands();
    }

    protected void removeItemCommands(Item item) {
        if (item == null || item != this.focusedItem) {
            return;
        }
        this.focusedItem = null;
        this.updateCommands();
    }

    protected void updateCommands() {
        this.leftCommand = null;
        this.rightCommand = null;
        Object ok = null;
        this.menuCommands.clear();
        Object[] arr = this.commands.toArray(new Command[0]);
        Arrays.sort(arr);
        this.menuCommands.addAll(Arrays.asList(arr));
        block4: for (Object cmd : arr) {
            int type = ((Command)cmd).getCommandType();
            switch (type) {
                case 4: {
                    if (ok != null) continue block4;
                    ok = cmd;
                    this.menuCommands.remove(cmd);
                    this.menuCommands.insertElementAt((Command)cmd, 0);
                    continue block4;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    if (this.rightCommand != null) continue block4;
                    this.rightCommand = cmd;
                    this.menuCommands.remove(cmd);
                }
            }
        }
        if (this.rightCommand == null && this.menuCommands.size() > 1) {
            Command cmd;
            this.rightCommand = cmd = this.menuCommands.lastElement();
            this.menuCommands.remove(cmd);
        }
        String leftLabel = "";
        String rightLabel = "";
        if (this.hasMenuOnLeft()) {
            leftLabel = UILocale.get("LCDUI_MENU_COMMAND", "Menu");
        } else if (!this.menuCommands.isEmpty()) {
            leftLabel = this.menuCommands.get(0).getLabel();
        } else if (this.leftCommand != null) {
            leftLabel = this.leftCommand.getLabel();
        }
        if (this.rightCommand != null) {
            rightLabel = this.rightCommand.getLabel();
        }
        Emulator.getEmulator().getScreen().setLeftSoftLabel(leftLabel);
        Emulator.getEmulator().getScreen().setRightSoftLabel(rightLabel);
    }

    private boolean hasMenuOnLeft() {
        int count = this.menuCommands.size();
        if (this.focusedItem != null && !this.focusedItem.commands.isEmpty()) {
            count += this.focusedItem.commands.size();
        }
        return count > 1;
    }

    protected boolean isCommandsEmpty() {
        return this.commands.isEmpty();
    }

    public void addCommand(Command command) {
        if (command == null || this.commands.contains(command)) {
            return;
        }
        this.commands.add(command);
        if (this.isShown()) {
            this.updateCommands();
        }
    }

    public void removeCommand(Command command) {
        if (this.commands.contains(command)) {
            this.commands.remove(command);
            if (this.isShown()) {
                this.updateCommands();
            }
        }
    }

    protected Command getLeftSoftCommand() {
        if (this.focusedItem != null && !this.focusedItem.commands.isEmpty()) {
            return this.focusedItem.commands.get(0);
        }
        if (!this.menuCommands.isEmpty()) {
            return this.menuCommands.get(0);
        }
        return this.leftCommand;
    }

    protected Command getRightSoftCommand() {
        return this.rightCommand;
    }

    public boolean handleSoftKeyAction(int n, boolean b2) {
        boolean fix;
        if (this.cmdListener == null && this instanceof Canvas) {
            return false;
        }
        boolean bl = fix = Settings.motorolaSoftKeyFix || Settings.softbankApi;
        if (KeyMapping.isLeftSoft(n)) {
            if (this.hasMenuOnLeft()) {
                if (b2) {
                    Vector<TargetedCommand> cmds = this.buildAllCommands();
                    Emulator.getEmulator().getScreen().showCommandsList(cmds, CommandsMenuPosition.CommandsButton, 0, 0);
                }
                return !fix;
            }
            Command leftSoftCommand = this.getLeftSoftCommand();
            if (b2 && leftSoftCommand != null) {
                Emulator.getEmulator().getLogStream().println("Left command: " + leftSoftCommand);
                if (this instanceof Alert && leftSoftCommand == Alert.DISMISS_COMMAND) {
                    if (this.cmdListener != null) {
                        Emulator.getEventQueue().commandAction(leftSoftCommand, this);
                    } else {
                        ((Alert)this).close();
                    }
                } else if (this.focusedItem != null && this.focusedItem.commands.contains(leftSoftCommand)) {
                    Emulator.getEventQueue().commandAction(leftSoftCommand, this.focusedItem);
                } else if (this.cmdListener != null) {
                    Emulator.getEventQueue().commandAction(leftSoftCommand, this);
                }
            }
            return leftSoftCommand != null && !fix;
        }
        if (KeyMapping.isRightSoft(n)) {
            Command rightSoftCommand = this.getRightSoftCommand();
            if (b2 && rightSoftCommand != null) {
                Emulator.getEmulator().getLogStream().println("Right command: " + rightSoftCommand);
                if (this instanceof Alert && rightSoftCommand == Alert.DISMISS_COMMAND) {
                    if (this.cmdListener != null) {
                        Emulator.getEventQueue().commandAction(rightSoftCommand, this);
                    } else {
                        ((Alert)this).close();
                    }
                } else if (this.focusedItem != null && this.focusedItem.commands.contains(rightSoftCommand)) {
                    Emulator.getEventQueue().commandAction(rightSoftCommand, this.focusedItem);
                } else if (this.cmdListener != null) {
                    Emulator.getEventQueue().commandAction(rightSoftCommand, this);
                }
            }
            return rightSoftCommand != null && !fix;
        }
        return false;
    }

    public void _callCommandAction(Command command) {
        if (this.cmdListener != null && command != null) {
            this.cmdListener.commandAction(command, this);
        }
    }

    public void setCommandListener(CommandListener listener) {
        this.cmdListener = listener;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.isShown()) {
            Emulator.getEmulator().getScreen().updateTitle();
        }
    }

    protected void sizeChanged(int n, int n2) {
    }

    public void _invokeSizeChanged(int w, int h2) {
        this._invokeSizeChanged(w, h2, true);
    }

    void _invokeSizeChanged(int w, int h2, boolean b2) {
        if (this.w != w || this.h != h2 || this.forceUpdateSize) {
            this.forceUpdateSize = false;
            this.w = w;
            this.h = h2;
            if (!this.fullScreen) {
                h2 -= this.ticker == null ? Screen.fontHeight4 : Screen.fontHeight4 * 2;
            }
            if (!(this instanceof Canvas)) {
                w -= 4;
            }
            this.bounds[2] = w;
            this.bounds[3] = h2;
            if (b2) {
                this.sizeChanged(w, h2);
            }
        }
        this.repaintScreen();
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTicker(Ticker ticker) {
        Object object = this.lock;
        synchronized (object) {
            this.ticker = ticker;
            this.tickerX = this.w;
            this.updateSize(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _paintTicker(Graphics graphics) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ticker == null) {
                if (!this.fullScreen && this instanceof Canvas) {
                    graphics.setColor(-1);
                    graphics.fillRect(0, this.bounds[3], this.w, Screen.fontHeight4);
                }
                return;
            }
            LCDUIUtils.drawTickerBackground(graphics, 0, Screen.fontHeight4 + this.bounds[3] - 1, this.w, Screen.fontHeight4);
            String t = this.ticker.getString();
            if (t == null) {
                return;
            }
            graphics.setFont(Screen.font);
            graphics.drawString(t, this.tickerX, Screen.fontHeight4 + this.bounds[3] - 1 + 2, 0);
            this.tickerX -= 5;
            if (this.tickerX < -Screen.font.stringWidth(t)) {
                this.tickerX = this.w;
            }
        }
    }

    void repaintScreen() {
        int n;
        if (!this.isShown()) {
            return;
        }
        if (this instanceof Canvas) {
            n = 1;
        } else {
            if (!(this instanceof Screen)) {
                return;
            }
            n = 4;
        }
        try {
            Emulator.getEventQueue().queue(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void repaintScreen(Item item) {
        this.repaintScreen();
    }

    protected void _paintSoftMenu(Graphics graphics) {
        CapturePlayerImpl.draw(graphics, Emulator.getCurrentDisplay().getCurrent());
    }

    public static synchronized void _fpsLimiter(boolean b2) {
        long l;
        long elapsed;
        long var2;
        long delta;
        if (b2 && (Settings.speedModifier == 1 || Settings.patchSleep && Settings.applySpeedToSleep) && Settings.frameRate <= 120 && (delta = (var2 = 1000000000L / (long)Settings.frameRate) - (elapsed = System.nanoTime() - lastFrameTime)) > 0L) {
            try {
                Thread.sleep(delta / 1000000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        lastFrameTime = System.nanoTime();
        if (b2) {
            ++framesCount;
        }
        if ((l = lastFrameTime - lastFpsUpdateTime) >= 2000000000L) {
            Profiler.FPS = (int)(((long)framesCount * 1000L + 500L) * 1000000L / l);
            lastFpsUpdateTime = lastFrameTime;
            framesCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void _checkForSteps(Object lock) {
        if (Settings.steps >= 0) {
            if (Settings.steps == 0) {
                long currentTimeMillis = System.currentTimeMillis();
                try {
                    while (Settings.steps == 0) {
                        if (lock == null) {
                            Thread.sleep(50L);
                            continue;
                        }
                        Object object = lock;
                        synchronized (object) {
                            lock.wait(50L);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Settings.aLong1235 += System.currentTimeMillis() - currentTimeMillis;
            }
            --Settings.steps;
        }
    }

    public static void _resetXRayGraphics() {
        Graphics.resetXRayCache();
    }

    protected void _shown() {
        this.updateSize(false);
    }

    Vector<TargetedCommand> buildAllCommands() {
        Vector<TargetedCommand> cmds = new Vector<TargetedCommand>();
        Displayable.buildItemCommands(cmds, this.focusedItem);
        if (!cmds.isEmpty()) {
            cmds.add(null);
        }
        this.buildScreenCommands(cmds);
        return cmds;
    }

    static void buildItemCommands(Vector<TargetedCommand> cmds, Item target) {
        if (target == null) {
            return;
        }
        Vector<Command> targetCommands = target.commands;
        for (Command cmd : targetCommands) {
            cmds.add(new TargetedCommand(cmd, target));
        }
    }

    void buildScreenCommands(Vector<TargetedCommand> cmds) {
        for (Command cmd : this.menuCommands) {
            cmds.add(new TargetedCommand(cmd, this));
        }
    }

    void updateSize(boolean force) {
        IScreen s = Emulator.getEmulator().getScreen();
        if (force) {
            this.forceUpdateSize = true;
            this._invokeSizeChanged(s.getWidth(), s.getHeight(), false);
            this.forceUpdateSize = true;
        }
        if (Emulator.getCurrentDisplay().getCurrent() != this) {
            return;
        }
        Emulator.getEventQueue().sizeChanged(s.getWidth(), s.getHeight());
    }

    static {
        lastFpsUpdateTime = lastFrameTime = System.nanoTime();
        framesCount = 0;
    }
}

