/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.Emulator;
import emulator.graphics2D.IFont;
import java.io.IOException;
import java.io.InputStream;

public class Font {
    IFont font;
    int face;
    int size;
    int style;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int SIZE_SMALL = 8;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_LARGE = 16;
    public static final int FACE_SYSTEM = 0;
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    static Font defaultFont;
    public static final int FONT_STATIC_TEXT = 0;
    public static final int FONT_INPUT_TEXT = 1;

    public Font(int face, int style, int size) {
        this.face = face;
        this.size = size;
        this.style = style;
        int mappedSize = 0;
        switch (size) {
            case 0: {
                mappedSize = Emulator.getEmulator().getProperty().getFontMediumSize();
                break;
            }
            case 16: {
                mappedSize = Emulator.getEmulator().getProperty().getFontLargeSize();
                break;
            }
            default: {
                mappedSize = Emulator.getEmulator().getProperty().getFontSmallSize();
            }
        }
        int filteredStyle = this.style;
        if ((filteredStyle & 4) != 0) {
            filteredStyle &= 0xFFFFFFFB;
        }
        this.font = Emulator.getEmulator().newFont(face, mappedSize, filteredStyle);
    }

    private Font(int face, int size, int style, IFont impl) {
        this.face = face;
        this.size = size;
        this.style = style;
        this.font = impl;
    }

    public IFont getImpl() {
        return this.font;
    }

    public static Font getFont(int n, int n2, int n3) {
        return new Font(n, n2, n3);
    }

    public static Font getDefaultFont() {
        if (defaultFont == null) {
            defaultFont = Font.getFont(0, 0, 8);
        }
        return defaultFont;
    }

    public int charWidth(char c2) {
        return this.font.charWidth(c2);
    }

    public int charsWidth(char[] array, int n, int n2) {
        return this.font.stringWidth(new String(array, n, n2));
    }

    public int substringWidth(String s, int n, int n2) {
        return this.font.stringWidth(s.substring(n, n + n2));
    }

    public int stringWidth(String s) {
        return this.font.stringWidth(s);
    }

    public int getHeight() {
        return this.font.getHeight();
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public int getFace() {
        return this.face;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) == 1;
    }

    public boolean isItalic() {
        return (this.style & 2) == 2;
    }

    public boolean isUnderlined() {
        return (this.style & 4) == 4;
    }

    public int getBaselinePosition() {
        return this.font.getAscent();
    }

    public static Font getFont(int n) {
        return Font.getDefaultFont();
    }

    public static Font _getNokiaUiFont(int face, int style, int height) {
        int filteredStyle = style;
        if ((filteredStyle & 4) != 0) {
            filteredStyle &= 0xFFFFFFFB;
        }
        IFont font = Emulator.getEmulator().newCustomFont(face, height, filteredStyle, true);
        return new Font(face, style, 0, font);
    }

    public static Font createFont(InputStream fontData) throws IOException {
        int size = Emulator.getEmulator().getProperty().getFontMediumSize();
        IFont font = Emulator.getEmulator().loadFont(fontData, size);
        if (font == null) {
            return Font.getDefaultFont();
        }
        return new Font(0, size, 0, font);
    }

    public static Font getFont(String name, int style, int pixelSize) {
        int filteredStyle = style;
        if ((filteredStyle & 4) != 0) {
            filteredStyle &= 0xFFFFFFFB;
        }
        if (pixelSize <= 0) {
            pixelSize = Emulator.getEmulator().getProperty().getFontMediumSize();
        }
        IFont font = Emulator.getEmulator().newFont(name, pixelSize, filteredStyle);
        return new Font(0, style, 0, font);
    }

    public Font deriveFont(int pixelSize) {
        return this.deriveFont(this.style, pixelSize);
    }

    public Font deriveFont(int style, int pixelSize) {
        this.style = style;
        int filteredStyle = this.style;
        if ((filteredStyle & 4) != 0) {
            filteredStyle &= 0xFFFFFFFB;
        }
        if (pixelSize <= 0) {
            pixelSize = Emulator.getEmulator().getProperty().getFontMediumSize();
        }
        IFont font = Emulator.getEmulator().newCustomFont(this.face, pixelSize, filteredStyle, false);
        return new Font(this.face, style, this.size, font);
    }

    public String getFamily() {
        return this.font.getFamily();
    }

    public String getName() {
        return this.font.getName();
    }

    public String getFontName() {
        return this.font.getFontName();
    }

    public int getPixelSize() {
        return this.font.getPixelSize();
    }

    public int getAscent() {
        return this.font.getAscent();
    }

    public int getDescent() {
        return this.font.getDescent();
    }

    public int getMaxAscent() {
        return this.font.getMaxAscent();
    }

    public int getMaxDescent() {
        return this.font.getMaxDescent();
    }

    public int getLeading() {
        return this.font.getLeading();
    }
}

