/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.Emulator;
import emulator.ui.CommandsMenuPosition;
import emulator.ui.TargetedCommand;
import java.util.ArrayList;
import java.util.Vector;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.Row;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class Form
extends Screen {
    ItemStateListener itemStateListener;
    private final ArrayList<Row> rows = new ArrayList();
    private int layoutStart;
    private boolean layout;
    private int layoutHeight;
    private int currentIndexInRow;
    private Item scrollCurrentItem;
    private Item scrollTargetItem;
    private int lastScrollDirection;
    private int currentDir;
    private boolean pointerGrabbed;
    private boolean hasGauges;

    public Form(String s) {
        this(s, null);
    }

    public Form(String s, Item[] array) {
        super(s);
        if (array != null) {
            for (Item item : array) {
                if (item == null) {
                    throw new NullPointerException();
                }
                if (item.screen != null) {
                    throw new IllegalStateException();
                }
                this.items.add(item);
                item.screen = this;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append(Item item) {
        Vector vector2 = this.items;
        synchronized (vector2) {
            if (item == null) {
                throw new NullPointerException();
            }
            if (item.screen != null) {
                throw new IllegalStateException();
            }
            this.items.add(item);
            item.screen = this;
            this.queueLayout(this.items.size() - 1);
            return this.items.size() - 1;
        }
    }

    public int append(String s) {
        return this.append(new StringItem(null, s));
    }

    public int append(Image image) {
        return this.append(new ImageItem(null, image, 0, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int n, Item item) {
        if (item == null) {
            throw new NullPointerException();
        }
        if (item.screen != null) {
            throw new IllegalStateException();
        }
        Vector vector2 = this.items;
        synchronized (vector2) {
            this.items.insertElementAt(item, n);
            item.screen = this;
        }
        this.queueLayout(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int n) {
        if (n < 0 || n >= this.items.size()) {
            throw new IndexOutOfBoundsException();
        }
        Vector vector2 = this.items;
        synchronized (vector2) {
            Item item = (Item)this.items.get(n);
            if (item == this.focusedItem) {
                this.focusedItem = null;
            }
            if (item == this.scrollCurrentItem) {
                this.scrollCurrentItem = null;
            }
            if (item == this.scrollTargetItem) {
                this.scrollTargetItem = null;
            }
            item.screen = null;
            this.items.remove(n);
        }
        this.queueLayout(n - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Vector vector2 = this.items;
        synchronized (vector2) {
            for (Object item : this.items) {
                ((Item)item).screen = null;
            }
            this.items.removeAllElements();
        }
        this.focusedItem = null;
        this.scrollCurrentItem = null;
        this.scrollTargetItem = null;
        this.queueLayout(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int n, Item item) {
        if (n < 0 || n >= this.items.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (item == null) {
            throw new NullPointerException();
        }
        if (item.screen != null) {
            throw new IllegalStateException();
        }
        Vector vector2 = this.items;
        synchronized (vector2) {
            Item prev = (Item)this.items.get(n);
            if (prev == this.focusedItem) {
                this.focusedItem = null;
            }
            if (prev == this.scrollCurrentItem) {
                this.scrollCurrentItem = null;
            }
            if (prev == this.scrollTargetItem) {
                this.scrollTargetItem = null;
            }
            prev.screen = null;
            this.items.set(n, item);
            item.screen = this;
        }
        this.queueLayout(n);
    }

    public Item get(int n) {
        if (n < 0 || n >= this.items.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Item)this.items.get(n);
    }

    public void setItemStateListener(ItemStateListener anItemStateListener858) {
        this.itemStateListener = anItemStateListener858;
    }

    @Override
    protected synchronized void _keyScroll(int key, boolean repeat) {
        if (this.rows.size() == 0) {
            return;
        }
        if (this.scrollTargetItem == null && this.scrollCurrentItem == null) {
            this.scrollTargetItem = this.getFirstVisibleAndFocusableItem();
        }
        if (this.focusedItem != null && this.focusedItem instanceof CustomItem && ((CustomItem)this.focusedItem).callTraverse(key)) {
            return;
        }
        if (this.scrollCurrentItem != null && this.focusedItem == null) {
            this.focusItem(this.scrollCurrentItem);
            this.repaintScreen();
            return;
        }
        int height = this.bounds[3];
        int scrollAmount = Math.max(8, height / 6);
        Row currentRow = this.getFirstRow(this.scrollCurrentItem);
        switch (key) {
            case 1: {
                if (this.focusedItem != null && this.focusedItem.keyScroll(key, repeat)) break;
                this.currentIndexInRow = 0;
                if (this.lastScrollDirection != key) {
                    if (this.scrollCurrentItem != null && !this.isVisible(this.scrollCurrentItem)) {
                        this.scrollCurrentItem = null;
                    }
                    this.scrollTargetItem = null;
                    this.lastScrollDirection = key;
                }
                if (this.scrollCurrentItem != null && this.scrollTargetItem == null) {
                    this.scrollTargetItem = this.getNextFocusableItem(this.scrollCurrentItem, -1);
                }
                if (this.scrollTargetItem != null && this.isVisible(this.scrollTargetItem)) {
                    this.focusItem(this.scrollTargetItem);
                    this.scrollCurrentItem = this.scrollTargetItem;
                    if (this.scrollTargetItem instanceof TextField || this.scrollTargetItem instanceof DateField) {
                        if (!this.isTopVisible(this.scrollTargetItem)) {
                            this.scroll = Math.min(this.getFirstRow((Item)this.scrollTargetItem).y, this.layoutHeight - height + this.bounds[1]);
                        }
                        this.scrollTargetItem = null;
                        break;
                    }
                    if (this.isTopVisible(this.scrollTargetItem)) {
                        this.scrollTargetItem = null;
                        break;
                    }
                }
                this.scroll = Math.max(this.scroll - scrollAmount, 0);
                if (this.scrollTargetItem == null || !this.isVisible(this.scrollTargetItem) || !this.isTopVisible(this.scrollTargetItem)) break;
                this.scrollTargetItem = null;
                break;
            }
            case 6: {
                if (this.focusedItem != null && this.focusedItem.keyScroll(key, repeat)) break;
                this.currentIndexInRow = 0;
                if (this.lastScrollDirection != key) {
                    if (this.scrollCurrentItem != null && !this.isVisible(this.scrollCurrentItem)) {
                        this.scrollCurrentItem = null;
                    }
                    this.scrollTargetItem = null;
                    this.lastScrollDirection = key;
                }
                if (this.scrollCurrentItem != null && this.scrollTargetItem == null) {
                    this.scrollTargetItem = this.getNextFocusableItem(this.scrollCurrentItem, 1);
                }
                if (this.scrollTargetItem != null && this.isVisible(this.scrollTargetItem)) {
                    this.focusItem(this.scrollTargetItem);
                    this.scrollCurrentItem = this.scrollTargetItem;
                    if (this.scrollTargetItem instanceof TextField || this.scrollTargetItem instanceof DateField) {
                        if (!this.isEndVisible(this.scrollTargetItem)) {
                            this.scroll = Math.min(this.getFirstRow((Item)this.scrollTargetItem).y, this.layoutHeight - height + this.bounds[1]);
                        }
                        this.scrollTargetItem = null;
                        break;
                    }
                    if (this.isEndVisible(this.scrollTargetItem)) {
                        this.scrollTargetItem = null;
                        break;
                    }
                }
                this.scroll = Math.min(this.scroll + scrollAmount, this.layoutHeight - height + this.bounds[1]);
                if (this.scrollTargetItem == null || !this.isVisible(this.scrollTargetItem) || !this.isEndVisible(this.scrollTargetItem)) break;
                this.scrollTargetItem = null;
                break;
            }
            case 2: {
                int i2;
                if (this.focusedItem != null && this.focusedItem.keyScroll(key, repeat)) break;
                if (currentRow != null && currentRow.items.size() > 1 && this.currentIndexInRow > 0 && (i2 = this.getNextFocusableItemInRow(currentRow, this.currentIndexInRow, -1)) != -1) {
                    this.currentIndexInRow = i2;
                    this.focusItem(currentRow.items.get((int)i2).item);
                    break;
                }
                this._keyScroll(1, repeat);
                return;
            }
            case 5: {
                int i3;
                if (this.focusedItem != null && this.focusedItem.keyScroll(key, repeat)) break;
                if (currentRow != null && currentRow.items.size() > 1 && this.currentIndexInRow < currentRow.items.size() && (i3 = this.getNextFocusableItemInRow(currentRow, this.currentIndexInRow, 1)) != -1) {
                    this.currentIndexInRow = i3;
                    this.focusItem(currentRow.items.get((int)i3).item);
                    break;
                }
                this._keyScroll(6, repeat);
                return;
            }
        }
        this.repaintScreen();
    }

    @Override
    public boolean _invokePointerPressed(int x, int y) {
        if (super._invokePointerPressed(x, y)) {
            return true;
        }
        int[] r = new int[2];
        Item item = this._getItemAt(x, y, r);
        if (item != null && item.isFocusable()) {
            this.focusItem(item);
            this.pointerGrabbed = true;
            this.focusedItem.pointerPressed(r[0], r[1]);
            this.repaintScreen();
        }
        return false;
    }

    @Override
    public void _invokePointerDragged(int x, int y) {
        if (!this.pointerGrabbed) {
            return;
        }
        int[] r = new int[2];
        Item item = this._getItemAt(x, y, r);
        if (this.focusedItem == item && item instanceof CustomItem) {
            ((CustomItem)this.focusedItem).pointerDragged(r[0], r[1]);
        }
    }

    @Override
    public void _invokePointerReleased(int x, int y) {
        if (!this.pointerGrabbed) {
            return;
        }
        this.pointerGrabbed = false;
        int[] r = new int[2];
        Item item = this._getItemAt(x, y, r);
        if (this.focusedItem == item && item instanceof CustomItem) {
            ((CustomItem)this.focusedItem).pointerReleased(r[0], r[1]);
            this.repaintScreen();
        }
    }

    public Item _getItemAt(int x, int y, int[] transformed) {
        if ((y -= this.bounds[1]) < 0) {
            return null;
        }
        int height = this.bounds[3];
        Row row = this.getFirstVisibleRow();
        if (row == null) {
            return null;
        }
        do {
            if (row.y + row.height < y + this.scroll) continue;
            if (height < row.y - this.scroll) {
                return null;
            }
            int ry = y + this.scroll - row.y;
            for (Row.RowItem o : row.items) {
                if (o.x > x || o.x + o.width < x || o.y > ry || o.y + o.height < ry) continue;
                if (transformed != null) {
                    transformed[0] = x - o.x;
                    transformed[1] = ry - o.y;
                }
                return o.item;
            }
        } while ((row = this.getNextRow(null, row)) != null);
        return null;
    }

    private void focusItem(Item item) {
        if (this.focusedItem == item) {
            return;
        }
        if (this.focusedItem != null) {
            this.focusedItem.defocus();
        }
        try {
            this.currentIndexInRow = this.getFirstRow(item).indexOf(item);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scrollCurrentItem = item;
        this.focusedItem = item;
        if (item != null) {
            item.focus();
        }
    }

    void setCurrentItem(Item item) {
        this.focusItem(item);
        if (!this.isVisible(item)) {
            this.scrollTo(item);
        }
    }

    private Row getFirstVisibleRow() {
        for (Row row : this.rows) {
            if (row.y + row.getHeight() - this.scroll <= 0) continue;
            return row;
        }
        return null;
    }

    private Item getFirstVisibleAndFocusableItem() {
        try {
            Row row = this.getNextFocusableRow(null, 1);
            if (row == null) {
                return null;
            }
            return row.getFirstFocusableItem();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private Row getNextFocusableRow(Row prevRow, int dir) {
        try {
            int i2;
            int n = i2 = prevRow == null ? this.rows.indexOf(this.getFirstVisibleRow()) : this.rows.indexOf(prevRow) + dir;
            while (i2 < this.rows.size() && i2 >= 0) {
                Row row = this.rows.get(i2);
                for (Row.RowItem o : row.items) {
                    if (!o.item.isFocusable()) continue;
                    return row;
                }
                i2 += dir;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private int getNextFocusableItemInRow(Row row, int currentIdx, int dir) {
        try {
            for (int i2 = currentIdx + dir; i2 < row.items.size() && i2 >= 0; i2 += dir) {
                Item item = row.items.get((int)i2).item;
                if (!item.isFocusable()) continue;
                return i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private Item getNextFocusableItem(Item prevItem, int dir) {
        try {
            for (int i2 = this.getFirstRowIdx(prevItem) + dir; i2 < this.rows.size() && i2 >= 0; i2 += dir) {
                Row row = this.rows.get(i2);
                for (Row.RowItem o : row.items) {
                    if (o.item == prevItem || !o.item.isFocusable()) continue;
                    return o.item;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public int size() {
        return this.items.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _paint(Graphics g) {
        if (this.rows.size() == 0) {
            this.doLayout(0);
        } else if (this.layout) {
            this.doLayout(this.layoutStart);
        }
        this.layout = false;
        this.layoutStart = Integer.MAX_VALUE;
        int y = this.bounds[1];
        int w = this.bounds[2];
        int h2 = this.bounds[3];
        int sy = y;
        g.setClip(0, sy, w, sy + h2);
        if (this.focusedItem == null && this.scrollCurrentItem == null && this.scrollTargetItem == null) {
            Item item = this.getFirstVisibleAndFocusableItem();
            if (item != null) {
                this.focusItem(item);
            }
        } else if (this.focusedItem != null && this.scrollCurrentItem == null && !this.isVisible(this.focusedItem)) {
            this.scrollTo(this.focusedItem);
        }
        this.scroll = Math.max(0, Math.min(this.scroll, this.layoutHeight - h2 + this.bounds[1]));
        y -= this.scroll;
        ArrayList<Row> arrayList = this.rows;
        synchronized (arrayList) {
            for (Row row : this.rows) {
                int rh = row.getHeight();
                if (y + rh > 0 && h2 + sy > y) {
                    row.paint(g, y, w);
                } else {
                    row.hidden();
                }
                y += rh;
            }
        }
        g.setClip(0, 0, this.w, this.h);
    }

    Row getFirstRow(Item item) {
        for (Row row : this.rows) {
            if (row == null || !row.contains(item)) continue;
            return row;
        }
        return null;
    }

    Row getLastRow(Item item) {
        Row row = this.getFirstRow(item);
        if (row != null) {
            Row tmp;
            for (int i2 = this.rows.indexOf(row); i2 < this.rows.size() && (tmp = this.rows.get(i2)).contains(item); ++i2) {
                row = tmp;
            }
        }
        return row;
    }

    int getFirstRowIdx(Item item) {
        int l = this.rows.size();
        for (int i2 = 0; i2 < l; ++i2) {
            if (!this.rows.get(i2).contains(item)) continue;
            return i2;
        }
        return -1;
    }

    Row getNextRow(Item item, Row prevRow) {
        if (prevRow == null) {
            return this.getFirstRow(item);
        }
        try {
            for (int i2 = this.rows.indexOf(prevRow) + 1; i2 < this.rows.size(); ++i2) {
                Row row = this.rows.get(i2);
                if (item != null && !row.contains(item)) continue;
                return row;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isVisible(Item item) {
        ArrayList<Row> arrayList = this.rows;
        synchronized (arrayList) {
            Row row = this.getFirstRow(item);
            if (row == null) {
                return false;
            }
            do {
                if (!this.isVisible(row)) continue;
                return true;
            } while ((row = this.getNextRow(item, row)) != null);
        }
        return false;
    }

    boolean isTopVisible(Item item) {
        Row row = this.getFirstRow(item);
        if (row == null) {
            return false;
        }
        return row.y - this.scroll >= 0 && this.bounds[3] > row.y - this.scroll;
    }

    boolean isEndVisible(Item item) {
        Row row = this.getLastRow(item);
        if (row == null) {
            return false;
        }
        return row.y + row.height - this.scroll > 0 && this.bounds[3] > row.y + row.height - this.scroll;
    }

    boolean isVisible(Row row) {
        if (row == null) {
            return false;
        }
        return row.y + row.height - this.scroll > 0 && this.bounds[3] > row.y - this.scroll;
    }

    void scrollTo(Item item) {
        this.scrollCurrentItem = item;
        try {
            this.scroll = this.getFirstRow((Item)item).y;
        }
        catch (Exception e2) {
            this.queueLayout(item);
            this.doLayout(0);
            try {
                this.scroll = this.getFirstRow((Item)item).y;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void queueLayout(int i2) {
        if (i2 < 0) {
            i2 = 0;
        }
        this.layoutStart = Math.min(this.layoutStart, i2);
        this.layout = true;
        this.repaintScreen();
    }

    void queueLayout(Item item) {
        if (item == null) {
            return;
        }
        int i2 = this.items.indexOf(item);
        if (i2 == -1) {
            return;
        }
        this.queueLayout(i2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doLayout(int i2) {
        ArrayList<Row> arrayList = this.rows;
        synchronized (arrayList) {
            this.layoutHeight = 0;
            if (this.items.isEmpty()) {
                this.rows.clear();
                return;
            }
            int width = this.bounds[2];
            int prevScroll = this.scroll;
            int prevScrollItemY = 0;
            Item scrollItem = this.scrollCurrentItem;
            if (scrollItem != null) {
                try {
                    prevScrollItemY = this.getFirstRow((Item)scrollItem).y;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Row row = null;
            Vector vector2 = this.items;
            synchronized (vector2) {
                while (row == null && i2 > 0) {
                    if (i2 < this.items.size()) {
                        row = this.getFirstRow((Item)this.items.get(i2));
                    }
                    if (row != null) continue;
                    --i2;
                }
                if (i2 == 0) {
                    this.rows.clear();
                    row = null;
                } else if (row != null) {
                    int rowIdx = this.rows.indexOf(row);
                    if (row.items.size() > 1) {
                        i2 = this.items.indexOf(row.getFirstItem());
                    }
                    while (this.rows.size() > rowIdx) {
                        this.rows.remove(rowIdx);
                    }
                }
                if (!this.rows.isEmpty()) {
                    for (Row r : this.rows) {
                        this.layoutHeight += r.getHeight();
                    }
                }
            }
            this.currentDir = row != null ? row.dir : 1;
            row = null;
            for (int j = i2; j < this.items.size(); ++j) {
                int itemDir;
                Item item = (Item)this.items.get(j);
                if (item instanceof Gauge) {
                    this.hasGauges = true;
                }
                if ((itemDir = item.layout & 3) == 0) {
                    itemDir = this.currentDir;
                }
                if (row == null || !(item instanceof StringItem) && !(item instanceof ImageItem) && !(item instanceof Spacer) && !(item instanceof CustomItem) && (!item._hasLayout(16384) || item instanceof DateField || item instanceof TextField || item instanceof ChoiceGroup) || item._hasLayout(256) || itemDir != this.currentDir) {
                    this.currentDir = itemDir;
                    row = this.newRow(row);
                }
                String text = null;
                if (item instanceof StringItem && ((text = ((StringItem)item).getText()) != null && !text.trim().isEmpty() && text.startsWith("\n") || ((StringItem)item).getAppearanceMode() != 2 && item.hasLabel())) {
                    row = this.newRow(row);
                }
                item.layout(row);
                if (!row.canAdd(item, width)) {
                    row = this.newRow(row);
                    item.layout(row);
                }
                if (item instanceof StringItem && ((StringItem)item).getAppearanceMode() != 2 && !item.isSizeLocked() && !item.hasLabel()) {
                    StringItem s = (StringItem)item;
                    int l = s.getRowsCount();
                    for (int k2 = 0; k2 < l; ++k2) {
                        row.add(s, k2, width);
                        if (k2 == l - 1) continue;
                        row = this.newRow(row);
                    }
                } else {
                    row.add(item, width);
                }
                if ((text == null || !text.endsWith("\n") || item._hasLayout(512)) && !item._hasLayout(512) && !(item instanceof ChoiceGroup) && !(item instanceof TextField) && !(item instanceof DateField)) continue;
                row = this.newRow(row);
            }
            if (row != null && !row.items.isEmpty()) {
                this.layoutHeight += row.getHeight();
            }
            if (prevScrollItemY != 0) {
                int s = prevScroll - prevScrollItemY;
                try {
                    this.scroll = s + this.getFirstRow((Item)scrollItem).y;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private Row newRow(Row row) {
        if (row == null || !row.items.isEmpty()) {
            if (row != null) {
                this.layoutHeight += row.getHeight();
            }
            row = new Row(this.layoutHeight, this.currentDir);
            this.rows.add(row);
        } else {
            row.dir = this.currentDir;
        }
        return row;
    }

    public boolean _tryShowMenuAt(int x, int y) {
        Item item = this._getItemAt(x, y, null);
        if (item != null && !item.commands.isEmpty()) {
            Vector<TargetedCommand> commands = new Vector<TargetedCommand>();
            Form.buildItemCommands(commands, item);
            Emulator.getEmulator().getScreen().showCommandsList(commands, CommandsMenuPosition.Cursor, 0, 0);
            return true;
        }
        return false;
    }

    int[] getLocationOnScreen(Item item) {
        int x = 0;
        int y = 0;
        try {
            Row row = this.getFirstRow(item);
            Row.RowItem o = row.items.get(row.indexOf(item));
            x = o.x;
            y = row.y + this.bounds[1] + o.y - this.scroll;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new int[]{x, y};
    }

    @Override
    public void _invokeSizeChanged(int w, int h2) {
        super._invokeSizeChanged(w, h2);
        this.queueLayout(0);
    }

    public void _itemStateChanged(Item item) {
        if (this.itemStateListener == null) {
            return;
        }
        this.itemStateListener.itemStateChanged(item);
    }

    @Override
    void repaintScreen(Item item) {
        if (this.isVisible(item)) {
            this.repaintScreen();
        }
    }

    @Override
    public int _repaintInterval() {
        return this.hasGauges || this.ticker != null ? 500 : -1;
    }
}

